/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel$;
import org.apache.spark.ml.classification.ProbabilisticClassifierSuite$;
import org.apache.spark.ml.classification.TestProbabilisticClassificationModel;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.util.MLTest;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.sql.Dataset;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001Q4A!\u0003\u0006\u0001+!)!\u0004\u0001C\u00017\u001d)aD\u0003E\u0001?\u0019)\u0011B\u0003E\u0001A!)!d\u0001C\u0001U!91f\u0001b\u0001\n\u0003a\u0003B\u0002 \u0004A\u0003%Q\u0006C\u0003@\u0007\u0011\u0005\u0001\tC\u0004k\u0007\u0005\u0005I\u0011B6\u00039A\u0013xNY1cS2L7\u000f^5d\u00072\f7o]5gS\u0016\u00148+^5uK*\u00111\u0002D\u0001\u000fG2\f7o]5gS\u000e\fG/[8o\u0015\tia\"\u0001\u0002nY*\u0011q\u0002E\u0001\u0006gB\f'o\u001b\u0006\u0003#I\ta!\u00199bG\",'\"A\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00011\u0002CA\f\u0019\u001b\u0005q\u0011BA\r\u000f\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012\u0001\b\t\u0003;\u0001i\u0011AC\u0001\u001d!J|'-\u00192jY&\u001cH/[2DY\u0006\u001c8/\u001b4jKJ\u001cV/\u001b;f!\ti2aE\u0002\u0004C\u001d\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0007C\u0001\u0012)\u0013\tI3E\u0001\u0007TKJL\u0017\r\\5{C\ndW\rF\u0001 \u0003A\tG\u000e\u001c)be\u0006l7+\u001a;uS:<7/F\u0001.!\u0011qS\u0007O\u001e\u000f\u0005=\u001a\u0004C\u0001\u0019$\u001b\u0005\t$B\u0001\u001a\u0015\u0003\u0019a$o\\8u}%\u0011AgI\u0001\u0007!J,G-\u001a4\n\u0005Y:$aA'ba*\u0011Ag\t\t\u0003]eJ!AO\u001c\u0003\rM#(/\u001b8h!\t\u0011C(\u0003\u0002>G\t\u0019\u0011I\\=\u0002#\u0005dG\u000eU1sC6\u001cV\r\u001e;j]\u001e\u001c\b%\u0001\nuKN$\bK]3eS\u000e$X*\u001a;i_\u0012\u001cXcA!\\#R!!)R'_!\t\u00113)\u0003\u0002EG\t!QK\\5u\u0011\u00151u\u00011\u0001H\u0003\u0019iG\u000eV3tiB\u0011\u0001jS\u0007\u0002\u0013*\u0011!\nD\u0001\u0005kRLG.\u0003\u0002M\u0013\n1Q\n\u0014+fgRDQAT\u0004A\u0002=\u000bQ!\\8eK2\u0004\"\u0001U)\r\u0001\u0011)!k\u0002b\u0001'\n\tQ*\u0005\u0002U/B\u0011!%V\u0005\u0003-\u000e\u0012qAT8uQ&tw\r\u0005\u0003\u001e1j{\u0015BA-\u000b\u0005\u0001\u0002&o\u001c2bE&d\u0017n\u001d;jG\u000ec\u0017m]:jM&\u001c\u0017\r^5p]6{G-\u001a7\u0011\u0005A[F!\u0002/\b\u0005\u0004i&\u0001\u0004$fCR,(/Z:UsB,\u0017C\u0001+<\u0011\u0015yv\u00011\u0001a\u0003!!Xm\u001d;ECR\f\u0007GA1i!\r\u0011WmZ\u0007\u0002G*\u0011AMD\u0001\u0004gFd\u0017B\u00014d\u0005\u001d!\u0015\r^1tKR\u0004\"\u0001\u00155\u0005\u0013%t\u0016\u0011!A\u0001\u0006\u0003i&aA0%c\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005a\u0007CA7s\u001b\u0005q'BA8q\u0003\u0011a\u0017M\\4\u000b\u0003E\fAA[1wC&\u00111O\u001c\u0002\u0007\u001f\nTWm\u0019;")
public class ProbabilisticClassifierSuite
extends SparkFunSuite {
    public static <FeaturesType, M extends ProbabilisticClassificationModel<FeaturesType, M>> void testPredictMethods(MLTest mLTest, M m, Dataset<?> dataset) {
        ProbabilisticClassifierSuite$.MODULE$.testPredictMethods(mLTest, m, dataset);
    }

    public static Map<String, Object> allParamSettings() {
        return ProbabilisticClassifierSuite$.MODULE$.allParamSettings();
    }

    public ProbabilisticClassifierSuite() {
        this.test("test thresholding", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TestProbabilisticClassificationModel testModel = (TestProbabilisticClassificationModel)new TestProbabilisticClassificationModel("myuid", 2, 2).setThresholds(new double[]{0.5, 0.2});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)testModel.friendlyPredict((Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0}))));
            double $org_scalatest_assert_macro_right = 1.0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ProbabilisticClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)testModel.friendlyPredict((Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 0.2}))));
            double $org_scalatest_assert_macro_right2 = 0.0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ProbabilisticClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        }, new Position("ProbabilisticClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("test thresholding not required", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TestProbabilisticClassificationModel testModel = new TestProbabilisticClassificationModel("myuid", 2, 2);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)testModel.friendlyPredict((Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0}))));
            double $org_scalatest_assert_macro_right = 1.0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ProbabilisticClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        }, new Position("ProbabilisticClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("test tiebreak", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TestProbabilisticClassificationModel testModel = (TestProbabilisticClassificationModel)new TestProbabilisticClassificationModel("myuid", 2, 2).setThresholds(new double[]{0.4, 0.4});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)testModel.friendlyPredict((Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[]{0.6, 0.6}))));
            double $org_scalatest_assert_macro_right = 0.0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ProbabilisticClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        }, new Position("ProbabilisticClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("test one zero threshold", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TestProbabilisticClassificationModel testModel = (TestProbabilisticClassificationModel)new TestProbabilisticClassificationModel("myuid", 2, 2).setThresholds(new double[]{0.0, 0.1});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)testModel.friendlyPredict((Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 10.0}))));
            double $org_scalatest_assert_macro_right = 0.0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ProbabilisticClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)testModel.friendlyPredict((Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 10.0}))));
            double $org_scalatest_assert_macro_right2 = 1.0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ProbabilisticClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        }, new Position("ProbabilisticClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("bad thresholds", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.intercept((Function0 & Serializable & scala.Serializable)() -> (TestProbabilisticClassificationModel)new TestProbabilisticClassificationModel("myuid", 2, 2).setThresholds(new double[]{0.0, 0.0}), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ProbabilisticClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (TestProbabilisticClassificationModel)new TestProbabilisticClassificationModel("myuid", 2, 2).setThresholds(new double[]{-0.1, 0.1}), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ProbabilisticClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        }, new Position("ProbabilisticClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        this.test("normalizeToProbabilitiesInPlace", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DenseVector vec1 = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0})).toDense();
            ProbabilisticClassificationModel$.MODULE$.normalizeToProbabilitiesInPlace(vec1);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)vec1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.16666666666666666, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.3333333333333333, 0.5}))).relTol(0.001)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(vec1).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.ml.linalg.Vectors.dense(0.16666666666666666, 0.3333333333333333, 0.5)).relTol(0.001))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ProbabilisticClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            DenseVector vec2 = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0})).toDense();
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ProbabilisticClassificationModel$.MODULE$.normalizeToProbabilitiesInPlace(vec2), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ProbabilisticClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
            DenseVector vec3 = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-1.0, 2.0})).toDense();
            return (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ProbabilisticClassificationModel$.MODULE$.normalizeToProbabilitiesInPlace(vec3), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ProbabilisticClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        }, new Position("ProbabilisticClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
    }
}

