/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import com.google.common.collect.Ordering;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.mllib.feature.Word2VecModel$;
import org.apache.spark.mllib.feature.Word2VecModel$SaveLoadV1_0$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.Saveable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\rf\u0001B\u001e=\u0001\u001dC\u0011b\u0016\u0001\u0003\u0006\u0004%\t\u0001\u0011-\t\u0011)\u0004!\u0011!Q\u0001\neC\u0011b\u001b\u0001\u0003\u0006\u0004%\t\u0001\u00117\t\u0011M\u0004!\u0011!Q\u0001\n5Da\u0001\u001e\u0001\u0005\u0002\u0001+\bb\u0002>\u0001\u0005\u0004%Ia\u001f\u0005\u0007y\u0002\u0001\u000b\u0011B4\t\u000fu\u0004!\u0019!C\u0005w\"1a\u0010\u0001Q\u0001\n\u001dD\u0011b \u0001\t\u0006\u0004%I!!\u0001\t\u0013\u0005\u0015\u0001\u0001#b\u0001\n\u0013a\u0007B\u0002;\u0001\t\u0003\t9\u0001C\u0004\u0002\"\u0001!\t!a\t\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002D!9\u00111\f\u0001\u0005\u0002\u0005u\u0003bBA.\u0001\u0011\u0005\u0011Q\u000f\u0005\t\u00037\u0002A\u0011\u0001!\u0002\u0000!9\u0011\u0011\u0013\u0001\u0005\u0002\u0005MuaBAOy!\u0005\u0011q\u0014\u0004\u0007wqB\t!!)\t\rQ$B\u0011AAU\u0011\u001d\tY\u000b\u0006C\u0005\u0003[Cq!!-\u0015\t\u0013\t\u0019lB\u0004\u00028RAI!!/\u0007\u000f\u0005uF\u0003#\u0003\u0002@\"1A/\u0007C\u0001\u0003\u0003D\u0011\"a1\u001a\u0005\u0004%\t!!2\t\u0011\u0005U\u0017\u0004)A\u0005\u0003\u000fD\u0011\"a6\u001a\u0005\u0004%\t!!2\t\u0011\u0005e\u0017\u0004)A\u0005\u0003\u000f4a!a7\u001a\u0001\u0006u\u0007BCA*?\tU\r\u0011\"\u0001\u0002f\"I\u0011q]\u0010\u0003\u0012\u0003\u0006I\u0001\u001a\u0005\n\u0003sz\"Q3A\u0005\u00021D\u0011\"!; \u0005#\u0005\u000b\u0011B7\t\rQ|B\u0011AAv\u0011%\t)pHA\u0001\n\u0003\t9\u0010C\u0005\u0002~~\t\n\u0011\"\u0001\u0002\u0000\"I!1C\u0010\u0012\u0002\u0013\u0005!Q\u0003\u0005\n\u00053y\u0012\u0011!C!\u0003\u000bD\u0001Ba\u0007 \u0003\u0003%\ta\u001f\u0005\n\u0005;y\u0012\u0011!C\u0001\u0005?A\u0011Ba\u000b \u0003\u0003%\tE!\f\t\u0013\tmr$!A\u0005\u0002\tu\u0002\"\u0003B$?\u0005\u0005I\u0011\tB%\u0011%\u0011YeHA\u0001\n\u0003\u0012i\u0005C\u0005\u0003P}\t\t\u0011\"\u0011\u0003R\u001dI!QK\r\u0002\u0002#\u0005!q\u000b\u0004\n\u00037L\u0012\u0011!E\u0001\u00053Ba\u0001^\u0019\u0005\u0002\t\u001d\u0004\"\u0003B&c\u0005\u0005IQ\tB'\u0011%\u0011I'MA\u0001\n\u0003\u0013Y\u0007C\u0005\u0003rE\n\t\u0011\"!\u0003t!I!QP\u0019\u0002\u0002\u0013%!q\u0010\u0005\b\u0005\u000fKB\u0011\u0001BE\u0011\u001d\t\t#\u0007C\u0001\u0005\u001fCqAa\"\u0015\t\u0003\u00129\nC\u0005\u0003~Q\t\t\u0011\"\u0003\u0003\u0000\tiqk\u001c:eeY+7-T8eK2T!!\u0010 \u0002\u000f\u0019,\u0017\r^;sK*\u0011q\bQ\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u0003\n\u000bQa\u001d9be.T!a\u0011#\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0015aA8sO\u000e\u00011\u0003\u0002\u0001I\u001dF\u0003\"!\u0013'\u000e\u0003)S\u0011aS\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b*\u0013a!\u00118z%\u00164\u0007CA%P\u0013\t\u0001&J\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0005\u0002S+6\t1K\u0003\u0002U}\u0005!Q\u000f^5m\u0013\t16K\u0001\u0005TCZ,\u0017M\u00197f\u0003%9xN\u001d3J]\u0012,\u00070F\u0001Z!\u0011Q\u0016\rZ4\u000f\u0005m{\u0006C\u0001/K\u001b\u0005i&B\u00010G\u0003\u0019a$o\\8u}%\u0011\u0001MS\u0001\u0007!J,G-\u001a4\n\u0005\t\u001c'aA'ba*\u0011\u0001M\u0013\t\u00035\u0016L!AZ2\u0003\rM#(/\u001b8h!\tI\u0005.\u0003\u0002j\u0015\n\u0019\u0011J\u001c;\u0002\u0015]|'\u000fZ%oI\u0016D\b%A\u0006x_J$g+Z2u_J\u001cX#A7\u0011\u0007%s\u0007/\u0003\u0002p\u0015\n)\u0011I\u001d:bsB\u0011\u0011*]\u0005\u0003e*\u0013QA\u00127pCR\fAb^8sIZ+7\r^8sg\u0002\na\u0001P5oSRtDc\u0001<ysB\u0011q\u000fA\u0007\u0002y!)q+\u0002a\u00013\")1.\u0002a\u0001[\u0006Aa.^7X_J$7/F\u0001h\u0003%qW/\\,pe\u0012\u001c\b%\u0001\u0006wK\u000e$xN]*ju\u0016\f1B^3di>\u00148+\u001b>fA\u0005Aqo\u001c:e\u0019&\u001cH/\u0006\u0002\u0002\u0004A\u0019\u0011J\u001c3\u0002\u001f]|'\u000f\u001a,fG&sgOT8s[N$2A^A\u0005\u0011\u001d\tY\u0001\u0004a\u0001\u0003\u001b\tQ!\\8eK2\u0004BAW1e[\"*A\"!\u0005\u0002\u001eA!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u0018\u0001\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tY\"!\u0006\u0003\u000bMKgnY3\"\u0005\u0005}\u0011!B\u0019/k9\u0002\u0014\u0001B:bm\u0016$b!!\n\u0002,\u0005]\u0002cA%\u0002(%\u0019\u0011\u0011\u0006&\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003[i\u0001\u0019AA\u0018\u0003\t\u00198\r\u0005\u0003\u00022\u0005MR\"\u0001!\n\u0007\u0005U\u0002I\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH\u000f\u0003\u0004\u0002:5\u0001\r\u0001Z\u0001\u0005a\u0006$\b\u000eK\u0003\u000e\u0003#\ti$\t\u0002\u0002@\u0005)\u0011G\f\u001b/a\u0005IAO]1og\u001a|'/\u001c\u000b\u0005\u0003\u000b\n\t\u0006\u0005\u0003\u0002H\u00055SBAA%\u0015\r\tYEP\u0001\u0007Y&t\u0017\r\\4\n\t\u0005=\u0013\u0011\n\u0002\u0007-\u0016\u001cGo\u001c:\t\r\u0005Mc\u00021\u0001e\u0003\u00119xN\u001d3)\u000b9\t\t\"a\u0016\"\u0005\u0005e\u0013!B\u0019/c9\u0002\u0014\u0001\u00044j]\u0012\u001c\u0016P\\8os6\u001cHCBA0\u0003[\ny\u0007\u0005\u0003J]\u0006\u0005\u0004CB%\u0002d\u0011\f9'C\u0002\u0002f)\u0013a\u0001V;qY\u0016\u0014\u0004cA%\u0002j%\u0019\u00111\u000e&\u0003\r\u0011{WO\u00197f\u0011\u0019\t\u0019f\u0004a\u0001I\"1\u0011\u0011O\bA\u0002\u001d\f1A\\;nQ\u0015y\u0011\u0011CA,)\u0019\ty&a\u001e\u0002|!9\u0011\u0011\u0010\tA\u0002\u0005\u0015\u0013A\u0002<fGR|'\u000f\u0003\u0004\u0002rA\u0001\ra\u001a\u0015\u0006!\u0005E\u0011q\u000b\u000b\t\u0003?\n\t)!\"\u0002\b\"9\u0011\u0011P\tA\u0002\u0005\r\u0005\u0003B%o\u0003OBa!!\u001d\u0012\u0001\u00049\u0007bBAE#\u0001\u0007\u00111R\u0001\bo>\u0014Hm\u00149u!\u0011I\u0015Q\u00123\n\u0007\u0005=%J\u0001\u0004PaRLwN\\\u0001\u000bO\u0016$h+Z2u_J\u001cXCAA\u0007Q\u0015\u0011\u0012\u0011CALC\t\tI*A\u00032]Ir\u0003\u0007K\u0003\u0001\u0003#\t9&A\u0007X_J$'GV3d\u001b>$W\r\u001c\t\u0003oR\u0019R\u0001\u0006%\u0002$:\u0003BAUASm&\u0019\u0011qU*\u0003\r1{\u0017\rZ3s)\t\ty*\u0001\bck&dGmV8sI&sG-\u001a=\u0015\u0007e\u000by\u000bC\u0004\u0002\fY\u0001\r!!\u0004\u0002!\t,\u0018\u000e\u001c3X_J$g+Z2u_J\u001cHcA7\u00026\"9\u00111B\fA\u0002\u00055\u0011\u0001D*bm\u0016du.\u00193Wc}\u0003\u0004cAA^35\tAC\u0001\u0007TCZ,Gj\\1e-Fz\u0006g\u0005\u0002\u001a\u0011R\u0011\u0011\u0011X\u0001\u0012M>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8Wc}\u0003TCAAd!\u0011\tI-a5\u000e\u0005\u0005-'\u0002BAg\u0003\u001f\fA\u0001\\1oO*\u0011\u0011\u0011[\u0001\u0005U\u00064\u0018-C\u0002g\u0003\u0017\f!CZ8s[\u0006$h+\u001a:tS>tg+M01A\u0005i1\r\\1tg:\u000bW.\u001a,2?B\nab\u00197bgNt\u0015-\\3Wc}\u0003\u0004E\u0001\u0003ECR\f7#B\u0010I\u0003?t\u0005cA%\u0002b&\u0019\u00111\u001d&\u0003\u000fA\u0013x\u000eZ;diV\tA-A\u0003x_J$\u0007%A\u0004wK\u000e$xN\u001d\u0011\u0015\r\u00055\u0018\u0011_Az!\r\tyoH\u0007\u00023!1\u00111\u000b\u0013A\u0002\u0011Da!!\u001f%\u0001\u0004i\u0017\u0001B2paf$b!!<\u0002z\u0006m\b\u0002CA*KA\u0005\t\u0019\u00013\t\u0011\u0005eT\u0005%AA\u00025\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\u0002)\u001aAMa\u0001,\u0005\t\u0015\u0001\u0003\u0002B\u0004\u0005\u001fi!A!\u0003\u000b\t\t-!QB\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0006K\u0013\u0011\u0011\tB!\u0003\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t]!fA7\u0003\u0004\u0005i\u0001O]8ek\u000e$\bK]3gSb\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003\"\t\u001d\u0002cA%\u0003$%\u0019!Q\u0005&\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0003*)\n\t\u00111\u0001h\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!q\u0006\t\u0007\u0005c\u00119D!\t\u000e\u0005\tM\"b\u0001B\u001b\u0015\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\te\"1\u0007\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003@\t\u0015\u0003cA%\u0003B%\u0019!1\t&\u0003\u000f\t{w\u000e\\3b]\"I!\u0011\u0006\u0017\u0002\u0002\u0003\u0007!\u0011E\u0001\tQ\u0006\u001c\bnQ8eKR\tq-\u0001\u0005u_N#(/\u001b8h)\t\t9-\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005\u007f\u0011\u0019\u0006C\u0005\u0003*=\n\t\u00111\u0001\u0003\"\u0005!A)\u0019;b!\r\ty/M\n\u0005c\tmc\n\u0005\u0005\u0003^\t\rD-\\Aw\u001b\t\u0011yFC\u0002\u0003b)\u000bqA];oi&lW-\u0003\u0003\u0003f\t}#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011!qK\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0003[\u0014iGa\u001c\t\r\u0005MC\u00071\u0001e\u0011\u0019\tI\b\u000ea\u0001[\u00069QO\\1qa2LH\u0003\u0002B;\u0005s\u0002R!SAG\u0005o\u0002R!SA2I6D\u0011Ba\u001f6\u0003\u0003\u0005\r!!<\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001BA!\u0011\tIMa!\n\t\t\u0015\u00151\u001a\u0002\u0007\u001f\nTWm\u0019;\u0002\t1|\u0017\r\u001a\u000b\u0006m\n-%Q\u0012\u0005\b\u0003[9\u0004\u0019AA\u0018\u0011\u0019\tId\u000ea\u0001IRA\u0011Q\u0005BI\u0005'\u0013)\nC\u0004\u0002.a\u0002\r!a\f\t\r\u0005e\u0002\b1\u0001e\u0011\u001d\tY\u0001\u000fa\u0001\u0003\u001b!RA\u001eBM\u00057Cq!!\f:\u0001\u0004\ty\u0003\u0003\u0004\u0002:e\u0002\r\u0001\u001a\u0015\u0006s\u0005E\u0011Q\b\u0015\u0006)\u0005E\u0011Q\b\u0015\u0006'\u0005E\u0011Q\b")
public class Word2VecModel
implements scala.Serializable,
Saveable {
    private String[] wordList;
    private float[] wordVecInvNorms;
    private final Map<String, Object> wordIndex;
    private final float[] wordVectors;
    private final int numWords;
    private final int vectorSize;
    private volatile byte bitmap$0;

    public static Word2VecModel load(SparkContext sparkContext, String string) {
        return Word2VecModel$.MODULE$.load(sparkContext, string);
    }

    public Map<String, Object> wordIndex() {
        return this.wordIndex;
    }

    public float[] wordVectors() {
        return this.wordVectors;
    }

    private int numWords() {
        return this.numWords;
    }

    private int vectorSize() {
        return this.vectorSize;
    }

    private String[] wordList$lzycompute() {
        Word2VecModel word2VecModel = this;
        synchronized (word2VecModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.wordList = (String[])((IterableLike)this.wordIndex().toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8._2$mcI$sp()), (scala.math.Ordering)Ordering.Int$.MODULE$)).iterator().map((Function1 & Serializable & scala.Serializable)x$9 -> (String)x$9._1()).toArray(ClassTag$.MODULE$.apply(String.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.wordList;
    }

    private String[] wordList() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.wordList$lzycompute() : this.wordList;
    }

    private float[] wordVecInvNorms$lzycompute() {
        Word2VecModel word2VecModel = this;
        synchronized (word2VecModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                int size = this.vectorSize();
                this.wordVecInvNorms = (float[])Array$.MODULE$.tabulate(this.numWords(), (Function1)(JFunction1.mcFI.sp & Serializable & scala.Serializable)i -> {
                    float norm = BLAS$.MODULE$.nativeBLAS().snrm2(size, this.wordVectors(), i * size, 1);
                    return norm != 0.0f ? 1.0f / norm : 0.0f;
                }, ClassTag$.MODULE$.Float());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.wordVecInvNorms;
    }

    private float[] wordVecInvNorms() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.wordVecInvNorms$lzycompute() : this.wordVecInvNorms;
    }

    @Override
    public void save(SparkContext sc, String path) {
        Word2VecModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.getVectors());
    }

    public Vector transform(String word) {
        double[] array;
        Option option = this.wordIndex().get((Object)word);
        if (option instanceof Some) {
            Some some = (Some)option;
            int index = BoxesRunTime.unboxToInt((Object)some.value());
            int size = this.vectorSize();
            int offset = index * size;
            array = (double[])Array$.MODULE$.ofDim(size, ClassTag$.MODULE$.Double());
            for (int i = 0; i < size; ++i) {
                array[i] = this.wordVectors()[offset + i];
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException(new StringBuilder(18).append(word).append(" not in vocabulary").toString());
            }
            throw new MatchError((Object)option);
        }
        Vector vector = Vectors$.MODULE$.dense(array);
        return vector;
    }

    public Tuple2<String, Object>[] findSynonyms(String word, int num) {
        Vector vector = this.transform(word);
        return this.findSynonyms(vector.toArray(), num, (Option<String>)new Some((Object)word));
    }

    public Tuple2<String, Object>[] findSynonyms(Vector vector, int num) {
        return this.findSynonyms(vector.toArray(), num, (Option<String>)None$.MODULE$);
    }

    public Tuple2<String, Object>[] findSynonyms(double[] vector, int num, Option<String> wordOpt) {
        Tuple2[] tuple2Array;
        Predef$.MODULE$.require(num > 0, (Function0 & Serializable & scala.Serializable)() -> "Number of similar words should > 0");
        int localVectorSize = this.vectorSize();
        float[] floatVec = (float[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(vector)).map((Function1)(JFunction1.mcFD.sp & Serializable & scala.Serializable)x$10 -> (float)x$10, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
        float vecNorm = BLAS$.MODULE$.nativeBLAS().snrm2(localVectorSize, floatVec, 1);
        String[] localWordList = this.wordList();
        int localNumWords = this.numWords();
        if (vecNorm == 0.0f) {
            tuple2Array = (Tuple2[])package$.MODULE$.Iterator().tabulate(num + 1, (Function1 & Serializable & scala.Serializable)i -> Word2VecModel.$anonfun$findSynonyms$3(localWordList, BoxesRunTime.unboxToInt((Object)i))).filterNot((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)wordOpt.contains(t._1()))).take(num).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        } else {
            BLAS$.MODULE$.nativeBLAS().sscal(localVectorSize, 1.0f / vecNorm, floatVec, 0, 1);
            float[] cosineVec = (float[])Array$.MODULE$.ofDim(localNumWords, ClassTag$.MODULE$.Float());
            BLAS$.MODULE$.nativeBLAS().sgemv("T", localVectorSize, localNumWords, 1.0f, this.wordVectors(), localVectorSize, floatVec, 1, 0.0f, cosineVec, 1);
            float[] localWordVecInvNorms = this.wordVecInvNorms();
            for (int i2 = 0; i2 < cosineVec.length; ++i2) {
                int n = i2;
                cosineVec[n] = cosineVec[n] * localWordVecInvNorms[i2];
            }
            Ordering<Object> idxOrd = new Ordering<Object>(null, cosineVec){
                private final float[] cosineVec$1;

                public int compare(int left, int right) {
                    return package$.MODULE$.Ordering().apply((scala.math.Ordering)Ordering.Float$.MODULE$).compare((Object)BoxesRunTime.boxToFloat((float)this.cosineVec$1[left]), (Object)BoxesRunTime.boxToFloat((float)this.cosineVec$1[right]));
                }
                {
                    this.cosineVec$1 = cosineVec$1;
                }
            };
            tuple2Array = (Tuple2[])((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(idxOrd.greatestOf((java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(package$.MODULE$.Iterator().range(0, localNumWords)).asJava(), num + 1).iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)i -> Word2VecModel.$anonfun$findSynonyms$5(localWordList, cosineVec, BoxesRunTime.unboxToInt((Object)i))).filterNot((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)wordOpt.contains(t._1()))).take(num).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        }
        return tuple2Array;
    }

    public Map<String, float[]> getVectors() {
        return (Map)this.wordIndex().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String word = (String)tuple2._1();
            int ind = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)word, new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(this.wordVectors())).slice(this.vectorSize() * ind, this.vectorSize() * ind + this.vectorSize()));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Tuple2 $anonfun$findSynonyms$3(String[] localWordList$1, int i) {
        return new Tuple2((Object)localWordList$1[i], (Object)BoxesRunTime.boxToDouble((double)0.0));
    }

    public static final /* synthetic */ Tuple2 $anonfun$findSynonyms$5(String[] localWordList$1, float[] cosineVec$1, int i) {
        return new Tuple2((Object)localWordList$1[i], (Object)BoxesRunTime.boxToDouble((double)cosineVec$1[i]));
    }

    public Word2VecModel(Map<String, Object> wordIndex, float[] wordVectors) {
        this.wordIndex = wordIndex;
        this.wordVectors = wordVectors;
        this.numWords = wordIndex.size();
        this.vectorSize = wordVectors.length / this.numWords();
    }

    public Word2VecModel(Map<String, float[]> model) {
        this(Word2VecModel$.MODULE$.org$apache$spark$mllib$feature$Word2VecModel$$buildWordIndex(model), Word2VecModel$.MODULE$.org$apache$spark$mllib$feature$Word2VecModel$$buildWordVectors(model));
    }
}

