/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.optimization;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Tensor$;
import breeze.linalg.Transpose$;
import breeze.linalg.norm$;
import breeze.math.Field;
import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.optimization.NNLS;
import org.apache.spark.mllib.optimization.NNLS$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u00113A\u0001B\u0003\u0001!!)Q\u0003\u0001C\u0001-!)\u0011\u0004\u0001C\u00015!)A\b\u0001C\u0001{\tIaJ\u0014'T'VLG/\u001a\u0006\u0003\r\u001d\tAb\u001c9uS6L'0\u0019;j_:T!\u0001C\u0005\u0002\u000b5dG.\u001b2\u000b\u0005)Y\u0011!B:qCJ\\'B\u0001\u0007\u000e\u0003\u0019\t\u0007/Y2iK*\ta\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001#A\u0011!cE\u0007\u0002\u0013%\u0011A#\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005)\u0011aC4f]>sWm\u001d#bi\u0006$2aG\u00185!\u0011ar$\t\u0017\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a\u0001V;qY\u0016\u0014\u0004c\u0001\u0012(S5\t1E\u0003\u0002%K\u00051A.\u001b8bY\u001eT\u0011AJ\u0001\u0007EJ,WM_3\n\u0005!\u001a#a\u0003#f]N,W*\u0019;sSb\u0004\"\u0001\b\u0016\n\u0005-j\"A\u0002#pk\ndW\rE\u0002#[%J!AL\u0012\u0003\u0017\u0011+gn]3WK\u000e$xN\u001d\u0005\u0006a\t\u0001\r!M\u0001\u0002]B\u0011ADM\u0005\u0003gu\u00111!\u00138u\u0011\u0015)$\u00011\u00017\u0003\u0011\u0011\u0018M\u001c3\u0011\u0005]RT\"\u0001\u001d\u000b\u0005ej\u0012\u0001B;uS2L!a\u000f\u001d\u0003\rI\u000bg\u000eZ8n\u0003U\u0019w.\u001c9vi\u0016|%M[3di&4XMV1mk\u0016$B!\u000b A\u0005\")qh\u0001a\u0001C\u0005\u0019\u0011\r^1\t\u000b\u0005\u001b\u0001\u0019\u0001\u0017\u0002\u0007\u0005$(\rC\u0003D\u0007\u0001\u0007A&A\u0001y\u0001")
public class NNLSSuite
extends SparkFunSuite {
    public Tuple2<DenseMatrix<Object>, DenseVector<Object>> genOnesData(int n, Random rand) {
        DenseMatrix.mcD.sp A = new DenseMatrix.mcD.sp(n, n, (double[])Array$.MODULE$.fill(n * n, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rand.nextDouble(), ClassTag$.MODULE$.Double()));
        DenseVector b = (DenseVector)A.$times((Object)new DenseVector.mcD.sp((double[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0, ClassTag$.MODULE$.Double())), (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DVD_eq_DVD());
        return new Tuple2(((ImmutableNumericOps)A.t(DenseMatrix$.MODULE$.canTranspose())).$times((Object)A, (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD()), ((ImmutableNumericOps)A.t(DenseMatrix$.MODULE$.canTranspose())).$times((Object)b, (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DVD_eq_DVD()));
    }

    public double computeObjectiveValue(DenseMatrix<Object> ata, DenseVector<Object> atb, DenseVector<Object> x) {
        return BoxesRunTime.unboxToDouble((Object)((ImmutableNumericOps)((ImmutableNumericOps)x.t(Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.$conforms()))).$times(ata, DenseMatrix$.MODULE$.implOpMulMatrix_DVTt_DMT_eq_DMT((UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD()))).$times(x, Transpose$.MODULE$.transTimesNormalFromDot((UFunc.UImpl2)DenseVector.canDotD$.MODULE$))) / 2.0 - BoxesRunTime.unboxToDouble((Object)atb.dot(x, (UFunc.UImpl2)DenseVector.canDotD$.MODULE$));
    }

    public static final /* synthetic */ Assertion $anonfun$new$6(double[] x$3, double[] goodx$1, int i) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x$3[i]).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(goodx$1[i]).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x.apply(i)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(goodx.apply(i)).absTol(0.001))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NNLSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        double $org_scalatest_assert_macro_left = x$3[i];
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left >= (double)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("NNLSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
    }

    public NNLSSuite() {
        this.test("NNLS: exact solution cases", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int n = 20;
            Random rand = new Random(12346);
            NNLS.Workspace ws = NNLS$.MODULE$.createWorkspace(n);
            IntRef numSolved = IntRef.create((int)0);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> {
                Tuple2<DenseMatrix<Object>, DenseVector<Object>> tuple2 = this.genOnesData(n, rand);
                if (tuple2 == null) throw new MatchError(tuple2);
                DenseMatrix ata = (DenseMatrix)tuple2._1();
                DenseVector atb = (DenseVector)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)ata, (Object)atb);
                Tuple2 tuple23 = tuple22;
                DenseMatrix ata2 = (DenseMatrix)tuple23._1();
                DenseVector atb2 = (DenseVector)tuple23._2();
                DenseVector.mcD.sp x = new DenseVector.mcD.sp(NNLS$.MODULE$.solve(ata2.data$mcD$sp(), atb2.data$mcD$sp(), ws));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)x.length()));
                int $org_scalatest_assert_macro_right = n;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NNLSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
                DenseVector.mcD.sp answer = new DenseVector.mcD.sp((double[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0, ClassTag$.MODULE$.Double()));
                if (!(BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(x.$minus((Object)answer, DenseVector$.MODULE$.canSubD()), DenseVector$.MODULE$.canNorm((Field)Field.fieldDouble$.MODULE$))) < 0.01)) return;
                ArrayOps.ofDouble ofDouble2 = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(((DenseVector)x.$minus((Object)answer, DenseVector$.MODULE$.canSubD())).toArray$mcD$sp(ClassTag$.MODULE$.Double()))).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$2 -> RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(x$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))));
                if (!(BoxesRunTime.unboxToDouble((Object)ofDouble2.max((Ordering)Ordering.Double$.MODULE$)) < 0.001)) return;
                boolean bl = true;
                boolean solved = bl;
                if (!solved) return;
                ++numSolved$1.elem;
            });
            int $org_scalatest_assert_macro_left = numSolved.elem;
            int $org_scalatest_assert_macro_right = 50;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NNLSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        }, new Position("NNLSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.test("NNLS: nonnegativity constraint active", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int n = 5;
            double[] ata = new double[]{4.377, -3.531, -1.306, -0.139, 3.418, -3.531, 4.344, 0.934, 0.305, -2.14, -1.306, 0.934, 2.644, -0.203, -0.17, -0.139, 0.305, -0.203, 5.883, 1.428, 3.418, -2.14, -0.17, 1.428, 4.684};
            double[] atb = new double[]{-1.632, 2.115, 1.094, -1.025, -0.636};
            double[] goodx = new double[]{0.13025, 0.54506, 0.2874, 0.0, 0.028628};
            NNLS.Workspace ws = NNLS$.MODULE$.createWorkspace(n);
            double[] x = NNLS$.MODULE$.solve(ata, atb, ws);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).foreach((Function1 & Serializable & scala.Serializable)i -> NNLSSuite.$anonfun$new$6(x, goodx, BoxesRunTime.unboxToInt((Object)i)));
        }, new Position("NNLSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("NNLS: objective value test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double obj;
            int n = 5;
            DenseMatrix.mcD.sp ata = new DenseMatrix.mcD.sp(5, 5, new double[]{517399.13534, 242529.67289, -153644.98976, 130802.84503, -798452.29283, 242529.67289, 126017.69765, -75944.21743, 81785.36128, -405290.60884, -153644.98976, -75944.21743, 46986.44577, -45401.12659, 247059.51049, 130802.84503, 81785.36128, -45401.12659, 67457.3131, -253747.03819, -798452.29283, -405290.60884, 247059.51049, -253747.03819, 1310939.40814});
            DenseVector.mcD.sp atb = new DenseVector.mcD.sp(new double[]{-31755.0571, 13047.14813, -20191.24443, 25993.7758, 11963.55017});
            DenseVector.mcD.sp refx = new DenseVector.mcD.sp(new double[]{34.90751, 103.96254, 0.0, 27.82094, 58.79627});
            double refObj = this.computeObjectiveValue((DenseMatrix<Object>)ata, (DenseVector<Object>)atb, (DenseVector<Object>)refx);
            NNLS.Workspace ws = NNLS$.MODULE$.createWorkspace(n);
            DenseVector.mcD.sp x = new DenseVector.mcD.sp(NNLS$.MODULE$.solve(ata.data$mcD$sp(), atb.data$mcD$sp(), ws));
            double $org_scalatest_assert_macro_left = obj = this.computeObjectiveValue((DenseMatrix<Object>)ata, (DenseVector<Object>)atb, (DenseVector<Object>)x);
            double $org_scalatest_assert_macro_right = refObj + 1.0E-5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NNLSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        }, new Position("NNLSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
    }
}

