/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.LogisticRegressionSuite$;
import org.apache.spark.mllib.classification.StreamingLogisticRegressionWithSGD;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.LocalStreamingContext;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.TestServer;
import org.apache.spark.streaming.TestSuiteBase;
import org.apache.spark.streaming.dstream.DStream;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.concurrent.PatienceConfiguration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IndexedSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001%2Aa\u0001\u0003\u0001\u001f!)Q\u0004\u0001C\u0001=!)\u0011\u0005\u0001C!E\t\u00013\u000b\u001e:fC6Lgn\u001a'pO&\u001cH/[2SK\u001e\u0014Xm]:j_:\u001cV/\u001b;f\u0015\t)a!\u0001\bdY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8\u000b\u0005\u001dA\u0011!B7mY&\u0014'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\u000b\u001b!\t\t\"#D\u0001\t\u0013\t\u0019\u0002BA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003+ai\u0011A\u0006\u0006\u0003/!\t\u0011b\u001d;sK\u0006l\u0017N\\4\n\u0005e1\"!\u0006'pG\u0006d7\u000b\u001e:fC6LgnZ\"p]R,\u0007\u0010\u001e\t\u0003+mI!\u0001\b\f\u0003\u001bQ+7\u000f^*vSR,')Y:f\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002!\u00015\tA!A\tnCb<\u0016-\u001b;US6,W*\u001b7mSN,\u0012a\t\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\u0004\u0013:$\b")
public class StreamingLogisticRegressionSuite
extends SparkFunSuite
implements LocalStreamingContext,
TestSuiteBase {
    private String checkpointDir;
    private final SparkConf conf;
    private final PatienceConfiguration.Timeout eventuallyTimeout;
    private transient StreamingContext ssc;
    private final transient boolean stopSparkContext;
    private volatile boolean bitmap$0;

    public /* synthetic */ void org$apache$spark$streaming$TestSuiteBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    public /* synthetic */ void org$apache$spark$streaming$TestSuiteBase$$super$afterEach() {
        LocalStreamingContext.afterEach$((LocalStreamingContext)this);
    }

    public String framework() {
        return TestSuiteBase.framework$((TestSuiteBase)this);
    }

    public String master() {
        return TestSuiteBase.master$((TestSuiteBase)this);
    }

    public Duration batchDuration() {
        return TestSuiteBase.batchDuration$((TestSuiteBase)this);
    }

    public int numInputPartitions() {
        return TestSuiteBase.numInputPartitions$((TestSuiteBase)this);
    }

    public boolean useManualClock() {
        return TestSuiteBase.useManualClock$((TestSuiteBase)this);
    }

    public boolean actuallyWait() {
        return TestSuiteBase.actuallyWait$((TestSuiteBase)this);
    }

    public void beforeFunction() {
        TestSuiteBase.beforeFunction$((TestSuiteBase)this);
    }

    public void afterFunction() {
        TestSuiteBase.afterFunction$((TestSuiteBase)this);
    }

    public void beforeEach() {
        TestSuiteBase.beforeEach$((TestSuiteBase)this);
    }

    public void afterEach() {
        TestSuiteBase.afterEach$((TestSuiteBase)this);
    }

    public <R> R withStreamingContext(StreamingContext ssc, Function1<StreamingContext, R> block) {
        return (R)TestSuiteBase.withStreamingContext$((TestSuiteBase)this, (StreamingContext)ssc, block);
    }

    public <R> R withTestServer(TestServer testServer, Function1<TestServer, R> block) {
        return (R)TestSuiteBase.withTestServer$((TestSuiteBase)this, (TestServer)testServer, block);
    }

    public <U, V> StreamingContext setupStreams(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, int numPartitions, ClassTag<U> evidence$4, ClassTag<V> evidence$5) {
        return TestSuiteBase.setupStreams$((TestSuiteBase)this, input, operation, (int)numPartitions, evidence$4, evidence$5);
    }

    public <U, V> int setupStreams$default$3() {
        return TestSuiteBase.setupStreams$default$3$((TestSuiteBase)this);
    }

    public <U, V, W> StreamingContext setupStreams(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, ClassTag<U> evidence$6, ClassTag<V> evidence$7, ClassTag<W> evidence$8) {
        return TestSuiteBase.setupStreams$((TestSuiteBase)this, input1, input2, operation, evidence$6, evidence$7, evidence$8);
    }

    public <V> Seq<Seq<V>> runStreams(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$9) {
        return TestSuiteBase.runStreams$((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, preStop, evidence$9);
    }

    public <V> Function0<BoxedUnit> runStreams$default$4() {
        return TestSuiteBase.runStreams$default$4$((TestSuiteBase)this);
    }

    public <V> Seq<Seq<Seq<V>>> runStreamsWithPartitions(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$10) {
        return TestSuiteBase.runStreamsWithPartitions$((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, preStop, evidence$10);
    }

    public <V> Function0<BoxedUnit> runStreamsWithPartitions$default$4() {
        return TestSuiteBase.runStreamsWithPartitions$default$4$((TestSuiteBase)this);
    }

    public <V> void verifyOutput(Seq<Seq<V>> output, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<V> evidence$11) {
        TestSuiteBase.verifyOutput$((TestSuiteBase)this, output, expectedOutput, (boolean)useSet, evidence$11);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<U> evidence$12, ClassTag<V> evidence$13) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input, operation, expectedOutput, (boolean)useSet, evidence$12, evidence$13);
    }

    public <U, V> boolean testOperation$default$4() {
        return TestSuiteBase.testOperation$default$4$((TestSuiteBase)this);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$14, ClassTag<V> evidence$15) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$14, evidence$15);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, boolean useSet, ClassTag<U> evidence$16, ClassTag<V> evidence$17, ClassTag<W> evidence$18) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input1, input2, operation, expectedOutput, (boolean)useSet, evidence$16, evidence$17, evidence$18);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$19, ClassTag<V> evidence$20, ClassTag<W> evidence$21) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input1, input2, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$19, evidence$20, evidence$21);
    }

    public /* synthetic */ void org$apache$spark$streaming$LocalStreamingContext$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public void resetStreamingContext() {
        LocalStreamingContext.resetStreamingContext$((LocalStreamingContext)this);
    }

    private String checkpointDir$lzycompute() {
        StreamingLogisticRegressionSuite streamingLogisticRegressionSuite = this;
        synchronized (streamingLogisticRegressionSuite) {
            if (!this.bitmap$0) {
                this.checkpointDir = TestSuiteBase.checkpointDir$((TestSuiteBase)this);
                this.bitmap$0 = true;
            }
        }
        return this.checkpointDir;
    }

    public String checkpointDir() {
        return !this.bitmap$0 ? this.checkpointDir$lzycompute() : this.checkpointDir;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public PatienceConfiguration.Timeout eventuallyTimeout() {
        return this.eventuallyTimeout;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$eventuallyTimeout_$eq(PatienceConfiguration.Timeout x$1) {
        this.eventuallyTimeout = x$1;
    }

    public StreamingContext ssc() {
        return this.ssc;
    }

    public void ssc_$eq(StreamingContext x$1) {
        this.ssc = x$1;
    }

    public boolean stopSparkContext() {
        return this.stopSparkContext;
    }

    public void org$apache$spark$streaming$LocalStreamingContext$_setter_$stopSparkContext_$eq(boolean x$1) {
        this.stopSparkContext = x$1;
    }

    public int maxWaitTimeMillis() {
        return 30000;
    }

    public static final /* synthetic */ boolean $anonfun$new$8(Tuple2 x) {
        return x._1$mcD$sp() - x._2$mcD$sp() <= 0.1;
    }

    public static final /* synthetic */ int $anonfun$new$9(Tuple2 x) {
        return x._1$mcD$sp() - x._2$mcD$sp() < 0.0 ? 1 : 0;
    }

    public static final /* synthetic */ double $anonfun$new$14(int nPoints$3, Seq batch) {
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)batch.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToDouble((double)package$.MODULE$.abs(p._1$mcD$sp() - p._2$mcD$sp())), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)nPoints$3;
    }

    public static final /* synthetic */ double $anonfun$new$21(int nPoints$4, Seq batch) {
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)batch.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToDouble((double)package$.MODULE$.abs(p._1$mcD$sp() - p._2$mcD$sp())), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)nPoints$4;
    }

    public StreamingLogisticRegressionSuite() {
        LocalStreamingContext.$init$((LocalStreamingContext)this);
        TestSuiteBase.$init$((TestSuiteBase)this);
        this.test("parameter accuracy", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int nPoints = 100;
            double B = 1.5;
            StreamingLogisticRegressionWithSGD model = new StreamingLogisticRegressionWithSGD().setInitialWeights(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))).setStepSize(0.2).setNumIterations(25);
            int numBatches = 20;
            IndexedSeq input = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).map((Function1 & Serializable & scala.Serializable)i -> LogisticRegressionSuite$.MODULE$.generateLogisticInput(0.0, B, nPoints, 42 * (BoxesRunTime.unboxToInt((Object)i) + 1)), IndexedSeq$.MODULE$.canBuildFrom());
            this.ssc_$eq(this.setupStreams((Seq)input, (Function1)(Function1 & Serializable & scala.Serializable)inputDStream -> {
                model.trainOn(inputDStream);
                return inputDStream.count();
            }, this.setupStreams$default$3(), (ClassTag)ClassTag$.MODULE$.apply(LabeledPoint.class), (ClassTag)ClassTag$.MODULE$.Long()));
            this.runStreams(this.ssc(), numBatches, numBatches, this.runStreams$default$4(), ClassTag$.MODULE$.Nothing());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(((LogisticRegressionModel)model.latestModel()).weights().apply(0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(B).relTol(0.1)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.latestModel().weights.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(B).relTol(0.1))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingLogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        }, new Position("StreamingLogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        this.test("parameter convergence", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double B = 1.5;
            int nPoints = 100;
            StreamingLogisticRegressionWithSGD model = new StreamingLogisticRegressionWithSGD().setInitialWeights(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))).setStepSize(0.2).setNumIterations(25);
            int numBatches = 20;
            IndexedSeq input = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).map((Function1 & Serializable & scala.Serializable)i -> LogisticRegressionSuite$.MODULE$.generateLogisticInput(0.0, B, nPoints, 42 * (BoxesRunTime.unboxToInt((Object)i) + 1)), IndexedSeq$.MODULE$.canBuildFrom());
            ArrayBuffer history = new ArrayBuffer(numBatches);
            this.ssc_$eq(this.setupStreams((Seq)input, (Function1)(Function1 & Serializable & scala.Serializable)inputDStream -> {
                model.trainOn(inputDStream);
                inputDStream.foreachRDD((Function1 & Serializable & scala.Serializable)x -> {
                    history.$plus$eq((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.abs(((LogisticRegressionModel)model.latestModel()).weights().apply(0) - B)));
                    return BoxedUnit.UNIT;
                });
                return inputDStream.count();
            }, this.setupStreams$default$3(), (ClassTag)ClassTag$.MODULE$.apply(LabeledPoint.class), (ClassTag)ClassTag$.MODULE$.Long()));
            this.runStreams(this.ssc(), numBatches, numBatches, this.runStreams$default$4(), ClassTag$.MODULE$.Nothing());
            ArrayBuffer deltas = (ArrayBuffer)((IndexedSeqOptimized)history.drop(1)).zip((GenIterable)history.dropRight(1), ArrayBuffer$.MODULE$.canBuildFrom());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(deltas.forall((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)StreamingLogisticRegressionSuite.$anonfun$new$8(x))), "deltas.forall(((x: (Double, Double)) => x._1.-(x._2).<=(0.1)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingLogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
            int $org_scalatest_assert_macro_left = BoxesRunTime.unboxToInt((Object)((TraversableOnce)deltas.map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)StreamingLogisticRegressionSuite.$anonfun$new$9(x)), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingLogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        }, new Position("StreamingLogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        this.test("predictions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double B = 1.5;
            int nPoints = 100;
            StreamingLogisticRegressionWithSGD model = new StreamingLogisticRegressionWithSGD().setInitialWeights(Vectors$.MODULE$.dense(1.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))).setStepSize(0.2).setNumIterations(25);
            int numBatches = 10;
            IndexedSeq testInput = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).map((Function1 & Serializable & scala.Serializable)i -> LogisticRegressionSuite$.MODULE$.generateLogisticInput(0.0, B, nPoints, 42 * (BoxesRunTime.unboxToInt((Object)i) + 1)), IndexedSeq$.MODULE$.canBuildFrom());
            this.ssc_$eq(this.setupStreams((Seq)testInput, (Function1)(Function1 & Serializable & scala.Serializable)inputDStream -> model.predictOnValues(inputDStream.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)BoxesRunTime.boxToDouble((double)x.label()), (Object)x.features()), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double()), this.setupStreams$default$3(), (ClassTag)ClassTag$.MODULE$.apply(LabeledPoint.class), (ClassTag)ClassTag$.MODULE$.apply(Tuple2.class)));
            Seq output = this.runStreams(this.ssc(), numBatches, numBatches, this.runStreams$default$4(), ClassTag$.MODULE$.Nothing());
            Seq errors = (Seq)output.map((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToDouble((double)StreamingLogisticRegressionSuite.$anonfun$new$14(nPoints, batch)), Seq$.MODULE$.canBuildFrom());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(errors.forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x -> x <= 0.4), "errors.forall(((x: Double) => x.<=(0.4)))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingLogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        }, new Position("StreamingLogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.test("training and prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Bool bool;
            StreamingLogisticRegressionWithSGD model = new StreamingLogisticRegressionWithSGD().setInitialWeights(Vectors$.MODULE$.dense(-0.1, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))).setStepSize(0.01).setNumIterations(10);
            int numBatches = 10;
            int nPoints = 100;
            IndexedSeq testInput = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).map((Function1 & Serializable & scala.Serializable)i -> LogisticRegressionSuite$.MODULE$.generateLogisticInput(0.0, 5.0, nPoints, 42 * (BoxesRunTime.unboxToInt((Object)i) + 1)), IndexedSeq$.MODULE$.canBuildFrom());
            this.ssc_$eq(this.setupStreams((Seq)testInput, (Function1)(Function1 & Serializable & scala.Serializable)inputDStream -> {
                model.trainOn(inputDStream);
                return model.predictOnValues(inputDStream.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)BoxesRunTime.boxToDouble((double)x.label()), (Object)x.features()), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double());
            }, this.setupStreams$default$3(), (ClassTag)ClassTag$.MODULE$.apply(LabeledPoint.class), (ClassTag)ClassTag$.MODULE$.apply(Tuple2.class)));
            Seq output = this.runStreams(this.ssc(), numBatches, numBatches, this.runStreams$default$4(), ClassTag$.MODULE$.Nothing());
            List error = ((TraversableOnce)output.map((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToDouble((double)StreamingLogisticRegressionSuite.$anonfun$new$21(nPoints, batch)), Seq$.MODULE$.canBuildFrom())).toList();
            double $org_scalatest_assert_macro_left = BoxesRunTime.unboxToDouble((Object)error.head());
            double $org_scalatest_assert_macro_right = 0.8;
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left2.value()) {
                double $org_scalatest_assert_macro_left3 = BoxesRunTime.unboxToDouble((Object)error.last());
                double $org_scalatest_assert_macro_right2 = 0.2;
                bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingLogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        }, new Position("StreamingLogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        this.test("handling empty RDDs in a stream", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StreamingLogisticRegressionWithSGD model = new StreamingLogisticRegressionWithSGD().setInitialWeights(Vectors$.MODULE$.dense(-0.1, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))).setStepSize(0.01).setNumIterations(10);
            int numBatches = 10;
            Seq emptyInput = (Seq)Nil$.MODULE$;
            this.ssc_$eq(this.setupStreams(emptyInput, (Function1 & Serializable & scala.Serializable)inputDStream -> {
                model.trainOn(inputDStream);
                return model.predictOnValues(inputDStream.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)BoxesRunTime.boxToDouble((double)x.label()), (Object)x.features()), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double());
            }, this.setupStreams$default$3(), ClassTag$.MODULE$.apply(LabeledPoint.class), ClassTag$.MODULE$.apply(Tuple2.class)));
            Seq output = this.runStreams(this.ssc(), numBatches, numBatches, this.runStreams$default$4(), ClassTag$.MODULE$.Nothing());
        }, new Position("StreamingLogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
    }
}

