/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.evaluation.RegressionEvaluator;
import org.apache.spark.ml.evaluation.RegressionEvaluatorSuite$;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.ParamsSuite$;
import org.apache.spark.ml.regression.LinearRegression;
import org.apache.spark.ml.regression.LinearRegressionModel;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.evaluation.RegressionMetrics;
import org.apache.spark.mllib.util.LinearDataGenerator$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00112AAA\u0002\u0001\u001d!)\u0001\u0005\u0001C\u0001C\tA\"+Z4sKN\u001c\u0018n\u001c8Fm\u0006dW/\u0019;peN+\u0018\u000e^3\u000b\u0005\u0011)\u0011AC3wC2,\u0018\r^5p]*\u0011aaB\u0001\u0003[2T!\u0001C\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005)Y\u0011AB1qC\u000eDWMC\u0001\r\u0003\ry'oZ\u0002\u0001'\u0011\u0001qbE\u000e\u0011\u0005A\tR\"A\u0004\n\u0005I9!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u001535\tQC\u0003\u0002\u0017/\u0005!Q\u000f^5m\u0015\tAr!A\u0003nY2L'-\u0003\u0002\u001b+\t)R\n\u00147jER+7\u000f^*qCJ\\7i\u001c8uKb$\bC\u0001\u000f\u001f\u001b\u0005i\"B\u0001\f\u0006\u0013\tyRD\u0001\u000bEK\u001a\fW\u000f\u001c;SK\u0006$wK]5uKR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\t\u0002\"a\t\u0001\u000e\u0003\r\u0001")
public class RegressionEvaluatorSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest.testDefaultReadWrite$(this, instance, testParams);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest.testDefaultReadWrite$default$2$(this);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testEstimatorParams, Map<String, Object> testModelParams, Function2<M, M, BoxedUnit> checkModelData) {
        DefaultReadWriteTest.testEstimatorAndModelReadWrite$(this, estimator, dataset, testEstimatorParams, testModelParams, checkModelData);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private final void testImplicits$lzycompute$1() {
        RegressionEvaluatorSuite regressionEvaluatorSuite = this;
        synchronized (regressionEvaluatorSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public RegressionEvaluatorSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        DefaultReadWriteTest.$init$(this);
        this.test("params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ParamsSuite$.MODULE$.checkParams((Params)new RegressionEvaluator()), new Position("RegressionEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
        this.test("Regression Evaluator: default params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(RegressionEvaluatorSuite.class.getClassLoader());
            public final class Org_apache_spark_ml_evaluation_RegressionEvaluatorSuite$$typecreator6$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.feature.LabeledPoint").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_evaluation_RegressionEvaluatorSuite$$typecreator6$1(RegressionEvaluatorSuite $outer) {
                }
            }
            Dataset dataset = this.testImplicits().localSeqToDatasetHolder((Seq)LinearDataGenerator$.MODULE$.generateLinearInput(6.3, new double[]{4.7, 7.2}, new double[]{0.9, -1.3}, new double[]{0.7, 1.2}, 100, 42, 0.1).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.asML(), Seq$.MODULE$.canBuildFrom()), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_evaluation_RegressionEvaluatorSuite$$typecreator6$1(null)))).toDF();
            LinearRegression trainer = new LinearRegression();
            LinearRegressionModel model = (LinearRegressionModel)trainer.fit(dataset);
            Dataset predictions = model.transform(dataset);
            RegressionEvaluator evaluator = new RegressionEvaluator();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(evaluator.evaluate(predictions)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.1013829).absTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(evaluator.evaluate(predictions)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.1013829).absTol(0.01))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RegressionEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            evaluator.setMetricName("r2");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(evaluator.evaluate(predictions)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.9998387).absTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(evaluator.evaluate(predictions)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.9998387).absTol(0.01))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RegressionEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            evaluator.setMetricName("mae");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(evaluator.evaluate(predictions)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.08399089).absTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(evaluator.evaluate(predictions)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.08399089).absTol(0.01))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RegressionEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
            evaluator.setMetricName("var");
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(evaluator.evaluate(predictions)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(63.6944519).absTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(evaluator.evaluate(predictions)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(63.6944519).absTol(0.01))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RegressionEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        }, new Position("RegressionEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        this.test("read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            RegressionEvaluator evaluator = new RegressionEvaluator().setPredictionCol("myPrediction").setLabelCol("myLabel").setMetricName("r2");
            return this.testDefaultReadWrite(evaluator, this.testDefaultReadWrite$default$2());
        }, new Position("RegressionEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        this.test("should support all NumericType labels and not support other types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MLTestingUtils$.MODULE$.checkNumericTypes(new RegressionEvaluator(), this.spark()), new Position("RegressionEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("getMetrics", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(RegressionEvaluatorSuite.class.getClassLoader());
            public final class Org_apache_spark_ml_evaluation_RegressionEvaluatorSuite$$typecreator16$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.feature.LabeledPoint").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_evaluation_RegressionEvaluatorSuite$$typecreator16$1(RegressionEvaluatorSuite $outer) {
                }
            }
            Dataset dataset = this.testImplicits().localSeqToDatasetHolder((Seq)LinearDataGenerator$.MODULE$.generateLinearInput(6.3, new double[]{4.7, 7.2}, new double[]{0.9, -1.3}, new double[]{0.7, 1.2}, 100, 42, 0.1).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.asML(), Seq$.MODULE$.canBuildFrom()), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_evaluation_RegressionEvaluatorSuite$$typecreator16$1(null)))).toDF();
            LinearRegression trainer = new LinearRegression();
            LinearRegressionModel model = (LinearRegressionModel)trainer.fit(dataset);
            Dataset predictions = model.transform(dataset);
            RegressionEvaluator evaluator = new RegressionEvaluator();
            RegressionMetrics metrics = evaluator.getMetrics(predictions);
            double rmse = metrics.rootMeanSquaredError();
            double r2 = metrics.r2();
            double mae = metrics.meanAbsoluteError();
            double variance = metrics.explainedVariance();
            double $org_scalatest_assert_macro_left = evaluator.evaluate(predictions);
            double $org_scalatest_assert_macro_right = rmse;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RegressionEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            evaluator.setMetricName("r2");
            double $org_scalatest_assert_macro_left2 = evaluator.evaluate(predictions);
            double $org_scalatest_assert_macro_right2 = r2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RegressionEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
            evaluator.setMetricName("mae");
            double $org_scalatest_assert_macro_left3 = evaluator.evaluate(predictions);
            double $org_scalatest_assert_macro_right3 = mae;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RegressionEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            evaluator.setMetricName("var");
            double $org_scalatest_assert_macro_left4 = evaluator.evaluate(predictions);
            double $org_scalatest_assert_macro_right4 = variance;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RegressionEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        }, new Position("RegressionEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
    }
}

