/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import java.io.Serializable;
import org.apache.spark.Partitioner;
import org.apache.spark.RangePartitioner;
import org.apache.spark.RangePartitioner$;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.regression.IsotonicRegressionModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001U4Aa\u0003\u0007\u0001/!Aa\u0005\u0001BA\u0002\u0013%q\u0005\u0003\u0005,\u0001\t\u0005\r\u0011\"\u0003-\u0011!\u0011\u0004A!A!B\u0013A\u0003\"B\u001a\u0001\t\u0013!\u0004\"B\u001a\u0001\t\u0003A\u0004\"\u0002\"\u0001\t\u0003\u0019\u0005\"B$\u0001\t\u0003A\u0005\"B$\u0001\t\u0003Y\u0006\"B6\u0001\t\u0013a\u0007\"B9\u0001\t\u0013\u0011(AE%t_R|g.[2SK\u001e\u0014Xm]:j_:T!!\u0004\b\u0002\u0015I,wM]3tg&|gN\u0003\u0002\u0010!\u0005)Q\u000e\u001c7jE*\u0011\u0011CE\u0001\u0006gB\f'o\u001b\u0006\u0003'Q\ta!\u00199bG\",'\"A\u000b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Ab\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VM\u001a\t\u0003?\u0011j\u0011\u0001\t\u0006\u0003C\t\n!![8\u000b\u0003\r\nAA[1wC&\u0011Q\u0005\t\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\tSN|Go\u001c8jGV\t\u0001\u0006\u0005\u0002\u001aS%\u0011!F\u0007\u0002\b\u0005>|G.Z1o\u00031I7o\u001c;p]&\u001cw\fJ3r)\ti\u0003\u0007\u0005\u0002\u001a]%\u0011qF\u0007\u0002\u0005+:LG\u000fC\u00042\u0005\u0005\u0005\t\u0019\u0001\u0015\u0002\u0007a$\u0013'A\u0005jg>$xN\\5dA\u00051A(\u001b8jiz\"\"!N\u001c\u0011\u0005Y\u0002Q\"\u0001\u0007\t\u000b\u0019\"\u0001\u0019\u0001\u0015\u0015\u0003UB3!\u0002\u001eA!\tYd(D\u0001=\u0015\ti\u0004#\u0001\u0006b]:|G/\u0019;j_:L!a\u0010\u001f\u0003\u000bMKgnY3\"\u0003\u0005\u000bQ!\r\u00184]A\n1b]3u\u0013N|Go\u001c8jGR\u0011A)R\u0007\u0002\u0001!)aE\u0002a\u0001Q!\u001aaA\u000f!\u0002\u0007I,h\u000e\u0006\u0002J\u0019B\u0011aGS\u0005\u0003\u00172\u0011q#S:pi>t\u0017n\u0019*fOJ,7o]5p]6{G-\u001a7\t\u000b5;\u0001\u0019\u0001(\u0002\u000b%t\u0007/\u001e;\u0011\u0007=\u0013F+D\u0001Q\u0015\t\t\u0006#A\u0002sI\u0012L!a\u0015)\u0003\u0007I#E\tE\u0003\u001a+^;v+\u0003\u0002W5\t1A+\u001e9mKN\u0002\"!\u0007-\n\u0005eS\"A\u0002#pk\ndW\rK\u0002\bu\u0001#\"!\u0013/\t\u000b5C\u0001\u0019A/\u0011\u0007y\u0013G-D\u0001`\u0015\t\u0019\u0003M\u0003\u0002b!\u0005\u0019\u0011\r]5\n\u0005\r|&a\u0002&bm\u0006\u0014F\t\u0012\t\u00063U+W-\u001a\t\u0003M&l\u0011a\u001a\u0006\u0003Q\n\nA\u0001\\1oO&\u0011\u0011l\u001a\u0015\u0004\u0011i\u0002\u0015!\u00069p_2\fEM[1dK:$h+[8mCR|'o\u001d\u000b\u0003[B\u00042!\u00078U\u0013\ty'DA\u0003BeJ\f\u0017\u0010C\u0003N\u0013\u0001\u0007Q.A\u000fqCJ\fG\u000e\\3m!>|G.\u00113kC\u000e,g\u000e\u001e,j_2\fGo\u001c:t)\ti7\u000fC\u0003N\u0015\u0001\u0007a\nK\u0002\u0001u\u0001\u0003")
public class IsotonicRegression
implements Serializable {
    private boolean isotonic;

    private boolean isotonic() {
        return this.isotonic;
    }

    private void isotonic_$eq(boolean x$1) {
        this.isotonic = x$1;
    }

    public IsotonicRegression setIsotonic(boolean isotonic) {
        this.isotonic_$eq(isotonic);
        return this;
    }

    public IsotonicRegressionModel run(RDD<Tuple3<Object, Object, Object>> input) {
        RDD preprocessedInput = this.isotonic() ? input : input.map((Function1 & Serializable & scala.Serializable)x -> new Tuple3((Object)BoxesRunTime.boxToDouble((double)(-BoxesRunTime.unboxToDouble((Object)x._1()))), x._2(), x._3()), ClassTag$.MODULE$.apply(Tuple3.class));
        Tuple3<Object, Object, Object>[] pooled = this.parallelPoolAdjacentViolators(preprocessedInput);
        double[] predictions = this.isotonic() ? (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pooled)).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)IsotonicRegression.$anonfun$run$2(x$5)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())) : (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pooled)).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToDouble((double)IsotonicRegression.$anonfun$run$3(x$6)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double[] boundaries = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pooled)).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToDouble((double)IsotonicRegression.$anonfun$run$4(x$7)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return new IsotonicRegressionModel(boundaries, predictions, this.isotonic());
    }

    public IsotonicRegressionModel run(JavaRDD<Tuple3<Double, Double, Double>> input) {
        return this.run((RDD<Tuple3<Object, Object, Object>>)input.rdd().retag(ClassTag$.MODULE$.apply(Tuple3.class)));
    }

    private Tuple3<Object, Object, Object>[] poolAdjacentViolators(Tuple3<Object, Object, Object>[] input) {
        Tuple3[] cleanInput = (Tuple3[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])input)).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)IsotonicRegression.$anonfun$poolAdjacentViolators$1(x0$1)));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cleanInput)).isEmpty()) {
            return (Tuple3[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple3.class));
        }
        int[] blockBounds = Array$.MODULE$.range(0, cleanInput.length);
        Tuple2[] weights = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cleanInput)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple3 tuple3 = x0$2;
            if (tuple3 != null) {
                double y = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                double weight = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                return new Tuple2.mcDD.sp(weight, weight * y);
            }
            throw new MatchError((Object)tuple3);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        int i = 0;
        while (IsotonicRegression.nextBlock$1(i, blockBounds) < cleanInput.length) {
            if (IsotonicRegression.average$1(i, weights) >= IsotonicRegression.average$1(IsotonicRegression.nextBlock$1(i, blockBounds), weights)) {
                IsotonicRegression.merge$1(i, IsotonicRegression.nextBlock$1(i, blockBounds), blockBounds, weights);
                while (i > 0 && IsotonicRegression.average$1(IsotonicRegression.prevBlock$1(i, blockBounds), weights) >= IsotonicRegression.average$1(i, weights)) {
                    i = IsotonicRegression.merge$1(IsotonicRegression.prevBlock$1(i, blockBounds), i, blockBounds, weights);
                }
                continue;
            }
            i = IsotonicRegression.nextBlock$1(i, blockBounds);
        }
        ArrayBuffer output = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        i = 0;
        while (i < cleanInput.length) {
            ArrayBuffer arrayBuffer;
            if (BoxesRunTime.unboxToDouble((Object)cleanInput[IsotonicRegression.blockEnd$1(i, blockBounds)]._2()) > BoxesRunTime.unboxToDouble((Object)cleanInput[i]._2())) {
                output.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)IsotonicRegression.average$1(i, weights)), cleanInput[i]._2(), (Object)BoxesRunTime.boxToDouble((double)(weights[i]._1$mcD$sp() / (double)2))));
                arrayBuffer = output.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)IsotonicRegression.average$1(i, weights)), cleanInput[IsotonicRegression.blockEnd$1(i, blockBounds)]._2(), (Object)BoxesRunTime.boxToDouble((double)(weights[i]._1$mcD$sp() / (double)2))));
            } else {
                arrayBuffer = output.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)IsotonicRegression.average$1(i, weights)), cleanInput[i]._2(), (Object)BoxesRunTime.boxToDouble((double)weights[i]._1$mcD$sp())));
            }
            i = IsotonicRegression.nextBlock$1(i, blockBounds);
        }
        return (Tuple3[])output.toArray(ClassTag$.MODULE$.apply(Tuple3.class));
    }

    private Tuple3<Object, Object, Object>[] parallelPoolAdjacentViolators(RDD<Tuple3<Object, Object, Object>> input2) {
        RDD keyedInput = input2.keyBy((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToDouble((double)IsotonicRegression.$anonfun$parallelPoolAdjacentViolators$1(x$8)));
        RDD qual$1 = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(keyedInput, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(Tuple3.class), (Ordering)Ordering.Double$.MODULE$).partitionBy((Partitioner)new RangePartitioner(keyedInput.getNumPartitions(), keyedInput, RangePartitioner$.MODULE$.$lessinit$greater$default$3(), RangePartitioner$.MODULE$.$lessinit$greater$default$4(), (Ordering)Ordering.Double$.MODULE$, ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(Tuple3.class), (Ordering)Ordering.Double$.MODULE$).values();
        Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)p -> package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[][]{(Tuple3[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])p.toArray(ClassTag$.MODULE$.apply(Tuple3.class)))).sortBy((Function1 & Serializable & scala.Serializable)x -> new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)x._2()), BoxesRunTime.unboxToDouble((Object)x._1())), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Double$.MODULE$, (Ordering)Ordering.Double$.MODULE$))}));
        boolean x$2 = qual$1.mapPartitions$default$2();
        Tuple3[] parallelStepResult = (Tuple3[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple3.class))).flatMap((Function1 & Serializable & scala.Serializable)input -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.poolAdjacentViolators(input))), ClassTag$.MODULE$.apply(Tuple3.class)).collect())).sortBy((Function1 & Serializable & scala.Serializable)x -> new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)x._2()), BoxesRunTime.unboxToDouble((Object)x._1())), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Double$.MODULE$, (Ordering)Ordering.Double$.MODULE$));
        return this.poolAdjacentViolators(parallelStepResult);
    }

    public static final /* synthetic */ double $anonfun$run$2(Tuple3 x$5) {
        return BoxesRunTime.unboxToDouble((Object)x$5._1());
    }

    public static final /* synthetic */ double $anonfun$run$3(Tuple3 x$6) {
        return -BoxesRunTime.unboxToDouble((Object)x$6._1());
    }

    public static final /* synthetic */ double $anonfun$run$4(Tuple3 x$7) {
        return BoxesRunTime.unboxToDouble((Object)x$7._2());
    }

    public static final /* synthetic */ boolean $anonfun$poolAdjacentViolators$1(Tuple3 x0$1) {
        Tuple3 tuple3 = x0$1;
        if (tuple3 != null) {
            double y = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            double x = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            double weight = BoxesRunTime.unboxToDouble((Object)tuple3._3());
            Predef$.MODULE$.require(weight >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Negative weight at point (").append(y).append(", ").append(x).append(", ").append(weight).append("). Weights must be non-negative").toString());
            return weight > 0.0;
        }
        throw new MatchError((Object)tuple3);
    }

    private static final int blockEnd$1(int start, int[] blockBounds$1) {
        return blockBounds$1[start];
    }

    private static final int blockStart$1(int end, int[] blockBounds$1) {
        return blockBounds$1[end];
    }

    private static final int nextBlock$1(int start, int[] blockBounds$1) {
        return IsotonicRegression.blockEnd$1(start, blockBounds$1) + 1;
    }

    private static final int prevBlock$1(int start, int[] blockBounds$1) {
        return IsotonicRegression.blockStart$1(start - 1, blockBounds$1);
    }

    private static final int merge$1(int block1, int block2, int[] blockBounds$1, Tuple2[] weights$1) {
        Predef$.MODULE$.assert(IsotonicRegression.blockEnd$1(block1, blockBounds$1) + 1 == block2, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(147).append("Attempting to merge non-consecutive blocks [").append(block1).append(", ").append(IsotonicRegression.blockEnd$1(block1, blockBounds$1)).append("]").append(" and [").append(block2).append(", ").append(IsotonicRegression.blockEnd$1(block2, blockBounds$1)).append("]. This is likely a bug in the isotonic regression").append(" implementation. Please file a bug report.").toString());
        blockBounds$1[block1] = IsotonicRegression.blockEnd$1(block2, blockBounds$1);
        blockBounds$1[IsotonicRegression.blockEnd$1((int)block2, (int[])blockBounds$1)] = block1;
        Tuple2 w1 = weights$1[block1];
        Tuple2 w2 = weights$1[block2];
        weights$1[block1] = new Tuple2.mcDD.sp(w1._1$mcD$sp() + w2._1$mcD$sp(), w1._2$mcD$sp() + w2._2$mcD$sp());
        return block1;
    }

    private static final double average$1(int start, Tuple2[] weights$1) {
        return weights$1[start]._2$mcD$sp() / weights$1[start]._1$mcD$sp();
    }

    public static final /* synthetic */ double $anonfun$parallelPoolAdjacentViolators$1(Tuple3 x$8) {
        return BoxesRunTime.unboxToDouble((Object)x$8._2());
    }

    private IsotonicRegression(boolean isotonic) {
        this.isotonic = isotonic;
    }

    public IsotonicRegression() {
        this(true);
    }
}

