/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.recommendation;

import com.google.common.collect.Ordering;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.rdd.MLPairRDDFunctions$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel$SaveLoadV1_0$;
import org.apache.spark.mllib.util.Loader;
import org.apache.spark.mllib.util.Loader$;
import org.apache.spark.rdd.RDD;
import org.json4s.JsonAST;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class MatrixFactorizationModel$
implements Loader<MatrixFactorizationModel>,
scala.Serializable {
    public static MatrixFactorizationModel$ MODULE$;

    static {
        new MatrixFactorizationModel$();
    }

    public Tuple2<Object, Object>[] org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommend(double[] recommendToFeatures, RDD<Tuple2<Object, double[]>> recommendableFeatures, int num) {
        RDD scored = recommendableFeatures.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int id = tuple2._1$mcI$sp();
                double[] features = (double[])tuple2._2();
                return new Tuple2.mcID.sp(id, BLAS$.MODULE$.nativeBLAS().ddot(features.length, recommendToFeatures, 1, features, 1));
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return (Tuple2[])scored.top(num, package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)x$3._2$mcD$sp()), (scala.math.Ordering)Ordering.Double$.MODULE$));
    }

    public RDD<Tuple2<Object, Tuple2<Object, Object>[]>> org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommendForAll(int rank, RDD<Tuple2<Object, double[]>> srcFeatures, RDD<Tuple2<Object, double[]>> dstFeatures, int num) {
        RDD<Tuple2<int[], double[]>> srcBlocks = this.blockify(srcFeatures, this.blockify$default$2());
        RDD<Tuple2<int[], double[]>> dstBlocks = this.blockify(dstFeatures, this.blockify$default$2());
        RDD qual$1 = srcBlocks.cartesian(dstBlocks, ClassTag$.MODULE$.apply(Tuple2.class));
        Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)iter -> {
            ObjectRef scores = ObjectRef.create(null);
            ObjectRef idxOrd = ObjectRef.create(null);
            return iter.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        int[] srcIds = (int[])tuple22._1();
                        double[] srcMat = (double[])tuple22._2();
                        if (tuple23 != null) {
                            int[] dstIds = (int[])tuple23._1();
                            double[] dstMat = (double[])tuple23._2();
                            Predef$.MODULE$.require(srcMat.length == srcIds.length * rank);
                            Predef$.MODULE$.require(dstMat.length == dstIds.length * rank);
                            int m = srcIds.length;
                            int n = dstIds.length;
                            if ((double[])scores$1.elem == null || ((double[])scores$1.elem).length < n) {
                                scores$1.elem = (double[])Array$.MODULE$.ofDim(n, ClassTag$.MODULE$.Double());
                                idxOrd$1.elem = new Ordering<Object>(scores){
                                    private final ObjectRef scores$1;

                                    public int compare(int left, int right) {
                                        return package$.MODULE$.Ordering().apply((scala.math.Ordering)Ordering.Double$.MODULE$).compare((Object)BoxesRunTime.boxToDouble((double)((double[])this.scores$1.elem)[left]), (Object)BoxesRunTime.boxToDouble((double)((double[])this.scores$1.elem)[right]));
                                    }
                                    {
                                        this.scores$1 = scores$1;
                                    }
                                };
                            }
                            return package$.MODULE$.Iterator().range(0, m).flatMap((Function1 & Serializable & scala.Serializable)i -> MatrixFactorizationModel$.$anonfun$recommendForAll$3(rank, n, dstMat, srcMat, scores, srcIds, idxOrd, num, dstIds, BoxesRunTime.unboxToInt((Object)i)));
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            });
        };
        boolean x$2 = qual$1.mapPartitions$default$2();
        RDD ratings = qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class));
        return MLPairRDDFunctions$.MODULE$.fromPairRDD(ratings, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class)).topByKey(num, package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToDouble((double)x$4._2$mcD$sp()), (scala.math.Ordering)Ordering.Double$.MODULE$));
    }

    private RDD<Tuple2<int[], double[]>> blockify(RDD<Tuple2<Object, double[]>> features, int blockSize) {
        return features.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> iter.grouped(blockSize).map((Function1 & Serializable & scala.Serializable)block -> new Tuple2(((TraversableOnce)block.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5._1$mcI$sp()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int()), ((TraversableOnce)block.flatMap((Function1 & Serializable & scala.Serializable)x$6 -> new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])x$6._2())), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double()))), features.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private int blockify$default$2() {
        return 4096;
    }

    @Override
    public MatrixFactorizationModel load(SparkContext sc, String path) {
        Tuple3<String, String, JsonAST.JValue> tuple3 = Loader$.MODULE$.loadMetadata(sc, path);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String loadedClassName = (String)tuple3._1();
        String formatVersion = (String)tuple3._2();
        Tuple2 tuple2 = new Tuple2((Object)loadedClassName, (Object)formatVersion);
        String loadedClassName2 = (String)tuple2._1();
        String formatVersion2 = (String)tuple2._2();
        String classNameV1_0 = MatrixFactorizationModel$SaveLoadV1_0$.MODULE$.thisClassName();
        Tuple2 tuple22 = new Tuple2((Object)loadedClassName2, (Object)formatVersion2);
        if (tuple22 != null) {
            String className = (String)tuple22._1();
            String string = (String)tuple22._2();
            if ("1.0".equals(string)) {
                String string2 = className;
                String string3 = classNameV1_0;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    return MatrixFactorizationModel$SaveLoadV1_0$.MODULE$.load(sc, path);
                }
            }
        }
        throw new IOException(new StringBuilder(100).append("MatrixFactorizationModel.load did not recognize model with").append("(class: ").append(loadedClassName2).append(", version: ").append(formatVersion2).append("). Supported:\n").append("  (").append(classNameV1_0).append(", 1.0)").toString());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ Tuple2 $anonfun$recommendForAll$4(int srcId$1, int[] dstIds$1, ObjectRef scores$1, int j) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)srcId$1), (Object)new Tuple2.mcID.sp(dstIds$1[j], ((double[])scores$1.elem)[j]));
    }

    public static final /* synthetic */ Iterator $anonfun$recommendForAll$3(int rank$1, int n$1, double[] dstMat$1, double[] srcMat$1, ObjectRef scores$1, int[] srcIds$1, ObjectRef idxOrd$1, int num$1, int[] dstIds$1, int i) {
        BLAS$.MODULE$.javaBLAS().dgemv("T", rank$1, n$1, 1.0, dstMat$1, 0, rank$1, srcMat$1, i * rank$1, 1, 0.0, (double[])scores$1.elem, 0, 1);
        int srcId = srcIds$1[i];
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((Ordering)idxOrd$1.elem).greatestOf((java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(package$.MODULE$.Iterator().range(0, n$1)).asJava(), num$1)).asScala()).iterator().map((Function1 & Serializable & scala.Serializable)j -> MatrixFactorizationModel$.$anonfun$recommendForAll$4(srcId, dstIds$1, scores$1, BoxesRunTime.unboxToInt((Object)j)));
    }

    private MatrixFactorizationModel$() {
        MODULE$ = this;
    }
}

