/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import java.io.Serializable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.evaluation.RankingMetrics$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001\u0002\t\u0012\u0001qA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\t\u000b\u0002\u0011\u0019\u0011)A\u0006\r\")A\n\u0001C\u0001\u001b\")1\u000b\u0001C\u0001)\"Aa\r\u0001EC\u0002\u0013\u0005q\rC\u0003j\u0001\u0011\u0005!\u000eC\u0003p\u0001\u0011%\u0001\u000fC\u0004\u0002\u0004\u0001!\t!!\u0002\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e!9\u00111\u0003\u0001\u0005\n\u0005UqaBA\u0012#!\u0005\u0011Q\u0005\u0004\u0007!EA\t!a\n\t\r1cA\u0011AA\u0015\u0011\u001d\tY\u0003\u0004C\u0001\u0003[A\u0011\"a\u001a\r\u0003\u0003%I!!\u001b\u0003\u001dI\u000bgn[5oO6+GO]5dg*\u0011!cE\u0001\u000bKZ\fG.^1uS>t'B\u0001\u000b\u0016\u0003\u0015iG\u000e\\5c\u0015\t1r#A\u0003ta\u0006\u00148N\u0003\u0002\u00193\u00051\u0011\r]1dQ\u0016T\u0011AG\u0001\u0004_J<7\u0001A\u000b\u0003;q\u001aB\u0001\u0001\u0010%UA\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t1\u0011I\\=SK\u001a\u0004\"!\n\u0015\u000e\u0003\u0019R!aJ\u000b\u0002\u0011%tG/\u001a:oC2L!!\u000b\u0014\u0003\u000f1{wmZ5oOB\u0011qdK\u0005\u0003Y\u0001\u0012AbU3sS\u0006d\u0017N_1cY\u0016\f1\u0003\u001d:fI&\u001cG/[8o\u0003:$G*\u00192fYN\u00042a\f\u001a5\u001b\u0005\u0001$BA\u0019\u0016\u0003\r\u0011H\rZ\u0005\u0003gA\u00121A\u0015#E!\u0011yRgN\u001c\n\u0005Y\u0002#A\u0002+va2,'\u0007E\u0002 qiJ!!\u000f\u0011\u0003\u000b\u0005\u0013(/Y=\u0011\u0005mbD\u0002\u0001\u0003\u0006{\u0001\u0011\rA\u0010\u0002\u0002)F\u0011qH\u0011\t\u0003?\u0001K!!\u0011\u0011\u0003\u000f9{G\u000f[5oOB\u0011qdQ\u0005\u0003\t\u0002\u00121!\u00118z\u0003))g/\u001b3f]\u000e,G%\r\t\u0004\u000f*ST\"\u0001%\u000b\u0005%\u0003\u0013a\u0002:fM2,7\r^\u0005\u0003\u0017\"\u0013\u0001b\u00117bgN$\u0016mZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00059\u0013FCA(R!\r\u0001\u0006AO\u0007\u0002#!)Qi\u0001a\u0002\r\")Qf\u0001a\u0001]\u0005Y\u0001O]3dSNLwN\\!u)\t)\u0006\f\u0005\u0002 -&\u0011q\u000b\t\u0002\u0007\t>,(\r\\3\t\u000be#\u0001\u0019\u0001.\u0002\u0003-\u0004\"aH.\n\u0005q\u0003#aA%oi\"\u001aAA\u00183\u0011\u0005}\u0013W\"\u00011\u000b\u0005\u0005,\u0012AC1o]>$\u0018\r^5p]&\u00111\r\u0019\u0002\u0006'&t7-Z\u0011\u0002K\u0006)\u0011G\f\u001a/a\u0005!R.Z1o\u0003Z,'/Y4f!J,7-[:j_:,\u0012!\u0016\u0015\u0004\u000by#\u0017AF7fC:\fe/\u001a:bO\u0016\u0004&/Z2jg&|g.\u0011;\u0015\u0005U[\u0007\"B-\u0007\u0001\u0004Q\u0006f\u0001\u0004_[\u0006\na.A\u00034]Ar\u0003'\u0001\tbm\u0016\u0014\u0018mZ3Qe\u0016\u001c\u0017n]5p]R)Q+]:\u0002\u0002!)!o\u0002a\u0001o\u0005!\u0001O]3e\u0011\u0015!x\u00011\u0001v\u0003\ra\u0017M\u0019\t\u0004mvTdBA<|!\tA\b%D\u0001z\u0015\tQ8$\u0001\u0004=e>|GOP\u0005\u0003y\u0002\na\u0001\u0015:fI\u00164\u0017B\u0001@\u0000\u0005\r\u0019V\r\u001e\u0006\u0003y\u0002BQ!W\u0004A\u0002i\u000baA\u001c3dO\u0006#HcA+\u0002\b!)\u0011\f\u0003a\u00015\"\u001a\u0001B\u00183\u0002\u0011I,7-\u00197m\u0003R$2!VA\b\u0011\u0015I\u0016\u00021\u0001[Q\rIa,\\\u0001\u0017G>,h\u000e\u001e*fY\u00164\u0018M\u001c;Ji\u0016l'+\u0019;j_RIQ+a\u0006\u0002\u001a\u0005m\u0011Q\u0004\u0005\u0006e*\u0001\ra\u000e\u0005\u0006i*\u0001\ra\u000e\u0005\u00063*\u0001\rA\u0017\u0005\u0007\u0003?Q\u0001\u0019\u0001.\u0002\u0017\u0011,gn\\7j]\u0006$xN\u001d\u0015\u0004\u0001y#\u0017A\u0004*b].LgnZ'fiJL7m\u001d\t\u0003!2\u00192\u0001\u0004\u0010+)\t\t)#\u0001\u0002pMV1\u0011qFA\u001b\u0003\u001f\"B!!\r\u0002:A!\u0001\u000bAA\u001a!\rY\u0014Q\u0007\u0003\u0007\u0003oq!\u0019\u0001 \u0003\u0003\u0015Ca!\f\bA\u0002\u0005m\u0002CBA\u001f\u0003\u000f\nY%\u0004\u0002\u0002@)!\u0011\u0011IA\"\u0003\u0011Q\u0017M^1\u000b\u0007\u0005\u0015S#A\u0002ba&LA!!\u0013\u0002@\t9!*\u0019<b%\u0012#\u0005CB\u00106\u0003\u001b\ni\u0005E\u0002<\u0003\u001f\"a!\u0010\bC\u0002\u0005E\u0013cA \u0002TA1\u0011QKA/\u0003gi!!a\u0016\u000b\t\u0005e\u00131L\u0001\u0005Y\u0006twM\u0003\u0002\u0002B%!\u0011qLA,\u0005!IE/\u001a:bE2,\u0007\u0006\u0002\b_\u0003G\n#!!\u001a\u0002\u000bErCG\f\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003W\u0002B!!\u0016\u0002n%!\u0011qNA,\u0005\u0019y%M[3di\u0002")
public class RankingMetrics<T>
implements Logging,
scala.Serializable {
    private double meanAveragePrecision;
    private final RDD<Tuple2<Object, Object>> predictionAndLabels;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static <E, T extends Iterable<E>> RankingMetrics<E> of(JavaRDD<Tuple2<T, T>> javaRDD) {
        return RankingMetrics$.MODULE$.of(javaRDD);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public double precisionAt(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable & scala.Serializable)() -> "ranking position k should be positive");
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictionAndLabels.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)RankingMetrics.$anonfun$precisionAt$2(this, k, x0$1)), ClassTag$.MODULE$.Double())).mean();
    }

    private double meanAveragePrecision$lzycompute() {
        RankingMetrics rankingMetrics = this;
        synchronized (rankingMetrics) {
            if (!this.bitmap$0) {
                this.meanAveragePrecision = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictionAndLabels.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)RankingMetrics.$anonfun$meanAveragePrecision$1(this, x0$1)), ClassTag$.MODULE$.Double())).mean();
                this.bitmap$0 = true;
            }
        }
        return this.meanAveragePrecision;
    }

    public double meanAveragePrecision() {
        if (!this.bitmap$0) {
            return this.meanAveragePrecision$lzycompute();
        }
        return this.meanAveragePrecision;
    }

    public double meanAveragePrecisionAt(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable & scala.Serializable)() -> "ranking position k should be positive");
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictionAndLabels.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)RankingMetrics.$anonfun$meanAveragePrecisionAt$2(this, k, x0$1)), ClassTag$.MODULE$.Double())).mean();
    }

    private double averagePrecision(Object pred, Set<T> lab, int k) {
        if (lab.nonEmpty()) {
            int cnt = 0;
            double precSum = 0.0;
            int n = package$.MODULE$.min(k, ScalaRunTime$.MODULE$.array_length(pred));
            for (int i = 0; i < n; ++i) {
                if (!lab.contains(ScalaRunTime$.MODULE$.array_apply(pred, i))) continue;
                precSum += (double)(++cnt) / (double)(i + 1);
            }
            return precSum / (double)package$.MODULE$.min(lab.size(), k);
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Empty ground truth set, check input data");
        return 0.0;
    }

    public double ndcgAt(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable & scala.Serializable)() -> "ranking position k should be positive");
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictionAndLabels.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)RankingMetrics.$anonfun$ndcgAt$2(this, k, x0$1)), ClassTag$.MODULE$.Double())).mean();
    }

    public double recallAt(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable & scala.Serializable)() -> "ranking position k should be positive");
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictionAndLabels.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)RankingMetrics.$anonfun$recallAt$2(this, k, x0$1)), ClassTag$.MODULE$.Double())).mean();
    }

    private double countRelevantItemRatio(Object pred, Object lab, int k, int denominator) {
        Set labSet = Predef$.MODULE$.genericArrayOps(lab).toSet();
        if (labSet.nonEmpty()) {
            int n = package$.MODULE$.min(ScalaRunTime$.MODULE$.array_length(pred), k);
            int cnt = 0;
            for (int i = 0; i < n; ++i) {
                if (!labSet.contains(ScalaRunTime$.MODULE$.array_apply(pred, i))) continue;
                ++cnt;
            }
            return (double)cnt / (double)denominator;
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Empty ground truth set, check input data");
        return 0.0;
    }

    public static final /* synthetic */ double $anonfun$precisionAt$2(RankingMetrics $this, int k$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object pred = tuple2._1();
            Object lab = tuple2._2();
            return $this.countRelevantItemRatio(pred, lab, k$1, k$1);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ double $anonfun$meanAveragePrecision$1(RankingMetrics $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object pred = tuple2._1();
            Object lab = tuple2._2();
            Set labSet = Predef$.MODULE$.genericArrayOps(lab).toSet();
            int k = package$.MODULE$.max(ScalaRunTime$.MODULE$.array_length(pred), labSet.size());
            return $this.averagePrecision(pred, labSet, k);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ double $anonfun$meanAveragePrecisionAt$2(RankingMetrics $this, int k$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object pred = tuple2._1();
            Object lab = tuple2._2();
            return $this.averagePrecision(pred, Predef$.MODULE$.genericArrayOps(lab).toSet(), k$2);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ double $anonfun$ndcgAt$2(RankingMetrics $this, int k$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object pred = tuple2._1();
            Object lab = tuple2._2();
            Set labSet = Predef$.MODULE$.genericArrayOps(lab).toSet();
            if (labSet.nonEmpty()) {
                int labSetSize = labSet.size();
                int n = package$.MODULE$.min(package$.MODULE$.max(ScalaRunTime$.MODULE$.array_length(pred), labSetSize), k$3);
                double maxDcg = 0.0;
                double dcg = 0.0;
                for (int i = 0; i < n; ++i) {
                    double gain = 1.0 / package$.MODULE$.log((double)(i + 2));
                    if (i < ScalaRunTime$.MODULE$.array_length(pred) && labSet.contains(ScalaRunTime$.MODULE$.array_apply(pred, i))) {
                        dcg += gain;
                    }
                    if (i >= labSetSize) continue;
                    maxDcg += gain;
                }
                return dcg / maxDcg;
            }
            $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Empty ground truth set, check input data");
            return 0.0;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ double $anonfun$recallAt$2(RankingMetrics $this, int k$4, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object pred = tuple2._1();
            Object lab = tuple2._2();
            return $this.countRelevantItemRatio(pred, lab, k$4, Predef$.MODULE$.genericArrayOps(lab).toSet().size());
        }
        throw new MatchError((Object)tuple2);
    }

    public RankingMetrics(RDD<Tuple2<Object, Object>> predictionAndLabels, ClassTag<T> evidence$1) {
        this.predictionAndLabels = predictionAndLabels;
        Logging.$init$((Logging)this);
    }
}

