/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.recommendation;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import org.apache.hadoop.fs.Path;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.recommendation.ALS;
import org.apache.spark.ml.util.DefaultParamsReadable;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.rdd.DeterministicLevel$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.collection.OpenHashMap;
import org.apache.spark.util.collection.OpenHashSet;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Sorting$;

public final class ALS$
implements DefaultParamsReadable<ALS>,
Logging,
scala.Serializable {
    public static ALS$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ALS$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public MLReader<ALS> read() {
        return DefaultParamsReadable.read$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public ALS load(String path) {
        return (ALS)MLReadable.load$(this, path);
    }

    public <ID> Tuple2<RDD<Tuple2<ID, float[]>>, RDD<Tuple2<ID, float[]>>> train(RDD<ALS.Rating<ID>> ratings, int rank, int numUserBlocks, int numItemBlocks, int maxIter, double regParam, boolean implicitPrefs, double alpha, boolean nonnegative, StorageLevel intermediateRDDStorageLevel, StorageLevel finalRDDStorageLevel, int checkpointInterval, long seed, ClassTag<ID> evidence$1, Ordering<ID> ord) {
        BoxedUnit boxedUnit;
        Predef$.MODULE$.require(!ratings.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("No ratings available from ").append(ratings).toString());
        StorageLevel storageLevel = intermediateRDDStorageLevel;
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        Predef$.MODULE$.require(storageLevel == null ? storageLevel2 != null : !storageLevel.equals(storageLevel2), (Function0 & Serializable & scala.Serializable)() -> "ALS is not designed to run without persisting intermediate RDDs.");
        SparkContext sc = ratings.sparkContext();
        HashPartitioner userPart = new HashPartitioner(numUserBlocks);
        HashPartitioner itemPart = new HashPartitioner(numItemBlocks);
        RDD blockRatings = this.partitionRatings(ratings, (Partitioner)userPart, (Partitioner)itemPart, evidence$1).persist(intermediateRDDStorageLevel);
        Tuple2<RDD<Tuple2<Object, ALS.InBlock<ID>>>, RDD<Tuple2<Object, int[][]>>> tuple2 = this.makeBlocks("user", blockRatings, (Partitioner)userPart, (Partitioner)itemPart, intermediateRDDStorageLevel, evidence$1, ord);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        RDD userInBlocks = (RDD)tuple2._1();
        RDD userOutBlocks = (RDD)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)userInBlocks, (Object)userOutBlocks);
        RDD userInBlocks2 = (RDD)tuple22._1();
        RDD userOutBlocks2 = (RDD)tuple22._2();
        userOutBlocks2.count();
        RDD swappedBlockRatings = blockRatings.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                ALS.RatingBlock ratingBlock = (ALS.RatingBlock)tuple2._2();
                if (tuple22 != null) {
                    int userBlockId = tuple22._1$mcI$sp();
                    int itemBlockId = tuple22._2$mcI$sp();
                    if (ratingBlock != null) {
                        Object userIds = ratingBlock.srcIds();
                        Object itemIds = ratingBlock.dstIds();
                        float[] localRatings = ratingBlock.ratings();
                        return new Tuple2((Object)new Tuple2.mcII.sp(itemBlockId, userBlockId), new ALS.RatingBlock(itemIds, userIds, localRatings, evidence$1));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        Tuple2<RDD<Tuple2<Object, ALS.InBlock<ID>>>, RDD<Tuple2<Object, int[][]>>> tuple23 = this.makeBlocks("item", swappedBlockRatings, (Partitioner)itemPart, (Partitioner)userPart, intermediateRDDStorageLevel, evidence$1, ord);
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        RDD itemInBlocks = (RDD)tuple23._1();
        RDD itemOutBlocks = (RDD)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)itemInBlocks, (Object)itemOutBlocks);
        RDD itemInBlocks2 = (RDD)tuple24._1();
        RDD itemOutBlocks2 = (RDD)tuple24._2();
        itemOutBlocks2.count();
        ALS.LocalIndexEncoder userLocalIndexEncoder = new ALS.LocalIndexEncoder(userPart.numPartitions());
        ALS.LocalIndexEncoder itemLocalIndexEncoder = new ALS.LocalIndexEncoder(itemPart.numPartitions());
        XORShiftRandom seedGen = new XORShiftRandom(seed);
        ObjectRef userFactors = ObjectRef.create(this.initialize(userInBlocks2, rank, seedGen.nextLong()));
        ObjectRef itemFactors = ObjectRef.create(this.initialize(itemInBlocks2, rank, seedGen.nextLong()));
        ALS.LeastSquaresNESolver solver = nonnegative ? new ALS.NNLSSolver() : new ALS.CholeskySolver();
        ObjectRef previousCheckpointFile = ObjectRef.create((Object)None$.MODULE$);
        JFunction1.mcZI.sp & Serializable & scala.Serializable shouldCheckpoint = (JFunction1.mcZI.sp & Serializable & scala.Serializable)iter -> sc.checkpointDir().isDefined() && checkpointInterval != -1 && iter % checkpointInterval == 0;
        JFunction0.mcV.sp & Serializable & scala.Serializable deletePreviousCheckpointFile = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Option)previousCheckpointFile$1.elem).foreach((Function1 & Serializable & scala.Serializable)file -> {
            Object object;
            try {
                Path checkpointFile = new Path(file);
                object = BoxesRunTime.boxToBoolean((boolean)checkpointFile.getFileSystem(sc.hadoopConfiguration()).delete(checkpointFile, true));
            }
            catch (IOException e) {
                MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Cannot delete checkpoint file ").append((String)file).append(":").toString(), e);
                object = BoxedUnit.UNIT;
            }
            return object;
        });
        if (implicitPrefs) {
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), maxIter).foreach(arg_0 -> ALS$.$anonfun$train$8$adapted(userFactors, intermediateRDDStorageLevel, itemFactors, userOutBlocks2, itemInBlocks2, rank, regParam, userLocalIndexEncoder, implicitPrefs, alpha, solver, (Function1)shouldCheckpoint, itemOutBlocks2, userInBlocks2, itemLocalIndexEncoder, (Function0)deletePreviousCheckpointFile, previousCheckpointFile, arg_0));
        } else {
            ObjectRef previousCachedItemFactors = ObjectRef.create((Object)None$.MODULE$);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), maxIter).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> ALS$.$anonfun$train$9(itemFactors, userFactors, userOutBlocks2, itemInBlocks2, rank, regParam, userLocalIndexEncoder, solver, (Function1)shouldCheckpoint, intermediateRDDStorageLevel, (Function0)deletePreviousCheckpointFile, previousCachedItemFactors, previousCheckpointFile, itemOutBlocks2, userInBlocks2, itemLocalIndexEncoder, arg_0)));
        }
        RDD userIdAndFactors = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(userInBlocks2, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ALS.InBlock.class), (Ordering)Ordering.Int$.MODULE$).mapValues((Function1 & Serializable & scala.Serializable)x$9 -> x$9.srcIds()), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(evidence$1.runtimeClass())), (Ordering)Ordering.Int$.MODULE$).join((RDD)userFactors.elem).mapPartitions((Function1 & Serializable & scala.Serializable)items -> items.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$2;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                Object ids = tuple2._1();
                float[][] factors = (float[][])tuple2._2();
                return Predef$.MODULE$.genericArrayOps(ids).iterator().zip(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])factors)).iterator());
            }
            throw new MatchError((Object)tuple22);
        }), true, ClassTag$.MODULE$.apply(Tuple2.class)).setName("userFactors").persist(finalRDDStorageLevel);
        RDD itemIdAndFactors = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(itemInBlocks2, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ALS.InBlock.class), (Ordering)Ordering.Int$.MODULE$).mapValues((Function1 & Serializable & scala.Serializable)x$10 -> x$10.srcIds()), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(evidence$1.runtimeClass())), (Ordering)Ordering.Int$.MODULE$).join((RDD)itemFactors.elem).mapPartitions((Function1 & Serializable & scala.Serializable)items -> items.flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$3;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                Object ids = tuple2._1();
                float[][] factors = (float[][])tuple2._2();
                return Predef$.MODULE$.genericArrayOps(ids).iterator().zip(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])factors)).iterator());
            }
            throw new MatchError((Object)tuple22);
        }), true, ClassTag$.MODULE$.apply(Tuple2.class)).setName("itemFactors").persist(finalRDDStorageLevel);
        StorageLevel storageLevel3 = finalRDDStorageLevel;
        StorageLevel storageLevel4 = StorageLevel$.MODULE$.NONE();
        if (storageLevel3 == null ? storageLevel4 != null : !storageLevel3.equals(storageLevel4)) {
            userIdAndFactors.count();
            userInBlocks2.unpersist(userInBlocks2.unpersist$default$1());
            userOutBlocks2.unpersist(userOutBlocks2.unpersist$default$1());
            itemOutBlocks2.unpersist(itemOutBlocks2.unpersist$default$1());
            blockRatings.unpersist(blockRatings.unpersist$default$1());
            itemIdAndFactors.count();
            RDD qual$3 = (RDD)itemFactors.elem;
            boolean x$21 = qual$3.unpersist$default$1();
            qual$3.unpersist(x$21);
            boxedUnit = itemInBlocks2.unpersist(itemInBlocks2.unpersist$default$1());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new Tuple2((Object)userIdAndFactors, (Object)itemIdAndFactors);
    }

    public <ID> int train$default$2() {
        return 10;
    }

    public <ID> int train$default$3() {
        return 10;
    }

    public <ID> int train$default$4() {
        return 10;
    }

    public <ID> int train$default$5() {
        return 10;
    }

    public <ID> double train$default$6() {
        return 0.1;
    }

    public <ID> boolean train$default$7() {
        return false;
    }

    public <ID> double train$default$8() {
        return 1.0;
    }

    public <ID> boolean train$default$9() {
        return false;
    }

    public <ID> StorageLevel train$default$10() {
        return StorageLevel$.MODULE$.MEMORY_AND_DISK();
    }

    public <ID> StorageLevel train$default$11() {
        return StorageLevel$.MODULE$.MEMORY_AND_DISK();
    }

    public <ID> int train$default$12() {
        return 10;
    }

    public <ID> long train$default$13() {
        return 0L;
    }

    private <ID> RDD<Tuple2<Object, float[][]>> initialize(RDD<Tuple2<Object, ALS.InBlock<ID>>> inBlocks, int rank, long seed) {
        return inBlocks.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> iter.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int srcBlockId = tuple2._1$mcI$sp();
                ALS.InBlock inBlock = (ALS.InBlock)tuple2._2();
                XORShiftRandom random = new XORShiftRandom(scala.util.hashing.package$.MODULE$.byteswap64(seed ^ (long)srcBlockId));
                float[][] factors = (float[][])Array$.MODULE$.fill(ScalaRunTime$.MODULE$.array_length(inBlock.srcIds()), (Function0 & Serializable & scala.Serializable)() -> {
                    float[] factor = (float[])Array$.MODULE$.fill(rank, (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> (float)random.nextGaussian(), ClassTag$.MODULE$.Float());
                    float nrm = BLAS$.MODULE$.nativeBLAS().snrm2(rank, factor, 1);
                    BLAS$.MODULE$.nativeBLAS().sscal(rank, 1.0f / nrm, factor, 1);
                    return factor;
                }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)));
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)srcBlockId), (Object)factors);
            }
            throw new MatchError((Object)tuple2);
        }), true, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private <ID> RDD<Tuple2<Tuple2<Object, Object>, ALS.RatingBlock<ID>>> partitionRatings(RDD<ALS.Rating<ID>> ratings, Partitioner srcPart, Partitioner dstPart, ClassTag<ID> evidence$5) {
        int numPartitions = srcPart.numPartitions() * dstPart.numPartitions();
        return RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(ratings.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            ALS.RatingBlockBuilder[] builders = (ALS.RatingBlockBuilder[])Array$.MODULE$.fill(numPartitions, (Function0 & Serializable & scala.Serializable)() -> new ALS.RatingBlockBuilder(evidence$5), ClassTag$.MODULE$.apply(ALS.RatingBlockBuilder.class));
            return iter.flatMap((Function1 & Serializable & scala.Serializable)r -> {
                int srcBlockId = srcPart.getPartition(r.user());
                int dstBlockId = dstPart.getPartition(r.item());
                int idx = srcBlockId + srcPart.numPartitions() * dstBlockId;
                ALS.RatingBlockBuilder builder = builders[idx];
                builder.add(r);
                if (builder.size() >= 2048) {
                    builders$1[idx] = new ALS.RatingBlockBuilder(evidence$5);
                    return package$.MODULE$.Iterator().single((Object)new Tuple2((Object)new Tuple2.mcII.sp(srcBlockId, dstBlockId), builder.build()));
                }
                return package$.MODULE$.Iterator().empty();
            }).$plus$plus((Function0 & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])builders)).iterator().zipWithIndex().filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ALS$.$anonfun$partitionRatings$5(x$11))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    ALS.RatingBlockBuilder block = (ALS.RatingBlockBuilder)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    int srcBlockId = idx % srcPart.numPartitions();
                    int dstBlockId = idx / srcPart.numPartitions();
                    return new Tuple2((Object)new Tuple2.mcII.sp(srcBlockId, dstBlockId), block.build());
                }
                throw new MatchError((Object)tuple2);
            }));
        }, ratings.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(ALS.RatingBlock.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).groupByKey(), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Iterable.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).mapValues((Function1 & Serializable & scala.Serializable)blocks -> {
            ALS.RatingBlockBuilder builder = new ALS.RatingBlockBuilder(evidence$5);
            blocks.foreach((Function1 & Serializable & scala.Serializable)other -> builder.merge(other));
            return builder.build();
        }).setName("ratingBlocks");
    }

    private <ID> Tuple2<RDD<Tuple2<Object, ALS.InBlock<ID>>>, RDD<Tuple2<Object, int[][]>>> makeBlocks(String prefix, RDD<Tuple2<Tuple2<Object, Object>, ALS.RatingBlock<ID>>> ratingBlocks, Partitioner srcPart, Partitioner dstPart, StorageLevel storageLevel, ClassTag<ID> evidence$10, Ordering<ID> srcOrd) {
        RDD inBlocks = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(ratingBlocks.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                ALS.RatingBlock ratingBlock = (ALS.RatingBlock)tuple2._2();
                if (tuple22 != null) {
                    int srcBlockId = tuple22._1$mcI$sp();
                    int dstBlockId = tuple22._2$mcI$sp();
                    if (ratingBlock != null) {
                        Object srcIds = ratingBlock.srcIds();
                        Object dstIds = ratingBlock.dstIds();
                        float[] ratings = ratingBlock.ratings();
                        long start = System.nanoTime();
                        OpenHashSet dstIdSet = new OpenHashSet(0x100000, evidence$10);
                        Predef$.MODULE$.genericArrayOps(dstIds).foreach((Function1 & Serializable & scala.Serializable)k -> {
                            dstIdSet.add(k);
                            return BoxedUnit.UNIT;
                        });
                        Object sortedDstIds = evidence$10.newArray(dstIdSet.size());
                        int i = 0;
                        int pos = dstIdSet.nextPos(0);
                        while (pos != -1) {
                            ScalaRunTime$.MODULE$.array_update(sortedDstIds, i, dstIdSet.getValue(pos));
                            pos = dstIdSet.nextPos(pos + 1);
                            ++i;
                        }
                        Predef$.MODULE$.assert(i == dstIdSet.size());
                        Sorting$.MODULE$.quickSort(sortedDstIds, srcOrd);
                        OpenHashMap.mcI.sp dstIdToLocalIndex = new OpenHashMap.mcI.sp(ScalaRunTime$.MODULE$.array_length(sortedDstIds), evidence$10, ClassTag$.MODULE$.Int());
                        for (i = 0; i < ScalaRunTime$.MODULE$.array_length(sortedDstIds); ++i) {
                            dstIdToLocalIndex.update$mcI$sp(ScalaRunTime$.MODULE$.array_apply(sortedDstIds, i), i);
                        }
                        MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Converting to local indices took ").append((double)(System.nanoTime() - start) / 1.0E9).append(" seconds.").toString());
                        int[] dstLocalIndices = (int[])Predef$.MODULE$.genericArrayOps(dstIds).map(arg_0 -> ALS$.$anonfun$makeBlocks$4$adapted((OpenHashMap)dstIdToLocalIndex, arg_0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)srcBlockId), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)dstBlockId), srcIds, (Object)dstLocalIndices, (Object)ratings));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple4.class), (Ordering)Ordering.Int$.MODULE$).groupByKey((Partitioner)new HashPartitioner(srcPart.numPartitions())), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Iterable.class), (Ordering)Ordering.Int$.MODULE$).mapValues((Function1 & Serializable & scala.Serializable)iter -> {
            ALS.UncompressedInBlockBuilder builder = new ALS.UncompressedInBlockBuilder(new ALS.LocalIndexEncoder(dstPart.numPartitions()), evidence$10, srcOrd);
            iter.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple4 tuple4 = x0$2;
                if (tuple4 != null) {
                    int dstBlockId = BoxesRunTime.unboxToInt((Object)tuple4._1());
                    Object srcIds = tuple4._2();
                    int[] dstLocalIndices = (int[])tuple4._3();
                    float[] ratings = (float[])tuple4._4();
                    return builder.add(dstBlockId, srcIds, dstLocalIndices, ratings);
                }
                throw new MatchError((Object)tuple4);
            });
            return builder.build().compress();
        }).setName(new StringBuilder(8).append(prefix).append("InBlocks").toString()).persist(storageLevel);
        RDD outBlocks = RDD$.MODULE$.rddToPairRDDFunctions(inBlocks, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ALS.InBlock.class), (Ordering)Ordering.Int$.MODULE$).mapValues((Function1 & Serializable & scala.Serializable)x0$3 -> {
            ALS.InBlock inBlock = x0$3;
            if (inBlock != null) {
                Object srcIds = inBlock.srcIds();
                int[] dstPtrs = inBlock.dstPtrs();
                int[] dstEncodedIndices = inBlock.dstEncodedIndices();
                ALS.LocalIndexEncoder encoder = new ALS.LocalIndexEncoder(dstPart.numPartitions());
                ArrayBuilder[] activeIds = (ArrayBuilder[])Array$.MODULE$.fill(dstPart.numPartitions(), (Function0 & Serializable & scala.Serializable)() -> ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Int()), ClassTag$.MODULE$.apply(ArrayBuilder.class));
                boolean[] seen = new boolean[dstPart.numPartitions()];
                for (int i = 0; i < ScalaRunTime$.MODULE$.array_length(srcIds); ++i) {
                    Arrays.fill(seen, false);
                    for (int j = dstPtrs[i]; j < dstPtrs[i + 1]; ++j) {
                        int dstBlockId = encoder.blockId(dstEncodedIndices[j]);
                        if (seen[dstBlockId]) continue;
                        activeIds[dstBlockId].$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                        seen[dstBlockId] = true;
                    }
                }
                return (int[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])activeIds)).map((Function1 & Serializable & scala.Serializable)x -> (int[])x.result(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
            }
            throw new MatchError((Object)inBlock);
        }).setName(new StringBuilder(9).append(prefix).append("OutBlocks").toString()).persist(storageLevel);
        return new Tuple2((Object)inBlocks, (Object)outBlocks);
    }

    /*
     * Unable to fully structure code
     */
    private <ID> RDD<Tuple2<Object, float[][]>> computeFactors(RDD<Tuple2<Object, float[][]>> srcFactorBlocks, RDD<Tuple2<Object, int[][]>> srcOutBlocks, RDD<Tuple2<Object, ALS.InBlock<ID>>> dstInBlocks, int rank, double regParam, ALS.LocalIndexEncoder srcEncoder, boolean implicitPrefs, double alpha, ALS.LeastSquaresNESolver solver) {
        numSrcBlocks = srcFactorBlocks.partitions().length;
        YtY = implicitPrefs != false ? new Some((Object)this.computeYtY(srcFactorBlocks, rank)) : None$.MODULE$;
        srcOut = RDD$.MODULE$.rddToPairRDDFunctions(srcOutBlocks, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))), (Ordering)Ordering.Int$.MODULE$).join(srcFactorBlocks).flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$computeFactors$1(scala.Tuple2 ), (Lscala/Tuple2;)Lscala/collection/Iterator;)(), ClassTag$.MODULE$.apply(Tuple2.class));
        merged = RDD$.MODULE$.rddToPairRDDFunctions(srcOut, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).groupByKey((Partitioner)new HashPartitioner(dstInBlocks.partitions().length));
        v0 = dstInBlocks.outputDeterministicLevel();
        var17_14 = DeterministicLevel$.MODULE$.INDETERMINATE();
        if (!(v0 == null ? var17_14 != null : v0.equals(var17_14) == false)) ** GOTO lbl-1000
        v1 = srcOutBlocks.outputDeterministicLevel();
        var18_15 = DeterministicLevel$.MODULE$.INDETERMINATE();
        if (!(v1 != null ? v1.equals(var18_15) == false : var18_15 != null)) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        isBlockRDDNondeterministic = v2;
        return RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(dstInBlocks, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ALS.InBlock.class), (Ordering)Ordering.Int$.MODULE$).join(merged), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).mapValues((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$computeFactors$4(int int boolean scala.Option org.apache.spark.ml.recommendation.ALS$LocalIndexEncoder boolean double org.apache.spark.ml.recommendation.ALS$LeastSquaresNESolver double scala.Tuple2 ), (Lscala/Tuple2;)[[F)((int)numSrcBlocks, (int)rank, (boolean)implicitPrefs, (Option)YtY, (ALS.LocalIndexEncoder)srcEncoder, (boolean)isBlockRDDNondeterministic, (double)alpha, (ALS.LeastSquaresNESolver)solver, (double)regParam));
    }

    private <ID> boolean computeFactors$default$7() {
        return false;
    }

    private <ID> double computeFactors$default$8() {
        return 1.0;
    }

    private ALS.NormalEquation computeYtY(RDD<Tuple2<Object, float[][]>> factorBlocks, int rank) {
        return (ALS.NormalEquation)RDD$.MODULE$.rddToPairRDDFunctions(factorBlocks, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE))), (Ordering)Ordering.Int$.MODULE$).values().aggregate((Object)new ALS.NormalEquation(rank), (Function2 & Serializable & scala.Serializable)(ne, factors) -> {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])factors)).foreach((Function1 & Serializable & scala.Serializable)x$12 -> ne.add((float[])x$12, 0.0, ne.add$default$3()));
            return ne;
        }, (Function2 & Serializable & scala.Serializable)(ne1, ne2) -> ne1.merge((ALS.NormalEquation)ne2), ClassTag$.MODULE$.apply(ALS.NormalEquation.class));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ RDD $anonfun$train$8(ObjectRef userFactors$1, StorageLevel intermediateRDDStorageLevel$1, ObjectRef itemFactors$1, RDD userOutBlocks$1, RDD itemInBlocks$1, int rank$1, double regParam$1, ALS.LocalIndexEncoder userLocalIndexEncoder$1, boolean implicitPrefs$1, double alpha$1, ALS.LeastSquaresNESolver solver$1, Function1 shouldCheckpoint$1, RDD itemOutBlocks$1, RDD userInBlocks$1, ALS.LocalIndexEncoder itemLocalIndexEncoder$1, Function0 deletePreviousCheckpointFile$1, ObjectRef previousCheckpointFile$1, int iter) {
        RDD previousUserFactors;
        block1: {
            ((RDD)userFactors$1.elem).setName(new StringBuilder(12).append("userFactors-").append(iter).toString()).persist(intermediateRDDStorageLevel$1);
            RDD previousItemFactors = (RDD)itemFactors$1.elem;
            itemFactors$1.elem = MODULE$.computeFactors((RDD<Tuple2<Object, float[][]>>)((RDD)userFactors$1.elem), (RDD<Tuple2<Object, int[][]>>)userOutBlocks$1, itemInBlocks$1, rank$1, regParam$1, userLocalIndexEncoder$1, implicitPrefs$1, alpha$1, solver$1);
            previousItemFactors.unpersist(previousItemFactors.unpersist$default$1());
            ((RDD)itemFactors$1.elem).setName(new StringBuilder(12).append("itemFactors-").append(iter).toString()).persist(intermediateRDDStorageLevel$1);
            if (shouldCheckpoint$1.apply$mcZI$sp(iter)) {
                ((RDD)itemFactors$1.elem).checkpoint();
            }
            previousUserFactors = (RDD)userFactors$1.elem;
            userFactors$1.elem = MODULE$.computeFactors((RDD<Tuple2<Object, float[][]>>)((RDD)itemFactors$1.elem), (RDD<Tuple2<Object, int[][]>>)itemOutBlocks$1, userInBlocks$1, rank$1, regParam$1, itemLocalIndexEncoder$1, implicitPrefs$1, alpha$1, solver$1);
            if (!shouldCheckpoint$1.apply$mcZI$sp(iter)) break block1;
            RDD qual$1 = (RDD)itemFactors$1.elem;
            boolean x$1 = qual$1.cleanShuffleDependencies$default$1();
            qual$1.cleanShuffleDependencies(x$1);
            deletePreviousCheckpointFile$1.apply$mcV$sp();
            previousCheckpointFile$1.elem = ((RDD)itemFactors$1.elem).getCheckpointFile();
        }
        return previousUserFactors.unpersist(previousUserFactors.unpersist$default$1());
    }

    public static final /* synthetic */ void $anonfun$train$9(ObjectRef itemFactors$1, ObjectRef userFactors$1, RDD userOutBlocks$1, RDD itemInBlocks$1, int rank$1, double regParam$1, ALS.LocalIndexEncoder userLocalIndexEncoder$1, ALS.LeastSquaresNESolver solver$1, Function1 shouldCheckpoint$1, StorageLevel intermediateRDDStorageLevel$1, Function0 deletePreviousCheckpointFile$1, ObjectRef previousCachedItemFactors$1, ObjectRef previousCheckpointFile$1, RDD itemOutBlocks$1, RDD userInBlocks$1, ALS.LocalIndexEncoder itemLocalIndexEncoder$1, int iter) {
        RDD x$2 = (RDD)userFactors$1.elem;
        RDD x$3 = userOutBlocks$1;
        RDD x$4 = itemInBlocks$1;
        int x$5 = rank$1;
        double x$6 = regParam$1;
        ALS.LocalIndexEncoder x$7 = userLocalIndexEncoder$1;
        ALS.LeastSquaresNESolver x$82 = solver$1;
        boolean x$9 = MODULE$.computeFactors$default$7();
        double x$10 = MODULE$.computeFactors$default$8();
        itemFactors$1.elem = MODULE$.computeFactors((RDD<Tuple2<Object, float[][]>>)x$2, (RDD<Tuple2<Object, int[][]>>)x$3, x$4, x$5, x$6, x$7, x$9, x$10, x$82);
        if (shouldCheckpoint$1.apply$mcZI$sp(iter)) {
            ((RDD)itemFactors$1.elem).setName(new StringBuilder(12).append("itemFactors-").append(iter).toString()).persist(intermediateRDDStorageLevel$1);
            ((RDD)itemFactors$1.elem).checkpoint();
            ((RDD)itemFactors$1.elem).count();
            RDD qual$2 = (RDD)itemFactors$1.elem;
            boolean x$11 = qual$2.cleanShuffleDependencies$default$1();
            qual$2.cleanShuffleDependencies(x$11);
            deletePreviousCheckpointFile$1.apply$mcV$sp();
            ((Option)previousCachedItemFactors$1.elem).foreach((Function1 & Serializable & scala.Serializable)x$8 -> x$8.unpersist(x$8.unpersist$default$1()));
            previousCheckpointFile$1.elem = ((RDD)itemFactors$1.elem).getCheckpointFile();
            previousCachedItemFactors$1.elem = Option$.MODULE$.apply((Object)((RDD)itemFactors$1.elem));
        }
        RDD x$12 = (RDD)itemFactors$1.elem;
        RDD x$13 = itemOutBlocks$1;
        RDD x$14 = userInBlocks$1;
        int x$15 = rank$1;
        double x$16 = regParam$1;
        ALS.LocalIndexEncoder x$17 = itemLocalIndexEncoder$1;
        ALS.LeastSquaresNESolver x$18 = solver$1;
        boolean x$19 = MODULE$.computeFactors$default$7();
        double x$20 = MODULE$.computeFactors$default$8();
        userFactors$1.elem = MODULE$.computeFactors((RDD<Tuple2<Object, float[][]>>)x$12, (RDD<Tuple2<Object, int[][]>>)x$13, x$14, x$15, x$16, x$17, x$19, x$20, x$18);
    }

    public static final /* synthetic */ boolean $anonfun$partitionRatings$5(Tuple2 x$11) {
        return ((ALS.RatingBlockBuilder)x$11._1()).size() > 0;
    }

    public static final /* synthetic */ float[] $anonfun$computeFactors$3(float[][] srcFactors$1, int idx) {
        return srcFactors$1[idx];
    }

    public static final /* synthetic */ Iterator $anonfun$computeFactors$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int srcBlockId = tuple2._1$mcI$sp();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 != null) {
                int[][] srcOutBlock = (int[][])tuple22._1();
                float[][] srcFactors = (float[][])tuple22._2();
                return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])srcOutBlock)).iterator().zipWithIndex().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        int[] activeIndices = (int[])tuple2._1();
                        int dstBlockId = tuple2._2$mcI$sp();
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)dstBlockId), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)srcBlockId), new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(activeIndices)).map((Function1 & Serializable & scala.Serializable)idx -> ALS$.$anonfun$computeFactors$3(srcFactors, BoxesRunTime.unboxToInt((Object)idx)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE))))));
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$computeFactors$5(float[][][] sortedSrcFactors$1, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            int srcBlockId = tuple2._1$mcI$sp();
            float[][] factors = (float[][])tuple2._2();
            sortedSrcFactors$1[srcBlockId] = factors;
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ float[][] $anonfun$computeFactors$4(int numSrcBlocks$1, int rank$3, boolean implicitPrefs$2, Option YtY$1, ALS.LocalIndexEncoder srcEncoder$1, boolean isBlockRDDNondeterministic$1, double alpha$2, ALS.LeastSquaresNESolver solver$2, double regParam$2, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            ALS.InBlock inBlock = (ALS.InBlock)tuple2._1();
            Iterable srcFactors = (Iterable)tuple2._2();
            if (inBlock != null) {
                Object dstIds = inBlock.srcIds();
                int[] srcPtrs = inBlock.dstPtrs();
                int[] srcEncodedIndices = inBlock.dstEncodedIndices();
                float[] ratings = inBlock.ratings();
                float[][][] sortedSrcFactors = new float[numSrcBlocks$1][][];
                srcFactors.foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                    ALS$.$anonfun$computeFactors$5(sortedSrcFactors, x0$4);
                    return BoxedUnit.UNIT;
                });
                float[][] dstFactors = new float[ScalaRunTime$.MODULE$.array_length(dstIds)][];
                ALS.NormalEquation ls = new ALS.NormalEquation(rank$3);
                for (int j = 0; j < ScalaRunTime$.MODULE$.array_length(dstIds); ++j) {
                    ls.reset();
                    Object object = implicitPrefs$2 ? ls.merge((ALS.NormalEquation)YtY$1.get()) : BoxedUnit.UNIT;
                    int numExplicits = 0;
                    for (int i = srcPtrs[j]; i < srcPtrs[j + 1]; ++i) {
                        Object object2;
                        int encoded = srcEncodedIndices[i];
                        int blockId = srcEncoder$1.blockId(encoded);
                        int localIndex = srcEncoder$1.localIndex(encoded);
                        float[] srcFactor = null;
                        try {
                            srcFactor = sortedSrcFactors[blockId][localIndex];
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            if (throwable2 instanceof ArrayIndexOutOfBoundsException) {
                                ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException = (ArrayIndexOutOfBoundsException)throwable2;
                                if (isBlockRDDNondeterministic$1) {
                                    String errMsg = "A failure detected when matching In/Out blocks of users/items. Because at least one In/Out block RDD is found to be nondeterministic now, the issue is probably caused by nondeterministic input data. You can try to checkpoint training data to make it deterministic. If you do `repartition` + `sample` or `randomSplit`, you can also try to sort it before `sample` or `randomSplit` to make it deterministic.";
                                    throw new SparkException(errMsg, (Throwable)arrayIndexOutOfBoundsException);
                                }
                            }
                            throw throwable;
                        }
                        float rating = ratings[i];
                        if (implicitPrefs$2) {
                            double c1 = alpha$2 * (double)scala.math.package$.MODULE$.abs(rating);
                            if ((double)rating > 0.0) {
                                ++numExplicits;
                            }
                            object2 = ls.add(srcFactor, (double)rating > 0.0 ? 1.0 + c1 : 0.0, c1);
                            continue;
                        }
                        ls.add(srcFactor, rating, ls.add$default$3());
                        ++numExplicits;
                        object2 = BoxedUnit.UNIT;
                    }
                    dstFactors[j] = solver$2.solve(ls, (double)numExplicits * regParam$2);
                }
                return dstFactors;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private ALS$() {
        MODULE$ = this;
        MLReadable.$init$(this);
        DefaultParamsReadable.$init$(this);
        Logging.$init$((Logging)this);
    }

    public static final /* synthetic */ RDD $anonfun$train$8$adapted(ObjectRef userFactors$1, StorageLevel intermediateRDDStorageLevel$1, ObjectRef itemFactors$1, RDD userOutBlocks$1, RDD itemInBlocks$1, int rank$1, double regParam$1, ALS.LocalIndexEncoder userLocalIndexEncoder$1, boolean implicitPrefs$1, double alpha$1, ALS.LeastSquaresNESolver solver$1, Function1 shouldCheckpoint$1, RDD itemOutBlocks$1, RDD userInBlocks$1, ALS.LocalIndexEncoder itemLocalIndexEncoder$1, Function0 deletePreviousCheckpointFile$1, ObjectRef previousCheckpointFile$1, Object iter) {
        return ALS$.$anonfun$train$8(userFactors$1, intermediateRDDStorageLevel$1, itemFactors$1, userOutBlocks$1, itemInBlocks$1, rank$1, regParam$1, userLocalIndexEncoder$1, implicitPrefs$1, alpha$1, solver$1, shouldCheckpoint$1, itemOutBlocks$1, userInBlocks$1, itemLocalIndexEncoder$1, deletePreviousCheckpointFile$1, previousCheckpointFile$1, BoxesRunTime.unboxToInt((Object)iter));
    }

    public static final /* synthetic */ Object $anonfun$makeBlocks$4$adapted(OpenHashMap dstIdToLocalIndex$1, Object k) {
        return BoxesRunTime.boxToInteger((int)dstIdToLocalIndex$1.apply$mcI$sp(k));
    }
}

