/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim.aggregator;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.feature.InstanceBlock;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.DenseVector$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.optim.aggregator.DifferentiableLossAggregator;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001E4Q\u0001E\t\u0001+uA\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005o!AA\t\u0001B\u0001B\u0003%Q\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003A\u0011!I\u0005A!A!\u0002\u0013\u0001\u0005\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u000bI\u0003A\u0011A*\t\u000fm\u0003!\u0019!C\u00059\"1\u0001\r\u0001Q\u0001\nuCq!\u0019\u0001C\u0002\u0013EC\f\u0003\u0004c\u0001\u0001\u0006I!\u0018\u0005\tG\u0002A)\u0019!C\u0005I\"9\u0011\u000e\u0001b\u0001\n\u0013Q\u0007BB6\u0001A\u0003%\u0001\tC\u0003m\u0001\u0011\u0005QNA\u000eMK\u0006\u001cHoU9vCJ,7O\u00117pG.\fum\u001a:fO\u0006$xN\u001d\u0006\u0003%M\t!\"Y4he\u0016<\u0017\r^8s\u0015\t!R#A\u0003paRLWN\u0003\u0002\u0017/\u0005\u0011Q\u000e\u001c\u0006\u00031e\tQa\u001d9be.T!AG\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0012aA8sON!\u0001A\b\u00130!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019\te.\u001f*fMB!QE\n\u0015/\u001b\u0005\t\u0012BA\u0014\u0012\u0005q!\u0015N\u001a4fe\u0016tG/[1cY\u0016dun]:BO\u001e\u0014XmZ1u_J\u0004\"!\u000b\u0017\u000e\u0003)R!aK\u000b\u0002\u000f\u0019,\u0017\r^;sK&\u0011QF\u000b\u0002\u000e\u0013:\u001cH/\u00198dK\ncwnY6\u0011\u0005\u0015\u0002\u0001C\u0001\u00194\u001b\u0005\t$B\u0001\u001a\u0018\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u001b2\u0005\u001daunZ4j]\u001e\fABY2J]Z,'o]3Ti\u0012\u001c\u0001\u0001E\u00029wuj\u0011!\u000f\u0006\u0003u]\t\u0011B\u0019:pC\u0012\u001c\u0017m\u001d;\n\u0005qJ$!\u0003\"s_\u0006$7-Y:u!\ryb\bQ\u0005\u0003\u007f\u0001\u0012Q!\u0011:sCf\u0004\"aH!\n\u0005\t\u0003#A\u0002#pk\ndW-\u0001\u0007cGN\u001b\u0017\r\\3e\u001b\u0016\fg.\u0001\u0007gSRLe\u000e^3sG\u0016\u0004H\u000f\u0005\u0002 \r&\u0011q\t\t\u0002\b\u0005>|G.Z1o\u0003!a\u0017MY3m'R$\u0017!\u00037bE\u0016dW*Z1o\u00039\u00117mQ8fM\u001aL7-[3oiN\u00042\u0001O\u001eM!\ti\u0005+D\u0001O\u0015\tyU#\u0001\u0004mS:\fGnZ\u0005\u0003#:\u0013aAV3di>\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0004U-^C\u0016L\u0017\u000b\u0003]UCQAS\u0004A\u0002-CQ!N\u0004A\u0002]BQaQ\u0004A\u0002]BQ\u0001R\u0004A\u0002\u0015CQ\u0001S\u0004A\u0002\u0001CQ!S\u0004A\u0002\u0001\u000b1B\\;n\r\u0016\fG/\u001e:fgV\tQ\f\u0005\u0002 =&\u0011q\f\t\u0002\u0004\u0013:$\u0018\u0001\u00048v[\u001a+\u0017\r^;sKN\u0004\u0013a\u00013j[\u0006!A-[7!\u00035)gMZ3di&4XmQ8fMV\tQ\b\u000b\u0002\rMB\u0011qdZ\u0005\u0003Q\u0002\u0012\u0011\u0002\u001e:b]NLWM\u001c;\u0002\r=4gm]3u+\u0005\u0001\u0015aB8gMN,G\u000fI\u0001\u0004C\u0012$GC\u00018p\u001b\u0005\u0001\u0001\"\u00029\u0010\u0001\u0004A\u0013!\u00022m_\u000e\\\u0007")
public class LeastSquaresBlockAggregator
implements DifferentiableLossAggregator<InstanceBlock, LeastSquaresBlockAggregator>,
Logging {
    private transient double[] effectiveCoef;
    private final Broadcast<double[]> bcInverseStd;
    private final boolean fitIntercept;
    private final double labelStd;
    private final Broadcast<Vector> bcCoefficients;
    private final int numFeatures;
    private final int dim;
    private final double offset;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private double weightSum;
    private double lossSum;
    private double[] gradientSumArray;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public DifferentiableLossAggregator merge(DifferentiableLossAggregator other) {
        return DifferentiableLossAggregator.merge$(this, other);
    }

    @Override
    public Vector gradient() {
        return DifferentiableLossAggregator.gradient$(this);
    }

    @Override
    public double weight() {
        return DifferentiableLossAggregator.weight$(this);
    }

    @Override
    public double loss() {
        return DifferentiableLossAggregator.loss$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public double weightSum() {
        return this.weightSum;
    }

    @Override
    public void weightSum_$eq(double x$1) {
        this.weightSum = x$1;
    }

    @Override
    public double lossSum() {
        return this.lossSum;
    }

    @Override
    public void lossSum_$eq(double x$1) {
        this.lossSum = x$1;
    }

    private double[] gradientSumArray$lzycompute() {
        LeastSquaresBlockAggregator leastSquaresBlockAggregator = this;
        synchronized (leastSquaresBlockAggregator) {
            if (!this.bitmap$0) {
                this.gradientSumArray = DifferentiableLossAggregator.gradientSumArray$(this);
                this.bitmap$0 = true;
            }
        }
        return this.gradientSumArray;
    }

    @Override
    public double[] gradientSumArray() {
        if (!this.bitmap$0) {
            return this.gradientSumArray$lzycompute();
        }
        return this.gradientSumArray;
    }

    private int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public int dim() {
        return this.dim;
    }

    private double[] effectiveCoef$lzycompute() {
        LeastSquaresBlockAggregator leastSquaresBlockAggregator = this;
        synchronized (leastSquaresBlockAggregator) {
            if (!this.bitmap$trans$0) {
                DenseVector denseVector;
                Option option;
                Vector vector = (Vector)this.bcCoefficients.value();
                if (!(vector instanceof DenseVector) || (option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector)).isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(55).append("coefficients only supports dense vector but ").append("got type ").append(this.bcCoefficients.value().getClass()).append(".)").toString());
                }
                double[] values = (double[])option.get();
                double[] inverseStd = (double[])this.bcInverseStd.value();
                this.effectiveCoef = (double[])Array$.MODULE$.tabulate(this.numFeatures(), (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> {
                    if (inverseStd[i] != 0.0) {
                        return values[i];
                    }
                    return 0.0;
                }, ClassTag$.MODULE$.Double());
                this.bitmap$trans$0 = true;
            }
        }
        return this.effectiveCoef;
    }

    private double[] effectiveCoef() {
        if (!this.bitmap$trans$0) {
            return this.effectiveCoef$lzycompute();
        }
        return this.effectiveCoef;
    }

    private double offset() {
        return this.offset;
    }

    @Override
    public LeastSquaresBlockAggregator add(InstanceBlock block) {
        Predef$.MODULE$.require(block.matrix().isTransposed());
        Predef$.MODULE$.require(this.numFeatures() == block.numFeatures(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Dimensions mismatch when adding new ").append("instance. Expecting ").append(this.numFeatures()).append(" but got ").append(block.numFeatures()).append(".").toString());
        Predef$.MODULE$.require(block.weightIter().forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$1 -> x$1 >= 0.0), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("instance weights ").append(block.weightIter().mkString("[", ",", "]")).append(" has to be >= 0.0").toString());
        if (block.weightIter().forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$2 -> x$2 == 0.0)) {
            return this;
        }
        int size = block.size();
        double[] arr = (double[])Array$.MODULE$.ofDim(size, ClassTag$.MODULE$.Double());
        if (this.fitIntercept) {
            Arrays.fill(arr, this.offset());
        }
        BLAS$.MODULE$.javaBLAS().daxpy(size, -1.0 / this.labelStd, block.labels(), 1, arr, 1);
        BLAS$.MODULE$.gemv(1.0, block.matrix(), this.effectiveCoef(), 1.0, arr);
        double localLossSum = 0.0;
        double localWeightSum = 0.0;
        for (int i = 0; i < size; ++i) {
            double multiplier;
            double weight = block.getWeight().apply$mcDI$sp(i);
            localWeightSum += weight;
            double diff = arr[i];
            localLossSum += weight * diff * diff / (double)2;
            arr[i] = multiplier = weight * diff;
        }
        this.lossSum_$eq(this.lossSum() + localLossSum);
        this.weightSum_$eq(this.weightSum() + localWeightSum);
        BLAS$.MODULE$.gemv(1.0, block.matrix().transpose(), arr, 1.0, this.gradientSumArray());
        return this;
    }

    public LeastSquaresBlockAggregator(Broadcast<double[]> bcInverseStd, Broadcast<double[]> bcScaledMean, boolean fitIntercept, double labelStd, double labelMean, Broadcast<Vector> bcCoefficients) {
        this.bcInverseStd = bcInverseStd;
        this.fitIntercept = fitIntercept;
        this.labelStd = labelStd;
        this.bcCoefficients = bcCoefficients;
        DifferentiableLossAggregator.$init$(this);
        Logging.$init$((Logging)this);
        Predef$.MODULE$.require(labelStd > 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append(this.getClass().getName()).append(" requires the label standard ").append("deviation to be positive.").toString());
        this.numFeatures = ((double[])bcInverseStd.value()).length;
        this.dim = this.numFeatures();
        this.offset = fitIntercept ? labelMean / labelStd - BLAS$.MODULE$.javaBLAS().ddot(this.numFeatures(), ((Vector)bcCoefficients.value()).toArray(), 1, (double[])bcScaledMean.value(), 1) : Double.NaN;
    }
}

