/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml;

import java.io.Serializable;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.PredictionModel;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasLabelCol;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b!B\u0006\r\u0003\u0003)\u0002\"B\u001a\u0001\t\u0003!\u0004\"\u0002\u001e\u0001\t\u0003Y\u0004\"B%\u0001\t\u0003Q\u0005\"\u0002'\u0001\t\u0003i\u0005\"B(\u0001\t\u0003\u0002\u0006\"B/\u0001\r\u0003r\u0006\"B4\u0001\r#A\u0007BB8\u0001\t\u0003a\u0001\u000fC\u0003x\u0001\u0011\u0005\u0003\u0010C\u0003\u007f\u0001\u0011EqPA\u0005Qe\u0016$\u0017n\u0019;pe*\u0011QBD\u0001\u0003[2T!a\u0004\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\u0002\u0001+\u00111\"fN\u000f\u0014\u0007\u00019\u0002\u0007E\u0002\u00193mi\u0011\u0001D\u0005\u000351\u0011\u0011\"R:uS6\fGo\u001c:\u0011\u0005qiB\u0002\u0001\u0003\u0006=\u0001\u0011\ra\b\u0002\u0002\u001bF\u0011\u0001E\n\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\b\u001d>$\b.\u001b8h!\u0011Ar%K\u000e\n\u0005!b!a\u0004)sK\u0012L7\r^5p]6{G-\u001a7\u0011\u0005qQC!B\u0016\u0001\u0005\u0004a#\u0001\u0004$fCR,(/Z:UsB,\u0017C\u0001\u0011.!\t\tc&\u0003\u00020E\t\u0019\u0011I\\=\u0011\u0005a\t\u0014B\u0001\u001a\r\u0005=\u0001&/\u001a3jGR|'\u000fU1sC6\u001c\u0018A\u0002\u001fj]&$h\bF\u00016!\u0015A\u0002!\u000b\u001c\u001c!\tar\u0007B\u00039\u0001\t\u0007\u0011HA\u0004MK\u0006\u0014h.\u001a:\u0012\u0005\u0001*\u0014aC:fi2\u000b'-\u001a7D_2$\"A\u000e\u001f\t\u000bu\u0012\u0001\u0019\u0001 \u0002\u000bY\fG.^3\u0011\u0005}2eB\u0001!E!\t\t%%D\u0001C\u0015\t\u0019E#\u0001\u0004=e>|GOP\u0005\u0003\u000b\n\na\u0001\u0015:fI\u00164\u0017BA$I\u0005\u0019\u0019FO]5oO*\u0011QII\u0001\u000fg\u0016$h)Z1ukJ,7oQ8m)\t14\nC\u0003>\u0007\u0001\u0007a(\u0001\ttKR\u0004&/\u001a3jGRLwN\\\"pYR\u0011aG\u0014\u0005\u0006{\u0011\u0001\rAP\u0001\u0004M&$HCA\u000eR\u0011\u0015\u0011V\u00011\u0001T\u0003\u001d!\u0017\r^1tKR\u0004$\u0001V.\u0011\u0007UC&,D\u0001W\u0015\t9f\"A\u0002tc2L!!\u0017,\u0003\u000f\u0011\u000bG/Y:fiB\u0011Ad\u0017\u0003\n9F\u000b\t\u0011!A\u0003\u00021\u00121a\u0018\u00134\u0003\u0011\u0019w\u000e]=\u0015\u0005Yz\u0006\"\u00021\u0007\u0001\u0004\t\u0017!B3yiJ\f\u0007C\u00012f\u001b\u0005\u0019'B\u00013\r\u0003\u0015\u0001\u0018M]1n\u0013\t17M\u0001\u0005QCJ\fW.T1q\u0003\u0015!(/Y5o)\tY\u0012\u000eC\u0003S\u000f\u0001\u0007!\u000e\r\u0002l[B\u0019Q\u000b\u00177\u0011\u0005qiG!\u00038j\u0003\u0003\u0005\tQ!\u0001-\u0005\ryF\u0005N\u0001\u0011M\u0016\fG/\u001e:fg\u0012\u000bG/\u0019+za\u0016,\u0012!\u001d\t\u0003eVl\u0011a\u001d\u0006\u0003iZ\u000bQ\u0001^=qKNL!A^:\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fq\u0002\u001e:b]N4wN]7TG\",W.\u0019\u000b\u0003sr\u0004\"A\u001d>\n\u0005m\u001c(AC*ueV\u001cG\u000fV=qK\")Q0\u0003a\u0001s\u000611o\u00195f[\u0006\fA#\u001a=ue\u0006\u001cG\u000fT1cK2,G\rU8j]R\u001cH\u0003BA\u0001\u00033\u0001b!a\u0001\u0002\n\u00055QBAA\u0003\u0015\r\t9AD\u0001\u0004e\u0012$\u0017\u0002BA\u0006\u0003\u000b\u00111A\u0015#E!\u0011\ty!!\u0006\u000e\u0005\u0005E!bAA\n\u0019\u00059a-Z1ukJ,\u0017\u0002BA\f\u0003#\u0011A\u0002T1cK2,G\rU8j]RDaA\u0015\u0006A\u0002\u0005m\u0001\u0007BA\u000f\u0003C\u0001B!\u0016-\u0002 A\u0019A$!\t\u0005\u0017\u0005\r\u0012\u0011DA\u0001\u0002\u0003\u0015\t\u0001\f\u0002\u0004?\u0012*\u0004")
public abstract class Predictor<FeaturesType, Learner extends Predictor<FeaturesType, Learner, M>, M extends PredictionModel<FeaturesType, M>>
extends Estimator<M>
implements PredictorParams {
    private final Param<String> predictionCol;
    private final Param<String> featuresCol;
    private final Param<String> labelCol;

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public RDD<Instance> extractInstances(Dataset<?> dataset) {
        return PredictorParams.extractInstances$(this, dataset);
    }

    @Override
    public RDD<Instance> extractInstances(Dataset<?> dataset, Function1<Instance, BoxedUnit> validateInstance) {
        return PredictorParams.extractInstances$(this, dataset, validateInstance);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol.getLabelCol$(this);
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param<String> x$1) {
        this.labelCol = x$1;
    }

    public Learner setLabelCol(String value) {
        return (Learner)((Predictor)this.set(this.labelCol(), value));
    }

    public Learner setFeaturesCol(String value) {
        return (Learner)((Predictor)this.set(this.featuresCol(), value));
    }

    public Learner setPredictionCol(String value) {
        return (Learner)((Predictor)this.set(this.predictionCol(), value));
    }

    @Override
    public M fit(Dataset<?> dataset) {
        Dataset dataset2;
        this.transformSchema(dataset.schema(), true);
        Metadata labelMeta = dataset.schema().apply(this.$(this.labelCol())).metadata();
        Dataset labelCasted = dataset.withColumn(this.$(this.labelCol()), functions$.MODULE$.col(this.$(this.labelCol())).cast((DataType)DoubleType$.MODULE$), labelMeta);
        Predictor predictor = this;
        if (predictor instanceof HasWeightCol) {
            Predictor predictor2 = predictor;
            if (this.isDefined(((HasWeightCol)((Object)predictor2)).weightCol()) && new StringOps(Predef$.MODULE$.augmentString(this.$(((HasWeightCol)((Object)predictor2)).weightCol()))).nonEmpty()) {
                Metadata weightMeta = dataset.schema().apply(this.$(((HasWeightCol)((Object)predictor2)).weightCol())).metadata();
                dataset2 = labelCasted.withColumn(this.$(((HasWeightCol)((Object)predictor2)).weightCol()), functions$.MODULE$.col(this.$(((HasWeightCol)((Object)predictor2)).weightCol())).cast((DataType)DoubleType$.MODULE$), weightMeta);
            } else {
                dataset2 = labelCasted;
            }
        } else {
            dataset2 = labelCasted;
        }
        Dataset casted = dataset2;
        return (M)((PredictionModel)this.copyValues(((Model)this.train(casted)).setParent(this), this.copyValues$default$2()));
    }

    public abstract Learner copy(ParamMap var1);

    public abstract M train(Dataset<?> var1);

    public DataType featuresDataType() {
        return new VectorUDT();
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema, true, this.featuresDataType());
    }

    public RDD<LabeledPoint> extractLabeledPoints(Dataset<?> dataset) {
        return dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.labelCol())), functions$.MODULE$.col(this.$(this.featuresCol()))})).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Row row = x0$1;
            Some some = Row$.MODULE$.unapplySeq(row);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                Object label = ((SeqLike)some.get()).apply(0);
                Object features = ((SeqLike)some.get()).apply(1);
                if (label instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)label);
                    if (features instanceof Vector) {
                        Vector vector = (Vector)features;
                        return new LabeledPoint(d, vector);
                    }
                }
            }
            throw new MatchError((Object)row);
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
    }

    public Predictor() {
        HasLabelCol.$init$(this);
        HasFeaturesCol.$init$(this);
        HasPredictionCol.$init$(this);
        PredictorParams.$init$(this);
    }
}

