/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg.distributed;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.mapActiveValues$;
import breeze.linalg.norm$;
import breeze.linalg.qr;
import breeze.linalg.support.LiteralRow$;
import breeze.linalg.svd;
import breeze.linalg.svd$;
import breeze.numerics.package;
import breeze.storage.Zero;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.QRDecomposition;
import org.apache.spark.mllib.linalg.SingularValueDecomposition;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.linalg.distributed.CoordinateMatrix;
import org.apache.spark.mllib.linalg.distributed.RowMatrix;
import org.apache.spark.mllib.random.RandomRDDs$;
import org.apache.spark.mllib.stat.MultivariateStatisticalSummary;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001\u0002\u000e\u001c\u0001!BQa\r\u0001\u0005\u0002QBqa\u000e\u0001C\u0002\u0013\u0005\u0001\b\u0003\u0004@\u0001\u0001\u0006I!\u000f\u0005\b\u0001\u0002\u0011\r\u0011\"\u00019\u0011\u0019\t\u0005\u0001)A\u0005s!9!\t\u0001b\u0001\n\u0003\u0019\u0005B\u0002&\u0001A\u0003%A\tC\u0004L\u0001\t\u0007I\u0011\u0001'\t\r]\u0003\u0001\u0015!\u0003N\u0011\u001dA\u0006A1A\u0005\u00021Ca!\u0017\u0001!\u0002\u0013i\u0005b\u0002.\u0001\u0005\u0004%\ta\u0017\u0005\u0007G\u0002\u0001\u000b\u0011\u0002/\t\u000f\u0011\u0004!\u0019!C\u0001K\"1\u0011\u000e\u0001Q\u0001\n\u0019D\u0011B\u001b\u0001A\u0002\u0003\u0007I\u0011A6\t\u0013=\u0004\u0001\u0019!a\u0001\n\u0003\u0001\b\"\u0003<\u0001\u0001\u0004\u0005\t\u0015)\u0003m\u0011%9\b\u00011AA\u0002\u0013\u00051\u000eC\u0005y\u0001\u0001\u0007\t\u0019!C\u0001s\"I1\u0010\u0001a\u0001\u0002\u0003\u0006K\u0001\u001c\u0005\u0006y\u0002!\t% \u0005\u0006}\u0002!\ta \u0005\u0007}\u0002!\t!a\u0003\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014\tq!k\\<NCR\u0014\u0018\u000e_*vSR,'B\u0001\u000f\u001e\u0003-!\u0017n\u001d;sS\n,H/\u001a3\u000b\u0005yy\u0012A\u00027j]\u0006dwM\u0003\u0002!C\u0005)Q\u000e\u001c7jE*\u0011!eI\u0001\u0006gB\f'o\u001b\u0006\u0003I\u0015\na!\u00199bG\",'\"\u0001\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001IS\u0006\u0005\u0002+W5\t\u0011%\u0003\u0002-C\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"AL\u0019\u000e\u0003=R!\u0001M\u0010\u0002\tU$\u0018\u000e\\\u0005\u0003e=\u0012Q#\u0014'mS\n$Vm\u001d;Ta\u0006\u00148nQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0002kA\u0011a\u0007A\u0007\u00027\u0005\tQ.F\u0001:!\tQT(D\u0001<\u0015\u0005a\u0014!B:dC2\f\u0017B\u0001 <\u0005\rIe\u000e^\u0001\u0003[\u0002\n\u0011A\\\u0001\u0003]\u0002\n1!\u0019:s+\u0005!\u0005c\u0001\u001eF\u000f&\u0011ai\u000f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003u!K!!S\u001e\u0003\r\u0011{WO\u00197f\u0003\u0011\t'O\u001d\u0011\u0002\u0013\u0011,gn]3ECR\fW#A'\u0011\u00079\u000b6+D\u0001P\u0015\t\u00016(\u0001\u0006d_2dWm\u0019;j_:L!AU(\u0003\u0007M+\u0017\u000f\u0005\u0002U+6\tQ$\u0003\u0002W;\t1a+Z2u_J\f!\u0002Z3og\u0016$\u0015\r^1!\u0003)\u0019\b/\u0019:tK\u0012\u000bG/Y\u0001\fgB\f'o]3ECR\f\u0007%A\nqe&t7-\u001b9bY\u000e{W\u000e]8oK:$8/F\u0001]!\ri\u0016mR\u0007\u0002=*\u0011ad\u0018\u0006\u0002A\u00061!M]3fu\u0016L!A\u00190\u0003\u0017\u0011+gn]3NCR\u0014\u0018\u000e_\u0001\u0015aJLgnY5qC2\u001cu.\u001c9p]\u0016tGo\u001d\u0011\u0002#\u0015D\b\u000f\\1j]\u0016$g+\u0019:jC:\u001cW-F\u0001g!\rivmR\u0005\u0003Qz\u00131\u0002R3og\u00164Vm\u0019;pe\u0006\u0011R\r\u001f9mC&tW\r\u001a,be&\fgnY3!\u0003!!WM\\:f\u001b\u0006$X#\u00017\u0011\u0005Yj\u0017B\u00018\u001c\u0005%\u0011vn^'biJL\u00070\u0001\u0007eK:\u001cX-T1u?\u0012*\u0017\u000f\u0006\u0002riB\u0011!H]\u0005\u0003gn\u0012A!\u00168ji\"9Q/EA\u0001\u0002\u0004a\u0017a\u0001=%c\u0005IA-\u001a8tK6\u000bG\u000fI\u0001\ngB\f'o]3NCR\fQb\u001d9beN,W*\u0019;`I\u0015\fHCA9{\u0011\u001d)H#!AA\u00021\f!b\u001d9beN,W*\u0019;!\u0003%\u0011WMZ8sK\u0006cG\u000eF\u0001r\u0003-\u0019Gn\\:f)>TVM]8\u0015\t\u0005\u0005\u0011q\u0001\t\u0004u\u0005\r\u0011bAA\u0003w\t9!i\\8mK\u0006t\u0007BBA\u0005/\u0001\u0007A,A\u0001H)\u0011\t\t!!\u0004\t\r\u0005=\u0001\u00041\u0001g\u0003\u00051\u0018!G1tg\u0016\u0014HoQ8mk6tW)];bYV\u0003Hk\\*jO:$r!]A\u000b\u00033\ti\u0002\u0003\u0004\u0002\u0018e\u0001\r\u0001X\u0001\u0002\u0003\"1\u00111D\rA\u0002q\u000b\u0011A\u0011\u0005\u0007\u0003?I\u0002\u0019A\u001d\u0002\u0003-\u0004")
public class RowMatrixSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private final int m;
    private final int n;
    private final double[] arr;
    private final Seq<Vector> denseData;
    private final Seq<Vector> sparseData;
    private final DenseMatrix<Object> principalComponents;
    private final DenseVector<Object> explainedVariance;
    private RowMatrix denseMat;
    private RowMatrix sparseMat;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public int m() {
        return this.m;
    }

    public int n() {
        return this.n;
    }

    public double[] arr() {
        return this.arr;
    }

    public Seq<Vector> denseData() {
        return this.denseData;
    }

    public Seq<Vector> sparseData() {
        return this.sparseData;
    }

    public DenseMatrix<Object> principalComponents() {
        return this.principalComponents;
    }

    public DenseVector<Object> explainedVariance() {
        return this.explainedVariance;
    }

    public RowMatrix denseMat() {
        return this.denseMat;
    }

    public void denseMat_$eq(RowMatrix x$1) {
        this.denseMat = x$1;
    }

    public RowMatrix sparseMat() {
        return this.sparseMat;
    }

    public void sparseMat_$eq(RowMatrix x$1) {
        this.sparseMat = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
        this.denseMat_$eq(new RowMatrix(this.sc().parallelize(this.denseData(), 2, ClassTag$.MODULE$.apply(Vector.class))));
        this.sparseMat_$eq(new RowMatrix(this.sc().parallelize(this.sparseData(), 2, ClassTag$.MODULE$.apply(Vector.class))));
    }

    public boolean closeToZero(DenseMatrix<Object> G) {
        return BoxesRunTime.unboxToDouble((Object)G.valuesIterator().map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> scala.math.package$.MODULE$.abs(x)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) < 1.0E-6;
    }

    public boolean closeToZero(DenseVector<Object> v) {
        return BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(v, (Object)BoxesRunTime.boxToDouble((double)1.0), DenseVector$.MODULE$.canNorm_Double())) < 1.0E-6;
    }

    public void assertColumnEqualUpToSign(DenseMatrix<Object> A, DenseMatrix<Object> B, int k) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)A.rows()));
        int $org_scalatest_assert_macro_right = B.rows();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), k).foreach((Function1 & Serializable & scala.Serializable)j -> RowMatrixSuite.$anonfun$assertColumnEqualUpToSign$1(this, A, B, BoxesRunTime.unboxToInt((Object)j)));
    }

    private final void testImplicits$lzycompute$1() {
        RowMatrixSuite rowMatrixSuite = this;
        synchronized (rowMatrixSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ Object $anonfun$new$18(DenseMatrix expected$3, int i$2, DenseMatrix G$1, int j) {
        if (expected$3.apply$mcD$sp(i$2, j) > 0.0) {
            double actual = expected$3.apply$mcD$sp(i$2, j);
            double estimate = G$1.apply$mcD$sp(i$2, j);
            double $org_scalatest_assert_macro_left = scala.math.package$.MODULE$.abs(actual - estimate) / actual;
            double $org_scalatest_assert_macro_right = 0.2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(35).append("Similarities not close enough: ").append(actual).append(" vs ").append(estimate).toString(), Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$16(RowMatrixSuite $this, DenseMatrix expected$3, RowMatrix mat) {
        DenseMatrix G = mat.columnSimilarities(0.11).toBreeze();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), $this.n()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), $this.n()).foreach((Function1 & Serializable & scala.Serializable)j -> RowMatrixSuite.$anonfun$new$18(expected$3, i, G, BoxesRunTime.unboxToInt((Object)j))));
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Object $anonfun$new$24(RowMatrixSuite $this, String mode$1, RowMatrix mat$1, DenseMatrix localU$1, DenseMatrix localV$1, DenseVector localSigma$1, int k) {
        block3: {
            v0 = mode$1;
            var8_7 = "local-eigs";
            if (!(v0 == null ? var8_7 != null : v0.equals(var8_7) == false)) break block3;
            v1 = mode$1;
            var9_8 = "dist-eigs";
            if (v1 != null ? v1.equals(var9_8) == false : var9_8 != null) ** GOTO lbl-1000
        }
        if (k == $this.n()) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = skip = false;
        }
        if (!skip) {
            svd = mat$1.computeSVD(k, true, 1.0E-9, 300, 1.0E-10, mode$1);
            U = (RowMatrix)svd.U();
            s = svd.s();
            V = (Matrix)svd.V();
            $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)U.numRows()));
            $org_scalatest_assert_macro_right = $this.m();
            $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
            $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)U.numCols()));
            $org_scalatest_assert_macro_right = k;
            $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
            $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)s.size()));
            $org_scalatest_assert_macro_right = k;
            $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
            $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)V.numRows()));
            $org_scalatest_assert_macro_right = $this.n();
            $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
            $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)V.numCols()));
            $org_scalatest_assert_macro_right = k;
            $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
            $this.assertColumnEqualUpToSign((DenseMatrix<Object>)U.toBreeze(), (DenseMatrix<Object>)localU$1, k);
            $this.assertColumnEqualUpToSign((DenseMatrix<Object>)((DenseMatrix)V.asBreeze()), (DenseMatrix<Object>)localV$1, k);
            $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.closeToZero((DenseVector<Object>)((DenseVector)((DenseVector)s.asBreeze()).$minus(localSigma$1.apply((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), k), DenseVector$.MODULE$.canSlice()), DenseVector$.MODULE$.canSubD()))), "RowMatrixSuite.this.closeToZero(s.asBreeze.asInstanceOf[breeze.linalg.DenseVector[Double]].-[breeze.linalg.DenseVector[Double], breeze.linalg.DenseVector[Double], breeze.linalg.DenseVector[Double]](localSigma.apply[scala.collection.immutable.Range, breeze.linalg.DenseVector[Double]](scala.Predef.intWrapper(0).until(k))(linalg.this.DenseVector.canSlice[Double]))(linalg.this.DenseVector.canSubD))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$22(RowMatrixSuite $this, RowMatrix mat) {
        ((IterableLike)new .colon.colon((Object)"auto", (List)new .colon.colon((Object)"local-svd", (List)new .colon.colon((Object)"local-eigs", (List)new .colon.colon((Object)"dist-eigs", (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)mode -> {
            DenseMatrix localMat = mat.toBreeze();
            svd.SVD sVD = (svd.SVD)svd$.MODULE$.apply((Object)localMat, (UFunc.UImpl)svd.Svd_DM_Impl$.MODULE$);
            if (sVD == null) {
                throw new MatchError((Object)sVD);
            }
            DenseMatrix localU = (DenseMatrix)sVD.leftVectors();
            DenseVector localSigma = (DenseVector)sVD.singularValues();
            DenseMatrix localVt = (DenseMatrix)sVD.rightVectors();
            Tuple3 tuple3 = new Tuple3((Object)localU, (Object)localSigma, (Object)localVt);
            DenseMatrix localU2 = (DenseMatrix)tuple3._1();
            DenseVector localSigma2 = (DenseVector)tuple3._2();
            DenseMatrix localVt2 = (DenseMatrix)tuple3._3();
            DenseMatrix localV = ((DenseMatrix)localVt2.t(DenseMatrix$.MODULE$.canTranspose())).toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), $this.n()).foreach((Function1 & Serializable & scala.Serializable)k -> RowMatrixSuite.$anonfun$new$24($this, mode, mat, localU2, localV, localSigma2, BoxesRunTime.unboxToInt((Object)k)));
            SingularValueDecomposition svdWithoutU = mat.computeSVD(1, false, 1.0E-9, 300, 1.0E-10, mode);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(svdWithoutU.U());
            Null$ $org_scalatest_assert_macro_right = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        });
    }

    public static final /* synthetic */ Assertion $anonfun$assertColumnEqualUpToSign$1(RowMatrixSuite $this, DenseMatrix A$1, DenseMatrix B$1, int j) {
        DenseVector bj;
        DenseVector aj = (DenseVector)A$1.apply((Object)package$.MODULE$.$colon$colon(), (Object)BoxesRunTime.boxToInteger((int)j), DenseMatrix$.MODULE$.canSliceCol());
        Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool($this.closeToZero((DenseVector<Object>)((DenseVector)aj.$minus((Object)(bj = (DenseVector)B$1.apply((Object)package$.MODULE$.$colon$colon(), (Object)BoxesRunTime.boxToInteger((int)j), DenseMatrix$.MODULE$.canSliceCol())), DenseVector$.MODULE$.canSubD()))), "RowMatrixSuite.this.closeToZero(aj.-[breeze.linalg.DenseVector[Double], breeze.linalg.DenseVector[Double], breeze.linalg.DenseVector[Double]](bj)(linalg.this.DenseVector.canSubD))", Prettifier$.MODULE$.default());
        Bool $org_scalatest_assert_macro_right = $org_scalatest_assert_macro_left.value() ? Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default()) : Bool$.MODULE$.simpleMacroBool($this.closeToZero((DenseVector<Object>)((DenseVector)aj.$plus((Object)bj, DenseVector$.MODULE$.canAddD()))), "RowMatrixSuite.this.closeToZero(aj.+[breeze.linalg.DenseVector[Double], breeze.linalg.DenseVector[Double], Nothing, breeze.linalg.DenseVector[Double]](bj)(linalg.this.DenseVector.canAddD))", Prettifier$.MODULE$.default());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "||", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$bar$bar((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(31).append("The ").append(j).append("-th columns mismatch: ").append(aj).append(" and ").append(bj).toString(), Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
    }

    public static final /* synthetic */ Assertion $anonfun$new$33(RowMatrixSuite $this, RowMatrix mat$4, int k) {
        Tuple2 tuple2 = mat$4.computePrincipalComponentsAndExplainedVariance(k);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Matrix pc = (Matrix)tuple2._1();
        Vector expVariance = (Vector)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)pc, (Object)expVariance);
        Matrix pc2 = (Matrix)tuple22._1();
        Vector expVariance2 = (Vector)tuple22._2();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)pc2.numRows()));
        int $org_scalatest_assert_macro_right = $this.n();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)pc2.numCols()));
        int $org_scalatest_assert_macro_right2 = k;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
        $this.assertColumnEqualUpToSign((DenseMatrix<Object>)((DenseMatrix)pc2.asBreeze()), $this.principalComponents(), k);
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool($this.closeToZero((DenseVector<Object>)((DenseVector)DenseVector$.MODULE$.apply$mDc$sp(expVariance2.toArray()).$minus((Object)DenseVector$.MODULE$.apply$mDc$sp(Arrays.copyOfRange($this.explainedVariance().data$mcD$sp(), 0, k)), DenseVector$.MODULE$.canSubD()))), "RowMatrixSuite.this.closeToZero(breeze.linalg.DenseVector.apply[Double](expVariance.toArray).-[breeze.linalg.DenseVector[Double], breeze.linalg.DenseVector[Double], breeze.linalg.DenseVector[Double]](breeze.linalg.DenseVector.apply[Double](java.util.Arrays.copyOfRange(RowMatrixSuite.this.explainedVariance.data, 0, k)))(linalg.this.DenseVector.canSubD))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(pc2);
        Matrix $org_scalatest_assert_macro_right3 = mat$4.computePrincipalComponents(k);
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
    }

    public static final /* synthetic */ void $anonfun$new$32(RowMatrixSuite $this, RowMatrix mat) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), $this.n()).foreach((Function1 & Serializable & scala.Serializable)k -> RowMatrixSuite.$anonfun$new$33($this, mat, BoxesRunTime.unboxToInt((Object)k)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$38(RowMatrixSuite $this, MultivariateStatisticalSummary summary$1, int k) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(summary$1.mean());
        Vector $org_scalatest_assert_macro_right = Vectors$.MODULE$.dense(4.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 4.0}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"mean mismatch", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(summary$1.variance());
        Vector $org_scalatest_assert_macro_right2 = Vectors$.MODULE$.dense(15.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{10.0, 10.0}));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"variance mismatch", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)summary$1.count()));
        int $org_scalatest_assert_macro_right3 = $this.m();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"count mismatch.", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(summary$1.numNonzeros());
        Vector $org_scalatest_assert_macro_right4 = Vectors$.MODULE$.dense(3.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 4.0}));
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"nnz mismatch", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(summary$1.max());
        Vector $org_scalatest_assert_macro_right5 = Vectors$.MODULE$.dense(9.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{7.0, 8.0}));
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"max mismatch", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(summary$1.min());
        Vector $org_scalatest_assert_macro_right6 = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0}));
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"column mismatch.", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = $this.convertToEqualizer(summary$1.normL2());
        Vector $org_scalatest_assert_macro_right7 = Vectors$.MODULE$.dense(scala.math.package$.MODULE$.sqrt(126.0), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{scala.math.package$.MODULE$.sqrt(66.0), scala.math.package$.MODULE$.sqrt(94.0)}));
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"magnitude mismatch.", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = $this.convertToEqualizer(summary$1.normL1());
        Vector $org_scalatest_assert_macro_right8 = Vectors$.MODULE$.dense(18.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{12.0, 16.0}));
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"L1 norm mismatch", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
    }

    public static final /* synthetic */ void $anonfun$new$37(RowMatrixSuite $this, RowMatrix mat) {
        MultivariateStatisticalSummary summary = mat.computeColumnSummaryStatistics();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1).foreach((Function1 & Serializable & scala.Serializable)k -> RowMatrixSuite.$anonfun$new$38($this, summary, BoxesRunTime.unboxToInt((Object)k)));
    }

    public static final /* synthetic */ Assertion $anonfun$new$46(RowMatrixSuite $this, Matrix cov$1, int i$3, int j) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToDouble((double)cov$1.apply(i$3, j)));
        double $org_scalatest_assert_macro_right = cov$1.apply(j, i$3);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331));
    }

    public RowMatrixSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.m = 4;
        this.n = 3;
        this.arr = new double[]{0.0, 3.0, 6.0, 9.0, 1.0, 4.0, 7.0, 0.0, 2.0, 5.0, 8.0, 1.0};
        this.denseData = (Seq)new .colon.colon((Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(3.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.0, 5.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(6.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{7.0, 8.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(9.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0})), (List)Nil$.MODULE$))));
        this.sparseData = (Seq)new .colon.colon((Object)Vectors$.MODULE$.sparse(3, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(1, 1.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(2, 2.0), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)Vectors$.MODULE$.sparse(3, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, 3.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(1, 4.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(2, 5.0), (List)Nil$.MODULE$)))), (List)new .colon.colon((Object)Vectors$.MODULE$.sparse(3, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, 6.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(1, 7.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(2, 8.0), (List)Nil$.MODULE$)))), (List)new .colon.colon((Object)Vectors$.MODULE$.sparse(3, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, 9.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(2, 1.0), (List)Nil$.MODULE$))), (List)Nil$.MODULE$))));
        this.principalComponents = (DenseMatrix)DenseMatrix$.MODULE$.apply$mDc$sp((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)(scala.math.package$.MODULE$.sqrt(2.0) / 2.0)), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)(scala.math.package$.MODULE$.sqrt(2.0) / 2.0))), new Tuple3((Object)BoxesRunTime.boxToDouble((double)(scala.math.package$.MODULE$.sqrt(2.0) / 2.0)), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)(-scala.math.package$.MODULE$.sqrt(2.0) / 2.0)))}), LiteralRow$.MODULE$.tuple3(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        this.explainedVariance = (DenseVector)DenseVector$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5714285714285714, 0.42857142857142855, 0.0}), ClassTag$.MODULE$.Double());
        this.test("size", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)this.denseMat().numRows()));
            int $org_scalatest_assert_macro_right = this.m();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)this.denseMat().numCols()));
            int $org_scalatest_assert_macro_right2 = this.n();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)this.sparseMat().numRows()));
            int $org_scalatest_assert_macro_right3 = this.m();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)this.sparseMat().numCols()));
            int $org_scalatest_assert_macro_right4 = this.n();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        }, new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        this.test("empty rows", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            RDD rows = this.sc().parallelize((Seq)Nil$.MODULE$, 1, ClassTag$.MODULE$.apply(Vector.class));
            RowMatrix emptyMat = new RowMatrix(rows);
            this.intercept((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> emptyMat.numCols(), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
            return (RuntimeException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> emptyMat.numRows(), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        }, new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        this.test("toBreeze", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            DenseMatrix expected = (DenseMatrix)DenseMatrix$.MODULE$.apply$mDc$sp((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)2.0)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)3.0), (Object)BoxesRunTime.boxToDouble((double)4.0), (Object)BoxesRunTime.boxToDouble((double)5.0)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)6.0), (Object)BoxesRunTime.boxToDouble((double)7.0), (Object)BoxesRunTime.boxToDouble((double)8.0)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)9.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)1.0))}), LiteralRow$.MODULE$.tuple3(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
            ((IterableLike)new .colon.colon((Object)this.denseMat(), (List)new .colon.colon((Object)this.sparseMat(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)mat -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(mat.toBreeze());
                DenseMatrix $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
            });
        }, new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        this.test("gram", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Matrix expected = Matrices$.MODULE$.dense(this.n(), this.n(), new double[]{126.0, 54.0, 72.0, 54.0, 66.0, 78.0, 72.0, 78.0, 94.0});
            ((IterableLike)new .colon.colon((Object)this.denseMat(), (List)new .colon.colon((Object)this.sparseMat(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)mat -> {
                Matrix G = mat.computeGramianMatrix();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(G.asBreeze());
                breeze.linalg.Matrix $org_scalatest_assert_macro_right = expected.asBreeze();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            });
        }, new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        this.test("getTreeAggregateIdealDepth", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int nbPartitions = 100;
            RDD qual$1 = this.sc().emptyRDD(ClassTag$.MODULE$.apply(Vector.class));
            int x$1 = nbPartitions;
            Ordering x$2 = qual$1.repartition$default$2(x$1);
            RDD vectors = qual$1.repartition(x$1, x$2);
            RowMatrix rowMat = new RowMatrix(vectors);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)rowMat.getTreeAggregateIdealDepth(0x6400000L)));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)rowMat.getTreeAggregateIdealDepth(0x6E00000L)));
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)rowMat.getTreeAggregateIdealDepth(734003200L)));
            int $org_scalatest_assert_macro_right3 = 10;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
            Exception zeroSizeException = (Exception)this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> rowMat.getTreeAggregateIdealDepth(0L), ClassTag$.MODULE$.apply(Exception.class), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            String $org_scalatest_assert_macro_left4 = zeroSizeException.getMessage();
            String $org_scalatest_assert_macro_right4 = "zero-size object to aggregate";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
            Exception objectBiggerThanResultSize = (Exception)this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> rowMat.getTreeAggregateIdealDepth(0x44C00000L), ClassTag$.MODULE$.apply(Exception.class), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
            String $org_scalatest_assert_macro_left5 = objectBiggerThanResultSize.getMessage();
            String $org_scalatest_assert_macro_right5 = "it's bigger than maxResultSize";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        }, new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        this.test("SPARK-33043: getTreeAggregateIdealDepth with unlimited driver size", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            long originalMaxResultSize = BoxesRunTime.unboxToLong((Object)this.sc().conf().get(org.apache.spark.internal.config.package$.MODULE$.MAX_RESULT_SIZE()));
            this.sc().conf().set(org.apache.spark.internal.config.package$.MODULE$.MAX_RESULT_SIZE(), (Object)BoxesRunTime.boxToLong((long)0L));
            try {
                int nbPartitions = 100;
                RDD qual$2 = this.sc().emptyRDD(ClassTag$.MODULE$.apply(Vector.class));
                int x$3 = nbPartitions;
                Ordering x$4 = qual$2.repartition$default$2(x$3);
                RDD vectors = qual$2.repartition(x$3, x$4);
                RowMatrix rowMat = new RowMatrix(vectors);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)rowMat.getTreeAggregateIdealDepth(734003200L)));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
            }
            finally {
                this.sc().conf().set(org.apache.spark.internal.config.package$.MODULE$.MAX_RESULT_SIZE(), (Object)BoxesRunTime.boxToLong((long)originalMaxResultSize));
            }
            return assertion;
        }, new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
        this.test("similar columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Vector colMags = Vectors$.MODULE$.dense(scala.math.package$.MODULE$.sqrt(126.0), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{scala.math.package$.MODULE$.sqrt(66.0), scala.math.package$.MODULE$.sqrt(94.0)}));
            DenseMatrix expected = (DenseMatrix)DenseMatrix$.MODULE$.apply$mDc$sp((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)54.0), (Object)BoxesRunTime.boxToDouble((double)72.0)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)78.0)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0))}), LiteralRow$.MODULE$.tuple3(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.n()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.n()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> expected.update$mcD$sp(i, j, expected.apply$mcD$sp(i, j) / (colMags.apply(i) * colMags.apply(j)))));
            ((IterableLike)new .colon.colon((Object)this.denseMat(), (List)new .colon.colon((Object)this.sparseMat(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)mat -> {
                RowMatrixSuite.$anonfun$new$16(this, expected, mat);
                return BoxedUnit.UNIT;
            });
            ((IterableLike)new .colon.colon((Object)this.denseMat(), (List)new .colon.colon((Object)this.sparseMat(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)mat -> {
                CoordinateMatrix G = mat.columnSimilarities();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.closeToZero((DenseMatrix<Object>)((DenseMatrix)G.toBreeze().$minus((Object)expected, DenseMatrix$.MODULE$.op_DM_DM_Double_OpSub()))), "RowMatrixSuite.this.closeToZero(G.toBreeze().-[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](expected)(linalg.this.DenseMatrix.op_DM_DM_Double_OpSub))", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
            });
            ((IterableLike)new .colon.colon((Object)this.denseMat(), (List)new .colon.colon((Object)this.sparseMat(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)mat -> {
                CoordinateMatrix G = mat.columnSimilaritiesDIMSUM(colMags.toArray(), 150.0);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.closeToZero((DenseMatrix<Object>)((DenseMatrix)G.toBreeze().$minus((Object)expected, DenseMatrix$.MODULE$.op_DM_DM_Double_OpSub()))), "RowMatrixSuite.this.closeToZero(G.toBreeze().-[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](expected)(linalg.this.DenseMatrix.op_DM_DM_Double_OpSub))", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
            });
        }, new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        this.test("svd of a full-rank matrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)this.denseMat(), (List)new .colon.colon((Object)this.sparseMat(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)mat -> {
            RowMatrixSuite.$anonfun$new$22(this, mat);
            return BoxedUnit.UNIT;
        }), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
        this.test("svd of a low-rank matrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            RDD rows = this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.fill(4, (Function0 & Serializable & scala.Serializable)() -> Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0})), ClassTag$.MODULE$.apply(Vector.class))), 2, ClassTag$.MODULE$.apply(Vector.class));
            RowMatrix mat = new RowMatrix(rows, 4L, 3);
            ((IterableLike)new .colon.colon((Object)"auto", (List)new .colon.colon((Object)"local-svd", (List)new .colon.colon((Object)"local-eigs", (List)new .colon.colon((Object)"dist-eigs", (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)mode -> {
                SingularValueDecomposition svd2 = mat.computeSVD(2, true, 1.0E-6, 300, 1.0E-10, mode);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)svd2.s().size()));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(47).append("should not return zero singular values but got ").append(svd2.s()).toString(), Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)((RowMatrix)svd2.U()).numRows()));
                int $org_scalatest_assert_macro_right2 = 4;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)((RowMatrix)svd2.U()).numCols()));
                int $org_scalatest_assert_macro_right3 = 1;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Matrix)svd2.V()).numRows()));
                int $org_scalatest_assert_macro_right4 = 3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Matrix)svd2.V()).numCols()));
                int $org_scalatest_assert_macro_right5 = 1;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
            });
        }, new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
        this.test("validate k in svd", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)this.denseMat(), (List)new .colon.colon((Object)this.sparseMat(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)mat -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> mat.computeSVD(-1, mat.computeSVD$default$2(), mat.computeSVD$default$3()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217))), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
        this.test("pca", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)this.denseMat(), (List)new .colon.colon((Object)this.sparseMat(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)mat -> {
            RowMatrixSuite.$anonfun$new$32(this, mat);
            return BoxedUnit.UNIT;
        }), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
        this.test("multiply a local matrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Matrix B = Matrices$.MODULE$.dense(this.n(), 2, new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0});
            ((IterableLike)new .colon.colon((Object)this.denseMat(), (List)new .colon.colon((Object)this.sparseMat(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)mat -> {
                RowMatrix AB = mat.multiply(B);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)AB.numRows()));
                int $org_scalatest_assert_macro_right = this.m();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)AB.numCols()));
                int $org_scalatest_assert_macro_right2 = 2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])AB.rows().collect())).toSeq());
                Seq $org_scalatest_assert_macro_right3 = (Seq)new .colon.colon((Object)Vectors$.MODULE$.dense(5.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{14.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(14.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{50.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(23.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{86.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{32.0})), (List)Nil$.MODULE$))));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
            });
        }, new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
        this.test("compute column summary statistics", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)this.denseMat(), (List)new .colon.colon((Object)this.sparseMat(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)mat -> {
            RowMatrixSuite.$anonfun$new$37(this, mat);
            return BoxedUnit.UNIT;
        }), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
        this.test("QR Decomposition", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)this.denseMat(), (List)new .colon.colon((Object)this.sparseMat(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)mat -> {
            QRDecomposition result = mat.tallSkinnyQR(true);
            qr.QR expected = (qr.QR)qr.reduced$.MODULE$.apply((Object)mat.toBreeze(), (UFunc.UImpl)qr.reduced$.impl_reduced_DM_Double$.MODULE$);
            RowMatrix calcQ = (RowMatrix)result.Q();
            Matrix calcR = (Matrix)result.R();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.closeToZero((DenseMatrix<Object>)((DenseMatrix)((ImmutableNumericOps)package.abs$.MODULE$.apply(expected.q(), package.abs$.MODULE$.fromLowOrderCanMapActiveValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.abs$.absDoubleImpl$.MODULE$, mapActiveValues$.MODULE$.implFromCanMapValues(DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double()))))).$minus(package.abs$.MODULE$.apply((Object)calcQ.toBreeze(), package.abs$.MODULE$.fromLowOrderCanMapActiveValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.abs$.absDoubleImpl$.MODULE$, mapActiveValues$.MODULE$.implFromCanMapValues(DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())))), DenseMatrix$.MODULE$.op_DM_DM_Double_OpSub()))), "RowMatrixSuite.this.closeToZero(breeze.numerics.`package`.abs.apply[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](expected.q)(`package`.this.abs.fromLowOrderCanMapActiveValues[breeze.linalg.DenseMatrix[Double], Double, Double, breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.scalarOf[Double], `package`.this.abs.absDoubleImpl, linalg.this.mapActiveValues.implFromCanMapValues[breeze.linalg.DenseMatrix[Double], Double, Double, breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.canMapValues[Double, Double]((ClassTag.Double: scala.reflect.ClassTag[Double]))))).-[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](breeze.numerics.`package`.abs.apply[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](calcQ.toBreeze())(`package`.this.abs.fromLowOrderCanMapActiveValues[breeze.linalg.DenseMatrix[Double], Double, Double, breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.scalarOf[Double], `package`.this.abs.absDoubleImpl, linalg.this.mapActiveValues.implFromCanMapValues[breeze.linalg.DenseMatrix[Double], Double, Double, breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.canMapValues[Double, Double]((ClassTag.Double: scala.reflect.ClassTag[Double]))))))(linalg.this.DenseMatrix.op_DM_DM_Double_OpSub))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.closeToZero((DenseMatrix<Object>)((DenseMatrix)((ImmutableNumericOps)package.abs$.MODULE$.apply(expected.r(), package.abs$.MODULE$.fromLowOrderCanMapActiveValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.abs$.absDoubleImpl$.MODULE$, mapActiveValues$.MODULE$.implFromCanMapValues(DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double()))))).$minus(package.abs$.MODULE$.apply((Object)((DenseMatrix)calcR.asBreeze()), package.abs$.MODULE$.fromLowOrderCanMapActiveValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.abs$.absDoubleImpl$.MODULE$, mapActiveValues$.MODULE$.implFromCanMapValues(DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())))), DenseMatrix$.MODULE$.op_DM_DM_Double_OpSub()))), "RowMatrixSuite.this.closeToZero(breeze.numerics.`package`.abs.apply[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](expected.r)(`package`.this.abs.fromLowOrderCanMapActiveValues[breeze.linalg.DenseMatrix[Double], Double, Double, breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.scalarOf[Double], `package`.this.abs.absDoubleImpl, linalg.this.mapActiveValues.implFromCanMapValues[breeze.linalg.DenseMatrix[Double], Double, Double, breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.canMapValues[Double, Double]((ClassTag.Double: scala.reflect.ClassTag[Double]))))).-[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](breeze.numerics.`package`.abs.apply[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](calcR.asBreeze.asInstanceOf[breeze.linalg.DenseMatrix[Double]])(`package`.this.abs.fromLowOrderCanMapActiveValues[breeze.linalg.DenseMatrix[Double], Double, Double, breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.scalarOf[Double], `package`.this.abs.absDoubleImpl, linalg.this.mapActiveValues.implFromCanMapValues[breeze.linalg.DenseMatrix[Double], Double, Double, breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.canMapValues[Double, Double]((ClassTag.Double: scala.reflect.ClassTag[Double]))))))(linalg.this.DenseMatrix.op_DM_DM_Double_OpSub))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.closeToZero((DenseMatrix<Object>)((DenseMatrix)calcQ.multiply(calcR).toBreeze().$minus((Object)mat.toBreeze(), DenseMatrix$.MODULE$.op_DM_DM_Double_OpSub()))), "RowMatrixSuite.this.closeToZero(calcQ.multiply(calcR).toBreeze().-[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](mat.toBreeze())(linalg.this.DenseMatrix.op_DM_DM_Double_OpSub))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
            QRDecomposition rOnly = mat.tallSkinnyQR(false);
            RowMatrix $org_scalatest_assert_macro_left = (RowMatrix)rOnly.Q();
            Object $org_scalatest_assert_macro_right = null;
            RowMatrix rowMatrix = $org_scalatest_assert_macro_left;
            Object var13_12 = null;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", null, !(rowMatrix != null ? !rowMatrix.equals(var13_12) : var13_12 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(this.closeToZero((DenseMatrix<Object>)((DenseMatrix)((ImmutableNumericOps)package.abs$.MODULE$.apply(expected.r(), package.abs$.MODULE$.fromLowOrderCanMapActiveValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.abs$.absDoubleImpl$.MODULE$, mapActiveValues$.MODULE$.implFromCanMapValues(DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double()))))).$minus(package.abs$.MODULE$.apply((Object)((DenseMatrix)((Matrix)rOnly.R()).asBreeze()), package.abs$.MODULE$.fromLowOrderCanMapActiveValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.abs$.absDoubleImpl$.MODULE$, mapActiveValues$.MODULE$.implFromCanMapValues(DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())))), DenseMatrix$.MODULE$.op_DM_DM_Double_OpSub()))), "RowMatrixSuite.this.closeToZero(breeze.numerics.`package`.abs.apply[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](expected.r)(`package`.this.abs.fromLowOrderCanMapActiveValues[breeze.linalg.DenseMatrix[Double], Double, Double, breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.scalarOf[Double], `package`.this.abs.absDoubleImpl, linalg.this.mapActiveValues.implFromCanMapValues[breeze.linalg.DenseMatrix[Double], Double, Double, breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.canMapValues[Double, Double]((ClassTag.Double: scala.reflect.ClassTag[Double]))))).-[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](breeze.numerics.`package`.abs.apply[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](rOnly.R.asBreeze.asInstanceOf[breeze.linalg.DenseMatrix[Double]])(`package`.this.abs.fromLowOrderCanMapActiveValues[breeze.linalg.DenseMatrix[Double], Double, Double, breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.scalarOf[Double], `package`.this.abs.absDoubleImpl, linalg.this.mapActiveValues.implFromCanMapValues[breeze.linalg.DenseMatrix[Double], Double, Double, breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.canMapValues[Double, Double]((ClassTag.Double: scala.reflect.ClassTag[Double]))))))(linalg.this.DenseMatrix.op_DM_DM_Double_OpSub))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
        }), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 288));
        this.test("dense vector covariance accuracy (SPARK-26158)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq denseData = (Seq)new .colon.colon((Object)Vectors$.MODULE$.dense(100000.000004, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{199999.999999})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(100000.000012, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{200000.000002})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(99999.9999931, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{200000.000003})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(99999.9999977, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{200000.000001})), (List)Nil$.MODULE$))));
            RowMatrix denseMat = new RowMatrix(this.sc().parallelize(denseData, 2, ClassTag$.MODULE$.apply(Vector.class)));
            Matrix result = denseMat.computeCovariance();
            DenseMatrix expected = breeze.linalg.package$.MODULE$.cov(denseMat.toBreeze(), breeze.linalg.package$.MODULE$.cov$default$2());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.closeToZero((DenseMatrix<Object>)((DenseMatrix)((ImmutableNumericOps)package.abs$.MODULE$.apply((Object)expected, package.abs$.MODULE$.fromLowOrderCanMapActiveValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.abs$.absDoubleImpl$.MODULE$, mapActiveValues$.MODULE$.implFromCanMapValues(DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double()))))).$minus(package.abs$.MODULE$.apply((Object)((DenseMatrix)result.asBreeze()), package.abs$.MODULE$.fromLowOrderCanMapActiveValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.abs$.absDoubleImpl$.MODULE$, mapActiveValues$.MODULE$.implFromCanMapValues(DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())))), DenseMatrix$.MODULE$.op_DM_DM_Double_OpSub()))), "RowMatrixSuite.this.closeToZero(breeze.numerics.`package`.abs.apply[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](expected)(`package`.this.abs.fromLowOrderCanMapActiveValues[breeze.linalg.DenseMatrix[Double], Double, Double, breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.scalarOf[Double], `package`.this.abs.absDoubleImpl, linalg.this.mapActiveValues.implFromCanMapValues[breeze.linalg.DenseMatrix[Double], Double, Double, breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.canMapValues[Double, Double]((ClassTag.Double: scala.reflect.ClassTag[Double]))))).-[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](breeze.numerics.`package`.abs.apply[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](result.asBreeze.asInstanceOf[breeze.linalg.DenseMatrix[Double]])(`package`.this.abs.fromLowOrderCanMapActiveValues[breeze.linalg.DenseMatrix[Double], Double, Double, breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.scalarOf[Double], `package`.this.abs.absDoubleImpl, linalg.this.mapActiveValues.implFromCanMapValues[breeze.linalg.DenseMatrix[Double], Double, Double, breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.canMapValues[Double, Double]((ClassTag.Double: scala.reflect.ClassTag[Double]))))))(linalg.this.DenseMatrix.op_DM_DM_Double_OpSub))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315));
        }, new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304));
        this.test("compute covariance", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)this.denseMat(), (List)new .colon.colon((Object)this.sparseMat(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)mat -> {
            Matrix result = mat.computeCovariance();
            DenseMatrix expected = breeze.linalg.package$.MODULE$.cov(mat.toBreeze(), breeze.linalg.package$.MODULE$.cov$default$2());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.closeToZero((DenseMatrix<Object>)((DenseMatrix)((ImmutableNumericOps)package.abs$.MODULE$.apply((Object)expected, package.abs$.MODULE$.fromLowOrderCanMapActiveValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.abs$.absDoubleImpl$.MODULE$, mapActiveValues$.MODULE$.implFromCanMapValues(DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double()))))).$minus(package.abs$.MODULE$.apply((Object)((DenseMatrix)result.asBreeze()), package.abs$.MODULE$.fromLowOrderCanMapActiveValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.abs$.absDoubleImpl$.MODULE$, mapActiveValues$.MODULE$.implFromCanMapValues(DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())))), DenseMatrix$.MODULE$.op_DM_DM_Double_OpSub()))), "RowMatrixSuite.this.closeToZero(breeze.numerics.`package`.abs.apply[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](expected)(`package`.this.abs.fromLowOrderCanMapActiveValues[breeze.linalg.DenseMatrix[Double], Double, Double, breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.scalarOf[Double], `package`.this.abs.absDoubleImpl, linalg.this.mapActiveValues.implFromCanMapValues[breeze.linalg.DenseMatrix[Double], Double, Double, breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.canMapValues[Double, Double]((ClassTag.Double: scala.reflect.ClassTag[Double]))))).-[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](breeze.numerics.`package`.abs.apply[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](result.asBreeze.asInstanceOf[breeze.linalg.DenseMatrix[Double]])(`package`.this.abs.fromLowOrderCanMapActiveValues[breeze.linalg.DenseMatrix[Double], Double, Double, breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.scalarOf[Double], `package`.this.abs.absDoubleImpl, linalg.this.mapActiveValues.implFromCanMapValues[breeze.linalg.DenseMatrix[Double], Double, Double, breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.canMapValues[Double, Double]((ClassTag.Double: scala.reflect.ClassTag[Double]))))))(linalg.this.DenseMatrix.op_DM_DM_Double_OpSub))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
        }), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
        this.test("covariance matrix is symmetric (SPARK-10875)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            RDD rdd = RandomRDDs$.MODULE$.normalVectorRDD(this.sc(), 100L, 10, 0, 0L);
            RowMatrix matrix = new RowMatrix(rdd);
            Matrix cov = matrix.computeCovariance();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), cov.numRows()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), i).foreach((Function1 & Serializable & scala.Serializable)j -> RowMatrixSuite.$anonfun$new$46(this, cov, i, BoxesRunTime.unboxToInt((Object)j))));
        }, new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
        this.test("QR decomposition should aware of empty partition (SPARK-16369)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            RowMatrix mat = new RowMatrix(this.sc().parallelize(this.denseData(), 1, ClassTag$.MODULE$.apply(Vector.class)));
            QRDecomposition qrResult = mat.tallSkinnyQR(true);
            RowMatrix matWithEmptyPartition = new RowMatrix(this.sc().parallelize(this.denseData(), 8, ClassTag$.MODULE$.apply(Vector.class)));
            QRDecomposition qrResult2 = matWithEmptyPartition.tallSkinnyQR(true);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)((RowMatrix)qrResult.Q()).numCols()));
            long $org_scalatest_assert_macro_right = ((RowMatrix)qrResult2.Q()).numCols();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Q matrix ncol not match", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)((RowMatrix)qrResult.Q()).numRows()));
            long $org_scalatest_assert_macro_right2 = ((RowMatrix)qrResult2.Q()).numRows();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Q matrix nrow not match", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((RowMatrix)qrResult.Q()).rows().collect())).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])((RowMatrix)qrResult2.Q()).rows().collect()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)x._1()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)x._2()).relTol(1.0E-8)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(x._1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(x._2).relTol(1.0E-8))", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Q matrix not match", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
            });
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(((Matrix)qrResult.R()).toArray())).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(((Matrix)qrResult2.R()).toArray()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._1$mcD$sp()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._2$mcD$sp()).relTol(1.0E-8)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x._1).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x._2).relTol(1.0E-8))", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"R matrix not match", Prettifier$.MODULE$.default(), new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
            });
        }, new Position("RowMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
    }
}

