/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.clustering.DistanceMeasure;
import org.apache.spark.mllib.clustering.DistanceMeasure$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u000193Aa\u0004\t\u00017!)a\u0005\u0001C\u0001O!9!\u0006\u0001b\u0001\n\u0013Y\u0003B\u0002\u001a\u0001A\u0003%A\u0006C\u00044\u0001\t\u0007I\u0011B\u0016\t\rQ\u0002\u0001\u0015!\u0003-\u0011\u001d)\u0004A1A\u0005\n-BaA\u000e\u0001!\u0002\u0013a\u0003\"C\u001c\u0001\u0001\u0004\u0005\r\u0011\"\u00039\u0011%y\u0004\u00011AA\u0002\u0013%\u0001\tC\u0005G\u0001\u0001\u0007\t\u0011)Q\u0005s!Iq\t\u0001a\u0001\u0002\u0004%I\u0001\u000f\u0005\n\u0011\u0002\u0001\r\u00111A\u0005\n%C\u0011b\u0013\u0001A\u0002\u0003\u0005\u000b\u0015B\u001d\t\u000b1\u0003A\u0011I'\u0003)\u0011K7\u000f^1oG\u0016lU-Y:ve\u0016\u001cV/\u001b;f\u0015\t\t\"#\u0001\u0006dYV\u001cH/\u001a:j]\u001eT!a\u0005\u000b\u0002\u000b5dG.\u001b2\u000b\u0005U1\u0012!B:qCJ\\'BA\f\u0019\u0003\u0019\t\u0007/Y2iK*\t\u0011$A\u0002pe\u001e\u001c\u0001aE\u0002\u00019\u0001\u0002\"!\b\u0010\u000e\u0003QI!a\b\u000b\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t\tC%D\u0001#\u0015\t\u0019##\u0001\u0003vi&d\u0017BA\u0013#\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqR\fa\u0001P5oSRtD#\u0001\u0015\u0011\u0005%\u0002Q\"\u0001\t\u0002\tM,W\rZ\u000b\u0002YA\u0011Q\u0006M\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\t\u0019\u0011J\u001c;\u0002\u000bM,W\r\u001a\u0011\u0002\u0003-\f!a\u001b\u0011\u0002\u0007\u0011LW.\u0001\u0003eS6\u0004\u0013aB2f]R,'o]\u000b\u0002sA\u0019QF\u000f\u001f\n\u0005mr#!B!se\u0006L\bCA\u0015>\u0013\tq\u0004C\u0001\bWK\u000e$xN],ji\"tuN]7\u0002\u0017\r,g\u000e^3sg~#S-\u001d\u000b\u0003\u0003\u0012\u0003\"!\f\"\n\u0005\rs#\u0001B+oSRDq!R\u0005\u0002\u0002\u0003\u0007\u0011(A\u0002yIE\n\u0001bY3oi\u0016\u00148\u000fI\u0001\u0005I\u0006$\u0018-\u0001\u0005eCR\fw\fJ3r)\t\t%\nC\u0004F\u0019\u0005\u0005\t\u0019A\u001d\u0002\u000b\u0011\fG/\u0019\u0011\u0002\u0013\t,gm\u001c:f\u00032dG#A!")
public class DistanceMeasureSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private final int seed;
    private final int k;
    private final int dim;
    private VectorWithNorm[] centers;
    private VectorWithNorm[] data;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private int seed() {
        return this.seed;
    }

    private int k() {
        return this.k;
    }

    private int dim() {
        return this.dim;
    }

    private VectorWithNorm[] centers() {
        return this.centers;
    }

    private void centers_$eq(VectorWithNorm[] x$1) {
        this.centers = x$1;
    }

    private VectorWithNorm[] data() {
        return this.data;
    }

    private void data_$eq(VectorWithNorm[] x$1) {
        this.data = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
        Random rng = new Random(this.seed());
        this.centers_$eq((VectorWithNorm[])Array$.MODULE$.tabulate(this.k(), (Function1 & Serializable & scala.Serializable)i -> DistanceMeasureSuite.$anonfun$beforeAll$1(this, rng, BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(VectorWithNorm.class)));
        this.data_$eq((VectorWithNorm[])Array$.MODULE$.tabulate(1000, (Function1 & Serializable & scala.Serializable)i -> DistanceMeasureSuite.$anonfun$beforeAll$3(this, rng, BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(VectorWithNorm.class)));
    }

    private final void testImplicits$lzycompute$1() {
        DistanceMeasureSuite distanceMeasureSuite = this;
        synchronized (distanceMeasureSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ VectorWithNorm $anonfun$beforeAll$1(DistanceMeasureSuite $this, Random rng$1, int i) {
        double[] values = (double[])Array$.MODULE$.fill($this.dim(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rng$1.nextGaussian(), ClassTag$.MODULE$.Double());
        return new VectorWithNorm(Vectors$.MODULE$.dense(values));
    }

    public static final /* synthetic */ VectorWithNorm $anonfun$beforeAll$3(DistanceMeasureSuite $this, Random rng$1, int i) {
        double[] values = (double[])Array$.MODULE$.fill($this.dim(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rng$1.nextGaussian(), ClassTag$.MODULE$.Double());
        return new VectorWithNorm(Vectors$.MODULE$.dense(values));
    }

    public static final /* synthetic */ void $anonfun$new$2(DistanceMeasureSuite $this, String distanceMeasure) {
        DistanceMeasure distance = DistanceMeasure$.MODULE$.decodeFromString(distanceMeasure);
        double[] statistics = distance.computeStatistics($this.centers());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.data())).foreach((Function1 & Serializable & scala.Serializable)point -> {
            Tuple2 tuple2 = distance.findClosest($this.centers(), point);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int index1 = tuple2._1$mcI$sp();
            double cost1 = tuple2._2$mcD$sp();
            Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(index1, cost1);
            int index12 = sp2._1$mcI$sp();
            double cost12 = sp2._2$mcD$sp();
            Tuple2 tuple22 = distance.findClosest($this.centers(), statistics, point);
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            int index2 = tuple22._1$mcI$sp();
            double cost2 = tuple22._2$mcD$sp();
            Tuple2.mcID.sp sp3 = new Tuple2.mcID.sp(index2, cost2);
            int index22 = sp3._1$mcI$sp();
            double cost22 = sp3._2$mcD$sp();
            int $org_scalatest_assert_macro_left = index12;
            int $org_scalatest_assert_macro_right = index22;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DistanceMeasureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(cost12).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(cost22).relTol(1.0E-10)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(cost1).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(cost2).relTol(1.0E-10))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DistanceMeasureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        });
    }

    public DistanceMeasureSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.seed = 42;
        this.k = 10;
        this.dim = 8;
        this.test("predict with statistics", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)DistanceMeasure$.MODULE$.COSINE(), (List)new .colon.colon((Object)DistanceMeasure$.MODULE$.EUCLIDEAN(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)distanceMeasure -> {
            DistanceMeasureSuite.$anonfun$new$2(this, distanceMeasure);
            return BoxedUnit.UNIT;
        }), new Position("DistanceMeasureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("compute statistics distributedly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)DistanceMeasure$.MODULE$.COSINE(), (List)new .colon.colon((Object)DistanceMeasure$.MODULE$.EUCLIDEAN(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)distanceMeasure -> {
            DistanceMeasure distance = DistanceMeasure$.MODULE$.decodeFromString(distanceMeasure);
            double[] statistics1 = distance.computeStatistics(this.centers());
            SparkContext sc = this.spark().sparkContext();
            Broadcast bcCenters = sc.broadcast((Object)this.centers(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(VectorWithNorm.class)));
            double[] statistics2 = distance.computeStatisticsDistributedly(sc, bcCenters);
            bcCenters.destroy();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(statistics1)).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(statistics2)).relTol(1.0E-10)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(statistics1)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(statistics2)).relTol(1.0E-10))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DistanceMeasureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        }), new Position("DistanceMeasureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
    }
}

