/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.source.libsvm;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.ArrayList;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SQLDataTypes$;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.datasources.CommonFileDataSourceSuite;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0003\u0006\u0001/!)a\u0006\u0001C\u0001_!)!\u0007\u0001C)g!)A\b\u0001C){!Ia\t\u0001a\u0001\u0002\u0004%\ta\u0012\u0005\n)\u0002\u0001\r\u00111A\u0005\u0002UC\u0011\u0002\u0018\u0001A\u0002\u0003\u0005\u000b\u0015\u0002%\t\u000bu\u0003A\u0011\t0\t\u000b}\u0003A\u0011\t0\u0003'1K'm\u0015,N%\u0016d\u0017\r^5p]N+\u0018\u000e^3\u000b\u0005-a\u0011A\u00027jEN4XN\u0003\u0002\u000e\u001d\u000511o\\;sG\u0016T!a\u0004\t\u0002\u00055d'BA\t\u0013\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019B#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002+\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0007\u000f%!\tI\"$D\u0001\u0011\u0013\tY\u0002CA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003;\tj\u0011A\b\u0006\u0003?\u0001\nA!\u001e;jY*\u0011\u0011\u0005E\u0001\u0006[2d\u0017NY\u0005\u0003Gy\u0011Q#\u0014'mS\n$Vm\u001d;Ta\u0006\u00148nQ8oi\u0016DH\u000f\u0005\u0002&Y5\taE\u0003\u0002(Q\u0005YA-\u0019;bg>,(oY3t\u0015\tI#&A\u0005fq\u0016\u001cW\u000f^5p]*\u00111\u0006E\u0001\u0004gFd\u0017BA\u0017'\u0005e\u0019u.\\7p]\u001aKG.\u001a#bi\u0006\u001cv.\u001e:dKN+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005\u0001\u0004CA\u0019\u0001\u001b\u0005Q\u0011\u0001\u00053bi\u0006\u001cv.\u001e:dK\u001a{'/\\1u+\u0005!\u0004CA\u001b;\u001b\u00051$BA\u001c9\u0003\u0011a\u0017M\\4\u000b\u0003e\nAA[1wC&\u00111H\u000e\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019%t\u0007/\u001e;ECR\f7/\u001a;\u0016\u0003y\u0002\"aP\"\u000f\u0005\u0001\u000bU\"\u0001\u0016\n\u0005\tS\u0013a\u00029bG.\fw-Z\u0005\u0003\t\u0016\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005\tS\u0013\u0001\u00029bi\",\u0012\u0001\u0013\t\u0003\u0013Js!A\u0013)\u0011\u0005-sU\"\u0001'\u000b\u000553\u0012A\u0002\u001fs_>$hHC\u0001P\u0003\u0015\u00198-\u00197b\u0013\t\tf*\u0001\u0004Qe\u0016$WMZ\u0005\u0003wMS!!\u0015(\u0002\u0011A\fG\u000f[0%KF$\"A\u0016.\u0011\u0005]CV\"\u0001(\n\u0005es%\u0001B+oSRDqaW\u0003\u0002\u0002\u0003\u0007\u0001*A\u0002yIE\nQ\u0001]1uQ\u0002\n\u0011BY3g_J,\u0017\t\u001c7\u0015\u0003Y\u000b\u0001\"\u00194uKJ\fE\u000e\u001c")
public class LibSVMRelationSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
CommonFileDataSourceSuite {
    private String path;
    private String sparkHome;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;
    private volatile boolean bitmap$0;

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    private String sparkHome$lzycompute() {
        LibSVMRelationSuite libSVMRelationSuite = this;
        synchronized (libSVMRelationSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public String dataSourceFormat() {
        return "libsvm";
    }

    public Dataset<Row> inputDataset() {
        ArrayList<Row> rawData = new ArrayList<Row>();
        rawData.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)1.0), Vectors$.MODULE$.sparse(1, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, 1.0), (List)Nil$.MODULE$))})));
        StructType struct = new StructType().add("labelFoo", (DataType)DoubleType$.MODULE$, false).add("featuresBar", SQLDataTypes$.MODULE$.VectorType(), false);
        return this.spark().createDataFrame(rawData, struct);
    }

    public String path() {
        return this.path;
    }

    public void path_$eq(String x$1) {
        this.path = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
        String lines0 = new StringOps(Predef$.MODULE$.augmentString("\n        |1 1:1.0 3:2.0 5:3.0\n        |0\n      ")).stripMargin();
        String lines1 = new StringOps(Predef$.MODULE$.augmentString("\n        |0 2:4.0 4:5.0 6:6.0\n      ")).stripMargin();
        File dir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        File succ = new File(dir, "_SUCCESS");
        File file0 = new File(dir, "part-00000");
        File file1 = new File(dir, "part-00001");
        Files.write((CharSequence)"", (File)succ, (Charset)StandardCharsets.UTF_8);
        Files.write((CharSequence)lines0, (File)file0, (Charset)StandardCharsets.UTF_8);
        Files.write((CharSequence)lines1, (File)file1, (Charset)StandardCharsets.UTF_8);
        this.path_$eq(dir.getPath());
    }

    @Override
    public void afterAll() {
        try {
            Utils$.MODULE$.deleteRecursively(new File(this.path()));
        }
        finally {
            MLlibTestSparkContext.afterAll$(this);
        }
    }

    private final void testImplicits$lzycompute$1() {
        LibSVMRelationSuite libSVMRelationSuite = this;
        synchronized (libSVMRelationSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$new$17(LibSVMRelationSuite $this, File dir) {
        SparseVector v;
        String basePath = dir.getCanonicalPath();
        String svmFileName = "[abc]";
        String escapedSvmFileName = "\\[abc\\]";
        ArrayList<Row> rawData = new ArrayList<Row>();
        rawData.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)1.0), Vectors$.MODULE$.sparse(2, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, 2.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(1, 3.0), (List)Nil$.MODULE$)))})));
        StructType struct = new StructType().add("labelFoo", (DataType)DoubleType$.MODULE$, false).add("featuresBar", SQLDataTypes$.MODULE$.VectorType(), false);
        Dataset df = $this.spark().createDataFrame(rawData, struct);
        df.write().format("libsvm").save(new StringBuilder(1).append(basePath).append("/").append(svmFileName).toString());
        Dataset df2 = $this.spark().read().format("libsvm").load(new StringBuilder(1).append(basePath).append("/").append(escapedSvmFileName).toString());
        Row row1 = (Row)df2.first();
        SparseVector $org_scalatest_assert_macro_left = v = (SparseVector)row1.getAs(1);
        Vector $org_scalatest_assert_macro_right = Vectors$.MODULE$.sparse(2, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, 2.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(1, 3.0), (List)Nil$.MODULE$)));
        SparseVector sparseVector = $org_scalatest_assert_macro_left;
        Vector vector = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(sparseVector != null ? !sparseVector.equals(vector) : vector != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
    }

    public LibSVMRelationSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        SQLHelper.$init$((SQLHelper)this);
        CommonFileDataSourceSuite.$init$((CommonFileDataSourceSuite)this);
        this.test("select as sparse vector", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparseVector v;
            Dataset df = this.spark().read().format("libsvm").load(this.path());
            String $org_scalatest_assert_macro_left = df.columns()[0];
            String $org_scalatest_assert_macro_right = "label";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            String $org_scalatest_assert_macro_left2 = df.columns()[1];
            String $org_scalatest_assert_macro_right2 = "features";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            Row row1 = (Row)df.first();
            double $org_scalatest_assert_macro_left3 = row1.getDouble(0);
            double $org_scalatest_assert_macro_right3 = 1.0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            SparseVector $org_scalatest_assert_macro_left4 = v = (SparseVector)row1.getAs(1);
            Vector $org_scalatest_assert_macro_right4 = Vectors$.MODULE$.sparse(6, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, 1.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(2, 2.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(4, 3.0), (List)Nil$.MODULE$))));
            SparseVector sparseVector = $org_scalatest_assert_macro_left4;
            Vector vector = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(sparseVector != null ? !sparseVector.equals(vector) : vector != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)AttributeGroup$.MODULE$.fromStructField(df.schema().apply("features")).size()));
            int $org_scalatest_assert_macro_right5 = v.size();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        }, new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        this.test("select as dense vector", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DenseVector v;
            Dataset df = this.spark().read().format("libsvm").options((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"vectorType"), (Object)"dense")}))).load(this.path());
            String $org_scalatest_assert_macro_left = df.columns()[0];
            String $org_scalatest_assert_macro_right = "label";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            String $org_scalatest_assert_macro_left2 = df.columns()[1];
            String $org_scalatest_assert_macro_right2 = "features";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            long $org_scalatest_assert_macro_left3 = df.count();
            int $org_scalatest_assert_macro_right3 = 3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == (long)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            Row row1 = (Row)df.first();
            double $org_scalatest_assert_macro_left4 = row1.getDouble(0);
            double $org_scalatest_assert_macro_right4 = 1.0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
            DenseVector $org_scalatest_assert_macro_left5 = v = (DenseVector)row1.getAs(1);
            Vector $org_scalatest_assert_macro_right5 = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.0, 0.0, 3.0, 0.0}));
            DenseVector denseVector = $org_scalatest_assert_macro_left5;
            Vector vector = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(denseVector != null ? !denseVector.equals(vector) : vector != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)AttributeGroup$.MODULE$.fromStructField(df.schema().apply("features")).size()));
            int $org_scalatest_assert_macro_right6 = v.size();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        }, new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("illegal vector types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String e;
            String $org_scalatest_assert_macro_left = e = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().read().format("libsvm").options((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"VectorType"), (Object)"sparser")}))).load(this.path()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107))).getMessage();
            String $org_scalatest_assert_macro_right = "Invalid value `sparser` for parameter `vectorType`. Expected types are `sparse` and `dense`.";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        }, new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.test("select a vector with specifying the longer dimension", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparseVector v;
            Dataset df = this.spark().read().option("numFeatures", "100").format("libsvm").load(this.path());
            Row row1 = (Row)df.first();
            SparseVector $org_scalatest_assert_macro_left = v = (SparseVector)row1.getAs(1);
            Vector $org_scalatest_assert_macro_right = Vectors$.MODULE$.sparse(100, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, 1.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(2, 2.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(4, 3.0), (List)Nil$.MODULE$))));
            SparseVector sparseVector = $org_scalatest_assert_macro_left;
            Vector vector = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(sparseVector != null ? !sparseVector.equals(vector) : vector != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)AttributeGroup$.MODULE$.fromStructField(df.schema().apply("features")).size()));
            int $org_scalatest_assert_macro_right2 = v.size();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        }, new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        this.test("case insensitive option", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset df = this.spark().read().option("NuMfEaTuReS", "100").format("libsvm").load(this.path());
            SparseVector $org_scalatest_assert_macro_left = (SparseVector)((Row)df.first()).getAs(1);
            Vector $org_scalatest_assert_macro_right = Vectors$.MODULE$.sparse(100, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, 1.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(2, 2.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(4, 3.0), (List)Nil$.MODULE$))));
            SparseVector sparseVector = $org_scalatest_assert_macro_left;
            Vector vector = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(sparseVector != null ? !sparseVector.equals(vector) : vector != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)AttributeGroup$.MODULE$.fromStructField(df.schema().apply("features")).size()));
            int $org_scalatest_assert_macro_right2 = 100;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        }, new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        this.test("write libsvm data and read it again", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparseVector v;
            Dataset df = this.spark().read().format("libsvm").load(this.path());
            String writePath = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getPath();
            df.coalesce(1).write().format("libsvm").mode(SaveMode.Overwrite).save(writePath);
            Dataset df2 = this.spark().read().format("libsvm").load(writePath);
            Row row1 = (Row)df2.first();
            SparseVector $org_scalatest_assert_macro_left = v = (SparseVector)row1.getAs(1);
            Vector $org_scalatest_assert_macro_right = Vectors$.MODULE$.sparse(6, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, 1.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(2, 2.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(4, 3.0), (List)Nil$.MODULE$))));
            SparseVector sparseVector = $org_scalatest_assert_macro_left;
            Vector vector = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(sparseVector != null ? !sparseVector.equals(vector) : vector != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)AttributeGroup$.MODULE$.fromStructField(df.schema().apply("features")).size()));
            int $org_scalatest_assert_macro_right2 = v.size();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)AttributeGroup$.MODULE$.fromStructField(df2.schema().apply("features")).size()));
            int $org_scalatest_assert_macro_right3 = v.size();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
        }, new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("write libsvm data failed due to invalid schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset df = this.spark().read().format("text").load(this.path());
            return (IOException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.write().format("libsvm").save(new StringBuilder(2).append(this.path()).append("_2").toString()), ClassTag$.MODULE$.apply(IOException.class), new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        }, new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        this.test("write libsvm data from scratch and read it again", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparseVector v;
            ArrayList<Row> rawData = new ArrayList<Row>();
            rawData.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)1.0), Vectors$.MODULE$.sparse(3, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, 2.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(1, 3.0), (List)Nil$.MODULE$)))})));
            rawData.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)4.0), Vectors$.MODULE$.sparse(3, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, 5.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(2, 6.0), (List)Nil$.MODULE$)))})));
            StructField structField = new StructField("labelFoo", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("featuresBar", SQLDataTypes$.MODULE$.VectorType(), false, StructField$.MODULE$.apply$default$4());
            StructType struct = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
            Dataset df = this.spark().sqlContext().createDataFrame(rawData, struct);
            String writePath = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getPath();
            df.coalesce(1).write().format("libsvm").mode(SaveMode.Overwrite).save(writePath);
            Dataset df2 = this.spark().read().format("libsvm").load(writePath);
            Row row1 = (Row)df2.first();
            SparseVector $org_scalatest_assert_macro_left = v = (SparseVector)row1.getAs(1);
            Vector $org_scalatest_assert_macro_right = Vectors$.MODULE$.sparse(3, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, 2.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(1, 3.0), (List)Nil$.MODULE$)));
            SparseVector sparseVector = $org_scalatest_assert_macro_left;
            Vector vector = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(sparseVector != null ? !sparseVector.equals(vector) : vector != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)AttributeGroup$.MODULE$.fromStructField(df2.schema().apply("features")).size()));
            int $org_scalatest_assert_macro_right2 = v.size();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        }, new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        this.test("select features from libsvm relation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset df = this.spark().read().format("libsvm").load(this.path());
            df.select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Object d;
                Row row = x0$1;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (d = ((SeqLike)some.get()).apply(0)) instanceof Vector) {
                    Vector vector = (Vector)d;
                    return vector;
                }
                throw new MatchError((Object)row);
            }, ClassTag$.MODULE$.apply(Vector.class)).first();
            return (Row[])df.select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect();
        }, new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        this.test("create libsvmTable table without schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            try {
                this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(130).append("\n           |CREATE TABLE libsvmTable\n           |USING libsvm\n           |OPTIONS (\n           |  path '").append(this.path()).append("'\n           |)\n         ").toString())).stripMargin());
                Dataset df = this.spark().table("libsvmTable");
                String $org_scalatest_assert_macro_left = df.columns()[0];
                String $org_scalatest_assert_macro_right = "label";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
                String $org_scalatest_assert_macro_left2 = df.columns()[1];
                String $org_scalatest_assert_macro_right2 = "features";
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
            }
            finally {
                this.spark().sql("DROP TABLE IF EXISTS libsvmTable");
            }
            return assertion;
        }, new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        this.test("create libsvmTable table without schema and path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            try {
                IllegalArgumentException e = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("CREATE TABLE libsvmTable USING libsvm"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
                String $org_scalatest_assert_macro_left = e.getMessage();
                String $org_scalatest_assert_macro_right = "No input path specified for libsvm data";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
            }
            finally {
                this.spark().sql("DROP TABLE IF EXISTS libsvmTable");
            }
            return assertion;
        }, new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
        this.test("SPARK-32815: Test LibSVM data source on file paths with glob metacharacters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1 & Serializable & scala.Serializable)dir -> {
            LibSVMRelationSuite.$anonfun$new$17(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("LibSVMRelationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
    }
}

