/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.clustering.GaussianMixtureModel;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.stat.distribution.MultivariateGaussian;
import org.apache.spark.ml.util.TestingUtils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class GaussianMixtureSuite$
extends SparkFunSuite {
    public static GaussianMixtureSuite$ MODULE$;
    private final Map<String, Object> allParamSettings;
    private final Seq<Vector> denseData;
    private final Seq<Vector> decompositionData;
    private final Seq<Vector> rData;

    static {
        new GaussianMixtureSuite$();
    }

    public Map<String, Object> allParamSettings() {
        return this.allParamSettings;
    }

    public Seq<Vector> denseData() {
        return this.denseData;
    }

    public Seq<Vector> decompositionData() {
        return this.decompositionData;
    }

    public Seq<Vector> rData() {
        return this.rData;
    }

    public void modelEquals(GaussianMixtureModel m1, GaussianMixtureModel m2) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)m1.weights().length));
        int $org_scalatest_assert_macro_right = m2.weights().length;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
        Tuple2[] s1 = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(m1.weights())).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])m1.gaussians()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).sortBy((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToDouble((double)x$9._1$mcD$sp()), (Ordering)Ordering.Double$.MODULE$);
        Tuple2[] s2 = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(m2.weights())).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])m2.gaussians()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).sortBy((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToDouble((double)x$10._1$mcD$sp()), (Ordering)Ordering.Double$.MODULE$);
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(m1.weights())).indices().foreach((Function1 & Serializable & scala.Serializable)i -> GaussianMixtureSuite$.$anonfun$modelEquals$3(s1, s2, BoxesRunTime.unboxToInt((Object)i)));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ Assertion $anonfun$modelEquals$3(Tuple2[] s1$1, Tuple2[] s2$1, int i) {
        Tuple2 tuple2 = s1$1[i];
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double w1 = tuple2._1$mcD$sp();
        MultivariateGaussian g1 = (MultivariateGaussian)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)w1), (Object)g1);
        double w12 = tuple22._1$mcD$sp();
        MultivariateGaussian g12 = (MultivariateGaussian)tuple22._2();
        Tuple2 tuple23 = s2$1[i];
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        double w2 = tuple23._1$mcD$sp();
        MultivariateGaussian g2 = (MultivariateGaussian)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)w2), (Object)g2);
        double w22 = tuple24._1$mcD$sp();
        MultivariateGaussian g22 = (MultivariateGaussian)tuple24._2();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(w12).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(w22).absTol(0.001)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(w1).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(w2).absTol(0.001))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(g12.mean()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(g22.mean()).absTol(0.001)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(g1.mean).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(g2.mean).absTol(0.001))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(g12.cov()).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(g22.cov()).absTol(0.001)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(g1.cov).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(g2.cov).absTol(0.001))", Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
    }

    private GaussianMixtureSuite$() {
        MODULE$ = this;
        this.allParamSettings = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"predictionCol"), (Object)"myPrediction"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"probabilityCol"), (Object)"myProbability"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxIter"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tol"), (Object)BoxesRunTime.boxToDouble((double)0.01))}));
        this.denseData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(-5.1971, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(-2.5359, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(-3.822, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(-5.2211, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(-5.0602, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(4.7118, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(6.8989, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(3.4592, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(4.6322, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(5.7048, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(4.6567, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(5.5026, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(4.5605, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(5.2043, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(6.2734, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))}));
        this.decompositionData = (Seq)Seq$.MODULE$.tabulate(25, (Function1 & Serializable & scala.Serializable)i -> Vectors$.MODULE$.dense((double[])Array$.MODULE$.tabulate(50, (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$8 -> (double)i + (double)x$8, ClassTag$.MODULE$.Double())));
        this.rData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(-0.6264538, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.1836433})), Vectors$.MODULE$.dense(-0.8356286, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.5952808})), Vectors$.MODULE$.dense(0.3295078, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.8204684})), Vectors$.MODULE$.dense(0.4874291, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.7383247})), Vectors$.MODULE$.dense(0.5757814, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.3053884})), Vectors$.MODULE$.dense(1.5117812, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.3898432})), Vectors$.MODULE$.dense(-0.6212406, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-2.2146999})), Vectors$.MODULE$.dense(11.1249309, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{9.9550664})), Vectors$.MODULE$.dense(9.9838097, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{10.9438362})), Vectors$.MODULE$.dense(10.8212212, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{10.5939013})), Vectors$.MODULE$.dense(10.9189774, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{10.7821363})), Vectors$.MODULE$.dense(10.074565, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{8.0106483})), Vectors$.MODULE$.dense(10.6198257, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{9.9438713})), Vectors$.MODULE$.dense(9.8442045, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{8.5292476})), Vectors$.MODULE$.dense(9.5218499, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{10.4179416}))}));
    }
}

