/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import breeze.generic.UFunc;
import breeze.linalg.Vector;
import breeze.linalg.Vector$;
import java.io.Serializable;
import java.util.List;
import org.apache.spark.ml.classification.ProbabilisticClassifierSuite$;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.util.TestingUtils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;
import scala.util.control.Breaks$;

public final class LogisticRegressionSuite$
implements scala.Serializable {
    public static LogisticRegressionSuite$ MODULE$;
    private final Map<String, Object> allParamSettings;

    static {
        new LogisticRegressionSuite$();
    }

    public Map<String, Object> allParamSettings() {
        return this.allParamSettings;
    }

    public List<LabeledPoint> generateLogisticInputAsList(double offset, double scale, int nPoints, int seed) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.generateLogisticInput(offset, scale, nPoints, seed)).asJava();
    }

    public Seq<LabeledPoint> generateLogisticInput(double offset, double scale, int nPoints, int seed) {
        Random rnd = new Random(seed);
        double[] x1 = (double[])Array$.MODULE$.fill(nPoints, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rnd.nextGaussian(), ClassTag$.MODULE$.Double());
        IndexedSeq y = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPoints).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> {
            double p = 1.0 / (1.0 + package$.MODULE$.exp(-(offset + scale * x1[i])));
            if (rnd.nextDouble() < p) {
                return 1.0;
            }
            return 0.0;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq testData = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPoints).map((Function1 & Serializable & scala.Serializable)i -> LogisticRegressionSuite$.$anonfun$generateLogisticInput$3(y, x1, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        return testData;
    }

    public Seq<LabeledPoint> generateMultinomialLogisticInput(double[] weights, double[] xMean, double[] xVariance, boolean addIntercept, int nPoints, int seed) {
        Random rnd = new Random(seed);
        int xDim = xMean.length;
        int xWithInterceptsDim = addIntercept ? xDim + 1 : xDim;
        int nClasses = weights.length / xWithInterceptsDim + 1;
        org.apache.spark.ml.linalg.Vector[] x = (org.apache.spark.ml.linalg.Vector[])Array$.MODULE$.fill(nPoints, (Function0 & Serializable & scala.Serializable)() -> Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(xDim, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rnd.nextGaussian(), ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(org.apache.spark.ml.linalg.Vector.class));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x)).foreach((Function1 & Serializable & scala.Serializable)vector -> {
            LogisticRegressionSuite$.$anonfun$generateMultinomialLogisticInput$3(xVariance, xMean, vector);
            return BoxedUnit.UNIT;
        });
        IndexedSeq y = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPoints).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)idx -> {
            double[] xArray = x[idx].toArray();
            double[] margins = (double[])Array$.MODULE$.ofDim(nClasses, ClassTag$.MODULE$.Double());
            double[] probs = (double[])Array$.MODULE$.ofDim(nClasses, ClassTag$.MODULE$.Double());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nClasses - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), xDim).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
                    int n = i + 1;
                    margins$1[n] = margins[n] + weights[i * xWithInterceptsDim + j] * xArray[j];
                });
                if (addIntercept) {
                    int n = i + 1;
                    margins$1[n] = margins[n] + weights[(i + 1) * xWithInterceptsDim - 1];
                    return;
                }
            });
            double maxMargin = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(margins)).max((Ordering)Ordering.Double$.MODULE$));
            if (maxMargin > 0.0) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nClasses).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    margins$1[i] = margins[i] - maxMargin;
                });
            }
            DoubleRef temp = DoubleRef.create((double)0.0);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nClasses).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                probs$1[i] = package$.MODULE$.exp(margins[i]);
                temp$1.elem += probs[i];
            });
            double norm = temp.elem;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nClasses).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                probs$1[i] = probs[i] / norm;
            });
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), nClasses).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                probs$1[i] = probs[i] + probs[i - 1];
            });
            double p = rnd.nextDouble();
            IntRef y = IntRef.create((int)0);
            Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nClasses).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                if (p < probs[i]) {
                    y$2.elem = i;
                    throw Breaks$.MODULE$.break();
                }
            }));
            return y.elem;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq testData = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPoints).map((Function1 & Serializable & scala.Serializable)i -> LogisticRegressionSuite$.$anonfun$generateMultinomialLogisticInput$13(y, x, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        return testData;
    }

    public void checkBoundedMLORCoefficientsEquivalent(Matrix coefficients1, Matrix coefficients2) {
        coefficients1.colIter().zip(coefficients2.colIter()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LogisticRegressionSuite$.$anonfun$checkBoundedMLORCoefficientsEquivalent$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ LabeledPoint $anonfun$generateLogisticInput$3(IndexedSeq y$1, double[] x1$1, int i) {
        return new LabeledPoint(BoxesRunTime.unboxToDouble((Object)y$1.apply(i)), Vectors$.MODULE$.dense(new double[]{x1$1[i]}));
    }

    public static final /* synthetic */ void $anonfun$generateMultinomialLogisticInput$3(double[] xVariance$1, double[] xMean$1, org.apache.spark.ml.linalg.Vector vector) {
        double[] vectorArray = vector.toArray();
        int len = vectorArray.length;
        for (int i = 0; i < len; ++i) {
            vectorArray[i] = vectorArray[i] * package$.MODULE$.sqrt(xVariance$1[i]) + xMean$1[i];
        }
    }

    public static final /* synthetic */ LabeledPoint $anonfun$generateMultinomialLogisticInput$13(IndexedSeq y$3, org.apache.spark.ml.linalg.Vector[] x$15, int i) {
        return new LabeledPoint((double)BoxesRunTime.unboxToInt((Object)y$3.apply(i)), x$15[i]);
    }

    public static final /* synthetic */ void $anonfun$checkBoundedMLORCoefficientsEquivalent$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            org.apache.spark.ml.linalg.Vector col1 = (org.apache.spark.ml.linalg.Vector)tuple2._1();
            org.apache.spark.ml.linalg.Vector col2 = (org.apache.spark.ml.linalg.Vector)tuple2._2();
            if (col1 != null) {
                org.apache.spark.ml.linalg.Vector vector = col1;
                if (col2 != null) {
                    org.apache.spark.ml.linalg.Vector vector2 = col2;
                    new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(((Vector)vector.asBreeze().$minus((Object)vector2.asBreeze(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpSub())).toArray$mcD$sp(ClassTag$.MODULE$.Double()))).toSeq().sliding(2).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Seq seq = x0$2;
                        Some some = Seq$.MODULE$.unapplySeq(seq);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            double v1 = BoxesRunTime.unboxToDouble((Object)((SeqLike)some.get()).apply(0));
                            double v2 = BoxesRunTime.unboxToDouble((Object)((SeqLike)some.get()).apply(1));
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(v1).$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(v2).absTol(0.01)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(v1).~=(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(v2).absTol(0.01))", Prettifier$.MODULE$.default());
                            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3162));
                        }
                        throw new MatchError((Object)seq);
                    });
                    return;
                }
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private LogisticRegressionSuite$() {
        MODULE$ = this;
        this.allParamSettings = ProbabilisticClassifierSuite$.MODULE$.allParamSettings().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"probabilityCol"), (Object)"myProbability"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"thresholds"), (Object)new double[]{0.4, 0.6}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"regParam"), (Object)BoxesRunTime.boxToDouble((double)0.01)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"elasticNetParam"), (Object)BoxesRunTime.boxToDouble((double)0.1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxIter"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fitIntercept"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tol"), (Object)BoxesRunTime.boxToDouble((double)0.8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"standardization"), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"threshold"), (Object)BoxesRunTime.boxToDouble((double)0.6))})));
    }
}

