/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import breeze.linalg.DenseMatrix;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.Random;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseMatrix$;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.MatrixUDT;
import org.apache.spark.mllib.linalg.SparseMatrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.sql.types.SQLUserDefinedType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@SQLUserDefinedType(udt=MatrixUDT.class)
@ScalaSignature(bytes="\u0006\u0001\tec\u0001B\u0014)\u0001MB\u0001B\u0010\u0001\u0003\u0006\u0004%\ta\u0010\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u0001\"Aa\n\u0001BC\u0002\u0013\u0005q\b\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003A\u0011!\u0011\u0006A!b\u0001\n\u0003\u0019\u0006\u0002C.\u0001\u0005\u0003\u0005\u000b\u0011\u0002+\t\u0011u\u0003!Q1A\u0005ByC\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006Ia\u0018\u0005\u0006O\u0002!\t\u0001\u001b\u0005\u0006O\u0002!\ta\u001d\u0005\u0006q\u0002!\t%\u001f\u0005\u0007\u007f\u0002!\t%!\u0001\t\u0011\u0005\r\u0001\u0001\"\u0001+\u0003\u000bA\u0001\"a\u0005\u0001\t\u0003Q\u0013Q\u0003\u0005\b\u0003'\u0001A\u0011IA\u000e\u0011!\t)\u0003\u0001C\u0001U\u0005\u001d\u0002\u0002CA\u0017\u0001\u0011\u0005!&a\f\t\u000f\u0005}\u0002\u0001\"\u0011\u0002B!A\u0011\u0011\n\u0001\u0005\u00021\nY\u0005\u0003\u0005\u0002.\u0001!\tAKA,\u0011\u001d\tY\u0006\u0001C!\u0003\u0003B\u0001\"a\u0018\u0001\t\u0003b\u0013\u0011\r\u0005\u0007\u0003W\u0002A\u0011I \t\r\u0005M\u0004\u0001\"\u0011@\u0011\u001d\t9\b\u0001C\u0001\u0003sBq!a!\u0001\t\u0003\n)\tC\u0004\u0002,\u0002!\t%!,\b\u000f\u0005m\u0007\u0006#\u0001\u0002^\u001a1q\u0005\u000bE\u0001\u0003?DaaZ\u000f\u0005\u0002\u0005\u001d\bbBAu;\u0011\u0005\u00111\u001e\u0005\b\u0003glB\u0011AA{\u0011\u001d\ti0\bC\u0001\u0003\u007fDqAa\u0002\u001e\t\u0003\u0011I\u0001C\u0004\u0003&u!\tAa\n\t\u000f\tER\u0004\"\u0001\u00034!9!1H\u000f\u0005\u0002\tu\u0002\"\u0003B#;\u0005\u0005I\u0011\u0002B$\u0005-!UM\\:f\u001b\u0006$(/\u001b=\u000b\u0005%R\u0013A\u00027j]\u0006dwM\u0003\u0002,Y\u0005)Q\u000e\u001c7jE*\u0011QFL\u0001\u0006gB\f'o\u001b\u0006\u0003_A\na!\u00199bG\",'\"A\u0019\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001!$\b\u0005\u00026q5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdG\u0001\u0004B]f\u0014VM\u001a\t\u0003wqj\u0011\u0001K\u0005\u0003{!\u0012a!T1ue&D\u0018a\u00028v[J{wo]\u000b\u0002\u0001B\u0011Q'Q\u0005\u0003\u0005Z\u00121!\u00138uQ\r\tAI\u0013\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000f2\n!\"\u00198o_R\fG/[8o\u0013\tIeIA\u0003TS:\u001cW-I\u0001L\u0003\u0015\td\u0006\r\u00181\u0003!qW/\u001c*poN\u0004\u0003f\u0001\u0002E\u0015\u00069a.^7D_2\u001c\bfA\u0002E\u0015\u0006Aa.^7D_2\u001c\b\u0005K\u0002\u0005\t*\u000baA^1mk\u0016\u001cX#\u0001+\u0011\u0007U*v+\u0003\u0002Wm\t)\u0011I\u001d:bsB\u0011Q\u0007W\u0005\u00033Z\u0012a\u0001R8vE2,\u0007fA\u0003E\u0015\u00069a/\u00197vKN\u0004\u0003f\u0001\u0004E\u0015\u0006a\u0011n\u001d+sC:\u001c\bo\\:fIV\tq\f\u0005\u00026A&\u0011\u0011M\u000e\u0002\b\u0005>|G.Z1oQ\r9AiY\u0011\u0002I\u0006)\u0011GL\u001a/a\u0005i\u0011n\u001d+sC:\u001c\bo\\:fI\u0002B3\u0001\u0003#d\u0003\u0019a\u0014N\\5u}Q)\u0011N\u001b7oaB\u00111\b\u0001\u0005\u0006}%\u0001\r\u0001\u0011\u0015\u0004U\u0012S\u0005\"\u0002(\n\u0001\u0004\u0001\u0005f\u00017E\u0015\")!+\u0003a\u0001)\"\u001aa\u000e\u0012&\t\u000buK\u0001\u0019A0)\u0007A$5\rK\u0002\n\t\u000e$B!\u001b;vm\")aH\u0003a\u0001\u0001\")aJ\u0003a\u0001\u0001\")!K\u0003a\u0001)\"\u001a!\u0002\u0012&\u0002\r\u0015\fX/\u00197t)\ty&\u0010C\u0003|\u0017\u0001\u0007A0A\u0001p!\t)T0\u0003\u0002\u007fm\t\u0019\u0011I\\=\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012\u0001Q\u0001\tCN\u0014%/Z3{KV\u0011\u0011q\u0001\t\u0006\u0003\u0013\t\tbV\u0007\u0003\u0003\u0017Q1!KA\u0007\u0015\t\ty!\u0001\u0004ce\u0016,'0Z\u0005\u0004{\u0005-\u0011!B1qa2LHcA,\u0002\u0018!1\u0011\u0011\u0004\bA\u0002\u0001\u000b\u0011!\u001b\u000b\u0006/\u0006u\u0011q\u0004\u0005\u0007\u00033y\u0001\u0019\u0001!\t\r\u0005\u0005r\u00021\u0001A\u0003\u0005Q\u0007fA\bEG\u0006)\u0011N\u001c3fqR)\u0001)!\u000b\u0002,!1\u0011\u0011\u0004\tA\u0002\u0001Ca!!\t\u0011\u0001\u0004\u0001\u0015AB;qI\u0006$X\r\u0006\u0005\u00022\u0005]\u0012\u0011HA\u001e!\r)\u00141G\u0005\u0004\u0003k1$\u0001B+oSRDa!!\u0007\u0012\u0001\u0004\u0001\u0005BBA\u0011#\u0001\u0007\u0001\t\u0003\u0004\u0002>E\u0001\raV\u0001\u0002m\u0006!1m\u001c9z+\u0005I\u0007\u0006\u0002\nE\u0003\u000b\n#!a\u0012\u0002\u000bErCG\f\u0019\u0002\u00075\f\u0007\u000fF\u0002j\u0003\u001bBq!a\u0014\u0014\u0001\u0004\t\t&A\u0001g!\u0015)\u00141K,X\u0013\r\t)F\u000e\u0002\n\rVt7\r^5p]F\"2![A-\u0011\u001d\ty\u0005\u0006a\u0001\u0003#\n\u0011\u0002\u001e:b]N\u0004xn]3)\u0007U!5-A\u0007g_J,\u0017m\u00195BGRLg/\u001a\u000b\u0005\u0003c\t\u0019\u0007C\u0004\u0002PY\u0001\r!!\u001a\u0011\u0011U\n9\u0007\u0011!X\u0003cI1!!\u001b7\u0005%1UO\\2uS>t7'A\u0006ok6tuN\u001c>fe>\u001c\b\u0006B\fE\u0003_\n#!!\u001d\u0002\u000bErSG\f\u0019\u0002\u00159,X.Q2uSZ,7\u000f\u000b\u0003\u0019\t\u0006=\u0014\u0001\u0003;p'B\f'o]3\u0016\u0005\u0005m\u0004cA\u001e\u0002~%\u0019\u0011q\u0010\u0015\u0003\u0019M\u0003\u0018M]:f\u001b\u0006$(/\u001b=)\u0007e!5-A\u0004d_2LE/\u001a:\u0016\u0005\u0005\u001d\u0005CBAE\u00033\u000byJ\u0004\u0003\u0002\f\u0006Ue\u0002BAG\u0003'k!!a$\u000b\u0007\u0005E%'\u0001\u0004=e>|GOP\u0005\u0002o%\u0019\u0011q\u0013\u001c\u0002\u000fA\f7m[1hK&!\u00111TAO\u0005!IE/\u001a:bi>\u0014(bAALmA\u00191(!)\n\u0007\u0005\r\u0006F\u0001\u0004WK\u000e$xN\u001d\u0015\u00055\u0011\u000b9+\t\u0002\u0002*\u0006)!G\f\u0019/a\u0005!\u0011m]'M+\t\ty\u000b\u0005\u0003\u00022\u0006eVBAAZ\u0015\rI\u0013Q\u0017\u0006\u0004\u0003oc\u0013AA7m\u0013\r9\u00131\u0017\u0015\u00057\u0011\u000b9\u000bK\u0004\u0001\u0003\u007f\u000by-!5\u0011\t\u0005\u0005\u00171Z\u0007\u0003\u0003\u0007TA!!2\u0002H\u0006)A/\u001f9fg*\u0019\u0011\u0011\u001a\u0017\u0002\u0007M\fH.\u0003\u0003\u0002N\u0006\r'AE*R\u0019V\u001bXM\u001d#fM&tW\r\u001a+za\u0016\f1!\u001e3uG\t\t\u0019\u000eE\u0002<\u0003+L1!a6)\u0005%i\u0015\r\u001e:jqV#E\u000bK\u0002\u0001\t*\u000b1\u0002R3og\u0016l\u0015\r\u001e:jqB\u00111(H\n\u0005;Q\n\t\u000fE\u00026\u0003GL1!!:7\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\ti.A\u0003{KJ|7\u000fF\u0003j\u0003[\fy\u000fC\u0003??\u0001\u0007\u0001\tC\u0003O?\u0001\u0007\u0001\tK\u0002 \t\u000e\fAa\u001c8fgR)\u0011.a>\u0002z\")a\b\ta\u0001\u0001\")a\n\ta\u0001\u0001\"\u001a\u0001\u0005R2\u0002\u0007\u0015LX\rF\u0002j\u0005\u0003AaAa\u0001\"\u0001\u0004\u0001\u0015!\u00018)\u0007\u0005\"5-\u0001\u0003sC:$GcB5\u0003\f\t5!q\u0002\u0005\u0006}\t\u0002\r\u0001\u0011\u0005\u0006\u001d\n\u0002\r\u0001\u0011\u0005\b\u0005#\u0011\u0003\u0019\u0001B\n\u0003\r\u0011hn\u001a\t\u0005\u0005+\u0011y\"\u0004\u0002\u0003\u0018)!!\u0011\u0004B\u000e\u0003\u0011)H/\u001b7\u000b\u0005\tu\u0011\u0001\u00026bm\u0006LAA!\t\u0003\u0018\t1!+\u00198e_6D3A\t#d\u0003\u0015\u0011\u0018M\u001c3o)\u001dI'\u0011\u0006B\u0016\u0005[AQAP\u0012A\u0002\u0001CQAT\u0012A\u0002\u0001CqA!\u0005$\u0001\u0004\u0011\u0019\u0002K\u0002$\t\u000e\fA\u0001Z5bOR\u0019\u0011N!\u000e\t\u000f\t]B\u00051\u0001\u0002 \u00061a/Z2u_JD3\u0001\n#d\u0003\u00191'o\\7N\u0019R\u0019\u0011Na\u0010\t\u000f\t\u0005S\u00051\u0001\u00020\u0006\tQ\u000e\u000b\u0003&\t\u0006\u001d\u0016a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!\u0013\u0011\t\t-#\u0011K\u0007\u0003\u0005\u001bRAAa\u0014\u0003\u001c\u0005!A.\u00198h\u0013\u0011\u0011\u0019F!\u0014\u0003\r=\u0013'.Z2uQ\riBi\u0019\u0015\u00049\u0011\u001b\u0007")
public class DenseMatrix
implements Matrix {
    private final int numRows;
    private final int numCols;
    private final double[] values;
    private final boolean isTransposed;

    public static DenseMatrix fromML(org.apache.spark.ml.linalg.DenseMatrix denseMatrix) {
        return DenseMatrix$.MODULE$.fromML(denseMatrix);
    }

    public static DenseMatrix diag(Vector vector) {
        return DenseMatrix$.MODULE$.diag(vector);
    }

    public static DenseMatrix randn(int n, int n2, Random random) {
        return DenseMatrix$.MODULE$.randn(n, n2, random);
    }

    public static DenseMatrix rand(int n, int n2, Random random) {
        return DenseMatrix$.MODULE$.rand(n, n2, random);
    }

    public static DenseMatrix eye(int n) {
        return DenseMatrix$.MODULE$.eye(n);
    }

    public static DenseMatrix ones(int n, int n2) {
        return DenseMatrix$.MODULE$.ones(n, n2);
    }

    public static DenseMatrix zeros(int n, int n2) {
        return DenseMatrix$.MODULE$.zeros(n, n2);
    }

    @Override
    public double[] toArray() {
        return Matrix.toArray$(this);
    }

    @Override
    public Iterator<Vector> rowIter() {
        return Matrix.rowIter$(this);
    }

    @Override
    public DenseMatrix multiply(DenseMatrix y) {
        return Matrix.multiply$((Matrix)this, y);
    }

    @Override
    public DenseVector multiply(DenseVector y) {
        return Matrix.multiply$((Matrix)this, y);
    }

    @Override
    public DenseVector multiply(Vector y) {
        return Matrix.multiply$((Matrix)this, y);
    }

    @Override
    public String toString() {
        return Matrix.toString$(this);
    }

    @Override
    public String toString(int maxLines, int maxLineWidth) {
        return Matrix.toString$(this, maxLines, maxLineWidth);
    }

    @Override
    public void org$apache$spark$mllib$linalg$Matrix$_setter_$isTransposed_$eq(boolean x$1) {
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public int numCols() {
        return this.numCols;
    }

    public double[] values() {
        return this.values;
    }

    @Override
    public boolean isTransposed() {
        return this.isTransposed;
    }

    public boolean equals(Object o) {
        boolean bl;
        Object object = o;
        if (object instanceof Matrix) {
            Matrix matrix = (Matrix)object;
            breeze.linalg.Matrix<Object> matrix2 = this.asBreeze();
            breeze.linalg.Matrix<Object> matrix3 = matrix.asBreeze();
            bl = !(matrix2 != null ? !matrix2.equals(matrix3) : matrix3 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Predef$.MODULE$.int2Integer(this.numRows()), Predef$.MODULE$.int2Integer(this.numCols()), this.toArray()});
    }

    @Override
    public breeze.linalg.Matrix<Object> asBreeze() {
        DenseMatrix.mcD.sp sp2;
        if (!this.isTransposed()) {
            sp2 = new DenseMatrix.mcD.sp(this.numRows(), this.numCols(), this.values());
        } else {
            DenseMatrix.mcD.sp breezeMatrix = new DenseMatrix.mcD.sp(this.numCols(), this.numRows(), this.values());
            sp2 = (breeze.linalg.Matrix)breezeMatrix.t(breeze.linalg.DenseMatrix$.MODULE$.canTranspose());
        }
        return sp2;
    }

    public double apply(int i) {
        return this.values()[i];
    }

    @Override
    public double apply(int i, int j) {
        return this.values()[this.index(i, j)];
    }

    @Override
    public int index(int i, int j) {
        Predef$.MODULE$.require(i >= 0 && i < this.numRows(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Expected 0 <= i < ").append(this.numRows()).append(", got i = ").append(i).append(".").toString());
        Predef$.MODULE$.require(j >= 0 && j < this.numCols(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Expected 0 <= j < ").append(this.numCols()).append(", got j = ").append(j).append(".").toString());
        return !this.isTransposed() ? i + this.numRows() * j : j + this.numCols() * i;
    }

    @Override
    public void update(int i, int j, double v) {
        this.values()[this.index((int)i, (int)j)] = v;
    }

    @Override
    public DenseMatrix copy() {
        return new DenseMatrix(this.numRows(), this.numCols(), (double[])this.values().clone());
    }

    @Override
    public DenseMatrix map(Function1<Object, Object> f) {
        return new DenseMatrix(this.numRows(), this.numCols(), (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.values())).map(f, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), this.isTransposed());
    }

    @Override
    public DenseMatrix update(Function1<Object, Object> f) {
        int len = this.values().length;
        for (int i = 0; i < len; ++i) {
            this.values()[i] = f.apply$mcDD$sp(this.values()[i]);
        }
        return this;
    }

    @Override
    public DenseMatrix transpose() {
        return new DenseMatrix(this.numCols(), this.numRows(), this.values(), !this.isTransposed());
    }

    @Override
    public void foreachActive(Function3<Object, Object, Object, BoxedUnit> f) {
        if (!this.isTransposed()) {
            for (int j = 0; j < this.numCols(); ++j) {
                int indStart = j * this.numRows();
                for (int i = 0; i < this.numRows(); ++i) {
                    f.apply((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToDouble((double)this.values()[indStart + i]));
                }
            }
        } else {
            for (int i = 0; i < this.numRows(); ++i) {
                int indStart = i * this.numCols();
                for (int j = 0; j < this.numCols(); ++j) {
                    f.apply((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToDouble((double)this.values()[indStart + j]));
                }
            }
        }
    }

    @Override
    public int numNonzeros() {
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.values())).count((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$1 -> x$1 != 0.0);
    }

    @Override
    public int numActives() {
        return this.values().length;
    }

    public SparseMatrix toSparse() {
        ArrayBuilder.ofDouble spVals = new ArrayBuilder.ofDouble();
        int[] colPtrs = new int[this.numCols() + 1];
        ArrayBuilder.ofInt rowIndices = new ArrayBuilder.ofInt();
        int nnz = 0;
        int j = 0;
        while (j < this.numCols()) {
            for (int i = 0; i < this.numRows(); ++i) {
                double v = this.values()[this.index(i, j)];
                if (v == 0.0) continue;
                rowIndices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                spVals.$plus$eq((Object)BoxesRunTime.boxToDouble((double)v));
                ++nnz;
            }
            colPtrs[++j] = nnz;
        }
        return new SparseMatrix(this.numRows(), this.numCols(), colPtrs, (int[])rowIndices.result(), (double[])spVals.result());
    }

    @Override
    public Iterator<Vector> colIter() {
        return this.isTransposed() ? package$.MODULE$.Iterator().tabulate(this.numCols(), (Function1 & Serializable & scala.Serializable)j -> DenseMatrix.$anonfun$colIter$1(this, BoxesRunTime.unboxToInt((Object)j))) : package$.MODULE$.Iterator().tabulate(this.numCols(), (Function1 & Serializable & scala.Serializable)j -> DenseMatrix.$anonfun$colIter$2(this, BoxesRunTime.unboxToInt((Object)j)));
    }

    public org.apache.spark.ml.linalg.DenseMatrix asML() {
        return new org.apache.spark.ml.linalg.DenseMatrix(this.numRows(), this.numCols(), this.values(), this.isTransposed());
    }

    public static final /* synthetic */ DenseVector $anonfun$colIter$1(DenseMatrix $this, int j) {
        double[] col = new double[$this.numRows()];
        BLAS$.MODULE$.nativeBLAS().dcopy($this.numRows(), $this.values(), j, $this.numCols(), col, 0, 1);
        return new DenseVector(col);
    }

    public static final /* synthetic */ DenseVector $anonfun$colIter$2(DenseMatrix $this, int j) {
        return new DenseVector((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps($this.values())).slice(j * $this.numRows(), (j + 1) * $this.numRows()));
    }

    public DenseMatrix(int numRows, int numCols, double[] values, boolean isTransposed) {
        this.numRows = numRows;
        this.numCols = numCols;
        this.values = values;
        this.isTransposed = isTransposed;
        Matrix.$init$(this);
        Predef$.MODULE$.require(values.length == numRows * numCols, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(104).append("The number of values supplied doesn't match the ").append("size of the matrix! values.length: ").append(this.values().length).append(", numRows * numCols: ").append(this.numRows() * this.numCols()).toString());
    }

    public DenseMatrix(int numRows, int numCols, double[] values) {
        this(numRows, numCols, values, false);
    }
}

