/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.impl.Utils$;
import org.apache.spark.mllib.clustering.DistanceMeasure$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005=gA\u0002\u000f\u001e\u0003\u0003\ts\u0005C\u00032\u0001\u0011\u00051\u0007C\u00037\u0001\u0019\u0005q\u0007C\u00037\u0001\u0011\u0005Q\bC\u0003H\u0001\u0011\u0005\u0001\nC\u0003X\u0001\u0011\u0005\u0001\fC\u0003X\u0001\u0019\u0005q\rC\u0003X\u0001\u0011\u00051\u000eC\u0003o\u0001\u0011\u0005q\u000eC\u0003s\u0001\u0011\u00051\u000fC\u0003=\u0001\u0019\u0005Q\u0010C\u0004\u0002\u0006\u00011\t!a\u0002\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c!9\u00111\u0002\u0001\u0005\u0002\u0005U\u0002bBA\u001e\u0001\u0011\u0005\u0011Q\b\u0005\b\u0003\u0017\u0002A\u0011AA'\u000f\u001d\t\u0019&\bE\u0001\u0003+2a\u0001H\u000f\t\u0002\u0005]\u0003BB\u0019\u0012\t\u0003\tI\u0006C\u0005\u0002\\E\u0011\r\u0011\"\u0001\u0002^!A\u0011\u0011Q\t!\u0002\u0013\ty\u0006C\u0005\u0002\u0006F\u0011\r\u0011\"\u0001\u0002^!A\u0011\u0011R\t!\u0002\u0013\ty\u0006\u0003\u0005\u0002\u000eF!\t!IAH\u0011!\tI+\u0005C\u0001C\u0005-\u0006\u0002CAX#\u0011\u0005Q$!-\t\u0011\u0005]\u0016\u0003\"\u0001\u001e\u0003sC\u0011\"!1\u0012\u0003\u0003%I!a1\u0003\u001f\u0011K7\u000f^1oG\u0016lU-Y:ve\u0016T!AH\u0010\u0002\u0015\rdWo\u001d;fe&twM\u0003\u0002!C\u0005)Q\u000e\u001c7jE*\u0011!eI\u0001\u0006gB\f'o\u001b\u0006\u0003I\u0015\na!\u00199bG\",'\"\u0001\u0014\u0002\u0007=\u0014xmE\u0002\u0001Q9\u0002\"!\u000b\u0017\u000e\u0003)R\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[)\u0012a!\u00118z%\u00164\u0007CA\u00150\u0013\t\u0001$F\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004=S:LGOP\u0002\u0001)\u0005!\u0004CA\u001b\u0001\u001b\u0005i\u0012!E2p[B,H/Z*uCRL7\u000f^5dgR\u0011\u0001h\u000f\t\u0003SeJ!A\u000f\u0016\u0003\r\u0011{WO\u00197f\u0011\u0015a$\u00011\u00019\u0003!!\u0017n\u001d;b]\u000e,GC\u0001 B!\rIs\bO\u0005\u0003\u0001*\u0012Q!\u0011:sCfDQAQ\u0002A\u0002\r\u000bqaY3oi\u0016\u00148\u000fE\u0002*\u007f\u0011\u0003\"!N#\n\u0005\u0019k\"A\u0004,fGR|'oV5uQ:{'/\\\u0001\u001fG>l\u0007/\u001e;f'R\fG/[:uS\u000e\u001cH)[:ue&\u0014W\u000f^3eYf$2AP%P\u0011\u0015QE\u00011\u0001L\u0003\t\u00198\r\u0005\u0002M\u001b6\t\u0011%\u0003\u0002OC\ta1\u000b]1sW\u000e{g\u000e^3yi\")\u0001\u000b\u0002a\u0001#\u0006I!mY\"f]R,'o\u001d\t\u0004%V\u001bU\"A*\u000b\u0005Q\u000b\u0013!\u00032s_\u0006$7-Y:u\u0013\t16KA\u0005Ce>\fGmY1ti\u0006Ya-\u001b8e\u00072|7/Z:u)\u0011Iv\fY3\u0011\t%RF\fO\u0005\u00037*\u0012a\u0001V;qY\u0016\u0014\u0004CA\u0015^\u0013\tq&FA\u0002J]RDQAQ\u0003A\u0002\rCQ!Y\u0003A\u0002\t\f!b\u001d;bi&\u001cH/[2t!\rI3MP\u0005\u0003I*\u0012aa\u00149uS>t\u0007\"\u00024\u0006\u0001\u0004!\u0015!\u00029pS:$H\u0003B-iS*DQA\u0011\u0004A\u0002\rCQ!\u0019\u0004A\u0002yBQA\u001a\u0004A\u0002\u0011#2!\u00177n\u0011\u0015\u0011u\u00011\u0001D\u0011\u00151w\u00011\u0001E\u0003%\u0001x.\u001b8u\u0007>\u001cH\u000fF\u00029aFDQA\u0011\u0005A\u0002\rCQA\u001a\u0005A\u0002\u0011\u000b\u0011#[:DK:$XM]\"p]Z,'oZ3e)\u0011!x/_>\u0011\u0005%*\u0018B\u0001<+\u0005\u001d\u0011un\u001c7fC:DQ\u0001_\u0005A\u0002\u0011\u000b\u0011b\u001c7e\u0007\u0016tG/\u001a:\t\u000biL\u0001\u0019\u0001#\u0002\u00139,woQ3oi\u0016\u0014\b\"\u0002?\n\u0001\u0004A\u0014aB3qg&dwN\u001c\u000b\u0005qy\f\t\u0001C\u0003\u0000\u0015\u0001\u0007A)\u0001\u0002wc!1\u00111\u0001\u0006A\u0002\u0011\u000b!A\u001e\u001a\u0002\u0017\rdWo\u001d;fe\u000e{7\u000f\u001e\u000b\nq\u0005%\u0011QBA\t\u0003+Aa!a\u0003\f\u0001\u0004!\u0015\u0001C2f]R\u0014x.\u001b3\t\r\u0005=1\u00021\u0001E\u0003%\u0001x.\u001b8ugN+X\u000e\u0003\u0004\u0002\u0014-\u0001\r\u0001O\u0001\no\u0016Lw\r\u001b;Tk6Da!a\u0006\f\u0001\u0004A\u0014!\u00059pS:$8oU9vCJ,GMT8s[\u0006\u0001R\u000f\u001d3bi\u0016\u001cE.^:uKJ\u001cV/\u001c\u000b\u0007\u0003;\t\u0019#!\n\u0011\u0007%\ny\"C\u0002\u0002\")\u0012A!\u00168ji\")a\r\u0004a\u0001\t\"9\u0011q\u0005\u0007A\u0002\u0005%\u0012aA:v[B!\u00111FA\u0019\u001b\t\tiCC\u0002\u00020}\ta\u0001\\5oC2<\u0017\u0002BA\u001a\u0003[\u0011aAV3di>\u0014H#\u0002#\u00028\u0005e\u0002bBA\u0014\u001b\u0001\u0007\u0011\u0011\u0006\u0005\u0007\u0003'i\u0001\u0019\u0001\u001d\u0002%MLX.\\3ue&\u001c7)\u001a8ue>LGm\u001d\u000b\t\u0003\u007f\t\t%!\u0012\u0002JA!\u0011F\u0017#E\u0011\u0019\t\u0019E\u0004a\u0001q\u0005)A.\u001a<fY\"9\u0011q\t\bA\u0002\u0005%\u0012!\u00028pSN,\u0007bBA\u0006\u001d\u0001\u0007\u0011\u0011F\u0001\u0005G>\u001cH\u000fF\u00039\u0003\u001f\n\t\u0006C\u0003g\u001f\u0001\u0007A\t\u0003\u0004\u0002\f=\u0001\r\u0001R\u0001\u0010\t&\u001cH/\u00198dK6+\u0017m];sKB\u0011Q'E\n\u0004#!rCCAA+\u0003%)Uk\u0011'J\t\u0016\u000be*\u0006\u0002\u0002`A!\u0011\u0011MA6\u001b\t\t\u0019G\u0003\u0003\u0002f\u0005\u001d\u0014\u0001\u00027b]\u001eT!!!\u001b\u0002\t)\fg/Y\u0005\u0005\u0003[\n\u0019G\u0001\u0004TiJLgn\u001a\u0015\u0006'\u0005E\u0014Q\u0010\t\u0005\u0003g\nI(\u0004\u0002\u0002v)\u0019\u0011qO\u0011\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002|\u0005U$!B*j]\u000e,\u0017EAA@\u0003\u0015\u0011d\u0006\u000e\u00181\u0003))Uk\u0011'J\t\u0016\u000be\n\t\u0015\u0006)\u0005E\u0014QP\u0001\u0007\u0007>\u001b\u0016JT#)\u000bU\t\t(! \u0002\u000f\r{5+\u0013(FA!*a#!\u001d\u0002~\u0005\u0001B-Z2pI\u00164%o\\7TiJLgn\u001a\u000b\u0004i\u0005E\u0005bBAJ/\u0001\u0007\u0011QS\u0001\u0010I&\u001cH/\u00198dK6+\u0017m];sKB!\u0011qSAS\u001d\u0011\tI*!)\u0011\u0007\u0005m%&\u0004\u0002\u0002\u001e*\u0019\u0011q\u0014\u001a\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019KK\u0001\u0007!J,G-\u001a4\n\t\u00055\u0014q\u0015\u0006\u0004\u0003GS\u0013a\u0006<bY&$\u0017\r^3ESN$\u0018M\\2f\u001b\u0016\f7/\u001e:f)\r!\u0018Q\u0016\u0005\b\u0003'C\u0002\u0019AAK\u0003]\u0019\bn\\;mI\u000e{W\u000e];uKN#\u0018\r^5ti&\u001c7\u000fF\u0002u\u0003gCa!!.\u001a\u0001\u0004a\u0016!A6\u0002=MDw.\u001e7e\u0007>l\u0007/\u001e;f'R\fG/[:uS\u000e\u001cHj\\2bY2LH#\u0002;\u0002<\u0006u\u0006BBA[5\u0001\u0007A\f\u0003\u0004\u0002@j\u0001\r\u0001X\u0001\f]Vlg)Z1ukJ,7/A\u0006sK\u0006$'+Z:pYZ,GCAAc!\u0011\t\t'a2\n\t\u0005%\u00171\r\u0002\u0007\u001f\nTWm\u0019;)\u000bE\t\t(! )\u000bA\t\t(! ")
public abstract class DistanceMeasure
implements scala.Serializable {
    public static String COSINE() {
        return DistanceMeasure$.MODULE$.COSINE();
    }

    public static String EUCLIDEAN() {
        return DistanceMeasure$.MODULE$.EUCLIDEAN();
    }

    public abstract double computeStatistics(double var1);

    /*
     * WARNING - void declaration
     */
    public double[] computeStatistics(VectorWithNorm[] centers) {
        void var3_3;
        int i;
        int k = centers.length;
        if (k == 1) {
            return new double[]{Double.NaN};
        }
        double[] packedValues = (double[])Array$.MODULE$.ofDim(k * (k + 1) / 2, ClassTag$.MODULE$.Double());
        double[] diagValues = (double[])Array$.MODULE$.fill(k, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> Double.POSITIVE_INFINITY, ClassTag$.MODULE$.Double());
        for (i = 0; i < k; ++i) {
            for (int j = i + 1; j < k; ++j) {
                double d = this.distance(centers[i], centers[j]);
                double s = this.computeStatistics(d);
                int index = Utils$.MODULE$.indexUpperTriangular(k, i, j);
                packedValues[index] = s;
                if (s < diagValues[i]) {
                    diagValues[i] = s;
                }
                if (!(s < diagValues[j])) continue;
                diagValues[j] = s;
            }
        }
        for (i = 0; i < k; ++i) {
            int index = Utils$.MODULE$.indexUpperTriangular(k, i, i);
            packedValues[index] = diagValues[i];
        }
        return var3_3;
    }

    public double[] computeStatisticsDistributedly(SparkContext sc, Broadcast<VectorWithNorm[]> bcCenters) {
        int k = ((VectorWithNorm[])bcCenters.value()).length;
        if (k == 1) {
            return new double[]{Double.NaN};
        }
        double[] packedValues = (double[])Array$.MODULE$.ofDim(k * (k + 1) / 2, ClassTag$.MODULE$.Double());
        double[] diagValues = (double[])Array$.MODULE$.fill(k, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> Double.POSITIVE_INFINITY, ClassTag$.MODULE$.Double());
        int numParts = package$.MODULE$.min(k, 1024);
        RDD qual$1 = sc.range(0L, (long)numParts, 1L, numParts);
        Function2 & Serializable & scala.Serializable x$1 = (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> DistanceMeasure.$anonfun$computeStatisticsDistributedly$2(this, bcCenters, k, numParts, BoxesRunTime.unboxToInt((Object)x0$1), x1$1);
        boolean x$2 = qual$1.mapPartitionsWithIndex$default$2();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])qual$1.mapPartitionsWithIndex((Function2)x$1, x$2, ClassTag$.MODULE$.apply(Tuple3.class)).collect())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            DistanceMeasure.$anonfun$computeStatisticsDistributedly$5(k, packedValues, diagValues, x0$2);
            return BoxedUnit.UNIT;
        });
        for (int i = 0; i < k; ++i) {
            int index = Utils$.MODULE$.indexUpperTriangular(k, i, i);
            packedValues[index] = diagValues[i];
        }
        return packedValues;
    }

    public Tuple2<Object, Object> findClosest(VectorWithNorm[] centers, Option<double[]> statistics, VectorWithNorm point) {
        return statistics.nonEmpty() ? this.findClosest(centers, (double[])statistics.get(), point) : this.findClosest(centers, point);
    }

    public abstract Tuple2<Object, Object> findClosest(VectorWithNorm[] var1, double[] var2, VectorWithNorm var3);

    public Tuple2<Object, Object> findClosest(VectorWithNorm[] centers, VectorWithNorm point) {
        double bestDistance = Double.POSITIVE_INFINITY;
        int bestIndex = 0;
        for (int i = 0; i < centers.length; ++i) {
            VectorWithNorm center = centers[i];
            double currentDistance = this.distance(center, point);
            if (!(currentDistance < bestDistance)) continue;
            bestDistance = currentDistance;
            bestIndex = i;
        }
        return new Tuple2.mcID.sp(bestIndex, bestDistance);
    }

    public double pointCost(VectorWithNorm[] centers, VectorWithNorm point) {
        return this.findClosest(centers, point)._2$mcD$sp();
    }

    public boolean isCenterConverged(VectorWithNorm oldCenter, VectorWithNorm newCenter, double epsilon) {
        return this.distance(oldCenter, newCenter) <= epsilon;
    }

    public abstract double distance(VectorWithNorm var1, VectorWithNorm var2);

    public abstract double clusterCost(VectorWithNorm var1, VectorWithNorm var2, double var3, double var5);

    public void updateClusterSum(VectorWithNorm point, Vector sum) {
        BLAS$.MODULE$.axpy(point.weight(), point.vector(), sum);
    }

    public VectorWithNorm centroid(Vector sum, double weightSum) {
        BLAS$.MODULE$.scal(1.0 / weightSum, sum);
        return new VectorWithNorm(sum);
    }

    public Tuple2<VectorWithNorm, VectorWithNorm> symmetricCentroids(double level, Vector noise, Vector centroid) {
        Vector left = centroid.copy();
        BLAS$.MODULE$.axpy(-level, noise, left);
        Vector right = centroid.copy();
        BLAS$.MODULE$.axpy(level, noise, right);
        return new Tuple2((Object)new VectorWithNorm(left), (Object)new VectorWithNorm(right));
    }

    public double cost(VectorWithNorm point, VectorWithNorm centroid) {
        return this.distance(point, centroid);
    }

    public static final /* synthetic */ Iterator $anonfun$computeStatisticsDistributedly$4(DistanceMeasure $this, int i$1, int numParts$1, int pid$1, VectorWithNorm[] centers$1, int j) {
        Iterator iterator;
        int hash = RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(new Tuple2.mcII.sp(i$1, j).hashCode()));
        if (hash % numParts$1 == pid$1) {
            double d = $this.distance(centers$1[i$1], centers$1[j]);
            double s = $this.computeStatistics(d);
            iterator = scala.package$.MODULE$.Iterator().single((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)i$1), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToDouble((double)s)));
        } else {
            iterator = scala.package$.MODULE$.Iterator().empty();
        }
        return iterator;
    }

    public static final /* synthetic */ Iterator $anonfun$computeStatisticsDistributedly$3(DistanceMeasure $this, int k$1, int numParts$1, int pid$1, VectorWithNorm[] centers$1, int i) {
        return scala.package$.MODULE$.Iterator().range(i + 1, k$1).flatMap((Function1 & Serializable & scala.Serializable)j -> DistanceMeasure.$anonfun$computeStatisticsDistributedly$4($this, i, numParts$1, pid$1, centers$1, BoxesRunTime.unboxToInt((Object)j)));
    }

    public static final /* synthetic */ Iterator $anonfun$computeStatisticsDistributedly$2(DistanceMeasure $this, Broadcast bcCenters$1, int k$1, int numParts$1, int x0$1, Iterator x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int pid = tuple2._1$mcI$sp();
        VectorWithNorm[] centers = (VectorWithNorm[])bcCenters$1.value();
        Iterator iterator = scala.package$.MODULE$.Iterator().range(0, k$1).flatMap((Function1 & Serializable & scala.Serializable)i -> DistanceMeasure.$anonfun$computeStatisticsDistributedly$3($this, k$1, numParts$1, pid, centers, BoxesRunTime.unboxToInt((Object)i)));
        return iterator;
    }

    public static final /* synthetic */ void $anonfun$computeStatisticsDistributedly$5(int k$1, double[] packedValues$1, double[] diagValues$1, Tuple3 x0$2) {
        BoxedUnit boxedUnit;
        Tuple3 tuple3 = x0$2;
        if (tuple3 != null) {
            int i = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int j = BoxesRunTime.unboxToInt((Object)tuple3._2());
            double s = BoxesRunTime.unboxToDouble((Object)tuple3._3());
            int index = Utils$.MODULE$.indexUpperTriangular(k$1, i, j);
            packedValues$1[index] = s;
            if (s < diagValues$1[i]) {
                diagValues$1[i] = s;
            }
            if (s < diagValues$1[j]) {
                diagValues$1[j] = s;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple3);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }
}

