/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.classification.ClassificationModel;
import org.apache.spark.mllib.classification.NaiveBayes$;
import org.apache.spark.mllib.classification.NaiveBayesModel;
import org.apache.spark.mllib.classification.NaiveBayesModel$;
import org.apache.spark.mllib.classification.NaiveBayesModel$SaveLoadV2_0$;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\rUf\u0001B5k\u0001UD!\"a\u0005\u0001\u0005\u000b\u0007I\u0011AA\u000b\u0011)\t)\u0004\u0001B\u0001B\u0003%\u0011q\u0003\u0005\u000b\u0003s\u0001!Q1A\u0005\u0002\u0005U\u0001BCA!\u0001\t\u0005\t\u0015!\u0003\u0002\u0018!Q\u0011Q\t\u0001\u0003\u0006\u0004%\t!a\u0012\t\u0015\u00055\u0003A!A!\u0002\u0013\tI\u0005\u0003\u0006\u0002R\u0001\u0011)\u0019!C\u0001\u0003'B!\"!\u001d\u0001\u0005\u0003\u0005\u000b\u0011BA+\u0011!\t)\b\u0001C\u0001]\u0006]\u0004\"CAF\u0001\t\u0007I\u0011BAG\u0011!\tY\n\u0001Q\u0001\n\u0005=\u0005\"CAO\u0001\t\u0007I\u0011BAP\u0011!\t9\u000b\u0001Q\u0001\n\u0005\u0005\u0006\u0002CA;\u0001\u0011\u0005A.!+\t\u0011\u0005U\u0004\u0001\"\u0001m\u0003cCA\"a3\u0001!\u0003\u0005\u0019\u0011)A\u0005\u0003\u001bD\u0011\"a7\u0001\u0005\u0004%I!!8\t\u0011\u0005}\u0007\u0001)A\u0005\u0003'D\u0011\"!9\u0001\u0005\u0004%I!a9\t\u0011\u0005\u0015\b\u0001)A\u0005\u00033Dq!a:\u0001\t\u0003\nI\u000fC\u0004\u0002h\u0002!\tE!\u0002\t\u000f\t-\u0001\u0001\"\u0001\u0003\u000e!9!1\u0002\u0001\u0005\u0002\t]\u0001b\u0002B\u000f\u0001\u0011%!q\u0004\u0005\b\u0005G\u0001A\u0011\u0002B\u0013\u0011\u001d\u0011I\u0003\u0001C\u0005\u0005WAqA!\r\u0001\t\u0003\u0012\u0019dB\u0004\u0003T)D\tA!\u0016\u0007\r%T\u0007\u0012\u0001B,\u0011\u001d\t)H\bC\u0001\u0005?:\u0001B!\u0019\u001f\u0011\u0003a'1\r\u0004\t\u0005Or\u0002\u0012\u00017\u0003j!9\u0011QO\u0011\u0005\u0002\t-\u0004b\u0002B7C\u0011\u0005\u00111\u000b\u0005\b\u0005_\nC\u0011AA*\r\u0019\u0011\t(\t!\u0003t!Q\u00111C\u0013\u0003\u0016\u0004%\t!!\u0006\t\u0015\u0005URE!E!\u0002\u0013\t9\u0002\u0003\u0006\u0002:\u0015\u0012)\u001a!C\u0001\u0003+A!\"!\u0011&\u0005#\u0005\u000b\u0011BA\f\u0011)\t)%\nBK\u0002\u0013\u0005\u0011q\t\u0005\u000b\u0003\u001b*#\u0011#Q\u0001\n\u0005%\u0003BCA)K\tU\r\u0011\"\u0001\u0002T!Q\u0011\u0011O\u0013\u0003\u0012\u0003\u0006I!!\u0016\t\u000f\u0005UT\u0005\"\u0001\u0003|!I!\u0011R\u0013\u0002\u0002\u0013\u0005!1\u0012\u0005\n\u0005++\u0013\u0013!C\u0001\u0005/C\u0011Ba+&#\u0003%\tAa&\t\u0013\t5V%%A\u0005\u0002\t=\u0006\"\u0003BZKE\u0005I\u0011\u0001B[\u0011%\u0011I,JA\u0001\n\u0003\u0012Y\fC\u0005\u0003B\u0016\n\t\u0011\"\u0001\u0003D\"I!1Z\u0013\u0002\u0002\u0013\u0005!Q\u001a\u0005\n\u00053,\u0013\u0011!C!\u00057D\u0011B!;&\u0003\u0003%\tAa;\t\u0013\tUX%!A\u0005B\t]\b\"\u0003B}K\u0005\u0005I\u0011\tB~\u0011%\u0011i0JA\u0001\n\u0003\u0012ypB\u0005\u0004\u0004\u0005\n\t\u0011#\u0001\u0004\u0006\u0019I!\u0011O\u0011\u0002\u0002#\u00051q\u0001\u0005\b\u0003kjD\u0011AB\u000b\u0011%\u0011I0PA\u0001\n\u000b\u0012Y\u0010C\u0005\u0004\u0018u\n\t\u0011\"!\u0004\u001a!I11E\u001f\u0002\u0002\u0013\u00055Q\u0005\u0005\n\u0007gi\u0014\u0011!C\u0005\u0007kAqA!\r\"\t\u0003\u0019i\u0004C\u0004\u0004H\u0005\"\ta!\u0013\b\u0011\rEc\u0004#\u0001m\u0007'2\u0001b!\u0016\u001f\u0011\u0003a7q\u000b\u0005\b\u0003k2E\u0011AB-\u0011\u001d\u0011iG\u0012C\u0001\u0003'BqAa\u001cG\t\u0003\t\u0019F\u0002\u0004\u0003r\u0019\u000351\f\u0005\u000b\u0003'Q%Q3A\u0005\u0002\u0005U\u0001BCA\u001b\u0015\nE\t\u0015!\u0003\u0002\u0018!Q\u0011\u0011\b&\u0003\u0016\u0004%\t!!\u0006\t\u0015\u0005\u0005#J!E!\u0002\u0013\t9\u0002\u0003\u0006\u0002F)\u0013)\u001a!C\u0001\u0003\u000fB!\"!\u0014K\u0005#\u0005\u000b\u0011BA%\u0011\u001d\t)H\u0013C\u0001\u0007;B\u0011B!#K\u0003\u0003%\ta!\u001b\t\u0013\tU%*%A\u0005\u0002\t]\u0005\"\u0003BV\u0015F\u0005I\u0011\u0001BL\u0011%\u0011iKSI\u0001\n\u0003\u0011y\u000bC\u0005\u0003:*\u000b\t\u0011\"\u0011\u0003<\"I!\u0011\u0019&\u0002\u0002\u0013\u0005!1\u0019\u0005\n\u0005\u0017T\u0015\u0011!C\u0001\u0007cB\u0011B!7K\u0003\u0003%\tEa7\t\u0013\t%(*!A\u0005\u0002\rU\u0004\"\u0003B{\u0015\u0006\u0005I\u0011\tB|\u0011%\u0011IPSA\u0001\n\u0003\u0012Y\u0010C\u0005\u0003~*\u000b\t\u0011\"\u0011\u0004z\u001dI11\u0001$\u0002\u0002#\u00051Q\u0010\u0004\n\u0005c2\u0015\u0011!E\u0001\u0007\u007fBq!!\u001e`\t\u0003\u00199\tC\u0005\u0003z~\u000b\t\u0011\"\u0012\u0003|\"I1qC0\u0002\u0002\u0013\u00055\u0011\u0012\u0005\n\u0007Gy\u0016\u0011!CA\u0007#C\u0011ba\r`\u0003\u0003%Ia!\u000e\t\u000f\tEb\t\"\u0001\u0004\u001e\"91q\t$\u0005\u0002\r\u0015\u0006bBB$=\u0011\u000531\u0016\u0005\n\u0007gq\u0012\u0011!C\u0005\u0007k\u0011qBT1jm\u0016\u0014\u0015-_3t\u001b>$W\r\u001c\u0006\u0003W2\fab\u00197bgNLg-[2bi&|gN\u0003\u0002n]\u0006)Q\u000e\u001c7jE*\u0011q\u000e]\u0001\u0006gB\f'o\u001b\u0006\u0003cJ\fa!\u00199bG\",'\"A:\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u00011H0!\u0001\u0002\bA\u0011qO_\u0007\u0002q*\t\u00110A\u0003tG\u0006d\u0017-\u0003\u0002|q\n1\u0011I\\=SK\u001a\u0004\"! @\u000e\u0003)L!a 6\u0003'\rc\u0017m]:jM&\u001c\u0017\r^5p]6{G-\u001a7\u0011\u0007]\f\u0019!C\u0002\u0002\u0006a\u0014AbU3sS\u0006d\u0017N_1cY\u0016\u0004B!!\u0003\u0002\u00105\u0011\u00111\u0002\u0006\u0004\u0003\u001ba\u0017\u0001B;uS2LA!!\u0005\u0002\f\tA1+\u0019<fC\ndW-\u0001\u0004mC\n,Gn]\u000b\u0003\u0003/\u0001Ra^A\r\u0003;I1!a\u0007y\u0005\u0015\t%O]1z!\r9\u0018qD\u0005\u0004\u0003CA(A\u0002#pk\ndW\rK\u0003\u0002\u0003K\t\t\u0004\u0005\u0003\u0002(\u00055RBAA\u0015\u0015\r\tYC\\\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0018\u0003S\u0011QaU5oG\u0016\f#!a\r\u0002\u000bEr\u0003G\f\u0019\u0002\u000f1\f'-\u001a7tA!*!!!\n\u00022\u0005\u0011\u0001/\u001b\u0015\u0006\u0007\u0005\u0015\u0012QH\u0011\u0003\u0003\u007f\tQ\u0001\r\u0018:]A\n1\u0001]5!Q\u0015!\u0011QEA\u001f\u0003\u0015!\b.\u001a;b+\t\tI\u0005E\u0003x\u00033\t9\u0002K\u0003\u0006\u0003K\ti$\u0001\u0004uQ\u0016$\u0018\r\t\u0015\u0006\r\u0005\u0015\u0012QH\u0001\n[>$W\r\u001c+za\u0016,\"!!\u0016\u0011\t\u0005]\u0013Q\r\b\u0005\u00033\n\t\u0007E\u0002\u0002\\al!!!\u0018\u000b\u0007\u0005}C/\u0001\u0004=e>|GOP\u0005\u0004\u0003GB\u0018A\u0002)sK\u0012,g-\u0003\u0003\u0002h\u0005%$AB*ue&twMC\u0002\u0002daDSaBA\u0013\u0003[\n#!a\u001c\u0002\u000bErCG\f\u0019\u0002\u00155|G-\u001a7UsB,\u0007\u0005K\u0003\t\u0003K\ti'\u0001\u0004=S:LGO\u0010\u000b\u000b\u0003s\nY(a \u0002\u0004\u0006\u001d\u0005CA?\u0001\u0011\u001d\t\u0019\"\u0003a\u0001\u0003/Ac!a\u001f\u0002&\u0005E\u0002bBA\u001d\u0013\u0001\u0007\u0011q\u0003\u0015\u0007\u0003\u007f\n)#!\u0010\t\u000f\u0005\u0015\u0013\u00021\u0001\u0002J!2\u00111QA\u0013\u0003{Aq!!\u0015\n\u0001\u0004\t)\u0006\u000b\u0004\u0002\b\u0006\u0015\u0012QN\u0001\ta&4Vm\u0019;peV\u0011\u0011q\u0012\t\u0005\u0003#\u000b9*\u0004\u0002\u0002\u0014*\u0019\u0011Q\u00137\u0002\r1Lg.\u00197h\u0013\u0011\tI*a%\u0003\u0017\u0011+gn]3WK\u000e$xN]\u0001\na&4Vm\u0019;pe\u0002\n1\u0002\u001e5fi\u0006l\u0015\r\u001e:jqV\u0011\u0011\u0011\u0015\t\u0005\u0003#\u000b\u0019+\u0003\u0003\u0002&\u0006M%a\u0003#f]N,W*\u0019;sSb\fA\u0002\u001e5fi\u0006l\u0015\r\u001e:jq\u0002\"\u0002\"!\u001f\u0002,\u00065\u0016q\u0016\u0005\b\u0003'q\u0001\u0019AA\f\u0011\u001d\tID\u0004a\u0001\u0003/Aq!!\u0012\u000f\u0001\u0004\tI\u0005\u0006\u0005\u0002z\u0005M\u0016QYAd\u0011\u001d\t\u0019b\u0004a\u0001\u0003k\u0003b!a.\u0002B\u0006uQBAA]\u0015\u0011\tY,!0\u0002\t1\fgn\u001a\u0006\u0003\u0003\u007f\u000bAA[1wC&!\u00111YA]\u0005!IE/\u001a:bE2,\u0007bBA\u001d\u001f\u0001\u0007\u0011Q\u0017\u0005\b\u0003\u000bz\u0001\u0019AAe!\u0019\t9,!1\u00026\u0006\u0019\u0001\u0010\n\u001a\u0011\u000f]\fy-a5\u0002Z&\u0019\u0011\u0011\u001b=\u0003\rQ+\b\u000f\\33!\u00159\u0018Q[AQ\u0013\r\t9\u000e\u001f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b]\f).a$\u0002%QDW\r^1NS:,8OT3h)\",G/Y\u000b\u0003\u0003'\f1\u0003\u001e5fi\u0006l\u0015N\\;t\u001d\u0016<G\u000b[3uC\u0002\n1B\\3h)\",G/Y*v[V\u0011\u0011\u0011\\\u0001\r]\u0016<G\u000b[3uCN+X\u000eI\u0001\baJ,G-[2u)\u0011\tY/a>\u0011\r\u00055\u00181_A\u000f\u001b\t\tyOC\u0002\u0002r:\f1A\u001d3e\u0013\u0011\t)0a<\u0003\u0007I#E\tC\u0004\u0002zV\u0001\r!a?\u0002\u0011Q,7\u000f\u001e#bi\u0006\u0004b!!<\u0002t\u0006u\b\u0003BAI\u0003\u007fLAA!\u0001\u0002\u0014\n1a+Z2u_JDS!FA\u0013\u0003c!B!!\b\u0003\b!9\u0011\u0011 \fA\u0002\u0005u\b&\u0002\f\u0002&\u0005E\u0012\u0001\u00069sK\u0012L7\r\u001e)s_\n\f'-\u001b7ji&,7\u000f\u0006\u0003\u0002|\n=\u0001bBA}/\u0001\u0007\u00111 \u0015\u0006/\u0005\u0015\"1C\u0011\u0003\u0005+\tQ!\r\u00186]A\"B!!@\u0003\u001a!9\u0011\u0011 \rA\u0002\u0005u\b&\u0002\r\u0002&\tM\u0011AF7vYRLgn\\7jC2\u001c\u0015\r\\2vY\u0006$\u0018n\u001c8\u0015\t\u0005=%\u0011\u0005\u0005\b\u0003sL\u0002\u0019AA\u007f\u0003Q\u0011WM\u001d8pk2d\u0017nQ1mGVd\u0017\r^5p]R!\u0011q\u0012B\u0014\u0011\u001d\tIP\u0007a\u0001\u0003{\fa\u0003]8ti\u0016\u0014\u0018n\u001c:Qe>\u0014\u0017MY5mSRLWm\u001d\u000b\u0005\u0003\u001f\u0013i\u0003C\u0004\u00030m\u0001\r!a$\u0002\u000f1|w\r\u0015:pE\u0006!1/\u0019<f)\u0019\u0011)Da\u000f\u0003HA\u0019qOa\u000e\n\u0007\te\u0002P\u0001\u0003V]&$\bb\u0002B\u001f9\u0001\u0007!qH\u0001\u0003g\u000e\u0004BA!\u0011\u0003D5\ta.C\u0002\u0003F9\u0014Ab\u00159be.\u001cuN\u001c;fqRDqA!\u0013\u001d\u0001\u0004\t)&\u0001\u0003qCRD\u0007&\u0002\u000f\u0002&\t5\u0013E\u0001B(\u0003\u0015\tdf\r\u00181Q\u0015\u0001\u0011QEA\u001f\u0003=q\u0015-\u001b<f\u0005\u0006LXm]'pI\u0016d\u0007CA?\u001f'\u0019qbO!\u0017\u0002\u0002A1\u0011\u0011\u0002B.\u0003sJAA!\u0018\u0002\f\t1Aj\\1eKJ$\"A!\u0016\u0002\u0019M\u000bg/\u001a'pC\u00124&g\u0018\u0019\u0011\u0007\t\u0015\u0014%D\u0001\u001f\u00051\u0019\u0016M^3M_\u0006$gKM01'\t\tc\u000f\u0006\u0002\u0003d\u0005\tB\u000f[5t\r>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8\u0002\u001bQD\u0017n]\"mCN\u001ch*Y7f\u0005\u0011!\u0015\r^1\u0014\r\u00152(QOA\u0001!\r9(qO\u0005\u0004\u0005sB(a\u0002)s_\u0012,8\r\u001e\u000b\u000b\u0005{\u0012\tIa!\u0003\u0006\n\u001d\u0005c\u0001B@K5\t\u0011\u0005C\u0004\u0002\u00149\u0002\r!a\u0006\t\u000f\u0005eb\u00061\u0001\u0002\u0018!9\u0011Q\t\u0018A\u0002\u0005%\u0003bBA)]\u0001\u0007\u0011QK\u0001\u0005G>\u0004\u0018\u0010\u0006\u0006\u0003~\t5%q\u0012BI\u0005'C\u0011\"a\u00050!\u0003\u0005\r!a\u0006\t\u0013\u0005er\u0006%AA\u0002\u0005]\u0001\"CA#_A\u0005\t\u0019AA%\u0011%\t\tf\fI\u0001\u0002\u0004\t)&\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\te%\u0006BA\f\u00057[#A!(\u0011\t\t}%qU\u0007\u0003\u0005CSAAa)\u0003&\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003WA\u0018\u0002\u0002BU\u0005C\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u00032*\"\u0011\u0011\nBN\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"Aa.+\t\u0005U#1T\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\tu\u0006\u0003BA\\\u0005\u007fKA!a\u001a\u0002:\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011!Q\u0019\t\u0004o\n\u001d\u0017b\u0001Beq\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!q\u001aBk!\r9(\u0011[\u0005\u0004\u0005'D(aA!os\"I!q\u001b\u001c\u0002\u0002\u0003\u0007!QY\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\tu\u0007C\u0002Bp\u0005K\u0014y-\u0004\u0002\u0003b*\u0019!1\u001d=\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003h\n\u0005(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BA!<\u0003tB\u0019qOa<\n\u0007\tE\bPA\u0004C_>dW-\u00198\t\u0013\t]\u0007(!AA\u0002\t=\u0017\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\t\u0015\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\tu\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0003n\u000e\u0005\u0001\"\u0003Blw\u0005\u0005\t\u0019\u0001Bh\u0003\u0011!\u0015\r^1\u0011\u0007\t}ThE\u0003>\u0007\u0013\t\t\u0001\u0005\b\u0004\f\rE\u0011qCA\f\u0003\u0013\n)F! \u000e\u0005\r5!bAB\bq\u00069!/\u001e8uS6,\u0017\u0002BB\n\u0007\u001b\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c85)\t\u0019)!A\u0003baBd\u0017\u0010\u0006\u0006\u0003~\rm1QDB\u0010\u0007CAq!a\u0005A\u0001\u0004\t9\u0002C\u0004\u0002:\u0001\u0003\r!a\u0006\t\u000f\u0005\u0015\u0003\t1\u0001\u0002J!9\u0011\u0011\u000b!A\u0002\u0005U\u0013aB;oCB\u0004H.\u001f\u000b\u0005\u0007O\u0019y\u0003E\u0003x\u0003+\u001cI\u0003E\u0006x\u0007W\t9\"a\u0006\u0002J\u0005U\u0013bAB\u0017q\n1A+\u001e9mKRB\u0011b!\rB\u0003\u0003\u0005\rA! \u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAB\u001c!\u0011\t9l!\u000f\n\t\rm\u0012\u0011\u0018\u0002\u0007\u001f\nTWm\u0019;\u0015\u0011\tU2qHB!\u0007\u0007BqA!\u0010D\u0001\u0004\u0011y\u0004C\u0004\u0003J\r\u0003\r!!\u0016\t\u000f\r\u00153\t1\u0001\u0003~\u0005!A-\u0019;b\u0003\u0011aw.\u00193\u0015\r\u0005e41JB'\u0011\u001d\u0011i\u0004\u0012a\u0001\u0005\u007fAqA!\u0013E\u0001\u0004\t)\u0006K\u0003E\u0003K\u0011i%\u0001\u0007TCZ,Gj\\1e-Fz\u0006\u0007E\u0002\u0003f\u0019\u0013AbU1wK2{\u0017\r\u001a,2?B\u001a\"A\u0012<\u0015\u0005\rM3C\u0002&w\u0005k\n\t\u0001\u0006\u0005\u0004`\r\r4QMB4!\r\u0019\tGS\u0007\u0002\r\"9\u00111C)A\u0002\u0005]\u0001bBA\u001d#\u0002\u0007\u0011q\u0003\u0005\b\u0003\u000b\n\u0006\u0019AA%)!\u0019yfa\u001b\u0004n\r=\u0004\"CA\n%B\u0005\t\u0019AA\f\u0011%\tID\u0015I\u0001\u0002\u0004\t9\u0002C\u0005\u0002FI\u0003\n\u00111\u0001\u0002JQ!!qZB:\u0011%\u00119\u000eWA\u0001\u0002\u0004\u0011)\r\u0006\u0003\u0003n\u000e]\u0004\"\u0003Bl5\u0006\u0005\t\u0019\u0001Bh)\u0011\u0011ioa\u001f\t\u0013\t]W,!AA\u0002\t=\u0007cAB1?N)ql!!\u0002\u0002Aa11BBB\u0003/\t9\"!\u0013\u0004`%!1QQB\u0007\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0007{\"\u0002ba\u0018\u0004\f\u000e55q\u0012\u0005\b\u0003'\u0011\u0007\u0019AA\f\u0011\u001d\tID\u0019a\u0001\u0003/Aq!!\u0012c\u0001\u0004\tI\u0005\u0006\u0003\u0004\u0014\u000em\u0005#B<\u0002V\u000eU\u0005#C<\u0004\u0018\u0006]\u0011qCA%\u0013\r\u0019I\n\u001f\u0002\u0007)V\u0004H.Z\u001a\t\u0013\rE2-!AA\u0002\r}C\u0003\u0003B\u001b\u0007?\u001b\tka)\t\u000f\tuR\r1\u0001\u0003@!9!\u0011J3A\u0002\u0005U\u0003bBB#K\u0002\u00071q\f\u000b\u0007\u0003s\u001a9k!+\t\u000f\tub\r1\u0001\u0003@!9!\u0011\n4A\u0002\u0005UCCBA=\u0007[\u001by\u000bC\u0004\u0003>\u001d\u0004\rAa\u0010\t\u000f\t%s\r1\u0001\u0002V!*a$!\n\u0003N!*Q$!\n\u0003N\u0001")
public class NaiveBayesModel
implements ClassificationModel,
Saveable {
    private final double[] labels;
    private final double[] pi;
    private final double[][] theta;
    private final String modelType;
    private final DenseVector piVector;
    private final DenseMatrix thetaMatrix;
    private final /* synthetic */ Tuple2 x$2;
    private final Option<DenseMatrix> thetaMinusNegTheta;
    private final Option<DenseVector> negThetaSum;

    public static NaiveBayesModel load(SparkContext sparkContext, String string) {
        return NaiveBayesModel$.MODULE$.load(sparkContext, string);
    }

    @Override
    public JavaRDD<Double> predict(JavaRDD<Vector> testData) {
        return ClassificationModel.predict$(this, testData);
    }

    public double[] labels() {
        return this.labels;
    }

    public double[] pi() {
        return this.pi;
    }

    public double[][] theta() {
        return this.theta;
    }

    public String modelType() {
        return this.modelType;
    }

    private DenseVector piVector() {
        return this.piVector;
    }

    private DenseMatrix thetaMatrix() {
        return this.thetaMatrix;
    }

    private Option<DenseMatrix> thetaMinusNegTheta() {
        return this.thetaMinusNegTheta;
    }

    private Option<DenseVector> negThetaSum() {
        return this.negThetaSum;
    }

    @Override
    public RDD<Object> predict(RDD<Vector> testData) {
        Broadcast bcModel = testData.context().broadcast((Object)this, ClassTag$.MODULE$.apply(NaiveBayesModel.class));
        return testData.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            NaiveBayesModel model = (NaiveBayesModel)bcModel.value();
            return iter.map((Function1 & Serializable & scala.Serializable)testData -> BoxesRunTime.boxToDouble((double)model.predict(testData)));
        }, testData.mapPartitions$default$2(), ClassTag$.MODULE$.Double());
    }

    @Override
    public double predict(Vector testData) {
        double d;
        String string = this.modelType();
        String string2 = NaiveBayes$.MODULE$.Multinomial();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            d = this.labels()[this.multinomialCalculation(testData).argmax()];
        } else {
            String string4 = NaiveBayes$.MODULE$.Bernoulli();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                d = this.labels()[this.bernoulliCalculation(testData).argmax()];
            } else {
                throw new MatchError((Object)string);
            }
        }
        return d;
    }

    public RDD<Vector> predictProbabilities(RDD<Vector> testData) {
        Broadcast bcModel = testData.context().broadcast((Object)this, ClassTag$.MODULE$.apply(NaiveBayesModel.class));
        return testData.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            NaiveBayesModel model = (NaiveBayesModel)bcModel.value();
            return iter.map((Function1 & Serializable & scala.Serializable)testData -> model.predictProbabilities((Vector)testData));
        }, testData.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Vector.class));
    }

    public Vector predictProbabilities(Vector testData) {
        DenseVector denseVector;
        String string = this.modelType();
        String string2 = NaiveBayes$.MODULE$.Multinomial();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            denseVector = this.posteriorProbabilities(this.multinomialCalculation(testData));
        } else {
            String string4 = NaiveBayes$.MODULE$.Bernoulli();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                denseVector = this.posteriorProbabilities(this.bernoulliCalculation(testData));
            } else {
                throw new MatchError((Object)string);
            }
        }
        return denseVector;
    }

    /*
     * WARNING - void declaration
     */
    private DenseVector multinomialCalculation(Vector testData) {
        void var2_2;
        DenseVector prob = this.thetaMatrix().multiply(testData);
        BLAS$.MODULE$.axpy(1.0, (Vector)this.piVector(), (Vector)prob);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private DenseVector bernoulliCalculation(Vector testData) {
        void var2_2;
        testData.foreachNonZero((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(x$3, value) -> {
            if (value != 1.0) {
                throw new SparkException(new StringBuilder(64).append("Bernoulli naive Bayes requires 0 or 1 feature values but found ").append(testData).append(".").toString());
            }
        });
        DenseVector prob = ((Matrix)this.thetaMinusNegTheta().get()).multiply(testData);
        BLAS$.MODULE$.axpy(1.0, (Vector)this.piVector(), (Vector)prob);
        BLAS$.MODULE$.axpy(1.0, (Vector)this.negThetaSum().get(), (Vector)prob);
        return var2_2;
    }

    private DenseVector posteriorProbabilities(DenseVector logProb) {
        double[] logProbArray = logProb.toArray();
        double maxLog = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(logProbArray)).max((Ordering)Ordering.Double$.MODULE$));
        double[] scaledProbs = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(logProbArray)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)lp -> package$.MODULE$.exp(lp - maxLog), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double probSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(scaledProbs)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return new DenseVector((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(scaledProbs)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$4 -> x$4 / probSum, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
    }

    @Override
    public void save(SparkContext sc, String path) {
        SaveLoadV2_0.Data data = new SaveLoadV2_0.Data(this.labels(), this.pi(), this.theta(), this.modelType());
        NaiveBayesModel$SaveLoadV2_0$.MODULE$.save(sc, path, data);
    }

    public NaiveBayesModel(double[] labels, double[] pi, double[][] theta, String modelType) {
        Tuple2 tuple2;
        this.labels = labels;
        this.pi = pi;
        this.theta = theta;
        this.modelType = modelType;
        ClassificationModel.$init$(this);
        this.piVector = new DenseVector(pi);
        this.thetaMatrix = new DenseMatrix(labels.length, theta[0].length, (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])theta)).flatten((Function1 & Serializable & scala.Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), ClassTag$.MODULE$.Double()), true);
        Predef$.MODULE$.require(NaiveBayes$.MODULE$.supportedModelTypes().contains((Object)modelType), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Invalid modelType ").append(this.modelType()).append(". Supported modelTypes are ").append(NaiveBayes$.MODULE$.supportedModelTypes()).append(".").toString());
        String string = modelType;
        String string2 = NaiveBayes$.MODULE$.Multinomial();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            tuple2 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        } else {
            String string4 = NaiveBayes$.MODULE$.Bernoulli();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                Matrix negTheta = this.thetaMatrix().map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)value -> package$.MODULE$.log1p(-package$.MODULE$.exp(value)));
                DenseVector ones = new DenseVector((double[])Array$.MODULE$.fill(this.thetaMatrix().numCols(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0, ClassTag$.MODULE$.Double()));
                Matrix thetaMinusNegTheta = this.thetaMatrix().map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)value -> value - package$.MODULE$.log1p(-package$.MODULE$.exp(value)));
                tuple2 = new Tuple2((Object)Option$.MODULE$.apply((Object)thetaMinusNegTheta), (Object)Option$.MODULE$.apply((Object)((DenseMatrix)negTheta).multiply(ones)));
            } else {
                throw new IllegalArgumentException(new StringBuilder(20).append("Invalid modelType: ").append(modelType).append(".").toString());
            }
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Option thetaMinusNegTheta = (Option)tuple22._1();
        Option negThetaSum = (Option)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)thetaMinusNegTheta, (Object)negThetaSum);
        this.x$2 = tuple23;
        this.thetaMinusNegTheta = (Option)this.x$2._1();
        this.negThetaSum = (Option)this.x$2._2();
    }

    public NaiveBayesModel(double[] labels, double[] pi, double[][] theta) {
        this(labels, pi, theta, NaiveBayes$.MODULE$.Multinomial());
    }

    public NaiveBayesModel(Iterable<Object> labels, Iterable<Object> pi, Iterable<Iterable<Object>> theta) {
        this((double[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(labels).asScala()).toArray(ClassTag$.MODULE$.Double()), (double[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(pi).asScala()).toArray(ClassTag$.MODULE$.Double()), (double[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(theta).asScala()).toArray(ClassTag$.MODULE$.apply(Iterable.class)))).map((Function1)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final double[] apply(Iterable<Object> x$1) {
                return (double[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(x$1).asScala()).toArray(ClassTag$.MODULE$.Double());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)))));
    }
}

