/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree.impl;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.tree.TreeEnsembleParams$;
import org.apache.spark.ml.tree.impl.DecisionTreeMetadata;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

public final class DecisionTreeMetadata$
implements Logging,
scala.Serializable {
    public static DecisionTreeMetadata$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DecisionTreeMetadata$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public DecisionTreeMetadata buildMetadata(RDD<Instance> input, Strategy strategy, int numTrees, String featureSubsetStrategy) {
        int n;
        String _featureSubsetStrategy;
        String string;
        int n2;
        int numFeatures = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])input.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)DecisionTreeMetadata$.$anonfun$buildMetadata$1(x$1)), ClassTag$.MODULE$.Int()).take(1))).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(72).append("DecisionTree requires size of input RDD > 0, ").append("but was given by empty one.").toString());
        }));
        Predef$.MODULE$.require(numFeatures > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(84).append("DecisionTree requires number of features > 0, ").append("but was given an empty features vector").toString());
        Tuple2 tuple2 = (Tuple2)input.aggregate((Object)new Tuple2.mcJD.sp(0L, 0.0), (Function2 & Serializable & scala.Serializable)(cw, instance) -> new Tuple2.mcJD.sp(cw._1$mcJ$sp() + 1L, cw._2$mcD$sp() + instance.weight()), (Function2 & Serializable & scala.Serializable)(cw1, cw2) -> new Tuple2.mcJD.sp(cw1._1$mcJ$sp() + cw2._1$mcJ$sp(), cw1._2$mcD$sp() + cw2._2$mcD$sp()), ClassTag$.MODULE$.apply(Tuple2.class));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long numExamples = tuple2._1$mcJ$sp();
        double weightSum = tuple2._2$mcD$sp();
        Tuple2.mcJD.sp sp2 = new Tuple2.mcJD.sp(numExamples, weightSum);
        Tuple2.mcJD.sp sp3 = sp2;
        long numExamples2 = sp3._1$mcJ$sp();
        double weightSum2 = sp3._2$mcD$sp();
        Enumeration.Value value = strategy.algo();
        Enumeration.Value value2 = Algo$.MODULE$.Classification();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            n2 = strategy.numClasses();
        } else {
            Enumeration.Value value4 = Algo$.MODULE$.Regression();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                n2 = 0;
            } else {
                throw new MatchError((Object)value);
            }
        }
        int numClasses = n2;
        int maxPossibleBins = (int)package$.MODULE$.min((long)strategy.maxBins(), numExamples2);
        if (maxPossibleBins < strategy.maxBins()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("DecisionTree reducing maxBins from ").append(strategy.maxBins()).append(" to ").append(maxPossibleBins).append(" (= number of training instances)").toString());
        }
        if (strategy.categoricalFeaturesInfo().nonEmpty()) {
            int maxCategoriesPerFeature = BoxesRunTime.unboxToInt((Object)strategy.categoricalFeaturesInfo().values().max((Ordering)Ordering.Int$.MODULE$));
            int maxCategory = ((Tuple2)strategy.categoricalFeaturesInfo().find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DecisionTreeMetadata$.$anonfun$buildMetadata$7(maxCategoriesPerFeature, x$3))).get())._1$mcI$sp();
            Predef$.MODULE$.require(maxCategoriesPerFeature <= maxPossibleBins, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(265).append("DecisionTree requires maxBins (= ").append(maxPossibleBins).append(") to be at least as large as the ").append("number of values in each categorical feature, but categorical feature ").append(maxCategory).append(" ").append("has ").append(maxCategoriesPerFeature).append(" values. Consider removing this and other categorical ").append("features with a large number of values, or add more training examples.").toString());
        }
        HashSet unorderedFeatures = new HashSet();
        int[] numBins = (int[])Array$.MODULE$.fill(numFeatures, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> maxPossibleBins, ClassTag$.MODULE$.Int());
        if (numClasses > 2) {
            int maxCategoriesForUnorderedFeature = (int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.log((double)(maxPossibleBins / 2 + 1)) / package$.MODULE$.log(2.0) + 1.0));
            strategy.categoricalFeaturesInfo().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DecisionTreeMetadata$.$anonfun$buildMetadata$10(maxCategoriesForUnorderedFeature, unorderedFeatures, numBins, x0$1);
                return BoxedUnit.UNIT;
            });
        } else {
            strategy.categoricalFeaturesInfo().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                DecisionTreeMetadata$.$anonfun$buildMetadata$11(numBins, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        String string2 = featureSubsetStrategy;
        if ("auto".equals(string2)) {
            String string3;
            if (numTrees == 1) {
                string3 = "all";
            } else {
                Enumeration.Value value6 = strategy.algo();
                Enumeration.Value value7 = Algo$.MODULE$.Classification();
                string3 = !(value6 != null ? !value6.equals(value7) : value7 != null) ? "sqrt" : "onethird";
            }
            string = string3;
        } else {
            string = featureSubsetStrategy;
        }
        String string4 = _featureSubsetStrategy = string;
        if ("all".equals(string4)) {
            n = numFeatures;
        } else if ("sqrt".equals(string4)) {
            n = (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.sqrt((double)numFeatures)));
        } else if ("log2".equals(string4)) {
            n = package$.MODULE$.max(1, (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.log((double)numFeatures) / package$.MODULE$.log(2.0))));
        } else if ("onethird".equals(string4)) {
            n = (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)numFeatures / 3.0));
        } else {
            int n3;
            Option option = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(_featureSubsetStrategy)).toInt()).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 > 0).toOption();
            if (option instanceof Some) {
                Some some = (Some)option;
                int value8 = BoxesRunTime.unboxToInt((Object)some.value());
                n3 = package$.MODULE$.min(value8, numFeatures);
            } else if (None$.MODULE$.equals(option)) {
                Option option2 = Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(_featureSubsetStrategy)).toDouble()).filter((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$5 -> x$5 > 0.0).filter((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$6 -> x$6 <= 1.0).toOption();
                if (!(option2 instanceof Some)) {
                    throw new IllegalArgumentException(new StringBuilder(37).append("Supported values:").append(" ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])TreeEnsembleParams$.MODULE$.supportedFeatureSubsetStrategies())).mkString(", ")).append(",").append(" (0.0-1.0], [1-n].").toString());
                }
                Some some = (Some)option2;
                double value9 = BoxesRunTime.unboxToDouble((Object)some.value());
                int n4 = (int)package$.MODULE$.ceil(value9 * (double)numFeatures);
                n3 = n4;
            } else {
                throw new MatchError((Object)option);
            }
            n = n3;
        }
        int numFeaturesPerNode = n;
        return new DecisionTreeMetadata(numFeatures, numExamples2, weightSum2, numClasses, BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(numBins)).max((Ordering)Ordering.Int$.MODULE$)), strategy.categoricalFeaturesInfo(), (Set<Object>)unorderedFeatures.toSet(), numBins, strategy.impurity(), strategy.quantileCalculationStrategy(), strategy.maxDepth(), strategy.minInstancesPerNode(), strategy.minWeightFractionPerNode(), strategy.minInfoGain(), numTrees, numFeaturesPerNode);
    }

    public DecisionTreeMetadata buildMetadata(RDD<Instance> input, Strategy strategy) {
        return this.buildMetadata(input, strategy, 1, "all");
    }

    public int numUnorderedBins(int arity) {
        return (1 << arity - 1) - 1;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ int $anonfun$buildMetadata$1(Instance x$1) {
        return x$1.features().size();
    }

    public static final /* synthetic */ boolean $anonfun$buildMetadata$7(int maxCategoriesPerFeature$1, Tuple2 x$3) {
        return x$3._2$mcI$sp() == maxCategoriesPerFeature$1;
    }

    public static final /* synthetic */ void $anonfun$buildMetadata$10(int maxCategoriesForUnorderedFeature$1, HashSet unorderedFeatures$1, int[] numBins$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int featureIndex = tuple2._1$mcI$sp();
            int numCategories = tuple2._2$mcI$sp();
            if (numCategories > 1) {
                if (numCategories <= maxCategoriesForUnorderedFeature$1) {
                    unorderedFeatures$1.add((Object)BoxesRunTime.boxToInteger((int)featureIndex));
                    numBins$1[featureIndex] = MODULE$.numUnorderedBins(numCategories);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    numBins$1[featureIndex] = numCategories;
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$buildMetadata$11(int[] numBins$1, Tuple2 x0$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            int featureIndex = tuple2._1$mcI$sp();
            int numCategories = tuple2._2$mcI$sp();
            if (numCategories > 1) {
                numBins$1[featureIndex] = numCategories;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private DecisionTreeMetadata$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

