/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.StreamingLinearRegressionWithSGD;
import org.apache.spark.mllib.util.LinearDataGenerator$;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.LocalStreamingContext;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.TestServer;
import org.apache.spark.streaming.TestSuiteBase;
import org.apache.spark.streaming.dstream.DStream;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.concurrent.PatienceConfiguration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IndexedSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001=3A!\u0002\u0004\u0001#!)q\u0004\u0001C\u0001A!)1\u0005\u0001C!I!)1\u0006\u0001C\u0001Y!)\u0011\b\u0001C\u0001u\tq2\u000b\u001e:fC6Lgn\u001a'j]\u0016\f'OU3he\u0016\u001c8/[8o'VLG/\u001a\u0006\u0003\u000f!\t!B]3he\u0016\u001c8/[8o\u0015\tI!\"A\u0003nY2L'M\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\n\u00179A\u00111\u0003F\u0007\u0002\u0015%\u0011QC\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005]QR\"\u0001\r\u000b\u0005eQ\u0011!C:ue\u0016\fW.\u001b8h\u0013\tY\u0002DA\u000bM_\u000e\fGn\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\u0011\u0005]i\u0012B\u0001\u0010\u0019\u00055!Vm\u001d;Tk&$XMQ1tK\u00061A(\u001b8jiz\"\u0012!\t\t\u0003E\u0001i\u0011AB\u0001\u0012[\u0006Dx+Y5u)&lW-T5mY&\u001cX#A\u0013\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\u0007%sG/A\u0006bgN,'\u000f^#rk\u0006dG\u0003B\u00171k]\u0002\"A\n\u0018\n\u0005=:#\u0001B+oSRDQ!M\u0002A\u0002I\n!A^\u0019\u0011\u0005\u0019\u001a\u0014B\u0001\u001b(\u0005\u0019!u.\u001e2mK\")ag\u0001a\u0001e\u0005\u0011aO\r\u0005\u0006q\r\u0001\rAM\u0001\bKB\u001c\u0018\u000e\\8o\u0003I1\u0018\r\\5eCR,\u0007K]3eS\u000e$\u0018n\u001c8\u0015\u00075Z\u0014\nC\u0003=\t\u0001\u0007Q(A\u0006qe\u0016$\u0017n\u0019;j_:\u001c\bc\u0001 Ge9\u0011q\b\u0012\b\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005B\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0015\n\u0005\u0015;\u0013a\u00029bG.\fw-Z\u0005\u0003\u000f\"\u00131aU3r\u0015\t)u\u0005C\u0003K\t\u0001\u00071*A\u0003j]B,H\u000fE\u0002?\r2\u0003\"AI'\n\u000593!\u0001\u0004'bE\u0016dW\r\u001a)pS:$\b")
public class StreamingLinearRegressionSuite
extends SparkFunSuite
implements LocalStreamingContext,
TestSuiteBase {
    private String checkpointDir;
    private final SparkConf conf;
    private final PatienceConfiguration.Timeout eventuallyTimeout;
    private transient StreamingContext ssc;
    private final transient boolean stopSparkContext;
    private volatile boolean bitmap$0;

    public /* synthetic */ void org$apache$spark$streaming$TestSuiteBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    public /* synthetic */ void org$apache$spark$streaming$TestSuiteBase$$super$afterEach() {
        LocalStreamingContext.afterEach$((LocalStreamingContext)this);
    }

    public String framework() {
        return TestSuiteBase.framework$((TestSuiteBase)this);
    }

    public String master() {
        return TestSuiteBase.master$((TestSuiteBase)this);
    }

    public Duration batchDuration() {
        return TestSuiteBase.batchDuration$((TestSuiteBase)this);
    }

    public int numInputPartitions() {
        return TestSuiteBase.numInputPartitions$((TestSuiteBase)this);
    }

    public boolean useManualClock() {
        return TestSuiteBase.useManualClock$((TestSuiteBase)this);
    }

    public boolean actuallyWait() {
        return TestSuiteBase.actuallyWait$((TestSuiteBase)this);
    }

    public void beforeFunction() {
        TestSuiteBase.beforeFunction$((TestSuiteBase)this);
    }

    public void afterFunction() {
        TestSuiteBase.afterFunction$((TestSuiteBase)this);
    }

    public void beforeEach() {
        TestSuiteBase.beforeEach$((TestSuiteBase)this);
    }

    public void afterEach() {
        TestSuiteBase.afterEach$((TestSuiteBase)this);
    }

    public <R> R withStreamingContext(StreamingContext ssc, Function1<StreamingContext, R> block) {
        return (R)TestSuiteBase.withStreamingContext$((TestSuiteBase)this, (StreamingContext)ssc, block);
    }

    public <R> R withTestServer(TestServer testServer, Function1<TestServer, R> block) {
        return (R)TestSuiteBase.withTestServer$((TestSuiteBase)this, (TestServer)testServer, block);
    }

    public <U, V> StreamingContext setupStreams(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, int numPartitions, ClassTag<U> evidence$4, ClassTag<V> evidence$5) {
        return TestSuiteBase.setupStreams$((TestSuiteBase)this, input, operation, (int)numPartitions, evidence$4, evidence$5);
    }

    public <U, V> int setupStreams$default$3() {
        return TestSuiteBase.setupStreams$default$3$((TestSuiteBase)this);
    }

    public <U, V, W> StreamingContext setupStreams(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, ClassTag<U> evidence$6, ClassTag<V> evidence$7, ClassTag<W> evidence$8) {
        return TestSuiteBase.setupStreams$((TestSuiteBase)this, input1, input2, operation, evidence$6, evidence$7, evidence$8);
    }

    public <V> Seq<Seq<V>> runStreams(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$9) {
        return TestSuiteBase.runStreams$((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, preStop, evidence$9);
    }

    public <V> Function0<BoxedUnit> runStreams$default$4() {
        return TestSuiteBase.runStreams$default$4$((TestSuiteBase)this);
    }

    public <V> Seq<Seq<Seq<V>>> runStreamsWithPartitions(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$10) {
        return TestSuiteBase.runStreamsWithPartitions$((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, preStop, evidence$10);
    }

    public <V> Function0<BoxedUnit> runStreamsWithPartitions$default$4() {
        return TestSuiteBase.runStreamsWithPartitions$default$4$((TestSuiteBase)this);
    }

    public <V> void verifyOutput(Seq<Seq<V>> output, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<V> evidence$11) {
        TestSuiteBase.verifyOutput$((TestSuiteBase)this, output, expectedOutput, (boolean)useSet, evidence$11);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<U> evidence$12, ClassTag<V> evidence$13) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input, operation, expectedOutput, (boolean)useSet, evidence$12, evidence$13);
    }

    public <U, V> boolean testOperation$default$4() {
        return TestSuiteBase.testOperation$default$4$((TestSuiteBase)this);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$14, ClassTag<V> evidence$15) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$14, evidence$15);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, boolean useSet, ClassTag<U> evidence$16, ClassTag<V> evidence$17, ClassTag<W> evidence$18) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input1, input2, operation, expectedOutput, (boolean)useSet, evidence$16, evidence$17, evidence$18);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$19, ClassTag<V> evidence$20, ClassTag<W> evidence$21) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input1, input2, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$19, evidence$20, evidence$21);
    }

    public /* synthetic */ void org$apache$spark$streaming$LocalStreamingContext$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public void resetStreamingContext() {
        LocalStreamingContext.resetStreamingContext$((LocalStreamingContext)this);
    }

    private String checkpointDir$lzycompute() {
        StreamingLinearRegressionSuite streamingLinearRegressionSuite = this;
        synchronized (streamingLinearRegressionSuite) {
            if (!this.bitmap$0) {
                this.checkpointDir = TestSuiteBase.checkpointDir$((TestSuiteBase)this);
                this.bitmap$0 = true;
            }
        }
        return this.checkpointDir;
    }

    public String checkpointDir() {
        return !this.bitmap$0 ? this.checkpointDir$lzycompute() : this.checkpointDir;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public PatienceConfiguration.Timeout eventuallyTimeout() {
        return this.eventuallyTimeout;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$eventuallyTimeout_$eq(PatienceConfiguration.Timeout x$1) {
        this.eventuallyTimeout = x$1;
    }

    public StreamingContext ssc() {
        return this.ssc;
    }

    public void ssc_$eq(StreamingContext x$1) {
        this.ssc = x$1;
    }

    public boolean stopSparkContext() {
        return this.stopSparkContext;
    }

    public void org$apache$spark$streaming$LocalStreamingContext$_setter_$stopSparkContext_$eq(boolean x$1) {
        this.stopSparkContext = x$1;
    }

    public int maxWaitTimeMillis() {
        return 100000;
    }

    public void assertEqual(double v1, double v2, double epsilon) {
        double $org_scalatest_assert_macro_left = package$.MODULE$.abs(v1 - v2);
        double $org_scalatest_assert_macro_right = epsilon;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left <= $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)StreamingLinearRegressionSuite.errorMessage$1(v1, v2), Prettifier$.MODULE$.default(), new Position("StreamingLinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
    }

    public void validatePrediction(Seq<Object> predictions, Seq<LabeledPoint> input) {
        int numOffPredictions;
        int $org_scalatest_assert_macro_left = numOffPredictions = ((TraversableOnce)predictions.zip(input, Seq$.MODULE$.canBuildFrom())).count((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)StreamingLinearRegressionSuite.$anonfun$validatePrediction$1(x0$1)));
        int $org_scalatest_assert_macro_right = input.length() / 5;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingLinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
    }

    private static final String errorMessage$1(double v1$1, double v2$1) {
        return new StringBuilder(15).append(Double.toString(v1$1)).append(" did not equal ").append(Double.toString(v2$1)).toString();
    }

    public static final /* synthetic */ boolean $anonfun$validatePrediction$1(Tuple2 x0$1) {
        LabeledPoint expected;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double prediction = tuple2._1$mcD$sp();
        boolean bl = package$.MODULE$.abs(prediction - (expected = (LabeledPoint)tuple2._2()).label()) > 0.5;
        return bl;
    }

    public static final /* synthetic */ double $anonfun$new$4(StreamingLinearRegressionWithSGD model$1, LabeledPoint row) {
        return model$1.latestModel().predict(row.features());
    }

    public static final /* synthetic */ boolean $anonfun$new$9(Tuple2 x) {
        return x._1$mcD$sp() - x._2$mcD$sp() <= 0.1;
    }

    public static final /* synthetic */ int $anonfun$new$10(Tuple2 x) {
        return x._1$mcD$sp() - x._2$mcD$sp() < 0.0 ? 1 : 0;
    }

    public static final /* synthetic */ double $anonfun$new$15(int nPoints$1, Seq batch) {
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)batch.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToDouble((double)package$.MODULE$.abs(p._1$mcD$sp() - p._2$mcD$sp())), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)nPoints$1;
    }

    public static final /* synthetic */ double $anonfun$new$22(int nPoints$2, Seq batch) {
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)batch.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToDouble((double)package$.MODULE$.abs(p._1$mcD$sp() - p._2$mcD$sp())), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)nPoints$2;
    }

    public StreamingLinearRegressionSuite() {
        LocalStreamingContext.$init$((LocalStreamingContext)this);
        TestSuiteBase.$init$((TestSuiteBase)this);
        this.test("parameter accuracy", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StreamingLinearRegressionWithSGD model = new StreamingLinearRegressionWithSGD().setInitialWeights(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}))).setStepSize(0.2).setNumIterations(25).setConvergenceTol(1.0E-4);
            int numBatches = 10;
            IndexedSeq input = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).map((Function1 & Serializable & scala.Serializable)i -> LinearDataGenerator$.MODULE$.generateLinearInput(0.0, new double[]{10.0, 10.0}, 100, 42 * (BoxesRunTime.unboxToInt((Object)i) + 1), LinearDataGenerator$.MODULE$.generateLinearInput$default$5()), IndexedSeq$.MODULE$.canBuildFrom());
            this.ssc_$eq(this.setupStreams((Seq)input, (Function1)(Function1 & Serializable & scala.Serializable)inputDStream -> {
                model.trainOn(inputDStream);
                return inputDStream.count();
            }, this.setupStreams$default$3(), (ClassTag)ClassTag$.MODULE$.apply(LabeledPoint.class), (ClassTag)ClassTag$.MODULE$.Long()));
            this.runStreams(this.ssc(), numBatches, numBatches, this.runStreams$default$4(), ClassTag$.MODULE$.Nothing());
            this.assertEqual(((LinearRegressionModel)model.latestModel()).intercept(), 0.0, 0.1);
            this.assertEqual(((LinearRegressionModel)model.latestModel()).weights().apply(0), 10.0, 0.1);
            this.assertEqual(((LinearRegressionModel)model.latestModel()).weights().apply(1), 10.0, 0.1);
            Seq validationData = LinearDataGenerator$.MODULE$.generateLinearInput(0.0, new double[]{10.0, 10.0}, 100, 17, LinearDataGenerator$.MODULE$.generateLinearInput$default$5());
            this.validatePrediction((Seq<Object>)((Seq)validationData.map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToDouble((double)StreamingLinearRegressionSuite.$anonfun$new$4(model, row)), Seq$.MODULE$.canBuildFrom())), (Seq<LabeledPoint>)validationData);
        }, new Position("StreamingLinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("parameter convergence", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StreamingLinearRegressionWithSGD model = new StreamingLinearRegressionWithSGD().setInitialWeights(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))).setStepSize(0.2).setNumIterations(25);
            int numBatches = 10;
            IndexedSeq input = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).map((Function1 & Serializable & scala.Serializable)i -> LinearDataGenerator$.MODULE$.generateLinearInput(0.0, new double[]{10.0}, 100, 42 * (BoxesRunTime.unboxToInt((Object)i) + 1), LinearDataGenerator$.MODULE$.generateLinearInput$default$5()), IndexedSeq$.MODULE$.canBuildFrom());
            ArrayBuffer history = new ArrayBuffer(numBatches);
            this.ssc_$eq(this.setupStreams((Seq)input, (Function1)(Function1 & Serializable & scala.Serializable)inputDStream -> {
                model.trainOn(inputDStream);
                inputDStream.foreachRDD((Function1 & Serializable & scala.Serializable)x -> {
                    history.$plus$eq((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.abs(((LinearRegressionModel)model.latestModel()).weights().apply(0) - 10.0)));
                    return BoxedUnit.UNIT;
                });
                return inputDStream.count();
            }, this.setupStreams$default$3(), (ClassTag)ClassTag$.MODULE$.apply(LabeledPoint.class), (ClassTag)ClassTag$.MODULE$.Long()));
            this.runStreams(this.ssc(), numBatches, numBatches, this.runStreams$default$4(), ClassTag$.MODULE$.Nothing());
            ArrayBuffer deltas = (ArrayBuffer)((IndexedSeqOptimized)history.drop(1)).zip((GenIterable)history.dropRight(1), ArrayBuffer$.MODULE$.canBuildFrom());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(deltas.forall((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)StreamingLinearRegressionSuite.$anonfun$new$9(x))), "deltas.forall(((x: (Double, Double)) => x._1.-(x._2).<=(0.1)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingLinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
            int $org_scalatest_assert_macro_left = BoxesRunTime.unboxToInt((Object)((TraversableOnce)deltas.map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)StreamingLinearRegressionSuite.$anonfun$new$10(x)), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingLinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        }, new Position("StreamingLinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        this.test("predictions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StreamingLinearRegressionWithSGD model = new StreamingLinearRegressionWithSGD().setInitialWeights(Vectors$.MODULE$.dense(10.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{10.0}))).setStepSize(0.2).setNumIterations(25);
            int numBatches = 10;
            int nPoints = 100;
            IndexedSeq testInput = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).map((Function1 & Serializable & scala.Serializable)i -> LinearDataGenerator$.MODULE$.generateLinearInput(0.0, new double[]{10.0, 10.0}, nPoints, 42 * (BoxesRunTime.unboxToInt((Object)i) + 1), LinearDataGenerator$.MODULE$.generateLinearInput$default$5()), IndexedSeq$.MODULE$.canBuildFrom());
            this.ssc_$eq(this.setupStreams((Seq)testInput, (Function1)(Function1 & Serializable & scala.Serializable)inputDStream -> model.predictOnValues(inputDStream.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)BoxesRunTime.boxToDouble((double)x.label()), (Object)x.features()), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double()), this.setupStreams$default$3(), (ClassTag)ClassTag$.MODULE$.apply(LabeledPoint.class), (ClassTag)ClassTag$.MODULE$.apply(Tuple2.class)));
            Seq output = this.runStreams(this.ssc(), numBatches, numBatches, this.runStreams$default$4(), ClassTag$.MODULE$.Nothing());
            Seq errors = (Seq)output.map((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToDouble((double)StreamingLinearRegressionSuite.$anonfun$new$15(nPoints, batch)), Seq$.MODULE$.canBuildFrom());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(errors.forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x -> x <= 0.1), "errors.forall(((x: Double) => x.<=(0.1)))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingLinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        }, new Position("StreamingLinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.test("training and prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StreamingLinearRegressionWithSGD model = new StreamingLinearRegressionWithSGD().setInitialWeights(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}))).setStepSize(0.2).setNumIterations(25);
            int numBatches = 10;
            int nPoints = 100;
            IndexedSeq testInput = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).map((Function1 & Serializable & scala.Serializable)i -> LinearDataGenerator$.MODULE$.generateLinearInput(0.0, new double[]{10.0, 10.0}, nPoints, 42 * (BoxesRunTime.unboxToInt((Object)i) + 1), LinearDataGenerator$.MODULE$.generateLinearInput$default$5()), IndexedSeq$.MODULE$.canBuildFrom());
            this.ssc_$eq(this.setupStreams((Seq)testInput, (Function1)(Function1 & Serializable & scala.Serializable)inputDStream -> {
                model.trainOn(inputDStream);
                return model.predictOnValues(inputDStream.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)BoxesRunTime.boxToDouble((double)x.label()), (Object)x.features()), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double());
            }, this.setupStreams$default$3(), (ClassTag)ClassTag$.MODULE$.apply(LabeledPoint.class), (ClassTag)ClassTag$.MODULE$.apply(Tuple2.class)));
            Seq output = this.runStreams(this.ssc(), numBatches, numBatches, this.runStreams$default$4(), ClassTag$.MODULE$.Nothing());
            List error = ((TraversableOnce)output.map((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToDouble((double)StreamingLinearRegressionSuite.$anonfun$new$22(nPoints, batch)), Seq$.MODULE$.canBuildFrom())).toList();
            double $org_scalatest_assert_macro_left = BoxesRunTime.unboxToDouble((Object)error.head()) - BoxesRunTime.unboxToDouble((Object)error.last());
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > (double)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingLinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        }, new Position("StreamingLinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        this.test("handling empty RDDs in a stream", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StreamingLinearRegressionWithSGD model = new StreamingLinearRegressionWithSGD().setInitialWeights(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}))).setStepSize(0.2).setNumIterations(25);
            int numBatches = 10;
            int nPoints = 100;
            Seq emptyInput = (Seq)Nil$.MODULE$;
            this.ssc_$eq(this.setupStreams(emptyInput, (Function1 & Serializable & scala.Serializable)inputDStream -> {
                model.trainOn(inputDStream);
                return model.predictOnValues(inputDStream.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)BoxesRunTime.boxToDouble((double)x.label()), (Object)x.features()), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double());
            }, this.setupStreams$default$3(), ClassTag$.MODULE$.apply(LabeledPoint.class), ClassTag$.MODULE$.apply(Tuple2.class)));
            Seq output = this.runStreams(this.ssc(), numBatches, numBatches, this.runStreams$default$4(), ClassTag$.MODULE$.Nothing());
        }, new Position("StreamingLinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
    }
}

