/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.SharedSparkSession;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.feature.Word2Vec;
import org.apache.spark.mllib.feature.Word2VecModel;
import org.junit.Assert;
import org.junit.Test;
import scala.Tuple2;

public class JavaWord2VecSuite
extends SharedSparkSession {
    @Test
    public void word2Vec() {
        String sentence = Strings.repeat((String)"a b ", (int)100) + Strings.repeat((String)"a c ", (int)10);
        List<String> words = Arrays.asList(sentence.split(" "));
        List<List> localDoc = Arrays.asList(words, words);
        JavaRDD doc = this.jsc.parallelize(localDoc);
        Word2Vec word2vec = new Word2Vec().setVectorSize(10).setSeed(42L);
        Word2VecModel model = word2vec.fit(doc);
        Tuple2[] syms = model.findSynonyms("a", 2);
        Assert.assertEquals((long)2L, (long)syms.length);
        Assert.assertEquals((Object)"b", (Object)syms[0]._1());
        Assert.assertEquals((Object)"c", (Object)syms[1]._1());
    }
}

