/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.spark.mllib.clustering.LocalLDAModel;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class LDASuite$
implements scala.Serializable {
    public static LDASuite$ MODULE$;

    static {
        new LDASuite$();
    }

    public int tinyK() {
        return 3;
    }

    public int tinyVocabSize() {
        return 5;
    }

    public double[][] tinyTopicsAsArray() {
        return (double[][])((Object[])new double[][]{(double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.1, 0.2, 0.3, 0.4, 0.0}), ClassTag$.MODULE$.Double()), (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5, 0.05, 0.05, 0.1, 0.3}), ClassTag$.MODULE$.Double()), (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.2, 0.2, 0.05, 0.05, 0.5}), ClassTag$.MODULE$.Double())});
    }

    public Matrix tinyTopics() {
        return new DenseMatrix(this.tinyVocabSize(), this.tinyK(), (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tinyTopicsAsArray())).fold(Array$.MODULE$.empty(ClassTag$.MODULE$.Double()), (Function2 & Serializable & scala.Serializable)(x$14, x$15) -> (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x$14)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x$15)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))));
    }

    public Tuple2<int[], double[]>[] tinyTopicDescription() {
        return (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tinyTopicsAsArray())).map((Function1 & Serializable & scala.Serializable)topic -> {
            Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(topic)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).sortBy((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToDouble((double)LDASuite$.$anonfun$tinyTopicDescription$2(x$16)), (Ordering)Ordering.Double$.MODULE$))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double[] termWeights = (double[])tuple2._1();
            int[] terms = (int[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)termWeights, (Object)terms);
            Tuple2 tuple23 = tuple22;
            double[] termWeights2 = (double[])tuple23._1();
            int[] terms2 = (int[])tuple23._2();
            return new Tuple2(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(terms2)).toArray(ClassTag$.MODULE$.Int()), new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(termWeights2)).toArray(ClassTag$.MODULE$.Double()));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    public Tuple2<Object, Vector>[] tinyCorpus() {
        return (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Vector[]{Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 0.0, 0.0})), Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 0.0, 2.0, 8.0})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 1.0, 0.0, 4.0})), Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 12.0, 3.0, 1.0})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 0.0, 0.0})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 1.0, 9.0, 8.0})), Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 4.0, 2.0, 6.0}))})).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector wordCounts = (Vector)tuple2._1();
            int docId = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)docId), (Object)wordCounts);
            return tuple22;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    public Tuple2<Object, Vector>[] getNonEmptyDoc(Tuple2<Object, Vector>[] corpus) {
        return (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])corpus)).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LDASuite$.$anonfun$getNonEmptyDoc$1(x0$1)));
    }

    public Tuple2<Object, Vector>[] toyData() {
        return (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Vector[]{Vectors$.MODULE$.sparse(6, new int[]{0, 1}, new double[]{1.0, 1.0}), Vectors$.MODULE$.sparse(6, new int[]{1, 2}, new double[]{1.0, 1.0}), Vectors$.MODULE$.sparse(6, new int[]{0, 2}, new double[]{1.0, 1.0}), Vectors$.MODULE$.sparse(6, new int[]{3, 4}, new double[]{1.0, 1.0}), Vectors$.MODULE$.sparse(6, new int[]{3, 5}, new double[]{1.0, 1.0}), Vectors$.MODULE$.sparse(6, new int[]{4, 5}, new double[]{1.0, 1.0})})).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector wordCounts = (Vector)tuple2._1();
            int docId = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)docId), (Object)wordCounts);
            return tuple22;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<Tuple2<Long, Vector>> javaToyData() {
        void var1_1;
        ArrayList<Tuple2> javaData = new ArrayList<Tuple2>();
        for (int i = 0; i < this.toyData().length; ++i) {
            javaData.add(new Tuple2((Object)Predef$.MODULE$.long2Long(this.toyData()[i]._1$mcJ$sp()), this.toyData()[i]._2()));
        }
        return var1_1;
    }

    public LocalLDAModel toyModel() {
        int k = 2;
        int vocabSize = 6;
        double alpha = 0.01;
        double eta = 0.01;
        int gammaShape = 100;
        DenseMatrix topics = new DenseMatrix(vocabSize, k, new double[]{1.86738052, 1.94056535, 1.89981687, 0.0833265, 0.07405918, 0.07940597, 0.15081551, 0.08637973, 0.12428538, 1.9474897, 1.94615165, 1.95204124});
        LocalLDAModel ldaModel = new LocalLDAModel((Matrix)topics, Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(k, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> alpha, ClassTag$.MODULE$.Double())), eta, (double)gammaShape);
        return ldaModel;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ double $anonfun$tinyTopicDescription$2(Tuple2 x$16) {
        return -x$16._1$mcD$sp();
    }

    public static final /* synthetic */ boolean $anonfun$new$76(Tuple2 x$18) {
        return ((Vector)x$18._2()).size() == MODULE$.tinyVocabSize();
    }

    public static final /* synthetic */ boolean $anonfun$getNonEmptyDoc$1(Tuple2 x0$1) {
        Vector wc;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null || (wc = (Vector)tuple2._2()) == null) {
            throw new MatchError((Object)tuple2);
        }
        Vector vector = wc;
        boolean bl = Vectors$.MODULE$.norm(vector, 1.0) != 0.0;
        return bl;
    }

    private LDASuite$() {
        MODULE$ = this;
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tinyCorpus())).forall((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)LDASuite$.$anonfun$new$76(x$18))));
    }
}

