/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.fpm;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.fpm.FPGrowth;
import org.apache.spark.ml.fpm.FPGrowthModel;
import org.apache.spark.ml.fpm.FPGrowthSuite$;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.ParamsSuite$;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple1;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\u0007\u000f\u0001eAQa\u000b\u0001\u0005\u00021B\u0011b\f\u0001A\u0002\u0003\u0007I\u0011\u0001\u0019\t\u0013-\u0003\u0001\u0019!a\u0001\n\u0003a\u0005\"\u0003\u001f\u0001\u0001\u0004\u0005\t\u0015)\u00032\u0011\u00151\u0006\u0001\"\u0011X\u000f\u0015Af\u0002#\u0001Z\r\u0015ia\u0002#\u0001[\u0011\u0015Ys\u0001\"\u0001b\u0011\u0015\u0011w\u0001\"\u0001d\u0011\u001dQxA1A\u0005\u0002mDq!a\u0004\bA\u0003%A\u0010C\u0005\u0002\u0012\u001d\t\t\u0011\"\u0003\u0002\u0014\tia\tU$s_^$\bnU;ji\u0016T!a\u0004\t\u0002\u0007\u0019\u0004XN\u0003\u0002\u0012%\u0005\u0011Q\u000e\u001c\u0006\u0003'Q\tQa\u001d9be.T!!\u0006\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0012aA8sO\u000e\u00011\u0003\u0002\u0001\u001b=\u0019\u0002\"a\u0007\u000f\u000e\u0003II!!\b\n\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\tyB%D\u0001!\u0015\t\t#%\u0001\u0003vi&d'BA\u0012\u0013\u0003\u0015iG\u000e\\5c\u0013\t)\u0003EA\u000bN\u00192L'\rV3tiN\u0003\u0018M]6D_:$X\r\u001f;\u0011\u0005\u001dJS\"\u0001\u0015\u000b\u0005\u0005\u0002\u0012B\u0001\u0016)\u0005Q!UMZ1vYR\u0014V-\u00193Xe&$X\rV3ti\u00061A(\u001b8jiz\"\u0012!\f\t\u0003]\u0001i\u0011AD\u0001\bI\u0006$\u0018m]3u+\u0005\t\u0004G\u0001\u001a;!\r\u0019d\u0007O\u0007\u0002i)\u0011QGE\u0001\u0004gFd\u0017BA\u001c5\u0005\u001d!\u0015\r^1tKR\u0004\"!\u000f\u001e\r\u0001\u0011I1\bBA\u0001\u0002\u0003\u0015\t\u0001\u0012\u0002\u0004?\u0012\n\u0014\u0001\u00033bi\u0006\u001cX\r\u001e\u0011)\u0005\u0011q\u0004CA C\u001b\u0005\u0001%\"A!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0003%!\u0003;sC:\u001c\u0018.\u001a8u#\t)\u0005\n\u0005\u0002@\r&\u0011q\t\u0011\u0002\b\u001d>$\b.\u001b8h!\ty\u0014*\u0003\u0002K\u0001\n\u0019\u0011I\\=\u0002\u0017\u0011\fG/Y:fi~#S-\u001d\u000b\u0003\u001bB\u0003\"a\u0010(\n\u0005=\u0003%\u0001B+oSRDq!U\u0002\u0002\u0002\u0003\u0007!+A\u0002yIE\u0002$aU+\u0011\u0007M2D\u000b\u0005\u0002:+\u0012I1\bUA\u0001\u0002\u0003\u0015\t\u0001R\u0001\nE\u00164wN]3BY2$\u0012!T\u0001\u000e\rB;%o\\<uQN+\u0018\u000e^3\u0011\u00059:1cA\u0004\\=B\u0011q\bX\u0005\u0003;\u0002\u0013a!\u00118z%\u00164\u0007CA `\u0013\t\u0001\u0007I\u0001\u0007TKJL\u0017\r\\5{C\ndW\rF\u0001Z\u0003=9W\r\u001e$Q\u000fJ|w\u000f\u001e5ECR\fGC\u00013w!\t)7O\u0004\u0002gc:\u0011q\r\u001d\b\u0003Q>t!!\u001b8\u000f\u0005)lW\"A6\u000b\u00051D\u0012A\u0002\u001fs_>$h(C\u0001\u0018\u0013\t)b#\u0003\u0002\u0014)%\u0011QGE\u0005\u0003eR\nq\u0001]1dW\u0006<W-\u0003\u0002uk\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003eRBQaE\u0005A\u0002]\u0004\"a\r=\n\u0005e$$\u0001D*qCJ\\7+Z:tS>t\u0017\u0001E1mYB\u000b'/Y7TKR$\u0018N\\4t+\u0005a\bCB?\u0002\u0004\u0005%\u0001J\u0004\u0002\u007f\u007fB\u0011!\u000eQ\u0005\u0004\u0003\u0003\u0001\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0006\u0005\u001d!aA'ba*\u0019\u0011\u0011\u0001!\u0011\u0007u\fY!\u0003\u0003\u0002\u000e\u0005\u001d!AB*ue&tw-A\tbY2\u0004\u0016M]1n'\u0016$H/\u001b8hg\u0002\n1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u0003\t\u0005\u0003/\t\t#\u0004\u0002\u0002\u001a)!\u00111DA\u000f\u0003\u0011a\u0017M\\4\u000b\u0005\u0005}\u0011\u0001\u00026bm\u0006LA!a\t\u0002\u001a\t1qJ\u00196fGR\u0004")
public class FPGrowthSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private transient Dataset<?> dataset;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static Map<String, Object> allParamSettings() {
        return FPGrowthSuite$.MODULE$.allParamSettings();
    }

    public static Dataset<Row> getFPGrowthData(SparkSession sparkSession) {
        return FPGrowthSuite$.MODULE$.getFPGrowthData(sparkSession);
    }

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest.testDefaultReadWrite$(this, instance, testParams);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest.testDefaultReadWrite$default$2$(this);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testEstimatorParams, Map<String, Object> testModelParams, Function2<M, M, BoxedUnit> checkModelData) {
        DefaultReadWriteTest.testEstimatorAndModelReadWrite$(this, estimator, dataset, testEstimatorParams, testModelParams, checkModelData);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public Dataset<?> dataset() {
        return this.dataset;
    }

    public void dataset_$eq(Dataset<?> x$1) {
        this.dataset = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
        this.dataset_$eq(FPGrowthSuite$.MODULE$.getFPGrowthData(this.spark()));
    }

    private final void testImplicits$lzycompute$1() {
        FPGrowthSuite fPGrowthSuite = this;
        synchronized (fPGrowthSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    private static final void checkModelData$1(FPGrowthModel model, FPGrowthModel model2) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.freqItemsets().collect())).toSet().equals((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model2.freqItemsets().collect())).toSet()), "scala.Predef.refArrayOps[org.apache.spark.sql.Row](model.freqItemsets.collect()).toSet[org.apache.spark.sql.Row].equals(scala.Predef.refArrayOps[org.apache.spark.sql.Row](model2.freqItemsets.collect()).toSet[org.apache.spark.sql.Row])", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.associationRules().collect())).toSet().equals((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model2.associationRules().collect())).toSet()), "scala.Predef.refArrayOps[org.apache.spark.sql.Row](model.associationRules.collect()).toSet[org.apache.spark.sql.Row].equals(scala.Predef.refArrayOps[org.apache.spark.sql.Row](model2.associationRules.collect()).toSet[org.apache.spark.sql.Row])", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.setMinConfidence(0.9).associationRules().collect())).toSet().equals((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model2.setMinConfidence(0.9).associationRules().collect())).toSet()), "scala.Predef.refArrayOps[org.apache.spark.sql.Row](model.setMinConfidence(0.9).associationRules.collect()).toSet[org.apache.spark.sql.Row].equals(scala.Predef.refArrayOps[org.apache.spark.sql.Row](model2.setMinConfidence(0.9).associationRules.collect()).toSet[org.apache.spark.sql.Row])", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
    }

    public FPGrowthSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        DefaultReadWriteTest.$init$(this);
        this.test("FPGrowth fit and transform with different data types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new AtomicType[]{IntegerType$.MODULE$, StringType$.MODULE$, ShortType$.MODULE$, LongType$.MODULE$, ByteType$.MODULE$})).foreach((Function1 & Serializable & scala.Serializable)dt -> {
            Dataset data = this.dataset().withColumn("items", functions$.MODULE$.col("items").cast((DataType)ArrayType$.MODULE$.apply((DataType)dt)));
            FPGrowthModel model = new FPGrowth().setMinSupport(0.5).fit(data);
            Dataset generatedRules = model.setMinConfidence(0.5).associationRules();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FPGrowthSuite.class.getClassLoader());
            public final class Org_apache_spark_ml_fpm_FPGrowthSuite$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
                }

                public Org_apache_spark_ml_fpm_FPGrowthSuite$$typecreator1$1(FPGrowthSuite $outer) {
                }
            }
            Dataset expectedRules = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple5((Object)new String[]{"2"}, (Object)new String[]{"1"}, (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.75)), (List)new .colon.colon((Object)new Tuple5((Object)new String[]{"1"}, (Object)new String[]{"2"}, (Object)BoxesRunTime.boxToDouble((double)0.75), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.75)), (List)Nil$.MODULE$)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_fpm_FPGrowthSuite$$typecreator1$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"antecedent", "consequent", "confidence", "lift", "support"})).withColumn("antecedent", functions$.MODULE$.col("antecedent").cast((DataType)ArrayType$.MODULE$.apply((DataType)dt))).withColumn("consequent", functions$.MODULE$.col("consequent").cast((DataType)ArrayType$.MODULE$.apply((DataType)dt)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expectedRules.sort("antecedent", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rdd().collect())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])generatedRules.sort("antecedent", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rdd().collect())), "scala.Predef.refArrayOps[org.apache.spark.sql.Row](expectedRules.sort(\"antecedent\").rdd.collect()).sameElements[org.apache.spark.sql.Row](scala.Predef.wrapRefArray[org.apache.spark.sql.Row](generatedRules.sort(\"antecedent\").rdd.collect()))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
            Dataset transformed = model.transform(data);
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(FPGrowthSuite.class.getClassLoader());
            public final class Org_apache_spark_ml_fpm_FPGrowthSuite$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_ml_fpm_FPGrowthSuite$$typecreator2$1(FPGrowthSuite $outer) {
                }
            }
            Dataset expectedTransformed = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)new String[]{"1", "2"}, (Object)Array$.MODULE$.emptyIntArray()), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)new String[]{"1", "2"}, (Object)Array$.MODULE$.emptyIntArray()), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)new String[]{"1", "2"}, (Object)Array$.MODULE$.emptyIntArray()), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)new String[]{"1", "3"}, (Object)new int[]{2}), (List)Nil$.MODULE$)))), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_fpm_FPGrowthSuite$$typecreator2$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "items", "prediction"})).withColumn("items", functions$.MODULE$.col("items").cast((DataType)ArrayType$.MODULE$.apply((DataType)dt))).withColumn("prediction", functions$.MODULE$.col("prediction").cast((DataType)ArrayType$.MODULE$.apply((DataType)dt)));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expectedTransformed.collect())).toSet().equals((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])transformed.collect())).toSet()), "scala.Predef.refArrayOps[org.apache.spark.sql.Row](expectedTransformed.collect()).toSet[org.apache.spark.sql.Row].equals(scala.Predef.refArrayOps[org.apache.spark.sql.Row](transformed.collect()).toSet[org.apache.spark.sql.Row])", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        }), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        this.test("FPGrowth associationRules", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FPGrowthSuite.class.getClassLoader());
            public final class Org_apache_spark_ml_fpm_FPGrowthSuite$$typecreator3$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_ml_fpm_FPGrowthSuite$$typecreator3$1(FPGrowthSuite $outer) {
                }
            }
            Dataset dataset = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)new String[]{"1", "2"}), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)new String[]{"3"}), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), (Object)new String[]{"4", "5"}), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)4), (Object)new String[]{"1", "2", "3"}), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)5), (Object)new String[]{"2"}), (List)Nil$.MODULE$))))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_fpm_FPGrowthSuite$$typecreator3$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "items"}));
            FPGrowthModel model = new FPGrowth().setMinSupport(0.1).setMinConfidence(0.1).fit(dataset);
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(FPGrowthSuite.class.getClassLoader());
            public final class Org_apache_spark_ml_fpm_FPGrowthSuite$$typecreator4$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
                }

                public Org_apache_spark_ml_fpm_FPGrowthSuite$$typecreator4$1(FPGrowthSuite $outer) {
                }
            }
            Dataset expectedRules = this.spark().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)new String[]{"2"}, (Object)new String[]{"1"}, (Object)BoxesRunTime.boxToDouble((double)0.6666666666666666), (Object)BoxesRunTime.boxToDouble((double)1.6666666666666665), (Object)BoxesRunTime.boxToDouble((double)0.4)), new Tuple5((Object)new String[]{"2"}, (Object)new String[]{"3"}, (Object)BoxesRunTime.boxToDouble((double)0.3333333333333333), (Object)BoxesRunTime.boxToDouble((double)0.8333333333333333), (Object)BoxesRunTime.boxToDouble((double)0.2)), new Tuple5((Object)new String[]{"3"}, (Object)new String[]{"1"}, (Object)BoxesRunTime.boxToDouble((double)0.5), (Object)BoxesRunTime.boxToDouble((double)1.25), (Object)BoxesRunTime.boxToDouble((double)0.2)), new Tuple5((Object)new String[]{"3"}, (Object)new String[]{"2"}, (Object)BoxesRunTime.boxToDouble((double)0.5), (Object)BoxesRunTime.boxToDouble((double)0.8333333333333334), (Object)BoxesRunTime.boxToDouble((double)0.2)), new Tuple5((Object)new String[]{"1", "3"}, (Object)new String[]{"2"}, (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)1.6666666666666667), (Object)BoxesRunTime.boxToDouble((double)0.2)), new Tuple5((Object)new String[]{"1", "2"}, (Object)new String[]{"3"}, (Object)BoxesRunTime.boxToDouble((double)0.5), (Object)BoxesRunTime.boxToDouble((double)1.25), (Object)BoxesRunTime.boxToDouble((double)0.2)), new Tuple5((Object)new String[]{"4"}, (Object)new String[]{"5"}, (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)5.0), (Object)BoxesRunTime.boxToDouble((double)0.2)), new Tuple5((Object)new String[]{"5"}, (Object)new String[]{"4"}, (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)5.0), (Object)BoxesRunTime.boxToDouble((double)0.2)), new Tuple5((Object)new String[]{"1"}, (Object)new String[]{"3"}, (Object)BoxesRunTime.boxToDouble((double)0.5), (Object)BoxesRunTime.boxToDouble((double)1.25), (Object)BoxesRunTime.boxToDouble((double)0.2)), new Tuple5((Object)new String[]{"1"}, (Object)new String[]{"2"}, (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)1.6666666666666667), (Object)BoxesRunTime.boxToDouble((double)0.4)), new Tuple5((Object)new String[]{"3", "2"}, (Object)new String[]{"1"}, (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)2.5), (Object)BoxesRunTime.boxToDouble((double)0.2))})), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_fpm_FPGrowthSuite$$typecreator4$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"antecedent", "consequent", "confidence", "lift", "support"}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expectedRules.collect())).toSet().equals((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.associationRules().collect())).toSet()), "scala.Predef.refArrayOps[org.apache.spark.sql.Row](expectedRules.collect()).toSet[org.apache.spark.sql.Row].equals(scala.Predef.refArrayOps[org.apache.spark.sql.Row](model.associationRules.collect()).toSet[org.apache.spark.sql.Row])", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        }, new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        this.test("FPGrowth getFreqItems", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Bool bool;
            FPGrowthModel model = new FPGrowth().setMinSupport(0.7).fit(this.dataset());
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FPGrowthSuite.class.getClassLoader());
            public final class Org_apache_spark_ml_fpm_FPGrowthSuite$$typecreator5$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_ml_fpm_FPGrowthSuite$$typecreator5$1(FPGrowthSuite $outer) {
                }
            }
            Dataset expectedFreq = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2((Object)new String[]{"1"}, (Object)BoxesRunTime.boxToLong((long)4L)), (List)new .colon.colon((Object)new Tuple2((Object)new String[]{"2"}, (Object)BoxesRunTime.boxToLong((long)3L)), (List)new .colon.colon((Object)new Tuple2((Object)new String[]{"1", "2"}, (Object)BoxesRunTime.boxToLong((long)3L)), (List)new .colon.colon((Object)new Tuple2((Object)new String[]{"2", "1"}, (Object)BoxesRunTime.boxToLong((long)3L)), (List)Nil$.MODULE$)))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_fpm_FPGrowthSuite$$typecreator5$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"items", "expectedFreq"}));
            Dataset freqItems = model.freqItemsets();
            Dataset checkDF = freqItems.join(expectedFreq, "items");
            long $org_scalatest_assert_macro_left = checkDF.count();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left2.value()) {
                long $org_scalatest_assert_macro_left3 = checkDF.filter(functions$.MODULE$.col("freq").$eq$eq$eq((Object)functions$.MODULE$.col("expectedFreq"))).count();
                int $org_scalatest_assert_macro_right2 = 3;
                bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 == (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        }, new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        this.test("FPGrowth getFreqItems with Null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FPGrowthSuite.class.getClassLoader());
            public final class Org_apache_spark_ml_fpm_FPGrowthSuite$$typecreator6$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_ml_fpm_FPGrowthSuite$$typecreator6$1(FPGrowthSuite $outer) {
                }
            }
            Dataset df = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)new String[]{"1", "2", "3", "5"}), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)new String[]{"1", "2", "3", "4"}), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), null), (List)Nil$.MODULE$))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_fpm_FPGrowthSuite$$typecreator6$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "items"}));
            FPGrowthModel model = new FPGrowth().setMinSupport(0.7).fit(this.dataset());
            Dataset prediction = model.transform(df);
            Seq $org_scalatest_assert_macro_left = ((Row)prediction.select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).where("id=3").first()).getSeq(0);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        }, new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("FPGrowth prediction should not contain duplicates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FPGrowthSuite.class.getClassLoader());
            public final class Org_apache_spark_ml_fpm_FPGrowthSuite$$typecreator7$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_ml_fpm_FPGrowthSuite$$typecreator7$1(FPGrowthSuite $outer) {
                }
            }
            Dataset dataset = this.spark().createDataFrame((Seq)((TraversableLike)new .colon.colon((Object)((String[])((Object[])new String[]{"1", "3"})), (List)new .colon.colon((Object)((String[])((Object[])new String[]{"2", "3"})), (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x$1 -> new Tuple1(x$1), Seq$.MODULE$.canBuildFrom()), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_fpm_FPGrowthSuite$$typecreator7$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"items"}));
            FPGrowthModel model = new FPGrowth().fit(dataset);
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(FPGrowthSuite.class.getClassLoader());
            public final class Org_apache_spark_ml_fpm_FPGrowthSuite$$typecreator8$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_ml_fpm_FPGrowthSuite$$typecreator8$1(FPGrowthSuite $outer) {
                }
            }
            Seq prediction = (Seq)((Row)model.transform(this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple1((Object)new String[]{"1", "2"}), (List)Nil$.MODULE$), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_fpm_FPGrowthSuite$$typecreator8$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"items"}))).first()).getAs("prediction");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(prediction);
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)"3", (List)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
        }, new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        this.test("FPGrowthModel setMinConfidence should affect rules generation and transform", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            FPGrowthModel model = new FPGrowth().setMinSupport(0.1).setMinConfidence(0.1).fit(this.dataset());
            long oldRulesNum = model.associationRules().count();
            Dataset oldPredict = model.transform(this.dataset());
            model.setMinConfidence(0.8765);
            long $org_scalatest_assert_macro_left = oldRulesNum;
            long $org_scalatest_assert_macro_right = model.associationRules().count();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.transform(this.dataset()).collect())).toSet().equals((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])oldPredict.collect())).toSet()), "scala.Predef.refArrayOps[org.apache.spark.sql.Row](model.transform(FPGrowthSuite.this.dataset).collect()).toSet[org.apache.spark.sql.Row].equals(scala.Predef.refArrayOps[org.apache.spark.sql.Row](oldPredict.collect()).toSet[org.apache.spark.sql.Row])", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
            model.setMinConfidence(0.1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)oldRulesNum));
            long $org_scalatest_assert_macro_right2 = model.associationRules().count();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.transform(this.dataset()).collect())).toSet().equals((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])oldPredict.collect())).toSet()), "scala.Predef.refArrayOps[org.apache.spark.sql.Row](model.transform(FPGrowthSuite.this.dataset).collect()).toSet[org.apache.spark.sql.Row].equals(scala.Predef.refArrayOps[org.apache.spark.sql.Row](oldPredict.collect()).toSet[org.apache.spark.sql.Row])", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        }, new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        this.test("FPGrowth parameter check", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            FPGrowth fpGrowth = new FPGrowth().setMinSupport(0.4567);
            FPGrowthModel model = fpGrowth.fit(this.dataset()).setMinConfidence(0.5678);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)fpGrowth.getMinSupport()));
            double $org_scalatest_assert_macro_right = 0.4567;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)model.getMinConfidence()));
            double $org_scalatest_assert_macro_right2 = 0.5678;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)fpGrowth.isDefined((Param)fpGrowth.numPartitions())));
            boolean $org_scalatest_assert_macro_right3 = false;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            MLTestingUtils$.MODULE$.checkCopyAndUids(fpGrowth, (Model<?>)model);
            ParamsSuite$.MODULE$.checkParams((Params)fpGrowth);
            ParamsSuite$.MODULE$.checkParams((Params)model);
        }, new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        this.test("read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            FPGrowth fPGrowth = new FPGrowth();
            this.testEstimatorAndModelReadWrite(fPGrowth, this.dataset(), FPGrowthSuite$.MODULE$.allParamSettings(), FPGrowthSuite$.MODULE$.allParamSettings(), (Function2 & Serializable & scala.Serializable)(model, model2) -> {
                FPGrowthSuite.checkModelData$1(model, model2);
                return BoxedUnit.UNIT;
            });
        }, new Position("FPGrowthSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
    }
}

