/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.optimization;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.optimization.Gradient;
import org.apache.spark.mllib.optimization.GradientDescent$;
import org.apache.spark.mllib.optimization.GradientDescentSuite$;
import org.apache.spark.mllib.optimization.LBFGS;
import org.apache.spark.mllib.optimization.LBFGS$;
import org.apache.spark.mllib.optimization.LogisticGradient;
import org.apache.spark.mllib.optimization.SimpleUpdater;
import org.apache.spark.mllib.optimization.SquaredL2Updater;
import org.apache.spark.mllib.optimization.Updater;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality;
import org.scalactic.Explicitly;
import org.scalactic.Prettifier;
import org.scalactic.Prettifier$;
import org.scalactic.Tolerance;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Entry;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.enablers.Collecting;
import org.scalatest.matchers.Matcher;
import org.scalatest.matchers.dsl.BeWord;
import org.scalatest.matchers.dsl.ContainWord;
import org.scalatest.matchers.dsl.DefinedWord;
import org.scalatest.matchers.dsl.EmptyWord;
import org.scalatest.matchers.dsl.EndWithWord;
import org.scalatest.matchers.dsl.ExistWord;
import org.scalatest.matchers.dsl.FullyMatchWord;
import org.scalatest.matchers.dsl.HaveWord;
import org.scalatest.matchers.dsl.IncludeWord;
import org.scalatest.matchers.dsl.LengthWord;
import org.scalatest.matchers.dsl.MatchPatternWord;
import org.scalatest.matchers.dsl.MatcherFactory1;
import org.scalatest.matchers.dsl.MatcherWords;
import org.scalatest.matchers.dsl.NoExceptionWord;
import org.scalatest.matchers.dsl.NotWord;
import org.scalatest.matchers.dsl.ReadableWord;
import org.scalatest.matchers.dsl.ResultOfATypeInvocation;
import org.scalatest.matchers.dsl.ResultOfAllElementsOfApplication;
import org.scalatest.matchers.dsl.ResultOfAllOfApplication;
import org.scalatest.matchers.dsl.ResultOfAnTypeInvocation;
import org.scalatest.matchers.dsl.ResultOfAtLeastOneElementOfApplication;
import org.scalatest.matchers.dsl.ResultOfAtLeastOneOfApplication;
import org.scalatest.matchers.dsl.ResultOfAtMostOneElementOfApplication;
import org.scalatest.matchers.dsl.ResultOfAtMostOneOfApplication;
import org.scalatest.matchers.dsl.ResultOfDefinedAt;
import org.scalatest.matchers.dsl.ResultOfGreaterThanComparison;
import org.scalatest.matchers.dsl.ResultOfGreaterThanOrEqualToComparison;
import org.scalatest.matchers.dsl.ResultOfInOrderApplication;
import org.scalatest.matchers.dsl.ResultOfInOrderElementsOfApplication;
import org.scalatest.matchers.dsl.ResultOfInOrderOnlyApplication;
import org.scalatest.matchers.dsl.ResultOfLessThanComparison;
import org.scalatest.matchers.dsl.ResultOfLessThanOrEqualToComparison;
import org.scalatest.matchers.dsl.ResultOfMessageWordApplication;
import org.scalatest.matchers.dsl.ResultOfNoElementsOfApplication;
import org.scalatest.matchers.dsl.ResultOfNoneOfApplication;
import org.scalatest.matchers.dsl.ResultOfOfTypeInvocation;
import org.scalatest.matchers.dsl.ResultOfOneElementOfApplication;
import org.scalatest.matchers.dsl.ResultOfOneOfApplication;
import org.scalatest.matchers.dsl.ResultOfOnlyApplication;
import org.scalatest.matchers.dsl.ResultOfTheSameElementsAsApplication;
import org.scalatest.matchers.dsl.ResultOfTheSameElementsInOrderAsApplication;
import org.scalatest.matchers.dsl.ResultOfTheTypeInvocation;
import org.scalatest.matchers.dsl.ResultOfThrownByApplication;
import org.scalatest.matchers.dsl.SizeWord;
import org.scalatest.matchers.dsl.SortedWord;
import org.scalatest.matchers.dsl.StartWithWord;
import org.scalatest.matchers.dsl.WritableWord;
import org.scalatest.matchers.must.Matchers;
import org.scalatest.matchers.must.Matchers$AtLeastCollected$;
import org.scalatest.matchers.must.Matchers$AtMostCollected$;
import org.scalatest.matchers.must.Matchers$BetweenCollected$;
import org.scalatest.matchers.must.Matchers$ExactlyCollected$;
import org.scalatest.verbs.CompileWord;
import org.scalatest.verbs.MustVerb;
import org.scalatest.verbs.TypeCheckWord;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.GenTraversable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.Tuple2Zipped;
import scala.runtime.Tuple2Zipped$;
import scala.runtime.java8.JFunction2;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001B\u000e\u001d\u0001\u001dBQ\u0001\u0010\u0001\u0005\u0002uBq\u0001\u0011\u0001C\u0002\u0013\u0005\u0011\t\u0003\u0004I\u0001\u0001\u0006IA\u0011\u0005\b\u0013\u0002\u0011\r\u0011\"\u0001K\u0011\u0019q\u0005\u0001)A\u0005\u0017\"9q\n\u0001b\u0001\n\u0003Q\u0005B\u0002)\u0001A\u0003%1\nC\u0004R\u0001\t\u0007I\u0011\u0001&\t\rI\u0003\u0001\u0015!\u0003L\u0011\u001d\u0019\u0006A1A\u0005\u0002QCa\u0001\u0017\u0001!\u0002\u0013)\u0006bB-\u0001\u0005\u0004%\tA\u0017\u0005\u0007=\u0002\u0001\u000b\u0011B.\t\u000f}\u0003!\u0019!C\u0001\u0003\"1\u0001\r\u0001Q\u0001\n\tCq!\u0019\u0001C\u0002\u0013\u0005!\n\u0003\u0004c\u0001\u0001\u0006Ia\u0013\u0005\bG\u0002\u0011\r\u0011\"\u0001e\u0011\u0019A\u0007\u0001)A\u0005K\"9\u0011\u000e\u0001b\u0001\n\u0003Q\u0007B\u00028\u0001A\u0003%1\u000eC\u0004p\u0001\t\u0007I\u0011\u00019\t\u000f\u0005\u001d\u0001\u0001)A\u0005c\"I\u0011\u0011\u0002\u0001C\u0002\u0013\u0005\u00111\u0002\u0005\t\u0003S\u0001\u0001\u0015!\u0003\u0002\u000e!Q\u00111\u0006\u0001\t\u0006\u0004%\t!!\f\u0003\u00151\u0013eiR*Tk&$XM\u0003\u0002\u001e=\u0005aq\u000e\u001d;j[&T\u0018\r^5p]*\u0011q\u0004I\u0001\u0006[2d\u0017N\u0019\u0006\u0003C\t\nQa\u001d9be.T!a\t\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0013aA8sO\u000e\u00011\u0003\u0002\u0001)YI\u0002\"!\u000b\u0016\u000e\u0003\u0001J!a\u000b\u0011\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\ti\u0003'D\u0001/\u0015\tyc$\u0001\u0003vi&d\u0017BA\u0019/\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqR\u0004\"a\r\u001e\u000e\u0003QR!!\u000e\u001c\u0002\t5,8\u000f\u001e\u0006\u0003oa\n\u0001\"\\1uG\",'o\u001d\u0006\u0003s\u0011\n\u0011b]2bY\u0006$Xm\u001d;\n\u0005m\"$\u0001C'bi\u000eDWM]:\u0002\rqJg.\u001b;?)\u0005q\u0004CA \u0001\u001b\u0005a\u0012a\u00028Q_&tGo]\u000b\u0002\u0005B\u00111IR\u0007\u0002\t*\tQ)A\u0003tG\u0006d\u0017-\u0003\u0002H\t\n\u0019\u0011J\u001c;\u0002\u00119\u0004v.\u001b8ug\u0002\n\u0011!Q\u000b\u0002\u0017B\u00111\tT\u0005\u0003\u001b\u0012\u0013a\u0001R8vE2,\u0017AA!!\u0003\u0005\u0011\u0015A\u0001\"!\u0003!Ig.\u001b;jC2\u0014\u0015!C5oSRL\u0017\r\u001c\"!\u00039Ig.\u001b;jC2<V-[4iiN,\u0012!\u0016\t\u0004\u0007Z[\u0015BA,E\u0005\u0015\t%O]1z\u0003=Ig.\u001b;jC2<V-[4iiN\u0004\u0013\u0001C4sC\u0012LWM\u001c;\u0016\u0003m\u0003\"a\u0010/\n\u0005uc\"\u0001\u0005'pO&\u001cH/[2He\u0006$\u0017.\u001a8u\u0003%9'/\u00193jK:$\b%\u0001\bok6\u001cuN\u001d:fGRLwN\\:\u0002\u001f9,XnQ8se\u0016\u001cG/[8og\u0002\nQ\"\\5oS\n\u000bGo\u00195Ge\u0006\u001c\u0017AD7j]&\u0014\u0015\r^2i\rJ\f7\rI\u0001\u000eg&l\u0007\u000f\\3Va\u0012\fG/\u001a:\u0016\u0003\u0015\u0004\"a\u00104\n\u0005\u001dd\"!D*j[BdW-\u00169eCR,'/\u0001\btS6\u0004H.Z+qI\u0006$XM\u001d\u0011\u0002!M\fX/\u0019:fI2\u0013T\u000b\u001d3bi\u0016\u0014X#A6\u0011\u0005}b\u0017BA7\u001d\u0005A\u0019\u0016/^1sK\u0012d%'\u00169eCR,'/A\ttcV\f'/\u001a3MeU\u0003H-\u0019;fe\u0002\n\u0001\u0002^3ti\u0012\u000bG/Y\u000b\u0002cB\u0019!O_?\u000f\u0005MDhB\u0001;x\u001b\u0005)(B\u0001<'\u0003\u0019a$o\\8u}%\tQ)\u0003\u0002z\t\u00069\u0001/Y2lC\u001e,\u0017BA>}\u0005\r\u0019V-\u001d\u0006\u0003s\u0012\u00032A`A\u0002\u001b\u0005y(bAA\u0001=\u0005Q!/Z4sKN\u001c\u0018n\u001c8\n\u0007\u0005\u0015qP\u0001\u0007MC\n,G.\u001a3Q_&tG/A\u0005uKN$H)\u0019;bA\u0005!A-\u0019;b+\t\ti\u0001\u0005\u0004\u0002\u0010\u0005U\u0011qC\u0007\u0003\u0003#Q1!a\u0005E\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0004w\u0006E\u0001CB\"\u0002\u001a-\u000bi\"C\u0002\u0002\u001c\u0011\u0013a\u0001V;qY\u0016\u0014\u0004\u0003BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\rb$\u0001\u0004mS:\fGnZ\u0005\u0005\u0003O\t\tC\u0001\u0004WK\u000e$xN]\u0001\u0006I\u0006$\u0018\rI\u0001\bI\u0006$\u0018M\u0015#E+\t\ty\u0003\u0005\u0004\u00022\u0005]\u0012qC\u0007\u0003\u0003gQ1!!\u000e!\u0003\r\u0011H\rZ\u0005\u0005\u0003s\t\u0019DA\u0002S\t\u0012\u0003")
public class LBFGSSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
Matchers {
    private RDD<Tuple2<Object, Vector>> dataRDD;
    private final int nPoints;
    private final double A;
    private final double B;
    private final double initialB;
    private final double[] initialWeights;
    private final LogisticGradient gradient;
    private final int numCorrections;
    private final double miniBatchFrac;
    private final SimpleUpdater simpleUpdater;
    private final SquaredL2Updater squaredL2Updater;
    private final Seq<LabeledPoint> testData;
    private final Seq<Tuple2<Object, Vector>> data;
    private final Matchers.KeyWord key;
    private final Matchers.ValueWord value;
    private final Matchers.AWord a;
    private final Matchers.AnWord an;
    private final Matchers.TheSameInstanceAsPhrase theSameInstanceAs;
    private final Matchers.RegexWord regex;
    private final Matchers.Collected org$scalatest$matchers$must$Matchers$$AllCollected;
    private final Matchers.Collected org$scalatest$matchers$must$Matchers$$EveryCollected;
    private volatile Matchers$BetweenCollected$ BetweenCollected$module;
    private volatile Matchers$AtLeastCollected$ AtLeastCollected$module;
    private volatile Matchers$AtMostCollected$ AtMostCollected$module;
    private final Matchers.Collected org$scalatest$matchers$must$Matchers$$NoCollected;
    private volatile Matchers$ExactlyCollected$ ExactlyCollected$module;
    private final Matchers.MustMethodHelperClass org$scalatest$matchers$must$Matchers$$MustMethodHelper;
    private final Explicitly.DecidedWord decided;
    private final Explicitly.DeterminedWord determined;
    private final Explicitly.TheAfterWord after;
    private final FullyMatchWord fullyMatch;
    private final StartWithWord startWith;
    private final EndWithWord endWith;
    private final IncludeWord include;
    private final HaveWord have;
    private final BeWord be;
    private final ContainWord contain;
    private final NotWord not;
    private final LengthWord length;
    private final SizeWord size;
    private final SortedWord sorted;
    private final DefinedWord defined;
    private final ExistWord exist;
    private final ReadableWord readable;
    private final WritableWord writable;
    private final EmptyWord empty;
    private final CompileWord compile;
    private final TypeCheckWord typeCheck;
    private final MatchPatternWord matchPattern;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;
    private volatile boolean bitmap$0;

    public Matchers.HavePropertyMatcherGenerator convertSymbolToHavePropertyMatcherGenerator(Symbol symbol, Prettifier prettifier, Position pos) {
        return Matchers.convertSymbolToHavePropertyMatcherGenerator$((Matchers)this, (Symbol)symbol, (Prettifier)prettifier, (Position)pos);
    }

    public <T> Matcher<T> equal(TripleEqualsSupport.Spread<T> spread) {
        return Matchers.equal$((Matchers)this, spread);
    }

    public Matcher<Object> equal(Null$ o) {
        return Matchers.equal$((Matchers)this, (Null$)o);
    }

    public <T> ResultOfLessThanComparison<T> $less(T right, Ordering<T> evidence$1) {
        return Matchers.$less$((Matchers)this, right, evidence$1);
    }

    public <T> ResultOfGreaterThanComparison<T> $greater(T right, Ordering<T> evidence$2) {
        return Matchers.$greater$((Matchers)this, right, evidence$2);
    }

    public <T> ResultOfLessThanOrEqualToComparison<T> $less$eq(T right, Ordering<T> evidence$3) {
        return Matchers.$less$eq$((Matchers)this, right, evidence$3);
    }

    public <T> ResultOfGreaterThanOrEqualToComparison<T> $greater$eq(T right, Ordering<T> evidence$4) {
        return Matchers.$greater$eq$((Matchers)this, right, evidence$4);
    }

    public <T> ResultOfDefinedAt<T> definedAt(T right) {
        return Matchers.definedAt$((Matchers)this, right);
    }

    public ResultOfOneOfApplication oneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.oneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfOneElementOfApplication oneElementOf(GenTraversable<Object> elements) {
        return Matchers.oneElementOf$((Matchers)this, elements);
    }

    public ResultOfAtLeastOneOfApplication atLeastOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.atLeastOneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfAtLeastOneElementOfApplication atLeastOneElementOf(GenTraversable<Object> elements) {
        return Matchers.atLeastOneElementOf$((Matchers)this, elements);
    }

    public ResultOfNoneOfApplication noneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.noneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfNoElementsOfApplication noElementsOf(GenTraversable<Object> elements) {
        return Matchers.noElementsOf$((Matchers)this, elements);
    }

    public ResultOfTheSameElementsAsApplication theSameElementsAs(GenTraversable<?> xs) {
        return Matchers.theSameElementsAs$((Matchers)this, xs);
    }

    public ResultOfTheSameElementsInOrderAsApplication theSameElementsInOrderAs(GenTraversable<?> xs) {
        return Matchers.theSameElementsInOrderAs$((Matchers)this, xs);
    }

    public ResultOfOnlyApplication only(Seq<Object> xs, Position pos) {
        return Matchers.only$((Matchers)this, xs, (Position)pos);
    }

    public <T> ResultOfInOrderOnlyApplication inOrderOnly(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.inOrderOnly$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfAllOfApplication allOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.allOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfAllElementsOfApplication allElementsOf(GenTraversable<R> elements) {
        return Matchers.allElementsOf$((Matchers)this, elements);
    }

    public ResultOfInOrderApplication inOrder(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.inOrder$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfInOrderElementsOfApplication inOrderElementsOf(GenTraversable<R> elements) {
        return Matchers.inOrderElementsOf$((Matchers)this, elements);
    }

    public ResultOfAtMostOneOfApplication atMostOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.atMostOneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfAtMostOneElementOfApplication atMostOneElementOf(GenTraversable<R> elements) {
        return Matchers.atMostOneElementOf$((Matchers)this, elements);
    }

    public ResultOfThrownByApplication thrownBy(Function0<Object> fun) {
        return Matchers.thrownBy$((Matchers)this, fun);
    }

    public ResultOfMessageWordApplication message(String expectedMessage) {
        return Matchers.message$((Matchers)this, (String)expectedMessage);
    }

    public <T> Assertion doCollected(Matchers.Collected collected, GenTraversable<T> xs, Object original, Prettifier prettifier, Position pos, Function1<T, Assertion> fun) {
        return Matchers.doCollected$((Matchers)this, (Matchers.Collected)collected, xs, (Object)original, (Prettifier)prettifier, (Position)pos, fun);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> all(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends GenMap<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> all(MAP xs, Collecting<Tuple2<K, V>, GenTraversable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> all(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> all(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atLeast(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends GenMap<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> atLeast(int num, MAP xs, Collecting<Tuple2<K, V>, GenTraversable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atLeast(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> atLeast(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> every(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> every(MAP xs, Collecting<Tuple2<K, V>, GenTraversable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> every(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> every(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> exactly(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends GenMap<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> exactly(int num, MAP xs, Collecting<Tuple2<K, V>, GenTraversable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> exactly(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> exactly(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> no(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> no(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> no(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> between(int from, int upTo, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> between(int from, int upTo, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> between(int from, int upTo, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atMost(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends GenMap<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> atMost(int num, MAP xs, Collecting<Tuple2<K, V>, GenTraversable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atMost(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> atMost(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <T> ResultOfATypeInvocation<T> a(ClassTag<T> evidence$5) {
        return Matchers.a$((Matchers)this, evidence$5);
    }

    public <T> ResultOfAnTypeInvocation<T> an(ClassTag<T> evidence$6) {
        return Matchers.an$((Matchers)this, evidence$6);
    }

    public <T> ResultOfTheTypeInvocation<T> the(ClassTag<T> evidence$7, Position pos) {
        return Matchers.the$((Matchers)this, evidence$7, (Position)pos);
    }

    public <T> Matchers.AnyMustWrapper<T> convertToAnyMustWrapper(T o, Position pos, Prettifier prettifier) {
        return Matchers.convertToAnyMustWrapper$((Matchers)this, o, (Position)pos, (Prettifier)prettifier);
    }

    public Matchers.StringMustWrapper convertToStringMustWrapper(String o, Position pos, Prettifier prettifier) {
        return Matchers.convertToStringMustWrapper$((Matchers)this, (String)o, (Position)pos, (Prettifier)prettifier);
    }

    public Matchers.RegexWrapper convertToRegexWrapper(Regex o) {
        return Matchers.convertToRegexWrapper$((Matchers)this, (Regex)o);
    }

    public <T> ResultOfOfTypeInvocation<T> of(ClassTag<T> ev) {
        return Matchers.of$((Matchers)this, ev);
    }

    public NoExceptionWord noException(Position pos) {
        return MatcherWords.noException$((MatcherWords)this, (Position)pos);
    }

    public MatcherFactory1<Object, Equality> equal(Object right) {
        return MatcherWords.equal$((MatcherWords)this, (Object)right);
    }

    public MustVerb.StringMustWrapperForVerb convertToStringMustWrapperForVerb(String o, Position position) {
        return MustVerb.convertToStringMustWrapperForVerb$((MustVerb)this, (String)o, (Position)position);
    }

    public <T> Tolerance.PlusOrMinusWrapper<T> convertNumericToPlusOrMinusWrapper(T pivot, Numeric<T> evidence$2) {
        return Tolerance.convertNumericToPlusOrMinusWrapper$((Tolerance)this, pivot, evidence$2);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    public Matchers.KeyWord key() {
        return this.key;
    }

    public Matchers.ValueWord value() {
        return this.value;
    }

    public Matchers.AWord a() {
        return this.a;
    }

    public Matchers.AnWord an() {
        return this.an;
    }

    public Matchers.TheSameInstanceAsPhrase theSameInstanceAs() {
        return this.theSameInstanceAs;
    }

    public Matchers.RegexWord regex() {
        return this.regex;
    }

    public Matchers.Collected org$scalatest$matchers$must$Matchers$$AllCollected() {
        return this.org$scalatest$matchers$must$Matchers$$AllCollected;
    }

    public Matchers.Collected org$scalatest$matchers$must$Matchers$$EveryCollected() {
        return this.org$scalatest$matchers$must$Matchers$$EveryCollected;
    }

    public Matchers$BetweenCollected$ org$scalatest$matchers$must$Matchers$$BetweenCollected() {
        if (this.BetweenCollected$module == null) {
            this.org$scalatest$matchers$must$Matchers$$BetweenCollected$lzycompute$1();
        }
        return this.BetweenCollected$module;
    }

    public Matchers$AtLeastCollected$ org$scalatest$matchers$must$Matchers$$AtLeastCollected() {
        if (this.AtLeastCollected$module == null) {
            this.org$scalatest$matchers$must$Matchers$$AtLeastCollected$lzycompute$1();
        }
        return this.AtLeastCollected$module;
    }

    public Matchers$AtMostCollected$ org$scalatest$matchers$must$Matchers$$AtMostCollected() {
        if (this.AtMostCollected$module == null) {
            this.org$scalatest$matchers$must$Matchers$$AtMostCollected$lzycompute$1();
        }
        return this.AtMostCollected$module;
    }

    public Matchers.Collected org$scalatest$matchers$must$Matchers$$NoCollected() {
        return this.org$scalatest$matchers$must$Matchers$$NoCollected;
    }

    public Matchers$ExactlyCollected$ org$scalatest$matchers$must$Matchers$$ExactlyCollected() {
        if (this.ExactlyCollected$module == null) {
            this.org$scalatest$matchers$must$Matchers$$ExactlyCollected$lzycompute$1();
        }
        return this.ExactlyCollected$module;
    }

    public Matchers.MustMethodHelperClass org$scalatest$matchers$must$Matchers$$MustMethodHelper() {
        return this.org$scalatest$matchers$must$Matchers$$MustMethodHelper;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$key_$eq(Matchers.KeyWord x$1) {
        this.key = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$value_$eq(Matchers.ValueWord x$1) {
        this.value = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$a_$eq(Matchers.AWord x$1) {
        this.a = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$an_$eq(Matchers.AnWord x$1) {
        this.an = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$theSameInstanceAs_$eq(Matchers.TheSameInstanceAsPhrase x$1) {
        this.theSameInstanceAs = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$regex_$eq(Matchers.RegexWord x$1) {
        this.regex = x$1;
    }

    public final void org$scalatest$matchers$must$Matchers$_setter_$org$scalatest$matchers$must$Matchers$$AllCollected_$eq(Matchers.Collected x$1) {
        this.org$scalatest$matchers$must$Matchers$$AllCollected = x$1;
    }

    public final void org$scalatest$matchers$must$Matchers$_setter_$org$scalatest$matchers$must$Matchers$$EveryCollected_$eq(Matchers.Collected x$1) {
        this.org$scalatest$matchers$must$Matchers$$EveryCollected = x$1;
    }

    public final void org$scalatest$matchers$must$Matchers$_setter_$org$scalatest$matchers$must$Matchers$$NoCollected_$eq(Matchers.Collected x$1) {
        this.org$scalatest$matchers$must$Matchers$$NoCollected = x$1;
    }

    public final void org$scalatest$matchers$must$Matchers$_setter_$org$scalatest$matchers$must$Matchers$$MustMethodHelper_$eq(Matchers.MustMethodHelperClass x$1) {
        this.org$scalatest$matchers$must$Matchers$$MustMethodHelper = x$1;
    }

    public Explicitly.DecidedWord decided() {
        return this.decided;
    }

    public Explicitly.DeterminedWord determined() {
        return this.determined;
    }

    public Explicitly.TheAfterWord after() {
        return this.after;
    }

    public void org$scalactic$Explicitly$_setter_$decided_$eq(Explicitly.DecidedWord x$1) {
        this.decided = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$determined_$eq(Explicitly.DeterminedWord x$1) {
        this.determined = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$after_$eq(Explicitly.TheAfterWord x$1) {
        this.after = x$1;
    }

    public FullyMatchWord fullyMatch() {
        return this.fullyMatch;
    }

    public StartWithWord startWith() {
        return this.startWith;
    }

    public EndWithWord endWith() {
        return this.endWith;
    }

    public IncludeWord include() {
        return this.include;
    }

    public HaveWord have() {
        return this.have;
    }

    public BeWord be() {
        return this.be;
    }

    public ContainWord contain() {
        return this.contain;
    }

    public NotWord not() {
        return this.not;
    }

    public LengthWord length() {
        return this.length;
    }

    public SizeWord size() {
        return this.size;
    }

    public SortedWord sorted() {
        return this.sorted;
    }

    public DefinedWord defined() {
        return this.defined;
    }

    public ExistWord exist() {
        return this.exist;
    }

    public ReadableWord readable() {
        return this.readable;
    }

    public WritableWord writable() {
        return this.writable;
    }

    public EmptyWord empty() {
        return this.empty;
    }

    public CompileWord compile() {
        return this.compile;
    }

    public TypeCheckWord typeCheck() {
        return this.typeCheck;
    }

    public MatchPatternWord matchPattern() {
        return this.matchPattern;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$fullyMatch_$eq(FullyMatchWord x$1) {
        this.fullyMatch = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$startWith_$eq(StartWithWord x$1) {
        this.startWith = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$endWith_$eq(EndWithWord x$1) {
        this.endWith = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$include_$eq(IncludeWord x$1) {
        this.include = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$have_$eq(HaveWord x$1) {
        this.have = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$be_$eq(BeWord x$1) {
        this.be = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$contain_$eq(ContainWord x$1) {
        this.contain = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$not_$eq(NotWord x$1) {
        this.not = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$length_$eq(LengthWord x$1) {
        this.length = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$size_$eq(SizeWord x$1) {
        this.size = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$sorted_$eq(SortedWord x$1) {
        this.sorted = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$defined_$eq(DefinedWord x$1) {
        this.defined = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$exist_$eq(ExistWord x$1) {
        this.exist = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$readable_$eq(ReadableWord x$1) {
        this.readable = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$writable_$eq(WritableWord x$1) {
        this.writable = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$empty_$eq(EmptyWord x$1) {
        this.empty = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$compile_$eq(CompileWord x$1) {
        this.compile = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$typeCheck_$eq(TypeCheckWord x$1) {
        this.typeCheck = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$matchPattern_$eq(MatchPatternWord x$1) {
        this.matchPattern = x$1;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public int nPoints() {
        return this.nPoints;
    }

    public double A() {
        return this.A;
    }

    public double B() {
        return this.B;
    }

    public double initialB() {
        return this.initialB;
    }

    public double[] initialWeights() {
        return this.initialWeights;
    }

    public LogisticGradient gradient() {
        return this.gradient;
    }

    public int numCorrections() {
        return this.numCorrections;
    }

    public double miniBatchFrac() {
        return this.miniBatchFrac;
    }

    public SimpleUpdater simpleUpdater() {
        return this.simpleUpdater;
    }

    public SquaredL2Updater squaredL2Updater() {
        return this.squaredL2Updater;
    }

    public Seq<LabeledPoint> testData() {
        return this.testData;
    }

    public Seq<Tuple2<Object, Vector>> data() {
        return this.data;
    }

    private RDD<Tuple2<Object, Vector>> dataRDD$lzycompute() {
        LBFGSSuite lBFGSSuite = this;
        synchronized (lBFGSSuite) {
            if (!this.bitmap$0) {
                this.dataRDD = this.sc().parallelize(this.data(), 2, ClassTag$.MODULE$.apply(Tuple2.class)).cache();
                this.bitmap$0 = true;
            }
        }
        return this.dataRDD;
    }

    public RDD<Tuple2<Object, Vector>> dataRDD() {
        return !this.bitmap$0 ? this.dataRDD$lzycompute() : this.dataRDD;
    }

    private final void org$scalatest$matchers$must$Matchers$$BetweenCollected$lzycompute$1() {
        LBFGSSuite lBFGSSuite = this;
        synchronized (lBFGSSuite) {
            if (this.BetweenCollected$module == null) {
                this.BetweenCollected$module = new Matchers$BetweenCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$matchers$must$Matchers$$AtLeastCollected$lzycompute$1() {
        LBFGSSuite lBFGSSuite = this;
        synchronized (lBFGSSuite) {
            if (this.AtLeastCollected$module == null) {
                this.AtLeastCollected$module = new Matchers$AtLeastCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$matchers$must$Matchers$$AtMostCollected$lzycompute$1() {
        LBFGSSuite lBFGSSuite = this;
        synchronized (lBFGSSuite) {
            if (this.AtMostCollected$module == null) {
                this.AtMostCollected$module = new Matchers$AtMostCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$matchers$must$Matchers$$ExactlyCollected$lzycompute$1() {
        LBFGSSuite lBFGSSuite = this;
        synchronized (lBFGSSuite) {
            if (this.ExactlyCollected$module == null) {
                this.ExactlyCollected$module = new Matchers$ExactlyCollected$((Matchers)this);
            }
        }
    }

    private final void testImplicits$lzycompute$1() {
        LBFGSSuite lBFGSSuite = this;
        synchronized (lBFGSSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public LBFGSSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        Tolerance.$init$((Tolerance)this);
        MustVerb.$init$((MustVerb)this);
        MatcherWords.$init$((MatcherWords)this);
        Explicitly.$init$((Explicitly)this);
        Matchers.$init$((Matchers)this);
        this.nPoints = 10000;
        this.A = 2.0;
        this.B = -1.5;
        this.initialB = -1.0;
        this.initialWeights = new double[]{this.initialB()};
        this.gradient = new LogisticGradient();
        this.numCorrections = 10;
        this.miniBatchFrac = 1.0;
        this.simpleUpdater = new SimpleUpdater();
        this.squaredL2Updater = new SquaredL2Updater();
        this.testData = GradientDescentSuite$.MODULE$.generateGDInput(this.A(), this.B(), this.nPoints(), 42);
        this.data = (Seq)this.testData().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LabeledPoint labeledPoint = x0$1;
            if (labeledPoint == null) {
                throw new MatchError((Object)labeledPoint);
            }
            double label = labeledPoint.label();
            Vector features = labeledPoint.features();
            double d = 1.0;
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)label)), (Object)Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(features.toArray())).$plus$colon((Object)BoxesRunTime.boxToDouble((double)d), ClassTag$.MODULE$.Double())));
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom());
        this.test("LBFGS loss should be decreasing and match the result of Gradient Descent.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double[] lossGD;
            double[] loss;
            boolean regParam = false;
            double d = 1.0;
            Vector initialWeightsWithIntercept = Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.initialWeights())).toArray(ClassTag$.MODULE$.Double()))).$plus$colon((Object)BoxesRunTime.boxToDouble((double)d), ClassTag$.MODULE$.Double()));
            double convergenceTol = 1.0E-12;
            int numIterations = 10;
            Tuple2 tuple2 = LBFGS$.MODULE$.runLBFGS(this.dataRDD(), (Gradient)this.gradient(), (Updater)this.simpleUpdater(), this.numCorrections(), convergenceTol, numIterations, (double)regParam, initialWeightsWithIntercept);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double[] dArray = loss = (double[])tuple2._2();
            double[] loss2 = dArray;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)loss2, new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(loss2)).tail())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(xs))), (Function2)(JFunction2.mcZDD.sp & Serializable & scala.Serializable)(x$3, x$4) -> x$3 > x$4), "scala.Predef.tuple2ToZippedOps[Array[Double], Array[Double]](scala.Tuple2.apply[Array[Double], Array[Double]](loss, scala.Predef.doubleArrayOps(loss).tail)).zipped[Double, Array[Double], Double, Array[Double]]({\n  ((xs: Array[Double]) => scala.Predef.doubleArrayOps(xs))\n}, {\n  ((xs: Array[Double]) => scala.Predef.doubleArrayOps(xs))\n}).forall(((x$3: Double, x$4: Double) => x$3.>(x$4)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"loss should be monotonically decreasing.", Prettifier$.MODULE$.default(), new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            double stepSize = 1.0;
            int numGDIterations = 50;
            Tuple2 tuple22 = GradientDescent$.MODULE$.runMiniBatchSGD(this.dataRDD(), (Gradient)this.gradient(), (Updater)this.simpleUpdater(), stepSize, numGDIterations, (double)regParam, this.miniBatchFrac(), initialWeightsWithIntercept);
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            double[] dArray2 = lossGD = (double[])tuple22._2();
            double[] lossGD2 = dArray2;
            double $org_scalatest_assert_macro_left = package$.MODULE$.abs((BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(lossGD2)).last()) - BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(loss2)).last())) / BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(loss2)).last()));
            double $org_scalatest_assert_macro_right = 0.02;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"LBFGS should match GD result within 2% difference.", Prettifier$.MODULE$.default(), new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        }, new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("LBFGS and Gradient Descent with L2 regularization should get the same result.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double regParam = 0.2;
            Vector initialWeightsWithIntercept = Vectors$.MODULE$.dense(0.3, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.12}));
            double convergenceTol = 1.0E-12;
            int numIterations = 10;
            Tuple2 tuple2 = LBFGS$.MODULE$.runLBFGS(this.dataRDD(), (Gradient)this.gradient(), (Updater)this.squaredL2Updater(), this.numCorrections(), convergenceTol, numIterations, regParam, initialWeightsWithIntercept);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector weightLBFGS = (Vector)tuple2._1();
            double[] lossLBFGS = (double[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)weightLBFGS, (Object)lossLBFGS);
            Tuple2 tuple23 = tuple22;
            Vector weightLBFGS2 = (Vector)tuple23._1();
            double[] lossLBFGS2 = (double[])tuple23._2();
            int numGDIterations = 50;
            double stepSize = 1.0;
            Tuple2 tuple24 = GradientDescent$.MODULE$.runMiniBatchSGD(this.dataRDD(), (Gradient)this.gradient(), (Updater)this.squaredL2Updater(), stepSize, numGDIterations, regParam, this.miniBatchFrac(), initialWeightsWithIntercept, convergenceTol);
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            Vector weightGD = (Vector)tuple24._1();
            double[] lossGD = (double[])tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)weightGD, (Object)lossGD);
            Tuple2 tuple26 = tuple25;
            Vector weightGD2 = (Vector)tuple26._1();
            double[] lossGD2 = (double[])tuple26._2();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(lossGD2[0]).$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(lossLBFGS2[0]).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(lossGD.apply(0)).~=(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(lossLBFGS.apply(0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The first losses of LBFGS and GD should be the same.", Prettifier$.MODULE$.default(), new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(lossGD2)).last())).$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(lossLBFGS2)).last())).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.Predef.doubleArrayOps(lossGD).last).~=(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.Predef.doubleArrayOps(lossLBFGS).last).relTol(0.02))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"The last losses of LBFGS and GD should be within 2% difference.", Prettifier$.MODULE$.default(), new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
            Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weightLBFGS2.apply(0)).$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weightGD2.apply(0)).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(weightLBFGS.apply(0)).~=(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(weightGD.apply(0)).relTol(0.02))", Prettifier$.MODULE$.default());
            Bool $org_scalatest_assert_macro_right = $org_scalatest_assert_macro_left.value() ? Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weightLBFGS2.apply(1)).$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weightGD2.apply(1)).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(weightLBFGS.apply(1)).~=(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(weightGD.apply(1)).relTol(0.02))", Prettifier$.MODULE$.default()) : Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"The weight differences between LBFGS and GD should be within 2%.", Prettifier$.MODULE$.default(), new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        }, new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        this.test("The convergence criteria should work as we expect.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double[] lossLBFGS3;
            double[] lossLBFGS2;
            double[] lossLBFGS22;
            double[] lossLBFGS1;
            double[] lossLBFGS12;
            double regParam = 0.0;
            Vector initialWeightsWithIntercept = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}));
            int numIterations = 8;
            double convergenceTol = 0.0;
            Tuple2 tuple2 = LBFGS$.MODULE$.runLBFGS(this.dataRDD(), (Gradient)this.gradient(), (Updater)this.squaredL2Updater(), this.numCorrections(), convergenceTol, numIterations, regParam, initialWeightsWithIntercept);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double[] dArray = lossLBFGS12 = (double[])tuple2._2();
            double[] $org_scalatest_assert_macro_left = lossLBFGS1 = dArray;
            int $org_scalatest_assert_macro_right = 9;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
            convergenceTol = 0.1;
            Tuple2 tuple22 = LBFGS$.MODULE$.runLBFGS(this.dataRDD(), (Gradient)this.gradient(), (Updater)this.squaredL2Updater(), this.numCorrections(), convergenceTol, numIterations, regParam, initialWeightsWithIntercept);
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            double[] dArray2 = lossLBFGS22 = (double[])tuple22._2();
            double[] $org_scalatest_assert_macro_left2 = lossLBFGS2 = dArray2;
            int $org_scalatest_assert_macro_right2 = 4;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
            double $org_scalatest_assert_macro_left3 = (lossLBFGS2[2] - lossLBFGS2[3]) / lossLBFGS2[2];
            double $org_scalatest_assert_macro_right3 = convergenceTol;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
            convergenceTol = 0.01;
            Tuple2 tuple23 = LBFGS$.MODULE$.runLBFGS(this.dataRDD(), (Gradient)this.gradient(), (Updater)this.squaredL2Updater(), this.numCorrections(), convergenceTol, numIterations, regParam, initialWeightsWithIntercept);
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            double[] dArray3 = lossLBFGS3 = (double[])tuple23._2();
            double[] lossLBFGS32 = dArray3;
            int $org_scalatest_assert_macro_left4 = lossLBFGS32.length;
            int $org_scalatest_assert_macro_right4 = lossLBFGS2.length;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 > $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
            double[] $org_scalatest_assert_macro_left5 = lossLBFGS32;
            int $org_scalatest_assert_macro_right5 = 6;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
            double $org_scalatest_assert_macro_left6 = (lossLBFGS32[4] - lossLBFGS32[5]) / lossLBFGS32[4];
            double $org_scalatest_assert_macro_right6 = convergenceTol;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left6), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 < $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        }, new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        this.test("Optimize via class LBFGS.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Vector weightGD;
            double regParam = 0.2;
            Vector initialWeightsWithIntercept = Vectors$.MODULE$.dense(0.3, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.12}));
            double convergenceTol = 1.0E-12;
            int numIterations = 10;
            LBFGS lbfgsOptimizer = new LBFGS((Gradient)this.gradient(), (Updater)this.squaredL2Updater()).setNumCorrections(this.numCorrections()).setConvergenceTol(convergenceTol).setNumIterations(numIterations).setRegParam(regParam);
            Vector weightLBFGS = lbfgsOptimizer.optimize(this.dataRDD(), initialWeightsWithIntercept);
            int numGDIterations = 50;
            double stepSize = 1.0;
            Tuple2 tuple2 = GradientDescent$.MODULE$.runMiniBatchSGD(this.dataRDD(), (Gradient)this.gradient(), (Updater)this.squaredL2Updater(), stepSize, numGDIterations, regParam, this.miniBatchFrac(), initialWeightsWithIntercept, convergenceTol);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector vector = weightGD = (Vector)tuple2._1();
            Vector weightGD2 = vector;
            Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weightLBFGS.apply(0)).$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weightGD2.apply(0)).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(weightLBFGS.apply(0)).~=(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(weightGD.apply(0)).relTol(0.02))", Prettifier$.MODULE$.default());
            Bool $org_scalatest_assert_macro_right = $org_scalatest_assert_macro_left.value() ? Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weightLBFGS.apply(1)).$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weightGD2.apply(1)).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(weightLBFGS.apply(1)).~=(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(weightGD.apply(1)).relTol(0.02))", Prettifier$.MODULE$.default()) : Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The weight differences between LBFGS and GD should be within 2%.", Prettifier$.MODULE$.default(), new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
        }, new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
        this.test("SPARK-18471: LBFGS aggregator on empty partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            boolean regParam = false;
            Vector initialWeightsWithIntercept = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
            double convergenceTol = 1.0E-12;
            int numIterations = 1;
            RDD dataWithEmptyPartitions = this.sc().parallelize((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), (List)Nil$.MODULE$), 2, ClassTag$.MODULE$.apply(Tuple2.class));
            return LBFGS$.MODULE$.runLBFGS(dataWithEmptyPartitions, (Gradient)this.gradient(), (Updater)this.simpleUpdater(), this.numCorrections(), convergenceTol, numIterations, (double)regParam, initialWeightsWithIntercept);
        }, new Position("LBFGSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
    }
}

