/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.r;

import org.apache.spark.ml.Model;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.Predictor;
import org.apache.spark.ml.classification.FMClassifier;
import org.apache.spark.ml.feature.IndexToString;
import org.apache.spark.ml.feature.RFormula;
import org.apache.spark.ml.feature.RFormulaModel;
import org.apache.spark.ml.r.FMClassifierWrapper;
import org.apache.spark.ml.r.RWrapperUtils$;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;

public final class FMClassifierWrapper$
implements MLReadable<FMClassifierWrapper> {
    public static FMClassifierWrapper$ MODULE$;
    private final String PREDICTED_LABEL_INDEX_COL;
    private final String PREDICTED_LABEL_COL;

    static {
        new FMClassifierWrapper$();
    }

    @Override
    public Object load(String path) {
        return MLReadable.load$(this, path);
    }

    public String PREDICTED_LABEL_INDEX_COL() {
        return this.PREDICTED_LABEL_INDEX_COL;
    }

    public String PREDICTED_LABEL_COL() {
        return this.PREDICTED_LABEL_COL;
    }

    public FMClassifierWrapper fit(Dataset<Row> data, String formula, int factorSize, boolean fitLinear, double regParam, double miniBatchFraction, double initStd, int maxIter, double stepSize, double tol, String solver, String seed, double[] thresholds, String handleInvalid) {
        RFormula rFormula = new RFormula().setFormula(formula).setForceIndexLabel(true).setHandleInvalid(handleInvalid);
        RWrapperUtils$.MODULE$.checkDataColumns(rFormula, data);
        Model rFormulaModel = rFormula.fit((Dataset)data);
        boolean fitIntercept = rFormula.hasIntercept();
        Tuple2<String[], String[]> tuple2 = RWrapperUtils$.MODULE$.getFeaturesAndLabels((RFormulaModel)rFormulaModel, data);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String[] features = (String[])tuple2._1();
        String[] labels = (String[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)features, (Object)labels);
        Tuple2 tuple23 = tuple22;
        String[] features2 = (String[])tuple23._1();
        String[] labels2 = (String[])tuple23._2();
        FMClassifier fmc = (FMClassifier)((Predictor)((Predictor)new FMClassifier().setFactorSize(factorSize).setFitIntercept(fitIntercept).setFitLinear(fitLinear).setRegParam(regParam).setMiniBatchFraction(miniBatchFraction).setInitStd(initStd).setMaxIter(maxIter).setStepSize(stepSize).setTol(tol).setSolver(solver).setFeaturesCol(rFormula.getFeaturesCol())).setLabelCol(rFormula.getLabelCol())).setPredictionCol(this.PREDICTED_LABEL_INDEX_COL());
        Object object = seed != null && seed.length() > 0 ? fmc.setSeed(new StringOps(Predef$.MODULE$.augmentString(seed)).toLong()) : BoxedUnit.UNIT;
        Object object2 = thresholds != null ? fmc.setThresholds(thresholds) : BoxedUnit.UNIT;
        IndexToString idxToStr = new IndexToString().setInputCol(this.PREDICTED_LABEL_INDEX_COL()).setOutputCol(this.PREDICTED_LABEL_COL()).setLabels(labels2);
        Model pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{rFormulaModel, fmc, idxToStr})).fit((Dataset)data);
        return new FMClassifierWrapper((PipelineModel)pipeline, features2, labels2);
    }

    @Override
    public MLReader<FMClassifierWrapper> read() {
        return new FMClassifierWrapper.FMClassifierWrapperReader();
    }

    private FMClassifierWrapper$() {
        MODULE$ = this;
        MLReadable.$init$(this);
        this.PREDICTED_LABEL_INDEX_COL = "pred_label_idx";
        this.PREDICTED_LABEL_COL = "prediction";
    }
}

