/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Bucketizer$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class BucketizerSuite$
extends SparkFunSuite {
    public static BucketizerSuite$ MODULE$;

    static {
        new BucketizerSuite$();
    }

    public double linearSearchForBuckets(double[] splits, double feature) {
        Predef$.MODULE$.require(feature >= BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(splits)).head()));
        int n = splits.length - 1;
        for (int i = 0; i < n; ++i) {
            if (!(feature < splits[i + 1])) continue;
            return i;
        }
        throw new RuntimeException(new StringBuilder(63).append("linearSearchForBuckets failed to find bucket for feature value ").append(feature).toString());
    }

    public void checkBinarySearch(double[] splits) {
        int n = splits.length - 1;
        for (int i = 0; i < n; ++i) {
            this.testFeature$1(splits[i], i, splits);
            this.testFeature$1((splits[i] + splits[i + 1]) / (double)2, i, splits);
        }
    }

    public void checkBucketResults(Dataset<Row> bucketResult, Seq<String> resultColumns, Seq<String> expectedColumns) {
        Seq<String> $org_scalatest_assert_macro_left = resultColumns;
        int $org_scalatest_assert_macro_right = expectedColumns.length();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(54).append("Given ").append(resultColumns.length()).append(" result columns doesn't match ").append(expectedColumns.length()).append(" expected columns.").toString(), Prettifier$.MODULE$.default(), new Position("BucketizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 461));
        int $org_scalatest_assert_macro_left2 = resultColumns.length();
        int $org_scalatest_assert_macro_right2 = 0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"At least one result and expected columns are needed.", Prettifier$.MODULE$.default(), new Position("BucketizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 464));
        Seq allColumns = (Seq)resultColumns.$plus$plus(expectedColumns, Seq$.MODULE$.canBuildFrom());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bucketResult.select((String)allColumns.head(), (Seq)allColumns.tail()).collect())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BucketizerSuite$.$anonfun$checkBucketResults$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final void testFeature$1(double feature, double expectedBucket, double[] splits$4) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)Bucketizer$.MODULE$.binarySearchForBuckets(splits$4, feature, false)));
        double $org_scalatest_assert_macro_right = expectedBucket;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(54).append("Expected feature value ").append(feature).append(" to be in bucket ").append(expectedBucket).append(" with splits:").append(" ").append(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(splits$4)).mkString(", ")).toString(), Prettifier$.MODULE$.default(), new Position("BucketizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 441));
    }

    public static final /* synthetic */ Assertion $anonfun$checkBucketResults$2(Row x1$1, int idx) {
        double result = x1$1.getDouble(idx);
        double expected = x1$1.getDouble(idx + x1$1.length() / 2);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = MODULE$.convertToEqualizer(BoxesRunTime.boxToDouble((double)result));
        double $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(71).append("The feature value is not correct after bucketing. ").append("Expected ").append(expected).append(" but found ").append(result).append(".").toString(), Prettifier$.MODULE$.default(), new Position("BucketizerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 472));
    }

    public static final /* synthetic */ void $anonfun$checkBucketResults$1(Row x0$1) {
        Row row = x0$1;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), row.length() / 2).foreach((Function1 & Serializable & scala.Serializable)idx -> BucketizerSuite$.$anonfun$checkBucketResults$2(row, BoxesRunTime.unboxToInt((Object)idx)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private BucketizerSuite$() {
        MODULE$ = this;
    }
}

