/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.attribute;

import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeType;
import org.apache.spark.ml.attribute.BinaryAttribute;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.sql.types.StructField;
import org.junit.Assert;
import org.junit.Test;

public class JavaAttributeSuite {
    @Test
    public void testAttributeType() {
        AttributeType numericType = AttributeType.Numeric();
        AttributeType nominalType = AttributeType.Nominal();
        AttributeType binaryType = AttributeType.Binary();
        Assert.assertEquals((Object)numericType, (Object)NumericAttribute.defaultAttr().attrType());
        Assert.assertEquals((Object)nominalType, (Object)NominalAttribute.defaultAttr().attrType());
        Assert.assertEquals((Object)binaryType, (Object)BinaryAttribute.defaultAttr().attrType());
    }

    @Test
    public void testNumericAttribute() {
        NumericAttribute attr = NumericAttribute.defaultAttr().withName("age").withIndex(0).withMin(0.0).withMax(1.0).withStd(0.5).withSparsity(0.4);
        Assert.assertEquals((Object)attr.withoutIndex(), (Object)Attribute.fromStructField((StructField)attr.toStructField()));
    }

    @Test
    public void testNominalAttribute() {
        NominalAttribute attr = NominalAttribute.defaultAttr().withName("size").withIndex(1).withValues("small", new String[]{"medium", "large"});
        Assert.assertEquals((Object)attr.withoutIndex(), (Object)Attribute.fromStructField((StructField)attr.toStructField()));
    }

    @Test
    public void testBinaryAttribute() {
        BinaryAttribute attr = BinaryAttribute.defaultAttr().withName("clicked").withIndex(2).withValues("no", "yes");
        Assert.assertEquals((Object)attr.withoutIndex(), (Object)Attribute.fromStructField((StructField)attr.toStructField()));
    }
}

