/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.r;

import java.io.Serializable;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.clustering.BisectingKMeans;
import org.apache.spark.ml.clustering.BisectingKMeansModel;
import org.apache.spark.ml.feature.RFormula;
import org.apache.spark.ml.feature.RFormulaModel;
import org.apache.spark.ml.r.BisectingKMeansWrapper;
import org.apache.spark.ml.r.RWrapperUtils$;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class BisectingKMeansWrapper$
implements MLReadable<BisectingKMeansWrapper> {
    public static BisectingKMeansWrapper$ MODULE$;

    static {
        new BisectingKMeansWrapper$();
    }

    private boolean $lessinit$greater$default$4() {
        return false;
    }

    public BisectingKMeansWrapper fit(Dataset<Row> data, String formula, int k, int maxIter, String seed, double minDivisibleClusterSize) {
        RFormula rFormula = new RFormula().setFormula(formula).setFeaturesCol("features");
        RWrapperUtils$.MODULE$.checkDataColumns(rFormula, data);
        Model rFormulaModel = rFormula.fit((Dataset)data);
        StructType schema = ((RFormulaModel)rFormulaModel).transform(data).schema();
        Attribute[] featureAttrs = (Attribute[])AttributeGroup$.MODULE$.fromStructField(schema.apply(((RFormulaModel)rFormulaModel).getFeaturesCol())).attributes().get();
        String[] features = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])featureAttrs)).map((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2.name().get(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        BisectingKMeans bisectingKmeans = new BisectingKMeans().setK(k).setMaxIter(maxIter).setMinDivisibleClusterSize(minDivisibleClusterSize).setFeaturesCol(rFormula.getFeaturesCol());
        Object object = seed != null && seed.length() > 0 ? bisectingKmeans.setSeed(new StringOps(Predef$.MODULE$.augmentString(seed)).toInt()) : BoxedUnit.UNIT;
        Model pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{rFormulaModel, bisectingKmeans})).fit((Dataset)data);
        BisectingKMeansModel bisectingKmeansModel = (BisectingKMeansModel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((PipelineModel)pipeline).stages())).last();
        long[] size = bisectingKmeansModel.summary().clusterSizes();
        return new BisectingKMeansWrapper((PipelineModel)pipeline, features, size, this.$lessinit$greater$default$4());
    }

    @Override
    public MLReader<BisectingKMeansWrapper> read() {
        return new BisectingKMeansWrapper.BisectingKMeansWrapperReader();
    }

    @Override
    public BisectingKMeansWrapper load(String path) {
        return (BisectingKMeansWrapper)MLReadable.load$(this, path);
    }

    private BisectingKMeansWrapper$() {
        MODULE$ = this;
        MLReadable.$init$(this);
    }
}

