/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import java.io.Serializable;
import org.apache.spark.ml.PredictionModel;
import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.LogisticRegressionWithLBFGS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.optimization.L1Updater;
import org.apache.spark.mllib.optimization.LBFGS;
import org.apache.spark.mllib.optimization.LogisticGradient;
import org.apache.spark.mllib.optimization.SquaredL2Updater;
import org.apache.spark.mllib.optimization.Updater;
import org.apache.spark.mllib.regression.GeneralizedLinearAlgorithm;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.DataValidators$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da\u0001\u0002\u0007\u000e\u0001aAQ!\u000b\u0001\u0005\u0002)Bq\u0001\f\u0001C\u0002\u0013\u0005S\u0006\u0003\u0004>\u0001\u0001\u0006IA\f\u0005\b\u007f\u0001\u0011\r\u0011\"\u0015A\u0011\u0019A\u0006\u0001)A\u0005\u0003\")\u0011\f\u0001C\u00055\")1\f\u0001C\u00019\")a\r\u0001C)O\")Q\u000f\u0001C!m\")Q\u000f\u0001C!s\")Q\u000f\u0001C\u0005{\nYBj\\4jgRL7MU3he\u0016\u001c8/[8o/&$\b\u000e\u0014\"G\u000fNS!AD\b\u0002\u001d\rd\u0017m]:jM&\u001c\u0017\r^5p]*\u0011\u0001#E\u0001\u0006[2d\u0017N\u0019\u0006\u0003%M\tQa\u001d9be.T!\u0001F\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0012aA8sO\u000e\u00011c\u0001\u0001\u001aGA\u0019!$H\u0010\u000e\u0003mQ!\u0001H\b\u0002\u0015I,wM]3tg&|g.\u0003\u0002\u001f7\tQr)\u001a8fe\u0006d\u0017N_3e\u0019&tW-\u0019:BY\u001e|'/\u001b;i[B\u0011\u0001%I\u0007\u0002\u001b%\u0011!%\u0004\u0002\u0018\u0019><\u0017n\u001d;jGJ+wM]3tg&|g.T8eK2\u0004\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fa\u0001P5oSRtD#A\u0016\u0011\u0005\u0001\u0002\u0011!C8qi&l\u0017N_3s+\u0005q\u0003CA\u00183\u001b\u0005\u0001$BA\u0019\u0010\u00031y\u0007\u000f^5nSj\fG/[8o\u0013\t\u0019\u0004GA\u0003M\u0005\u001a;5\u000bK\u0002\u0003km\u0002\"AN\u001d\u000e\u0003]R!\u0001O\t\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002;o\t)1+\u001b8dK\u0006\nA(A\u00032]Er\u0003'\u0001\u0006paRLW.\u001b>fe\u0002B3aA\u001b<\u0003)1\u0018\r\\5eCR|'o]\u000b\u0002\u0003B\u0019!iR%\u000e\u0003\rS!\u0001R#\u0002\u0013%lW.\u001e;bE2,'B\u0001$&\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u0011\u000e\u0013A\u0001T5tiB!AE\u0013'V\u0013\tYUEA\u0005Gk:\u001cG/[8ocA\u0019Q\n\u0015*\u000e\u00039S!aT\t\u0002\u0007I$G-\u0003\u0002R\u001d\n\u0019!\u000b\u0012#\u0011\u0005i\u0019\u0016B\u0001+\u001c\u00051a\u0015MY3mK\u0012\u0004v.\u001b8u!\t!c+\u0003\u0002XK\t9!i\\8mK\u0006t\u0017a\u0003<bY&$\u0017\r^8sg\u0002\n1#\\;mi&d\u0015MY3m-\u0006d\u0017\u000eZ1u_J,\u0012!S\u0001\u000eg\u0016$h*^7DY\u0006\u001c8/Z:\u0015\u0005usV\"\u0001\u0001\t\u000b};\u0001\u0019\u00011\u0002\u00159,Xn\u00117bgN,7\u000f\u0005\u0002%C&\u0011!-\n\u0002\u0004\u0013:$\bfA\u00046I\u0006\nQ-A\u00032]Mr\u0003'A\u0006de\u0016\fG/Z'pI\u0016dGcA\u0010ia\")\u0011\u000e\u0003a\u0001U\u00069q/Z5hQR\u001c\bCA6o\u001b\u0005a'BA7\u0010\u0003\u0019a\u0017N\\1mO&\u0011q\u000e\u001c\u0002\u0007-\u0016\u001cGo\u001c:\t\u000bED\u0001\u0019\u0001:\u0002\u0013%tG/\u001a:dKB$\bC\u0001\u0013t\u0013\t!XE\u0001\u0004E_V\u0014G.Z\u0001\u0004eVtGCA\u0010x\u0011\u0015A\u0018\u00021\u0001M\u0003\u0015Ig\u000e];u)\ry\"p\u001f\u0005\u0006q*\u0001\r\u0001\u0014\u0005\u0006y*\u0001\rA[\u0001\u000fS:LG/[1m/\u0016Lw\r\u001b;t)\u0015ybp`A\u0001\u0011\u0015A8\u00021\u0001M\u0011\u0015a8\u00021\u0001k\u0011\u0019\t\u0019a\u0003a\u0001+\u0006\u0019Ro]3s'V\u0004\b\u000f\\5fI^+\u0017n\u001a5ug\"\u001a\u0001!N\u001e")
public class LogisticRegressionWithLBFGS
extends GeneralizedLinearAlgorithm<LogisticRegressionModel> {
    private final LBFGS optimizer;
    private final List<Function1<RDD<LabeledPoint>, Object>> validators;

    @Override
    public LBFGS optimizer() {
        return this.optimizer;
    }

    public List<Function1<RDD<LabeledPoint>, Object>> validators() {
        return this.validators;
    }

    private Function1<RDD<LabeledPoint>, Object> multiLabelValidator() {
        return (Function1 & Serializable & scala.Serializable)data -> BoxesRunTime.boxToBoolean((boolean)LogisticRegressionWithLBFGS.$anonfun$multiLabelValidator$1(this, data));
    }

    public LogisticRegressionWithLBFGS setNumClasses(int numClasses) {
        Predef$.MODULE$.require(numClasses > 1);
        this.numOfLinearPredictor_$eq(numClasses - 1);
        Object object = numClasses > 2 ? this.optimizer().setGradient(new LogisticGradient(numClasses)) : BoxedUnit.UNIT;
        return this;
    }

    @Override
    public LogisticRegressionModel createModel(Vector weights, double intercept) {
        return this.numOfLinearPredictor() == 1 ? new LogisticRegressionModel(weights, intercept) : new LogisticRegressionModel(weights, intercept, this.numFeatures(), this.numOfLinearPredictor() + 1);
    }

    @Override
    public LogisticRegressionModel run(RDD<LabeledPoint> input) {
        return this.run(input, this.generateInitialWeights(input), false);
    }

    @Override
    public LogisticRegressionModel run(RDD<LabeledPoint> input, Vector initialWeights) {
        return this.run(input, initialWeights, true);
    }

    private LogisticRegressionModel run(RDD<LabeledPoint> input, Vector initialWeights, boolean userSuppliedWeights) {
        LogisticRegressionModel logisticRegressionModel;
        if (this.numOfLinearPredictor() == 1) {
            Updater updater = this.optimizer().getUpdater();
            LogisticRegressionModel logisticRegressionModel2 = updater instanceof SquaredL2Updater ? this.runWithMlLogisticRegression$1(0.0, userSuppliedWeights, initialWeights, input) : (updater instanceof L1Updater ? this.runWithMlLogisticRegression$1(1.0, userSuppliedWeights, initialWeights, input) : (LogisticRegressionModel)super.run(input, initialWeights));
            logisticRegressionModel = logisticRegressionModel2;
        } else {
            logisticRegressionModel = (LogisticRegressionModel)super.run(input, initialWeights);
        }
        return logisticRegressionModel;
    }

    public static final /* synthetic */ boolean $anonfun$multiLabelValidator$1(LogisticRegressionWithLBFGS $this, RDD data) {
        return $this.numOfLinearPredictor() > 1 ? BoxesRunTime.unboxToBoolean((Object)DataValidators$.MODULE$.multiLabelValidator($this.numOfLinearPredictor() + 1).apply((Object)data)) : BoxesRunTime.unboxToBoolean((Object)DataValidators$.MODULE$.binaryLabelValidator().apply((Object)data));
    }

    private final LogisticRegressionModel runWithMlLogisticRegression$1(double elasticNetParam, boolean userSuppliedWeights$1, Vector initialWeights$1, RDD input$1) {
        Object object;
        LogisticRegression lr = new LogisticRegression();
        lr.setRegParam(this.optimizer().getRegParam());
        lr.setElasticNetParam(elasticNetParam);
        lr.setStandardization(this.useFeatureScaling());
        if (userSuppliedWeights$1) {
            String uid = Identifiable$.MODULE$.randomUID("logreg-static");
            object = lr.setInitialModel(new org.apache.spark.ml.classification.LogisticRegressionModel(uid, (Matrix)new DenseMatrix(1, initialWeights$1.size(), initialWeights$1.toArray()), Vectors$.MODULE$.dense(1.0, (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[0])).asML(), 2, false));
        } else {
            object = BoxedUnit.UNIT;
        }
        lr.setFitIntercept(this.addIntercept());
        lr.setMaxIter(this.optimizer().getNumIterations());
        lr.setTol(this.optimizer().getConvergenceTol());
        SparkSession spark = SparkSession$.MODULE$.builder().sparkContext(input$1.context()).getOrCreate();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LogisticRegressionWithLBFGS.class.getClassLoader());
        public final class Org_apache_spark_mllib_classification_LogisticRegressionWithLBFGS$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.feature.LabeledPoint").asType().toTypeConstructor();
            }

            public Org_apache_spark_mllib_classification_LogisticRegressionWithLBFGS$$typecreator1$1(LogisticRegressionWithLBFGS $outer) {
            }
        }
        Dataset df = spark.createDataFrame(input$1.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.asML(), ClassTag$.MODULE$.apply(org.apache.spark.ml.feature.LabeledPoint.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_mllib_classification_LogisticRegressionWithLBFGS$$typecreator1$1(null)));
        PredictionModel mlLogisticRegressionModel = lr.train(df);
        Vector weights = Vectors$.MODULE$.dense(((org.apache.spark.ml.classification.LogisticRegressionModel)mlLogisticRegressionModel).coefficients().toArray());
        return this.createModel(weights, ((org.apache.spark.ml.classification.LogisticRegressionModel)mlLogisticRegressionModel).intercept());
    }

    public LogisticRegressionWithLBFGS() {
        this.setFeatureScaling(true);
        this.optimizer = new LBFGS(new LogisticGradient(), new SquaredL2Updater());
        this.validators = new .colon.colon(this.multiLabelValidator(), (List)Nil$.MODULE$);
    }
}

