/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.r;

import org.apache.spark.ml.Model;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.Predictor;
import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.feature.IndexToString;
import org.apache.spark.ml.feature.RFormula;
import org.apache.spark.ml.feature.RFormulaModel;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.r.LogisticRegressionWrapper;
import org.apache.spark.ml.r.RWrapperUtils$;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.MatchError;
import scala.Tuple2;
import scala.runtime.BoxedUnit;

public final class LogisticRegressionWrapper$
implements MLReadable<LogisticRegressionWrapper> {
    public static LogisticRegressionWrapper$ MODULE$;
    private final String PREDICTED_LABEL_INDEX_COL;
    private final String PREDICTED_LABEL_COL;

    static {
        new LogisticRegressionWrapper$();
    }

    public String PREDICTED_LABEL_INDEX_COL() {
        return this.PREDICTED_LABEL_INDEX_COL;
    }

    public String PREDICTED_LABEL_COL() {
        return this.PREDICTED_LABEL_COL;
    }

    public LogisticRegressionWrapper fit(Dataset<Row> data, String formula, double regParam, double elasticNetParam, int maxIter, double tol, String family, boolean standardization, double[] thresholds, String weightCol, int aggregationDepth, int numRowsOfBoundsOnCoefficients, int numColsOfBoundsOnCoefficients, double[] lowerBoundsOnCoefficients, double[] upperBoundsOnCoefficients, double[] lowerBoundsOnIntercepts, double[] upperBoundsOnIntercepts, String handleInvalid) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        RFormula rFormula = new RFormula().setFormula(formula).setForceIndexLabel(true).setHandleInvalid(handleInvalid);
        RWrapperUtils$.MODULE$.checkDataColumns(rFormula, data);
        Model rFormulaModel = rFormula.fit((Dataset)data);
        boolean fitIntercept = rFormula.hasIntercept();
        Tuple2<String[], String[]> tuple2 = RWrapperUtils$.MODULE$.getFeaturesAndLabels((RFormulaModel)rFormulaModel, data);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String[] features = (String[])tuple2._1();
        String[] labels = (String[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)features, (Object)labels);
        Tuple2 tuple23 = tuple22;
        String[] features2 = (String[])tuple23._1();
        String[] labels2 = (String[])tuple23._2();
        LogisticRegression lr = ((LogisticRegression)((Predictor)((Predictor)new LogisticRegression().setRegParam(regParam).setElasticNetParam(elasticNetParam).setMaxIter(maxIter).setTol(tol).setFitIntercept(fitIntercept).setFamily(family).setStandardization(standardization).setFeaturesCol(rFormula.getFeaturesCol())).setLabelCol(rFormula.getLabelCol())).setPredictionCol(this.PREDICTED_LABEL_INDEX_COL())).setAggregationDepth(aggregationDepth);
        LogisticRegression logisticRegression = thresholds.length > 1 ? lr.setThresholds(thresholds) : lr.setThreshold(thresholds[0]);
        Object object5 = weightCol != null ? lr.setWeightCol(weightCol) : BoxedUnit.UNIT;
        if (numRowsOfBoundsOnCoefficients != 0 && numColsOfBoundsOnCoefficients != 0 && lowerBoundsOnCoefficients != null) {
            Matrix coef = Matrices$.MODULE$.dense(numRowsOfBoundsOnCoefficients, numColsOfBoundsOnCoefficients, lowerBoundsOnCoefficients);
            object4 = lr.setLowerBoundsOnCoefficients(coef);
        } else {
            object4 = BoxedUnit.UNIT;
        }
        if (numRowsOfBoundsOnCoefficients != 0 && numColsOfBoundsOnCoefficients != 0 && upperBoundsOnCoefficients != null) {
            Matrix coef = Matrices$.MODULE$.dense(numRowsOfBoundsOnCoefficients, numColsOfBoundsOnCoefficients, upperBoundsOnCoefficients);
            object3 = lr.setUpperBoundsOnCoefficients(coef);
        } else {
            object3 = BoxedUnit.UNIT;
        }
        if (lowerBoundsOnIntercepts != null) {
            Vector intercept = Vectors$.MODULE$.dense(lowerBoundsOnIntercepts);
            object2 = lr.setLowerBoundsOnIntercepts(intercept);
        } else {
            object2 = BoxedUnit.UNIT;
        }
        if (upperBoundsOnIntercepts != null) {
            Vector intercept = Vectors$.MODULE$.dense(upperBoundsOnIntercepts);
            object = lr.setUpperBoundsOnIntercepts(intercept);
        } else {
            object = BoxedUnit.UNIT;
        }
        IndexToString idxToStr = new IndexToString().setInputCol(this.PREDICTED_LABEL_INDEX_COL()).setOutputCol(this.PREDICTED_LABEL_COL()).setLabels(labels2);
        Model pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{rFormulaModel, lr, idxToStr})).fit((Dataset)data);
        return new LogisticRegressionWrapper((PipelineModel)pipeline, features2, labels2);
    }

    @Override
    public MLReader<LogisticRegressionWrapper> read() {
        return new LogisticRegressionWrapper.LogisticRegressionWrapperReader();
    }

    @Override
    public LogisticRegressionWrapper load(String path) {
        return (LogisticRegressionWrapper)MLReadable.load$(this, path);
    }

    private LogisticRegressionWrapper$() {
        MODULE$ = this;
        MLReadable.$init$(this);
        this.PREDICTED_LABEL_INDEX_COL = "pred_label_idx";
        this.PREDICTED_LABEL_COL = "prediction";
    }
}

