/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.param;

import org.apache.spark.ml.linalg.JsonMatrixConverter$;
import org.apache.spark.ml.linalg.JsonVectorConverter$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.Param$;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.util.Identifiable;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\u000e\u001d\u0001\u001dB\u0001B\r\u0001\u0003\u0006\u0004%\ta\r\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005i!A\u0001\t\u0001BC\u0002\u0013\u00051\u0007\u0003\u0005B\u0001\t\u0005\t\u0015!\u00035\u0011!\u0011\u0005A!b\u0001\n\u0003\u0019\u0004\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u0011\u0011\u0003!Q1A\u0005\u0002\u0015C\u0001b\u0016\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\u00061\u0002!\t!\u0017\u0005\u00061\u0002!\t\u0001\u0019\u0005\u00061\u0002!\ta\u001b\u0005\u00061\u0002!\ta\u001c\u0005\u0007g\u0002!\t\u0001\b;\t\u000bi\u0004A\u0011A>\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004!9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001bBA\u0007\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003+\u0001\u0001\u0015!\u00035\u0011\u001d\t9\u0002\u0001C#\u00033Aq!a\u0007\u0001\t\u000b\ni\u0002C\u0004\u0002&\u0001!)%a\n\b\u0011\u00055B\u0004#\u0001\u001f\u0003_1qa\u0007\u000f\t\u0002y\t\t\u0004\u0003\u0004Y/\u0011\u0005\u00111\u0007\u0005\b\u0003\u001b9B\u0011AA\u001b\u0011%\tydFA\u0001\n\u0013\t\tEA\u0003QCJ\fWN\u0003\u0002\u001e=\u0005)\u0001/\u0019:b[*\u0011q\u0004I\u0001\u0003[2T!!\t\u0012\u0002\u000bM\u0004\u0018M]6\u000b\u0005\r\"\u0013AB1qC\u000eDWMC\u0001&\u0003\ry'oZ\u0002\u0001+\tA3jE\u0002\u0001S=\u0002\"AK\u0017\u000e\u0003-R\u0011\u0001L\u0001\u0006g\u000e\fG.Y\u0005\u0003]-\u0012a!\u00118z%\u00164\u0007C\u0001\u00161\u0013\t\t4F\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004qCJ,g\u000e^\u000b\u0002iA\u0011Q\u0007\u0010\b\u0003mi\u0002\"aN\u0016\u000e\u0003aR!!\u000f\u0014\u0002\rq\u0012xn\u001c;?\u0013\tY4&\u0001\u0004Qe\u0016$WMZ\u0005\u0003{y\u0012aa\u0015;sS:<'BA\u001e,\u0003\u001d\u0001\u0018M]3oi\u0002\nAA\\1nK\u0006)a.Y7fA\u0005\u0019Am\\2\u0002\t\u0011|7\rI\u0001\bSN4\u0016\r\\5e+\u00051\u0005\u0003\u0002\u0016H\u0013RK!\u0001S\u0016\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001&L\u0019\u0001!Q\u0001\u0014\u0001C\u00025\u0013\u0011\u0001V\t\u0003\u001dF\u0003\"AK(\n\u0005A[#a\u0002(pi\"Lgn\u001a\t\u0003UIK!aU\u0016\u0003\u0007\u0005s\u0017\u0010\u0005\u0002++&\u0011ak\u000b\u0002\b\u0005>|G.Z1o\u0003!I7OV1mS\u0012\u0004\u0013A\u0002\u001fj]&$h\bF\u0003[9vsv\fE\u0002\\\u0001%k\u0011\u0001\b\u0005\u0006e%\u0001\r\u0001\u000e\u0005\u0006\u0001&\u0001\r\u0001\u000e\u0005\u0006\u0005&\u0001\r\u0001\u000e\u0005\u0006\t&\u0001\rA\u0012\u000b\u00065\u0006D\u0017N\u001b\u0005\u0006e)\u0001\rA\u0019\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003Kz\tA!\u001e;jY&\u0011q\r\u001a\u0002\r\u0013\u0012,g\u000e^5gS\u0006\u0014G.\u001a\u0005\u0006\u0001*\u0001\r\u0001\u000e\u0005\u0006\u0005*\u0001\r\u0001\u000e\u0005\u0006\t*\u0001\rA\u0012\u000b\u000552lg\u000eC\u00033\u0017\u0001\u0007A\u0007C\u0003A\u0017\u0001\u0007A\u0007C\u0003C\u0017\u0001\u0007A\u0007\u0006\u0003[aF\u0014\b\"\u0002\u001a\r\u0001\u0004\u0011\u0007\"\u0002!\r\u0001\u0004!\u0004\"\u0002\"\r\u0001\u0004!\u0014\u0001\u0003<bY&$\u0017\r^3\u0015\u0005UD\bC\u0001\u0016w\u0013\t98F\u0001\u0003V]&$\b\"B=\u000e\u0001\u0004I\u0015!\u0002<bYV,\u0017!A<\u0015\u0005q|\bcA.~\u0013&\u0011a\u0010\b\u0002\n!\u0006\u0014\u0018-\u001c)bSJDQ!\u001f\bA\u0002%\u000ba\u0002J7j]V\u001cHe\u001a:fCR,'\u000fF\u0002}\u0003\u000bAQ!_\bA\u0002%\u000b!B[:p]\u0016s7m\u001c3f)\r!\u00141\u0002\u0005\u0006sB\u0001\r!S\u0001\u000bUN|g\u000eR3d_\u0012,GcA%\u0002\u0012!1\u00111C\tA\u0002Q\nAA[:p]\u0006!2\u000f\u001e:j]\u001e\u0014V\r\u001d:fg\u0016tG/\u0019;j_:\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002i\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002 A\u0019!&!\t\n\u0007\u0005\r2FA\u0002J]R\fa!Z9vC2\u001cHc\u0001+\u0002*!1\u00111F\u000bA\u0002E\u000b1a\u001c2k\u0003\u0015\u0001\u0016M]1n!\tYvcE\u0002\u0018S=\"\"!a\f\u0016\t\u0005]\u00121\b\u000b\u0005\u0003s\ti\u0004E\u0002K\u0003w!Q\u0001T\rC\u00025Ca!a\u0005\u001a\u0001\u0004!\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\u0011\u0011\t\u0005\u0015\u0013qJ\u0007\u0003\u0003\u000fRA!!\u0013\u0002L\u0005!A.\u00198h\u0015\t\ti%\u0001\u0003kCZ\f\u0017\u0002BA)\u0003\u000f\u0012aa\u00142kK\u000e$\b")
public class Param<T>
implements Serializable {
    private final String parent;
    private final String name;
    private final String doc;
    private final Function1<T, Object> isValid;
    private final String stringRepresentation;

    public String parent() {
        return this.parent;
    }

    public String name() {
        return this.name;
    }

    public String doc() {
        return this.doc;
    }

    public Function1<T, Object> isValid() {
        return this.isValid;
    }

    public void validate(T value) {
        if (!BoxesRunTime.unboxToBoolean((Object)this.isValid().apply(value))) {
            String string;
            T t = value;
            if (ScalaRunTime$.MODULE$.isArray(t, 1)) {
                T t2 = t;
                string = Predef$.MODULE$.genericArrayOps(t2).mkString("[", ",", "]");
            } else {
                string = value.toString();
            }
            String valueToString = string;
            throw new IllegalArgumentException(new StringBuilder(33).append(this.parent()).append(" parameter ").append(this.name()).append(" given invalid value ").append(valueToString).append(".").toString());
        }
    }

    public ParamPair<T> w(T value) {
        return this.$minus$greater(value);
    }

    public ParamPair<T> $minus$greater(T value) {
        return new ParamPair<T>(this, value);
    }

    public String jsonEncode(T value) {
        String string;
        T t = value;
        if (t instanceof String) {
            String string2 = (String)t;
            JsonAST.JString x$1 = package$.MODULE$.JString().apply(string2);
            Formats x$2 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$1);
            string = JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$1, x$2));
        } else if (t instanceof Vector) {
            T t2 = t;
            string = JsonVectorConverter$.MODULE$.toJson((Vector)t2);
        } else if (t instanceof Matrix) {
            T t3 = t;
            string = JsonMatrixConverter$.MODULE$.toJson((Matrix)t3);
        } else {
            throw new UnsupportedOperationException(new StringBuilder(95).append("The default jsonEncode only supports string, vector and matrix. ").append(this.getClass().getName()).append(" must override jsonEncode for ").append(value.getClass().getName()).append(".").toString());
        }
        return string;
    }

    public T jsonDecode(String json) {
        return Param$.MODULE$.jsonDecode(json);
    }

    public final String toString() {
        return this.stringRepresentation;
    }

    public final int hashCode() {
        return Statics.anyHash((Object)this.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof Param)) return false;
        Param param = (Param)object;
        String string = param.parent();
        String string2 = this.parent();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = param.name();
        String string4 = this.name();
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    public Param(String parent, String name, String doc, Function1<T, Object> isValid) {
        this.parent = parent;
        this.name = name;
        this.doc = doc;
        this.isValid = isValid;
        this.stringRepresentation = new StringBuilder(2).append(parent).append("__").append(name).toString();
    }

    public Param(Identifiable parent, String name, String doc, Function1<T, Object> isValid) {
        this(parent.uid(), name, doc, isValid);
    }

    public Param(String parent, String name, String doc) {
        this(parent, name, doc, ParamValidators$.MODULE$.alwaysTrue());
    }

    public Param(Identifiable parent, String name, String doc) {
        this(parent.uid(), name, doc);
    }
}

