/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.BinaryLogisticRegressionSummaryImpl;
import org.apache.spark.ml.classification.BinaryLogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.LogisticRegressionModel$;
import org.apache.spark.ml.classification.LogisticRegressionModel$LogisticRegressionModelWriter$;
import org.apache.spark.ml.classification.LogisticRegressionModel$LogisticRegressionModelWriter$Data$;
import org.apache.spark.ml.classification.LogisticRegressionParams;
import org.apache.spark.ml.classification.LogisticRegressionSummary;
import org.apache.spark.ml.classification.LogisticRegressionSummaryImpl;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.impl.Utils$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasElasticNetParam;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxBlockSizeInMB;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasThreshold;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.HasTrainingSummary;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.VersionUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r%h\u0001\u0002/^\u0001!D!\"a\u0002\u0001\u0005\u000b\u0007I\u0011IA\u0005\u0011)\t9\u0004\u0001B\u0001B\u0003%\u00111\u0002\u0005\u000b\u0003w\u0001!Q1A\u0005\u0002\u0005u\u0002BCA&\u0001\t\u0005\t\u0015!\u0003\u0002@!Q\u0011q\n\u0001\u0003\u0006\u0004%\t!!\u0015\t\u0013\u0005U\u0003A!A!\u0002\u0013i\u0007BCA-\u0001\t\u0015\r\u0011\"\u0011\u0002\\!Q\u00111\u000e\u0001\u0003\u0002\u0003\u0006I!!\u0018\t\u0015\u0005=\u0004A!b\u0001\n\u0013\t\t\b\u0003\u0006\u0002z\u0001\u0011\t\u0011)A\u0005\u0003gB\u0001\"a\u001f\u0001\t\u0003\t\u0017Q\u0010\u0005\t\u0003w\u0002A\u0011A1\u0002\u0012\"9\u0011q\u0013\u0001\u0005\u0002\u0005E\u0003BCAU\u0001!\u0015\r\u0011\"\u0003\u0002R!9\u00111\u0014\u0001\u0005\u0002\u0005-\u0006BCAX\u0001!\u0015\r\u0011\"\u0003\u0002,\"Q\u0011\u0011\u0017\u0001\t\u0006\u0004%I!a-\t\u0015\u0005m\u0006\u0001#b\u0001\n\u0013\ti\fC\u0004\u0002F\u0002!I!a+\t\u000f\u0005\u001d\u0007\u0001\"\u0003\u0002,\"9\u0011\u0011\u001a\u0001\u0005\n\u0005-\u0007bBAl\u0001\u0011\u0005\u0013\u0011\u001c\u0005\b\u0003O\u0004A\u0011IAV\u0011\u001d\tY\u000f\u0001C!\u0003[Dq!a=\u0001\t\u0003\ni\fC\u0005\u0002x\u0002\u0011\r\u0011\"\u0003\u0002z\"A!\u0011\u0001\u0001!\u0002\u0013\tY\u0010C\u0005\u0003\u0004\u0001\u0011\r\u0011\"\u0003\u0003\u0006!A!\u0011\u0002\u0001!\u0002\u0013\u00119\u0001C\u0005\u0003\f\u0001\u0011\r\u0011\"\u0003\u0002z\"A!Q\u0002\u0001!\u0002\u0013\tY\u0010C\u0005\u0003\u0010\u0001\u0011\r\u0011\"\u0011\u0002\\!A!q\u0003\u0001!\u0002\u0013\ti\u0006C\u0004\u0003\u001c\u0001!\tE!\b\t\u000f\t\u0005\u0002\u0001\"\u0001\u0003$!9!\u0011\u0007\u0001\u0005\u0002\tM\u0002b\u0002B3\u0001\u0011\u0005#q\r\u0005\b\u0005[\u0002A\u0011\u000bB8\u0011\u001d\u0011)\b\u0001C!\u0005oBqA!!\u0001\t\u0003\u0012\u0019\tC\u0004\u0003\u0018\u0002!\tF!'\t\u000f\tu\u0005\u0001\"\u0015\u0003 \"9!Q\u0015\u0001\u0005B\t\u001d\u0006b\u0002BY\u0001\u0011\u0005#1W\u0004\b\u0005ok\u0006\u0012\u0001B]\r\u0019aV\f#\u0001\u0003<\"9\u00111\u0010\u0018\u0005\u0002\t=\u0007b\u0002Bi]\u0011\u0005#1\u001b\u0005\b\u0005;tC\u0011\tBp\r\u001d\u00119O\f\u0001/\u0005SD\u0011Ba>3\u0005\u0003\u0005\u000b\u0011B:\t\u000f\u0005m$\u0007\"\u0001\u0003z\u001a11\u0011\u0001\u001aE\u0007\u0007A!\"!\u00176\u0005+\u0007I\u0011AA.\u0011)\tY'\u000eB\tB\u0003%\u0011Q\f\u0005\u000b\u0005\u001f)$Q3A\u0005\u0002\u0005m\u0003B\u0003B\fk\tE\t\u0015!\u0003\u0002^!Q\u0011qJ\u001b\u0003\u0016\u0004%\t!!\u0015\t\u0013\u0005USG!E!\u0002\u0013i\u0007BCA\u001ek\tU\r\u0011\"\u0001\u0002>!Q\u00111J\u001b\u0003\u0012\u0003\u0006I!a\u0010\t\u0015\u0005=TG!f\u0001\n\u0003\t\t\b\u0003\u0006\u0002zU\u0012\t\u0012)A\u0005\u0003gBq!a\u001f6\t\u0003\u0019Y\u0001C\u0005\u0003\u0002V\n\t\u0011\"\u0001\u0004\u001c!I1qE\u001b\u0012\u0002\u0013\u00051\u0011\u0006\u0005\n\u0007{)\u0014\u0013!C\u0001\u0007SA\u0011ba\u00106#\u0003%\ta!\u0011\t\u0013\r\u0015S'%A\u0005\u0002\r\u001d\u0003\"CB&kE\u0005I\u0011AB'\u0011%\u0019\t&NA\u0001\n\u0003\u001a\u0019\u0006C\u0005\u0004dU\n\t\u0011\"\u0001\u0002\\!I1QM\u001b\u0002\u0002\u0013\u00051q\r\u0005\n\u0007[*\u0014\u0011!C!\u0007_B\u0011b! 6\u0003\u0003%\taa \t\u0013\r\rU'!A\u0005B\r\u0015\u0005\"\u0003BYk\u0005\u0005I\u0011IBD\u0011%\u0019I)NA\u0001\n\u0003\u001aYiB\u0005\u0004\u0010J\n\t\u0011#\u0003\u0004\u0012\u001aI1\u0011\u0001\u001a\u0002\u0002#%11\u0013\u0005\b\u0003w\u0002F\u0011ABQ\u0011%\u0011\t\fUA\u0001\n\u000b\u001a9\tC\u0005\u0004$B\u000b\t\u0011\"!\u0004&\"I1\u0011\u0017)\u0002\u0002\u0013\u000551\u0017\u0005\b\u0007\u000b\u0014D\u0011KBd\r\u0019\u0019YM\f\u0003\u0004N\"9\u00111\u0010,\u0005\u0002\r=\u0007\"CBj-\n\u0007I\u0011BB*\u0011!\u0019)N\u0016Q\u0001\n\rU\u0003b\u0002Bo-\u0012\u00053q\u001b\u0005\n\u00077t\u0013\u0011!C\u0005\u0007;\u0014q\u0003T8hSN$\u0018n\u0019*fOJ,7o]5p]6{G-\u001a7\u000b\u0005y{\u0016AD2mCN\u001c\u0018NZ5dCRLwN\u001c\u0006\u0003A\u0006\f!!\u001c7\u000b\u0005\t\u001c\u0017!B:qCJ\\'B\u00013f\u0003\u0019\t\u0007/Y2iK*\ta-A\u0002pe\u001e\u001c\u0001aE\u0003\u0001SRTX\u0010\u0005\u0003kW6\u001cX\"A/\n\u00051l&\u0001\t)s_\n\f'-\u001b7jgRL7m\u00117bgNLg-[2bi&|g.T8eK2\u0004\"A\\9\u000e\u0003=T!\u0001]0\u0002\r1Lg.\u00197h\u0013\t\u0011xN\u0001\u0004WK\u000e$xN\u001d\t\u0003U\u0002\u0001\"!\u001e=\u000e\u0003YT!a^0\u0002\tU$\u0018\u000e\\\u0005\u0003sZ\u0014!\"\u0014'Xe&$\u0018M\u00197f!\tQ70\u0003\u0002};\nABj\\4jgRL7MU3he\u0016\u001c8/[8o!\u0006\u0014\u0018-\\:\u0011\tUt\u0018\u0011A\u0005\u0003\u007fZ\u0014!\u0003S1t)J\f\u0017N\\5oON+X.\\1ssB\u0019!.a\u0001\n\u0007\u0005\u0015QLA\u0011M_\u001eL7\u000f^5d%\u0016<'/Z:tS>tGK]1j]&twmU;n[\u0006\u0014\u00180A\u0002vS\u0012,\"!a\u0003\u0011\t\u00055\u0011q\u0004\b\u0005\u0003\u001f\tY\u0002\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)bZ\u0001\u0007yI|w\u000e\u001e \u000b\u0005\u0005e\u0011!B:dC2\f\u0017\u0002BA\u000f\u0003/\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0011\u0003G\u0011aa\u0015;sS:<'\u0002BA\u000f\u0003/AS!AA\u0014\u0003g\u0001B!!\u000b\u000205\u0011\u00111\u0006\u0006\u0004\u0003[\t\u0017AC1o]>$\u0018\r^5p]&!\u0011\u0011GA\u0016\u0005\u0015\u0019\u0016N\\2fC\t\t)$A\u00032]Qr\u0003'\u0001\u0003vS\u0012\u0004\u0003&\u0002\u0002\u0002(\u0005M\u0012!E2pK\u001a4\u0017nY5f]Rl\u0015\r\u001e:jqV\u0011\u0011q\b\t\u0004]\u0006\u0005\u0013bAA\"_\n1Q*\u0019;sSbDSaAA\u0014\u0003\u000f\n#!!\u0013\u0002\u000bIr\u0013G\f\u0019\u0002%\r|WM\u001a4jG&,g\u000e^'biJL\u0007\u0010\t\u0015\u0006\t\u0005\u001d\u0012qI\u0001\u0010S:$XM]2faR4Vm\u0019;peV\tQ\u000eK\u0003\u0006\u0003O\t9%\u0001\tj]R,'oY3qiZ+7\r^8sA!*a!a\n\u0002H\u0005Qa.^7DY\u0006\u001c8/Z:\u0016\u0005\u0005u\u0003\u0003BA0\u0003Cj!!a\u0006\n\t\u0005\r\u0014q\u0003\u0002\u0004\u0013:$\b&B\u0004\u0002(\u0005\u001d\u0014EAA5\u0003\u0015\tdf\r\u00181\u0003-qW/\\\"mCN\u001cXm\u001d\u0011)\u000b!\t9#a\u001a\u0002\u001b%\u001cX*\u001e7uS:|W.[1m+\t\t\u0019\b\u0005\u0003\u0002`\u0005U\u0014\u0002BA<\u0003/\u0011qAQ8pY\u0016\fg.\u0001\bjg6+H\u000e^5o_6L\u0017\r\u001c\u0011\u0002\rqJg.\u001b;?)-\u0019\u0018qPAB\u0003\u000f\u000bY)a$\t\u000f\u0005\u001d1\u00021\u0001\u0002\f!2\u0011qPA\u0014\u0003gAq!a\u000f\f\u0001\u0004\ty\u0004\u000b\u0004\u0002\u0004\u0006\u001d\u0012q\t\u0005\u0007\u0003\u001fZ\u0001\u0019A7)\r\u0005\u001d\u0015qEA$\u0011\u001d\tIf\u0003a\u0001\u0003;Bc!a#\u0002(\u0005\u001d\u0004bBA8\u0017\u0001\u0007\u00111\u000f\u000b\bg\u0006M\u0015QSAM\u0011\u001d\t9\u0001\u0004a\u0001\u0003\u0017Aa!a&\r\u0001\u0004i\u0017\u0001D2pK\u001a4\u0017nY5f]R\u001c\bbBAN\u0019\u0001\u0007\u0011QT\u0001\nS:$XM]2faR\u0004B!a\u0018\u0002 &!\u0011\u0011UA\f\u0005\u0019!u.\u001e2mK\"*Q\"a\n\u0002&\u0006\u0012\u0011qU\u0001\u0006e9\u0002d\u0006M\u0001\u000e?\u000e|WM\u001a4jG&,g\u000e^:\u0016\u0005\u0005u\u0005&B\b\u0002(\u0005\u001d\u0014AC0j]R,'oY3qi\u0006\u0001r,\u001b8uKJ\u001cW\r\u001d;WK\u000e$xN]\u000b\u0003\u0003k\u00032A\\A\\\u0013\r\tIl\u001c\u0002\f\t\u0016t7/\u001a,fGR|'/A\u000b`E&t\u0017M]=UQJ,7\u000f[8mI\u0006\u0013(/Y=\u0016\u0005\u0005}\u0006CBA0\u0003\u0003\fi*\u0003\u0003\u0002D\u0006]!!B!se\u0006L\u0018AC0uQJ,7\u000f[8mI\u0006iqL]1x)\"\u0014Xm\u001d5pY\u0012\fa#\u001e9eCR,')\u001b8bef$\u0006N]3tQ>dGm\u001d\u000b\u0005\u0003\u001b\f\u0019\u000e\u0005\u0003\u0002`\u0005=\u0017\u0002BAi\u0003/\u0011A!\u00168ji\"9\u0011Q[\u000bA\u0002\u0005}\u0016!B1se\u0006L\u0018\u0001D:fiRC'/Z:i_2$G\u0003BAn\u0003;l\u0011\u0001\u0001\u0005\b\u0003?4\u0002\u0019AAO\u0003\u00151\u0018\r\\;fQ\u00151\u0012qEArC\t\t)/A\u00032]Ur\u0003'\u0001\u0007hKR$\u0006N]3tQ>dG\rK\u0003\u0018\u0003O\t\u0019/A\u0007tKR$\u0006N]3tQ>dGm\u001d\u000b\u0005\u00037\fy\u000fC\u0004\u0002`b\u0001\r!a0)\u000ba\t9#a9\u0002\u001b\u001d,G\u000f\u00165sKNDw\u000e\u001c3tQ\u0015I\u0012qEAr\u0003\u0019i\u0017M]4j]V\u0011\u00111 \t\b\u0003?\ni0\\AO\u0013\u0011\ty0a\u0006\u0003\u0013\u0019+hn\u0019;j_:\f\u0014aB7be\u001eLg\u000eI\u0001\b[\u0006\u0014x-\u001b8t+\t\u00119\u0001\u0005\u0004\u0002`\u0005uX.\\\u0001\t[\u0006\u0014x-\u001b8tA\u0005)1oY8sK\u000611oY8sK\u0002\n1B\\;n\r\u0016\fG/\u001e:fg\"*\u0001%a\n\u0003\u0014\u0005\u0012!QC\u0001\u0006c92d\u0006M\u0001\r]Vlg)Z1ukJ,7\u000f\t\u0015\u0006C\u0005\u001d\"1C\u0001\bgVlW.\u0019:z+\t\t\t\u0001K\u0003#\u0003O\t\u0019/A\u0007cS:\f'/_*v[6\f'/_\u000b\u0003\u0005K\u00012A\u001bB\u0014\u0013\r\u0011I#\u0018\u0002(\u0005&t\u0017M]=M_\u001eL7\u000f^5d%\u0016<'/Z:tS>tGK]1j]&twmU;n[\u0006\u0014\u0018\u0010K\u0003$\u0003O\u0011i#\t\u0002\u00030\u0005)!GL\u001a/a\u0005AQM^1mk\u0006$X\r\u0006\u0003\u00036\tm\u0002c\u00016\u00038%\u0019!\u0011H/\u000331{w-[:uS\u000e\u0014Vm\u001a:fgNLwN\\*v[6\f'/\u001f\u0005\b\u0005{!\u0003\u0019\u0001B \u0003\u001d!\u0017\r^1tKR\u0004DA!\u0011\u0003RA1!1\tB%\u0005\u001bj!A!\u0012\u000b\u0007\t\u001d\u0013-A\u0002tc2LAAa\u0013\u0003F\t9A)\u0019;bg\u0016$\b\u0003\u0002B(\u0005#b\u0001\u0001\u0002\u0007\u0003T\tm\u0012\u0011!A\u0001\u0006\u0003\u0011)FA\u0002`IM\nBAa\u0016\u0003^A!\u0011q\fB-\u0013\u0011\u0011Y&a\u0006\u0003\u000f9{G\u000f[5oOB!\u0011q\fB0\u0013\u0011\u0011\t'a\u0006\u0003\u0007\u0005s\u0017\u0010K\u0003%\u0003O\t)+A\u0004qe\u0016$\u0017n\u0019;\u0015\t\u0005u%\u0011\u000e\u0005\u0007\u0005W*\u0003\u0019A7\u0002\u0011\u0019,\u0017\r^;sKN\faC]1xeA\u0014xNY1cS2LG/_%o!2\f7-\u001a\u000b\u0004[\nE\u0004B\u0002B:M\u0001\u0007Q.A\u0007sC^\u0004&/\u001a3jGRLwN\\\u0001\u000baJ,G-[2u%\u0006<HcA7\u0003z!1!1N\u0014A\u00025DSaJA\u0014\u0005{\n#Aa \u0002\u000bMr\u0003G\f\u0019\u0002\t\r|\u0007/\u001f\u000b\u0004g\n\u0015\u0005b\u0002BDQ\u0001\u0007!\u0011R\u0001\u0006Kb$(/\u0019\t\u0005\u0005\u0017\u0013\t*\u0004\u0002\u0003\u000e*\u0019!qR0\u0002\u000bA\f'/Y7\n\t\tM%Q\u0012\u0002\t!\u0006\u0014\u0018-\\'ba\"*\u0001&a\n\u00024\u0005q!/Y<3aJ,G-[2uS>tG\u0003BAO\u00057CaAa\u001d*\u0001\u0004i\u0017A\u00069s_\n\f'-\u001b7jif\u0014\u0004O]3eS\u000e$\u0018n\u001c8\u0015\t\u0005u%\u0011\u0015\u0005\u0007\u0005GS\u0003\u0019A7\u0002\u0017A\u0014xNY1cS2LG/_\u0001\u0006oJLG/Z\u000b\u0003\u0005S\u00032!\u001eBV\u0013\r\u0011iK\u001e\u0002\t\u001b2;&/\u001b;fe\"*1&a\n\u0003\u0014\u0005AAo\\*ue&tw\r\u0006\u0002\u0002\f!*\u0001!a\n\u00024\u00059Bj\\4jgRL7MU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\t\u0003U:\u001arA\fB_\u0005\u0007\u0014I\r\u0005\u0003\u0002`\t}\u0016\u0002\u0002Ba\u0003/\u0011a!\u00118z%\u00164\u0007\u0003B;\u0003FNL1Aa2w\u0005)iEJU3bI\u0006\u0014G.\u001a\t\u0005\u0003?\u0012Y-\u0003\u0003\u0003N\u0006]!\u0001D*fe&\fG.\u001b>bE2,GC\u0001B]\u0003\u0011\u0011X-\u00193\u0016\u0005\tU\u0007\u0003B;\u0003XNL1A!7w\u0005!iEJU3bI\u0016\u0014\b&\u0002\u0019\u0002(\tM\u0011\u0001\u00027pC\u0012$2a\u001dBq\u0011\u001d\u0011\u0019/\ra\u0001\u0003\u0017\tA\u0001]1uQ\"*\u0011'a\n\u0003\u0014\tiBj\\4jgRL7MU3he\u0016\u001c8/[8o\u001b>$W\r\\,sSR,'oE\u00033\u0005S\u0013Y\u000f\u0005\u0003\u0003n\nMXB\u0001Bx\u0015\r\u0011\t0Y\u0001\tS:$XM\u001d8bY&!!Q\u001fBx\u0005\u001daunZ4j]\u001e\f\u0001\"\u001b8ti\u0006t7-\u001a\u000b\u0005\u0005w\u0014y\u0010E\u0002\u0003~Jj\u0011A\f\u0005\u0007\u0005o$\u0004\u0019A:\u0003\t\u0011\u000bG/Y\n\bk\tu6Q\u0001Be!\u0011\tyfa\u0002\n\t\r%\u0011q\u0003\u0002\b!J|G-^2u)1\u0019ia!\u0005\u0004\u0014\rU1qCB\r!\r\u0019y!N\u0007\u0002e!9\u0011\u0011\f!A\u0002\u0005u\u0003b\u0002B\b\u0001\u0002\u0007\u0011Q\f\u0005\u0007\u0003\u001f\u0002\u0005\u0019A7\t\u000f\u0005m\u0002\t1\u0001\u0002@!9\u0011q\u000e!A\u0002\u0005MD\u0003DB\u0007\u0007;\u0019yb!\t\u0004$\r\u0015\u0002\"CA-\u0003B\u0005\t\u0019AA/\u0011%\u0011y!\u0011I\u0001\u0002\u0004\ti\u0006\u0003\u0005\u0002P\u0005\u0003\n\u00111\u0001n\u0011%\tY$\u0011I\u0001\u0002\u0004\ty\u0004C\u0005\u0002p\u0005\u0003\n\u00111\u0001\u0002t\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAB\u0016U\u0011\tif!\f,\u0005\r=\u0002\u0003BB\u0019\u0007si!aa\r\u000b\t\rU2qG\u0001\nk:\u001c\u0007.Z2lK\u0012TA!!\f\u0002\u0018%!11HB\u001a\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"aa\u0011+\u00075\u001ci#\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r%#\u0006BA \u0007[\tabY8qs\u0012\"WMZ1vYR$S'\u0006\u0002\u0004P)\"\u00111OB\u0017\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u00111Q\u000b\t\u0005\u0007/\u001a\t'\u0004\u0002\u0004Z)!11LB/\u0003\u0011a\u0017M\\4\u000b\u0005\r}\u0013\u0001\u00026bm\u0006LA!!\t\u0004Z\u0005a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B/\u0007SB\u0011ba\u001bJ\u0003\u0003\u0005\r!!\u0018\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0019\t\b\u0005\u0004\u0004t\re$QL\u0007\u0003\u0007kRAaa\u001e\u0002\u0018\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\rm4Q\u000f\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002t\r\u0005\u0005\"CB6\u0017\u0006\u0005\t\u0019\u0001B/\u0003!A\u0017m\u001d5D_\u0012,GCAA/)\t\u0019)&\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003g\u001ai\tC\u0005\u0004l9\u000b\t\u00111\u0001\u0003^\u0005!A)\u0019;b!\r\u0019y\u0001U\n\u0006!\u000eU%\u0011\u001a\t\u0010\u0007/\u001bi*!\u0018\u0002^5\fy$a\u001d\u0004\u000e5\u00111\u0011\u0014\u0006\u0005\u00077\u000b9\"A\u0004sk:$\u0018.\\3\n\t\r}5\u0011\u0014\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:,DCABI\u0003\u0015\t\u0007\u000f\u001d7z)1\u0019iaa*\u0004*\u000e-6QVBX\u0011\u001d\tIf\u0015a\u0001\u0003;BqAa\u0004T\u0001\u0004\ti\u0006\u0003\u0004\u0002PM\u0003\r!\u001c\u0005\b\u0003w\u0019\u0006\u0019AA \u0011\u001d\tyg\u0015a\u0001\u0003g\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u00046\u000e\u0005\u0007CBA0\u0007o\u001bY,\u0003\u0003\u0004:\u0006]!AB(qi&|g\u000eE\u0007\u0002`\ru\u0016QLA/[\u0006}\u00121O\u0005\u0005\u0007\u007f\u000b9B\u0001\u0004UkBdW-\u000e\u0005\n\u0007\u0007$\u0016\u0011!a\u0001\u0007\u001b\t1\u0001\u001f\u00131\u0003!\u0019\u0018M^3J[BdG\u0003BAg\u0007\u0013DqAa9V\u0001\u0004\tYAA\u000fM_\u001eL7\u000f^5d%\u0016<'/Z:tS>tWj\u001c3fYJ+\u0017\rZ3s'\r1&Q\u001b\u000b\u0003\u0007#\u00042A!@W\u0003%\u0019G.Y:t\u001d\u0006lW-\u0001\u0006dY\u0006\u001c8OT1nK\u0002\"2a]Bm\u0011\u001d\u0011\u0019O\u0017a\u0001\u0003\u0017\t1B]3bIJ+7o\u001c7wKR\u00111q\u001c\t\u0005\u0007/\u001a\t/\u0003\u0003\u0004d\u000ee#AB(cU\u0016\u001cG\u000fK\u0003/\u0003O\u0011\u0019\u0002K\u0003.\u0003O\u0011\u0019\u0002")
public class LogisticRegressionModel
extends ProbabilisticClassificationModel<Vector, LogisticRegressionModel>
implements MLWritable,
LogisticRegressionParams,
HasTrainingSummary<LogisticRegressionTrainingSummary> {
    private Vector _coefficients;
    private double _intercept;
    private DenseVector _interceptVector;
    private double[] _binaryThresholdArray;
    private final String uid;
    private final Matrix coefficientMatrix;
    private final Vector interceptVector;
    private final int numClasses;
    private final boolean org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial;
    private final Function1<Vector, Object> margin;
    private final Function1<Vector, Vector> margins;
    private final Function1<Vector, Object> score;
    private final int numFeatures;
    private Option<LogisticRegressionTrainingSummary> trainingSummary;
    private final Param<String> family;
    private final Param<Matrix> lowerBoundsOnCoefficients;
    private final Param<Matrix> upperBoundsOnCoefficients;
    private final Param<Vector> lowerBoundsOnIntercepts;
    private final Param<Vector> upperBoundsOnIntercepts;
    private final DoubleParam maxBlockSizeInMB;
    private final IntParam aggregationDepth;
    private final DoubleParam threshold;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final DoubleParam tol;
    private final BooleanParam fitIntercept;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;
    private volatile byte bitmap$0;

    public static LogisticRegressionModel load(String string) {
        return LogisticRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<LogisticRegressionModel> read() {
        return LogisticRegressionModel$.MODULE$.read();
    }

    @Override
    public boolean hasSummary() {
        return HasTrainingSummary.hasSummary$(this);
    }

    @Override
    public HasTrainingSummary<LogisticRegressionTrainingSummary> setSummary(Option<LogisticRegressionTrainingSummary> summary) {
        return HasTrainingSummary.setSummary$(this, summary);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$classification$LogisticRegressionParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public String getFamily() {
        return LogisticRegressionParams.getFamily$(this);
    }

    @Override
    public void checkThresholdConsistency() {
        LogisticRegressionParams.checkThresholdConsistency$(this);
    }

    @Override
    public Matrix getLowerBoundsOnCoefficients() {
        return LogisticRegressionParams.getLowerBoundsOnCoefficients$(this);
    }

    @Override
    public Matrix getUpperBoundsOnCoefficients() {
        return LogisticRegressionParams.getUpperBoundsOnCoefficients$(this);
    }

    @Override
    public Vector getLowerBoundsOnIntercepts() {
        return LogisticRegressionParams.getLowerBoundsOnIntercepts$(this);
    }

    @Override
    public Vector getUpperBoundsOnIntercepts() {
        return LogisticRegressionParams.getUpperBoundsOnIntercepts$(this);
    }

    @Override
    public boolean usingBoundConstrainedOptimization() {
        return LogisticRegressionParams.usingBoundConstrainedOptimization$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return LogisticRegressionParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final double getMaxBlockSizeInMB() {
        return HasMaxBlockSizeInMB.getMaxBlockSizeInMB$(this);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization.getStandardization$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam.getElasticNetParam$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final Option<LogisticRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    @Override
    public final void trainingSummary_$eq(Option<LogisticRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    @Override
    public final Param<String> family() {
        return this.family;
    }

    @Override
    public Param<Matrix> lowerBoundsOnCoefficients() {
        return this.lowerBoundsOnCoefficients;
    }

    @Override
    public Param<Matrix> upperBoundsOnCoefficients() {
        return this.upperBoundsOnCoefficients;
    }

    @Override
    public Param<Vector> lowerBoundsOnIntercepts() {
        return this.lowerBoundsOnIntercepts;
    }

    @Override
    public Param<Vector> upperBoundsOnIntercepts() {
        return this.upperBoundsOnIntercepts;
    }

    @Override
    public final void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$family_$eq(Param<String> x$1) {
        this.family = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnCoefficients_$eq(Param<Matrix> x$1) {
        this.lowerBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnCoefficients_$eq(Param<Matrix> x$1) {
        this.upperBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnIntercepts_$eq(Param<Vector> x$1) {
        this.lowerBoundsOnIntercepts = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnIntercepts_$eq(Param<Vector> x$1) {
        this.upperBoundsOnIntercepts = x$1;
    }

    @Override
    public final DoubleParam maxBlockSizeInMB() {
        return this.maxBlockSizeInMB;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxBlockSizeInMB$_setter_$maxBlockSizeInMB_$eq(DoubleParam x$1) {
        this.maxBlockSizeInMB = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Matrix coefficientMatrix() {
        return this.coefficientMatrix;
    }

    public Vector interceptVector() {
        return this.interceptVector;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    public boolean org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial() {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial;
    }

    public Vector coefficients() {
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            throw new SparkException("Multinomial models contain a matrix of coefficients, use coefficientMatrix instead.");
        }
        return this._coefficients();
    }

    private Vector _coefficients$lzycompute() {
        LogisticRegressionModel logisticRegressionModel = this;
        synchronized (logisticRegressionModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Vector vector;
                Predef$.MODULE$.require(this.coefficientMatrix().isTransposed(), (Function0 & Serializable & scala.Serializable)() -> "LogisticRegressionModel coefficients should be row major for binomial model.");
                Matrix matrix = this.coefficientMatrix();
                if (matrix instanceof DenseMatrix) {
                    DenseMatrix denseMatrix = (DenseMatrix)matrix;
                    vector = Vectors$.MODULE$.dense(denseMatrix.values());
                } else if (matrix instanceof SparseMatrix) {
                    SparseMatrix sparseMatrix = (SparseMatrix)matrix;
                    vector = Vectors$.MODULE$.sparse(this.coefficientMatrix().numCols(), sparseMatrix.rowIndices(), sparseMatrix.values());
                } else {
                    throw new MatchError((Object)matrix);
                }
                this._coefficients = vector;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this._coefficients;
    }

    private Vector _coefficients() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this._coefficients$lzycompute() : this._coefficients;
    }

    public double intercept() {
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            throw new SparkException("Multinomial models contain a vector of intercepts, use interceptVector instead.");
        }
        return this._intercept();
    }

    private double _intercept$lzycompute() {
        LogisticRegressionModel logisticRegressionModel = this;
        synchronized (logisticRegressionModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this._intercept = this.interceptVector().apply(0);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this._intercept;
    }

    private double _intercept() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this._intercept$lzycompute() : this._intercept;
    }

    private DenseVector _interceptVector$lzycompute() {
        LogisticRegressionModel logisticRegressionModel = this;
        synchronized (logisticRegressionModel) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this._interceptVector = this.interceptVector().toDense();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this._interceptVector;
    }

    private DenseVector _interceptVector() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this._interceptVector$lzycompute() : this._interceptVector;
    }

    /*
     * WARNING - void declaration
     */
    private double[] _binaryThresholdArray$lzycompute() {
        LogisticRegressionModel logisticRegressionModel = this;
        synchronized (logisticRegressionModel) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                void var2_2;
                double[] array = new double[]{Double.NaN, Double.NaN};
                this.updateBinaryThresholds(array);
                this._binaryThresholdArray = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this._binaryThresholdArray;
    }

    private double[] _binaryThresholdArray() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this._binaryThresholdArray$lzycompute() : this._binaryThresholdArray;
    }

    private double _threshold() {
        return this._binaryThresholdArray()[0];
    }

    private double _rawThreshold() {
        return this._binaryThresholdArray()[1];
    }

    private void updateBinaryThresholds(double[] array) {
        block0: {
            double _threshold;
            if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) break block0;
            array[0] = _threshold = this.getThreshold();
            array[1] = _threshold == 0.0 ? Double.NEGATIVE_INFINITY : (_threshold == 1.0 ? Double.POSITIVE_INFINITY : scala.math.package$.MODULE$.log(_threshold / (1.0 - _threshold)));
        }
    }

    @Override
    public LogisticRegressionModel setThreshold(double value) {
        LogisticRegressionParams.setThreshold$(this, value);
        this.updateBinaryThresholds(this._binaryThresholdArray());
        return this;
    }

    @Override
    public double getThreshold() {
        return LogisticRegressionParams.getThreshold$(this);
    }

    @Override
    public LogisticRegressionModel setThresholds(double[] value) {
        LogisticRegressionParams.setThresholds$(this, value);
        this.updateBinaryThresholds(this._binaryThresholdArray());
        return this;
    }

    @Override
    public double[] getThresholds() {
        return LogisticRegressionParams.getThresholds$(this);
    }

    private Function1<Vector, Object> margin() {
        return this.margin;
    }

    private Function1<Vector, Vector> margins() {
        return this.margins;
    }

    private Function1<Vector, Object> score() {
        return this.score;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public LogisticRegressionTrainingSummary summary() {
        return (LogisticRegressionTrainingSummary)HasTrainingSummary.summary$(this);
    }

    public BinaryLogisticRegressionTrainingSummary binarySummary() {
        BinaryLogisticRegressionTrainingSummary binaryLogisticRegressionTrainingSummary;
        LogisticRegressionTrainingSummary logisticRegressionTrainingSummary = this.summary();
        if (!(logisticRegressionTrainingSummary instanceof BinaryLogisticRegressionTrainingSummary)) {
            throw new RuntimeException(new StringBuilder(88).append("Cannot create a binary summary for a non-binary model").append("(numClasses=").append(this.numClasses()).append("), use summary instead.").toString());
        }
        BinaryLogisticRegressionTrainingSummary binaryLogisticRegressionTrainingSummary2 = binaryLogisticRegressionTrainingSummary = (BinaryLogisticRegressionTrainingSummary)logisticRegressionTrainingSummary;
        return binaryLogisticRegressionTrainingSummary2;
    }

    public LogisticRegressionSummary evaluate(Dataset<?> dataset) {
        String weightColName = !this.isDefined(this.weightCol()) ? "weightCol" : this.$(this.weightCol());
        Tuple3 tuple3 = this.findSummaryModel();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        ProbabilisticClassificationModel summaryModel = (ProbabilisticClassificationModel)tuple3._1();
        String probabilityColName = (String)tuple3._2();
        String predictionColName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)summaryModel, (Object)probabilityColName, (Object)predictionColName);
        Tuple3 tuple33 = tuple32;
        ProbabilisticClassificationModel summaryModel2 = (ProbabilisticClassificationModel)tuple33._1();
        String probabilityColName2 = (String)tuple33._2();
        String predictionColName2 = (String)tuple33._3();
        return this.numClasses() > 2 ? new LogisticRegressionSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), weightColName) : new BinaryLogisticRegressionSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), weightColName);
    }

    @Override
    public double predict(Vector features) {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial() ? super.predict(features) : (BoxesRunTime.unboxToDouble((Object)this.score().apply((Object)features)) > this._threshold() ? 1.0 : 0.0);
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        DenseVector denseVector;
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            denseVector = (DenseVector)vector;
            double[] values = denseVector.values();
            if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
                Utils$.MODULE$.softmax(values);
            } else {
                values[0] = 1.0 / (1.0 + scala.math.package$.MODULE$.exp(-values[0]));
                values[1] = 1.0 - values[0];
            }
        } else {
            if (vector instanceof SparseVector) {
                throw new RuntimeException("Unexpected error in LogisticRegressionModel: raw2probabilitiesInPlace encountered SparseVector");
            }
            throw new MatchError((Object)vector);
        }
        DenseVector denseVector2 = denseVector;
        return denseVector2;
    }

    @Override
    public Vector predictRaw(Vector features) {
        Vector vector;
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            vector = (Vector)this.margins().apply((Object)features);
        } else {
            double m = BoxesRunTime.unboxToDouble((Object)this.margin().apply((Object)features));
            vector = Vectors$.MODULE$.dense(-m, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{m}));
        }
        return vector;
    }

    @Override
    public LogisticRegressionModel copy(ParamMap extra) {
        LogisticRegressionModel newModel = this.copyValues(new LogisticRegressionModel(this.uid(), this.coefficientMatrix(), this.interceptVector(), this.numClasses(), this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()), extra);
        return (LogisticRegressionModel)((Model)((Object)newModel.setSummary(this.trainingSummary()))).setParent(this.parent());
    }

    @Override
    public double raw2prediction(Vector rawPrediction) {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial() ? super.raw2prediction(rawPrediction) : (rawPrediction.apply(1) > this._rawThreshold() ? 1.0 : 0.0);
    }

    @Override
    public double probability2prediction(Vector probability) {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial() ? super.probability2prediction(probability) : (probability.apply(1) > this._threshold() ? 1.0 : 0.0);
    }

    @Override
    public MLWriter write() {
        return new LogisticRegressionModelWriter(this);
    }

    @Override
    public String toString() {
        return new StringBuilder(56).append("LogisticRegressionModel: uid=").append(this.uid()).append(", numClasses=").append(this.numClasses()).append(", numFeatures=").append(this.numFeatures()).toString();
    }

    public static final /* synthetic */ double $anonfun$margin$1(LogisticRegressionModel $this, Vector features) {
        return BLAS$.MODULE$.dot(features, $this._coefficients()) + $this._intercept();
    }

    public static final /* synthetic */ double $anonfun$score$1(LogisticRegressionModel $this, Vector features) {
        double m = BoxesRunTime.unboxToDouble((Object)$this.margin().apply((Object)features));
        return 1.0 / (1.0 + scala.math.package$.MODULE$.exp(-m));
    }

    public LogisticRegressionModel(String uid, Matrix coefficientMatrix, Vector interceptVector, int numClasses, boolean isMultinomial) {
        this.uid = uid;
        this.coefficientMatrix = coefficientMatrix;
        this.interceptVector = interceptVector;
        this.numClasses = numClasses;
        this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial = isMultinomial;
        MLWritable.$init$(this);
        HasRegParam.$init$(this);
        HasElasticNetParam.$init$(this);
        HasMaxIter.$init$(this);
        HasFitIntercept.$init$(this);
        HasTol.$init$(this);
        HasStandardization.$init$(this);
        HasWeightCol.$init$(this);
        HasThreshold.$init$(this);
        HasAggregationDepth.$init$(this);
        HasMaxBlockSizeInMB.$init$(this);
        LogisticRegressionParams.$init$(this);
        HasTrainingSummary.$init$(this);
        Predef$.MODULE$.require(coefficientMatrix.numRows() == interceptVector.size(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(88).append("Dimension mismatch! Expected ").append("coefficientMatrix.numRows == interceptVector.size, but ").append(this.coefficientMatrix().numRows()).append(" != ").append(this.interceptVector().size()).toString());
        this.margin = (Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)LogisticRegressionModel.$anonfun$margin$1(this, features));
        this.margins = (Function1 & Serializable & scala.Serializable)features -> {
            void var2_2;
            DenseVector m = this._interceptVector().copy();
            BLAS$.MODULE$.gemv(1.0, this.coefficientMatrix(), features, 1.0, m);
            return var2_2;
        };
        this.score = (Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)LogisticRegressionModel.$anonfun$score$1(this, features));
        this.numFeatures = coefficientMatrix.numCols();
    }

    public LogisticRegressionModel(String uid, Vector coefficients, double intercept) {
        this(uid, (Matrix)new DenseMatrix(1, coefficients.size(), coefficients.toArray(), true), Vectors$.MODULE$.dense(intercept, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), 2, false);
    }

    private static class LogisticRegressionModelReader
    extends MLReader<LogisticRegressionModel> {
        private final String className = LogisticRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public LogisticRegressionModel load(String path) {
            LogisticRegressionModel logisticRegressionModel;
            DefaultParamsReader.Metadata metadata;
            block10: {
                Matrix matrix;
                Vector vector;
                int n;
                int n2;
                Object isMultinomial;
                block12: {
                    Row row;
                    block11: {
                        Dataset data;
                        block7: {
                            double d;
                            int n3;
                            int n4;
                            Object coefficients;
                            block9: {
                                Row row2;
                                block8: {
                                    metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
                                    Tuple2 tuple2 = VersionUtils$.MODULE$.majorMinorVersion(metadata.sparkVersion());
                                    if (tuple2 == null) {
                                        throw new MatchError((Object)tuple2);
                                    }
                                    int major = tuple2._1$mcI$sp();
                                    int minor = tuple2._2$mcI$sp();
                                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(major, minor);
                                    Tuple2.mcII.sp sp3 = sp2;
                                    int major2 = sp3._1$mcI$sp();
                                    int minor2 = sp3._2$mcI$sp();
                                    String dataPath = new Path(path, "data").toString();
                                    data = this.sparkSession().read().format("parquet").load(dataPath);
                                    if (major2 >= 2 && (major2 != 2 || minor2 != 0)) break block7;
                                    row2 = (Row)MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).select("numClasses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numFeatures", "intercept", "coefficients"})).head();
                                    Some some = Row$.MODULE$.unapplySeq(row2);
                                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(4) != 0) break block8;
                                    Object numClasses = ((SeqLike)some.get()).apply(0);
                                    Object numFeatures = ((SeqLike)some.get()).apply(1);
                                    Object intercept = ((SeqLike)some.get()).apply(2);
                                    coefficients = ((SeqLike)some.get()).apply(3);
                                    if (!(numClasses instanceof Integer)) break block8;
                                    n4 = BoxesRunTime.unboxToInt((Object)numClasses);
                                    if (!(numFeatures instanceof Integer)) break block8;
                                    n3 = BoxesRunTime.unboxToInt((Object)numFeatures);
                                    if (!(intercept instanceof Double)) break block8;
                                    d = BoxesRunTime.unboxToDouble((Object)intercept);
                                    if (coefficients instanceof Vector) break block9;
                                }
                                throw new MatchError((Object)row2);
                            }
                            Vector vector2 = (Vector)coefficients;
                            Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)n4), (Object)BoxesRunTime.boxToInteger((int)n3), (Object)BoxesRunTime.boxToDouble((double)d), (Object)vector2);
                            Tuple4 tuple42 = tuple4;
                            int numClasses = BoxesRunTime.unboxToInt((Object)tuple42._1());
                            int numFeatures = BoxesRunTime.unboxToInt((Object)tuple42._2());
                            double intercept = BoxesRunTime.unboxToDouble((Object)tuple42._3());
                            Vector coefficients2 = (Vector)tuple42._4();
                            DenseMatrix coefficientMatrix = new DenseMatrix(1, coefficients2.size(), coefficients2.toArray(), true);
                            Vector interceptVector = Vectors$.MODULE$.dense(intercept, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
                            logisticRegressionModel = new LogisticRegressionModel(metadata.uid(), (Matrix)coefficientMatrix, interceptVector, numClasses, false);
                            break block10;
                        }
                        row = (Row)data.select("numClasses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numFeatures", "interceptVector", "coefficientMatrix", "isMultinomial"})).head();
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(5) != 0) break block11;
                        Object numClasses = ((SeqLike)some.get()).apply(0);
                        Object numFeatures = ((SeqLike)some.get()).apply(1);
                        Object interceptVector = ((SeqLike)some.get()).apply(2);
                        Object coefficientMatrix = ((SeqLike)some.get()).apply(3);
                        isMultinomial = ((SeqLike)some.get()).apply(4);
                        if (!(numClasses instanceof Integer)) break block11;
                        n2 = BoxesRunTime.unboxToInt((Object)numClasses);
                        if (!(numFeatures instanceof Integer)) break block11;
                        n = BoxesRunTime.unboxToInt((Object)numFeatures);
                        if (!(interceptVector instanceof Vector)) break block11;
                        vector = (Vector)interceptVector;
                        if (!(coefficientMatrix instanceof Matrix)) break block11;
                        matrix = (Matrix)coefficientMatrix;
                        if (isMultinomial instanceof Boolean) break block12;
                    }
                    throw new MatchError((Object)row);
                }
                boolean bl = BoxesRunTime.unboxToBoolean((Object)isMultinomial);
                Tuple5 tuple5 = new Tuple5((Object)BoxesRunTime.boxToInteger((int)n2), (Object)BoxesRunTime.boxToInteger((int)n), (Object)vector, (Object)matrix, (Object)BoxesRunTime.boxToBoolean((boolean)bl));
                Tuple5 tuple52 = tuple5;
                int numClasses = BoxesRunTime.unboxToInt((Object)tuple52._1());
                int numFeatures = BoxesRunTime.unboxToInt((Object)tuple52._2());
                Vector interceptVector = (Vector)tuple52._3();
                Matrix coefficientMatrix = (Matrix)tuple52._4();
                boolean isMultinomial2 = BoxesRunTime.unboxToBoolean((Object)tuple52._5());
                logisticRegressionModel = new LogisticRegressionModel(metadata.uid(), coefficientMatrix, interceptVector, numClasses, isMultinomial2);
            }
            LogisticRegressionModel model = logisticRegressionModel;
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class LogisticRegressionModelWriter
    extends MLWriter {
        private volatile LogisticRegressionModel$LogisticRegressionModelWriter$Data$ Data$module;
        private final LogisticRegressionModel instance;

        private LogisticRegressionModel$LogisticRegressionModelWriter$Data$ Data() {
            if (this.Data$module == null) {
                this.Data$lzycompute$1();
            }
            return this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = new Data(this, this.instance.numClasses(), this.instance.numFeatures(), this.instance.interceptVector(), this.instance.coefficientMatrix(), this.instance.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LogisticRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.LogisticRegressionModel.LogisticRegressionModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.LogisticRegressionModel.LogisticRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1(LogisticRegressionModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)new .colon.colon((Object)data, (List)Nil$.MODULE$), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1(null))).repartition(1).write().parquet(dataPath);
        }

        private final void Data$lzycompute$1() {
            LogisticRegressionModelWriter logisticRegressionModelWriter = this;
            synchronized (logisticRegressionModelWriter) {
                if (this.Data$module == null) {
                    this.Data$module = new LogisticRegressionModel$LogisticRegressionModelWriter$Data$(this);
                }
            }
        }

        public LogisticRegressionModelWriter(LogisticRegressionModel instance) {
            this.instance = instance;
        }

        private class Data
        implements Product,
        scala.Serializable {
            private final int numClasses;
            private final int numFeatures;
            private final Vector interceptVector;
            private final Matrix coefficientMatrix;
            private final boolean isMultinomial;
            public final /* synthetic */ LogisticRegressionModelWriter $outer;

            public int numClasses() {
                return this.numClasses;
            }

            public int numFeatures() {
                return this.numFeatures;
            }

            public Vector interceptVector() {
                return this.interceptVector;
            }

            public Matrix coefficientMatrix() {
                return this.coefficientMatrix;
            }

            public boolean isMultinomial() {
                return this.isMultinomial;
            }

            public Data copy(int numClasses, int numFeatures, Vector interceptVector, Matrix coefficientMatrix, boolean isMultinomial) {
                return new Data(this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer(), numClasses, numFeatures, interceptVector, coefficientMatrix, isMultinomial);
            }

            public int copy$default$1() {
                return this.numClasses();
            }

            public int copy$default$2() {
                return this.numFeatures();
            }

            public Vector copy$default$3() {
                return this.interceptVector();
            }

            public Matrix copy$default$4() {
                return this.coefficientMatrix();
            }

            public boolean copy$default$5() {
                return this.isMultinomial();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 5;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    case 0: {
                        object = BoxesRunTime.boxToInteger((int)this.numClasses());
                        break;
                    }
                    case 1: {
                        object = BoxesRunTime.boxToInteger((int)this.numFeatures());
                        break;
                    }
                    case 2: {
                        object = this.interceptVector();
                        break;
                    }
                    case 3: {
                        object = this.coefficientMatrix();
                        break;
                    }
                    case 4: {
                        object = BoxesRunTime.boxToBoolean((boolean)this.isMultinomial());
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(Integer.toString(x$1));
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.numClasses());
                n = Statics.mix((int)n, (int)this.numFeatures());
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.interceptVector()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficientMatrix()));
                n = Statics.mix((int)n, (int)(this.isMultinomial() ? 1231 : 1237));
                return Statics.finalizeHash((int)n, (int)5);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                if (((Data)object).org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer() != this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.numClasses() != data.numClasses()) return false;
                if (this.numFeatures() != data.numFeatures()) return false;
                Vector vector = this.interceptVector();
                Vector vector2 = data.interceptVector();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                Matrix matrix = this.coefficientMatrix();
                Matrix matrix2 = data.coefficientMatrix();
                if (matrix == null) {
                    if (matrix2 != null) {
                        return false;
                    }
                } else if (!matrix.equals(matrix2)) return false;
                if (this.isMultinomial() != data.isMultinomial()) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ LogisticRegressionModelWriter org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(LogisticRegressionModelWriter $outer, int numClasses, int numFeatures, Vector interceptVector, Matrix coefficientMatrix, boolean isMultinomial) {
                this.numClasses = numClasses;
                this.numFeatures = numFeatures;
                this.interceptVector = interceptVector;
                this.coefficientMatrix = coefficientMatrix;
                this.isMultinomial = isMultinomial;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

