/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.stat.test.BinarySample;
import org.apache.spark.mllib.stat.test.StreamingTest;
import org.apache.spark.mllib.stat.test.StreamingTestResult;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.TestServer;
import org.apache.spark.streaming.TestSuiteBase;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.util.StatCounter;
import org.apache.spark.util.random.XORShiftRandom;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.PatienceConfiguration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u000153A\u0001B\u0003\u0001!!)1\u0004\u0001C\u00019!)q\u0004\u0001C!A!)q\u0005\u0001C\u0005Q\t\u00112\u000b\u001e:fC6Lgn\u001a+fgR\u001cV/\u001b;f\u0015\t1q!\u0001\u0003ti\u0006$(B\u0001\u0005\n\u0003\u0015iG\u000e\\5c\u0015\tQ1\"A\u0003ta\u0006\u00148N\u0003\u0002\r\u001b\u00051\u0011\r]1dQ\u0016T\u0011AD\u0001\u0004_J<7\u0001A\n\u0004\u0001E)\u0002C\u0001\n\u0014\u001b\u0005I\u0011B\u0001\u000b\n\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011a#G\u0007\u0002/)\u0011\u0001$C\u0001\ngR\u0014X-Y7j]\u001eL!AG\f\u0003\u001bQ+7\u000f^*vSR,')Y:f\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\tQ!A\tnCb<\u0016-\u001b;US6,W*\u001b7mSN,\u0012!\t\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0004\u0013:$\u0018\u0001E4f]\u0016\u0014\u0018\r^3UKN$H)\u0019;b)!ICH\u0010!F\u000f&[\u0005c\u0001\u00163k9\u00111\u0006\r\b\u0003Y=j\u0011!\f\u0006\u0003]=\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0013\n\u0005E\u001a\u0013a\u00029bG.\fw-Z\u0005\u0003gQ\u0012!\"\u00138eKb,GmU3r\u0015\t\t4\u0005E\u0002+eY\u0002\"a\u000e\u001e\u000e\u0003aR!!O\u0003\u0002\tQ,7\u000f^\u0005\u0003wa\u0012ABQ5oCJL8+Y7qY\u0016DQ!P\u0002A\u0002\u0005\n!B\\;n\u0005\u0006$8\r[3t\u0011\u0015y4\u00011\u0001\"\u00039\u0001x.\u001b8ugB+'OQ1uG\"DQ!Q\u0002A\u0002\t\u000bQ!\\3b]\u0006\u0003\"AI\"\n\u0005\u0011\u001b#A\u0002#pk\ndW\rC\u0003G\u0007\u0001\u0007!)\u0001\u0004ti\u0012,g/\u0011\u0005\u0006\u0011\u000e\u0001\rAQ\u0001\u0006[\u0016\fgN\u0011\u0005\u0006\u0015\u000e\u0001\rAQ\u0001\u0007gR$WM\u001e\"\t\u000b1\u001b\u0001\u0019A\u0011\u0002\tM,W\r\u001a")
public class StreamingTestSuite
extends SparkFunSuite
implements TestSuiteBase {
    private String checkpointDir;
    private final SparkConf conf;
    private final PatienceConfiguration.Timeout eventuallyTimeout;
    private volatile boolean bitmap$0;

    public /* synthetic */ void org$apache$spark$streaming$TestSuiteBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    public /* synthetic */ void org$apache$spark$streaming$TestSuiteBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public String framework() {
        return TestSuiteBase.framework$((TestSuiteBase)this);
    }

    public String master() {
        return TestSuiteBase.master$((TestSuiteBase)this);
    }

    public Duration batchDuration() {
        return TestSuiteBase.batchDuration$((TestSuiteBase)this);
    }

    public int numInputPartitions() {
        return TestSuiteBase.numInputPartitions$((TestSuiteBase)this);
    }

    public boolean useManualClock() {
        return TestSuiteBase.useManualClock$((TestSuiteBase)this);
    }

    public boolean actuallyWait() {
        return TestSuiteBase.actuallyWait$((TestSuiteBase)this);
    }

    public void beforeFunction() {
        TestSuiteBase.beforeFunction$((TestSuiteBase)this);
    }

    public void afterFunction() {
        TestSuiteBase.afterFunction$((TestSuiteBase)this);
    }

    public void beforeEach() {
        TestSuiteBase.beforeEach$((TestSuiteBase)this);
    }

    public void afterEach() {
        TestSuiteBase.afterEach$((TestSuiteBase)this);
    }

    public <R> R withStreamingContext(StreamingContext ssc, Function1<StreamingContext, R> block) {
        return (R)TestSuiteBase.withStreamingContext$((TestSuiteBase)this, (StreamingContext)ssc, block);
    }

    public <R> R withTestServer(TestServer testServer, Function1<TestServer, R> block) {
        return (R)TestSuiteBase.withTestServer$((TestSuiteBase)this, (TestServer)testServer, block);
    }

    public <U, V> StreamingContext setupStreams(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, int numPartitions, ClassTag<U> evidence$4, ClassTag<V> evidence$5) {
        return TestSuiteBase.setupStreams$((TestSuiteBase)this, input, operation, (int)numPartitions, evidence$4, evidence$5);
    }

    public <U, V> int setupStreams$default$3() {
        return TestSuiteBase.setupStreams$default$3$((TestSuiteBase)this);
    }

    public <U, V, W> StreamingContext setupStreams(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, ClassTag<U> evidence$6, ClassTag<V> evidence$7, ClassTag<W> evidence$8) {
        return TestSuiteBase.setupStreams$((TestSuiteBase)this, input1, input2, operation, evidence$6, evidence$7, evidence$8);
    }

    public <V> Seq<Seq<V>> runStreams(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$9) {
        return TestSuiteBase.runStreams$((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, preStop, evidence$9);
    }

    public <V> Function0<BoxedUnit> runStreams$default$4() {
        return TestSuiteBase.runStreams$default$4$((TestSuiteBase)this);
    }

    public <V> Seq<Seq<Seq<V>>> runStreamsWithPartitions(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$10) {
        return TestSuiteBase.runStreamsWithPartitions$((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, preStop, evidence$10);
    }

    public <V> Function0<BoxedUnit> runStreamsWithPartitions$default$4() {
        return TestSuiteBase.runStreamsWithPartitions$default$4$((TestSuiteBase)this);
    }

    public <V> void verifyOutput(Seq<Seq<V>> output, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<V> evidence$11) {
        TestSuiteBase.verifyOutput$((TestSuiteBase)this, output, expectedOutput, (boolean)useSet, evidence$11);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<U> evidence$12, ClassTag<V> evidence$13) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input, operation, expectedOutput, (boolean)useSet, evidence$12, evidence$13);
    }

    public <U, V> boolean testOperation$default$4() {
        return TestSuiteBase.testOperation$default$4$((TestSuiteBase)this);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$14, ClassTag<V> evidence$15) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$14, evidence$15);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, boolean useSet, ClassTag<U> evidence$16, ClassTag<V> evidence$17, ClassTag<W> evidence$18) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input1, input2, operation, expectedOutput, (boolean)useSet, evidence$16, evidence$17, evidence$18);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$19, ClassTag<V> evidence$20, ClassTag<W> evidence$21) {
        TestSuiteBase.testOperation$((TestSuiteBase)this, input1, input2, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$19, evidence$20, evidence$21);
    }

    private String checkpointDir$lzycompute() {
        StreamingTestSuite streamingTestSuite = this;
        synchronized (streamingTestSuite) {
            if (!this.bitmap$0) {
                this.checkpointDir = TestSuiteBase.checkpointDir$((TestSuiteBase)this);
                this.bitmap$0 = true;
            }
        }
        return this.checkpointDir;
    }

    public String checkpointDir() {
        return !this.bitmap$0 ? this.checkpointDir$lzycompute() : this.checkpointDir;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public PatienceConfiguration.Timeout eventuallyTimeout() {
        return this.eventuallyTimeout;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$eventuallyTimeout_$eq(PatienceConfiguration.Timeout x$1) {
        this.eventuallyTimeout = x$1;
    }

    public int maxWaitTimeMillis() {
        return 30000;
    }

    private IndexedSeq<IndexedSeq<BinarySample>> generateTestData(int numBatches, int pointsPerBatch, double meanA, double stdevA, double meanB, double stdevB, int seed) {
        XORShiftRandom rand = new XORShiftRandom((long)seed);
        int numTrues = pointsPerBatch / 2;
        scala.collection.immutable.IndexedSeq data = (scala.collection.immutable.IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).map((Function1 & Serializable & scala.Serializable)i -> StreamingTestSuite.$anonfun$generateTestData$1(numTrues, meanA, stdevA, rand, pointsPerBatch, meanB, stdevB, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        return data;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$new$3(StreamingTestResult res) {
        if (!(res.pValue() > 0.05)) return false;
        String string = res.method();
        String string2 = "Welch's 2-sample t-test";
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$new$6(StreamingTestResult res) {
        if (!(res.pValue() < 0.05)) return false;
        String string = res.method();
        String string2 = "Welch's 2-sample t-test";
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$new$9(StreamingTestResult res) {
        if (!(res.pValue() > 0.05)) return false;
        String string = res.method();
        String string2 = "Student's 2-sample t-test";
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$new$12(StreamingTestResult res) {
        if (!(res.pValue() < 0.05)) return false;
        String string = res.method();
        String string2 = "Student's 2-sample t-test";
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public static final /* synthetic */ long $anonfun$new$15(Tuple2 x$1) {
        return ((StatCounter)x$1._2()).count();
    }

    public static final /* synthetic */ Assertion $anonfun$new$16(Seq outputCounts$1, int pointsPerBatch$1, int i) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((IterableLike)outputCounts$1.slice(2 * i, 2 * i + 2)).forall((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$2 -> x$2 == (long)((i + 1) * pointsPerBatch$1 / 2)), "outputCounts.slice(2.*(i), 2.*(i).+(2)).forall(((x$2: Long) => x$2.==(i.+(1).*(pointsPerBatch)./(2))))", Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
    }

    public static final /* synthetic */ boolean $anonfun$new$25(StreamingTestResult result) {
        return RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(result.pValue() - 1.0)) < 0.001;
    }

    public static final /* synthetic */ BinarySample $anonfun$generateTestData$2(double meanA$1, double stdevA$1, XORShiftRandom rand$1, int idx) {
        return new BinarySample(true, meanA$1 + stdevA$1 * rand$1.nextGaussian());
    }

    public static final /* synthetic */ BinarySample $anonfun$generateTestData$3(double meanB$1, double stdevB$1, XORShiftRandom rand$1, int idx) {
        return new BinarySample(false, meanB$1 + stdevB$1 * rand$1.nextGaussian());
    }

    public static final /* synthetic */ scala.collection.immutable.IndexedSeq $anonfun$generateTestData$1(int numTrues$1, double meanA$1, double stdevA$1, XORShiftRandom rand$1, int pointsPerBatch$2, double meanB$1, double stdevB$1, int i) {
        return (scala.collection.immutable.IndexedSeq)((TraversableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTrues$1).map((Function1 & Serializable & scala.Serializable)idx -> StreamingTestSuite.$anonfun$generateTestData$2(meanA$1, stdevA$1, rand$1, BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(pointsPerBatch$2 / 2), pointsPerBatch$2).map((Function1 & Serializable & scala.Serializable)idx -> StreamingTestSuite.$anonfun$generateTestData$3(meanB$1, stdevB$1, rand$1, BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public StreamingTestSuite() {
        TestSuiteBase.$init$((TestSuiteBase)this);
        this.test("accuracy for null hypothesis using welch t-test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String testMethod = "welch";
            int numBatches = 2;
            int pointsPerBatch = 1000;
            boolean meanA = false;
            double stdevA = 0.001;
            boolean meanB = false;
            double stdevB = 0.001;
            StreamingTest model = new StreamingTest().setWindowSize(0).setPeacePeriod(0).setTestMethod(testMethod);
            IndexedSeq<IndexedSeq<BinarySample>> input = this.generateTestData(numBatches, pointsPerBatch, (double)meanA, stdevA, (double)meanB, stdevB, 42);
            StreamingContext ssc = this.setupStreams((Seq)input, (Function1)(Function1 & Serializable & scala.Serializable)inputDStream -> model.registerStream(inputDStream), this.setupStreams$default$3(), (ClassTag)ClassTag$.MODULE$.apply(BinarySample.class), (ClassTag)ClassTag$.MODULE$.apply(StreamingTestResult.class));
            Seq outputBatches = this.runStreams(ssc, numBatches, numBatches, this.runStreams$default$4(), ClassTag$.MODULE$.apply(StreamingTestResult.class));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((IterableLike)outputBatches.flatten((Function1)Predef$.MODULE$.$conforms())).forall((Function1 & Serializable & scala.Serializable)res -> BoxesRunTime.boxToBoolean((boolean)StreamingTestSuite.$anonfun$new$3(res))), "outputBatches.flatten[org.apache.spark.mllib.stat.test.StreamingTestResult](scala.Predef.$conforms[Seq[org.apache.spark.mllib.stat.test.StreamingTestResult]]).forall(((res: org.apache.spark.mllib.stat.test.StreamingTestResult) => res.pValue.>(0.05).&&(res.method.==(\"Welch\\'s 2-sample t-test\"))))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        }, new Position("StreamingTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
        this.test("accuracy for alternative hypothesis using welch t-test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String testMethod = "welch";
            int numBatches = 2;
            int pointsPerBatch = 1000;
            int meanA = -10;
            boolean stdevA = true;
            int meanB = 10;
            boolean stdevB = true;
            StreamingTest model = new StreamingTest().setWindowSize(0).setPeacePeriod(0).setTestMethod(testMethod);
            IndexedSeq<IndexedSeq<BinarySample>> input = this.generateTestData(numBatches, pointsPerBatch, meanA, (double)stdevA, meanB, (double)stdevB, 42);
            StreamingContext ssc = this.setupStreams((Seq)input, (Function1)(Function1 & Serializable & scala.Serializable)inputDStream -> model.registerStream(inputDStream), this.setupStreams$default$3(), (ClassTag)ClassTag$.MODULE$.apply(BinarySample.class), (ClassTag)ClassTag$.MODULE$.apply(StreamingTestResult.class));
            Seq outputBatches = this.runStreams(ssc, numBatches, numBatches, this.runStreams$default$4(), ClassTag$.MODULE$.apply(StreamingTestResult.class));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((IterableLike)outputBatches.flatten((Function1)Predef$.MODULE$.$conforms())).forall((Function1 & Serializable & scala.Serializable)res -> BoxesRunTime.boxToBoolean((boolean)StreamingTestSuite.$anonfun$new$6(res))), "outputBatches.flatten[org.apache.spark.mllib.stat.test.StreamingTestResult](scala.Predef.$conforms[Seq[org.apache.spark.mllib.stat.test.StreamingTestResult]]).forall(((res: org.apache.spark.mllib.stat.test.StreamingTestResult) => res.pValue.<(0.05).&&(res.method.==(\"Welch\\'s 2-sample t-test\"))))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        }, new Position("StreamingTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        this.test("accuracy for null hypothesis using student t-test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String testMethod = "student";
            int numBatches = 2;
            int pointsPerBatch = 1000;
            boolean meanA = false;
            double stdevA = 0.001;
            boolean meanB = false;
            double stdevB = 0.001;
            StreamingTest model = new StreamingTest().setWindowSize(0).setPeacePeriod(0).setTestMethod(testMethod);
            IndexedSeq<IndexedSeq<BinarySample>> input = this.generateTestData(numBatches, pointsPerBatch, (double)meanA, stdevA, (double)meanB, stdevB, 42);
            StreamingContext ssc = this.setupStreams((Seq)input, (Function1)(Function1 & Serializable & scala.Serializable)inputDStream -> model.registerStream(inputDStream), this.setupStreams$default$3(), (ClassTag)ClassTag$.MODULE$.apply(BinarySample.class), (ClassTag)ClassTag$.MODULE$.apply(StreamingTestResult.class));
            Seq outputBatches = this.runStreams(ssc, numBatches, numBatches, this.runStreams$default$4(), ClassTag$.MODULE$.apply(StreamingTestResult.class));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((IterableLike)outputBatches.flatten((Function1)Predef$.MODULE$.$conforms())).forall((Function1 & Serializable & scala.Serializable)res -> BoxesRunTime.boxToBoolean((boolean)StreamingTestSuite.$anonfun$new$9(res))), "outputBatches.flatten[org.apache.spark.mllib.stat.test.StreamingTestResult](scala.Predef.$conforms[Seq[org.apache.spark.mllib.stat.test.StreamingTestResult]]).forall(((res: org.apache.spark.mllib.stat.test.StreamingTestResult) => res.pValue.>(0.05).&&(res.method.==(\"Student\\'s 2-sample t-test\"))))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        }, new Position("StreamingTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        this.test("accuracy for alternative hypothesis using student t-test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String testMethod = "student";
            int numBatches = 2;
            int pointsPerBatch = 1000;
            int meanA = -10;
            boolean stdevA = true;
            int meanB = 10;
            boolean stdevB = true;
            StreamingTest model = new StreamingTest().setWindowSize(0).setPeacePeriod(0).setTestMethod(testMethod);
            IndexedSeq<IndexedSeq<BinarySample>> input = this.generateTestData(numBatches, pointsPerBatch, meanA, (double)stdevA, meanB, (double)stdevB, 42);
            StreamingContext ssc = this.setupStreams((Seq)input, (Function1)(Function1 & Serializable & scala.Serializable)inputDStream -> model.registerStream(inputDStream), this.setupStreams$default$3(), (ClassTag)ClassTag$.MODULE$.apply(BinarySample.class), (ClassTag)ClassTag$.MODULE$.apply(StreamingTestResult.class));
            Seq outputBatches = this.runStreams(ssc, numBatches, numBatches, this.runStreams$default$4(), ClassTag$.MODULE$.apply(StreamingTestResult.class));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((IterableLike)outputBatches.flatten((Function1)Predef$.MODULE$.$conforms())).forall((Function1 & Serializable & scala.Serializable)res -> BoxesRunTime.boxToBoolean((boolean)StreamingTestSuite.$anonfun$new$12(res))), "outputBatches.flatten[org.apache.spark.mllib.stat.test.StreamingTestResult](scala.Predef.$conforms[Seq[org.apache.spark.mllib.stat.test.StreamingTestResult]]).forall(((res: org.apache.spark.mllib.stat.test.StreamingTestResult) => res.pValue.<(0.05).&&(res.method.==(\"Student\\'s 2-sample t-test\"))))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        }, new Position("StreamingTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        this.test("batches within same test window are grouped", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int testWindow = 3;
            int numBatches = 5;
            int pointsPerBatch = 100;
            int meanA = -10;
            boolean stdevA = true;
            int meanB = 10;
            boolean stdevB = true;
            StreamingTest model = new StreamingTest().setWindowSize(testWindow).setPeacePeriod(0);
            IndexedSeq<IndexedSeq<BinarySample>> input = this.generateTestData(numBatches, pointsPerBatch, meanA, (double)stdevA, meanB, (double)stdevB, 42);
            StreamingContext ssc = this.setupStreams((Seq)input, (Function1)(Function1 & Serializable & scala.Serializable)inputDStream -> model.summarizeByKeyAndWindow(inputDStream), this.setupStreams$default$3(), (ClassTag)ClassTag$.MODULE$.apply(BinarySample.class), (ClassTag)ClassTag$.MODULE$.apply(Tuple2.class));
            Seq outputBatches = this.runStreams(ssc, numBatches, numBatches, this.runStreams$default$4(), ClassTag$.MODULE$.apply(Tuple2.class));
            Seq outputCounts = (Seq)((TraversableLike)outputBatches.flatten((Function1)Predef$.MODULE$.$conforms())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)StreamingTestSuite.$anonfun$new$15(x$1)), Seq$.MODULE$.canBuildFrom());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), testWindow).foreach((Function1 & Serializable & scala.Serializable)i -> StreamingTestSuite.$anonfun$new$16(outputCounts, pointsPerBatch, BoxesRunTime.unboxToInt((Object)i)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((IterableLike)outputCounts.drop(2 * (testWindow - 1))).forall((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$3 -> x$3 == (long)(testWindow * pointsPerBatch / 2)), "outputCounts.drop(2.*(testWindow.-(1))).forall(((x$3: Long) => x$3.==(testWindow.*(pointsPerBatch)./(2))))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        }, new Position("StreamingTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        this.test("entries in peace period are dropped", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int peacePeriod = 3;
            int numBatches = 7;
            int pointsPerBatch = 1000;
            int meanA = -10;
            boolean stdevA = true;
            int meanB = 10;
            boolean stdevB = true;
            StreamingTest model = new StreamingTest().setWindowSize(0).setPeacePeriod(peacePeriod);
            IndexedSeq<IndexedSeq<BinarySample>> input = this.generateTestData(numBatches, pointsPerBatch, meanA, (double)stdevA, meanB, (double)stdevB, 42);
            StreamingContext ssc = this.setupStreams((Seq)input, (Function1)(Function1 & Serializable & scala.Serializable)inputDStream -> model.dropPeacePeriod(inputDStream), this.setupStreams$default$3(), (ClassTag)ClassTag$.MODULE$.apply(BinarySample.class), (ClassTag)ClassTag$.MODULE$.apply(BinarySample.class));
            Seq outputBatches = this.runStreams(ssc, numBatches, numBatches, this.runStreams$default$4(), ClassTag$.MODULE$.apply(Tuple2.class));
            Seq $org_scalatest_assert_macro_left = (Seq)outputBatches.flatten((Function1)Predef$.MODULE$.$conforms());
            int $org_scalatest_assert_macro_right = (numBatches - peacePeriod) * pointsPerBatch;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        }, new Position("StreamingTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        this.test("null hypothesis when only data from one group is present", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int numBatches = 2;
            int pointsPerBatch = 1000;
            boolean meanA = false;
            double stdevA = 0.001;
            boolean meanB = false;
            double stdevB = 0.001;
            StreamingTest model = new StreamingTest().setWindowSize(0).setPeacePeriod(0);
            IndexedSeq input = (IndexedSeq)this.generateTestData(numBatches, pointsPerBatch, (double)meanA, stdevA, (double)meanB, stdevB, 42).map((Function1 & Serializable & scala.Serializable)batch -> (IndexedSeq)batch.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isExperiment())), scala.collection.IndexedSeq$.MODULE$.canBuildFrom());
            StreamingContext ssc = this.setupStreams((Seq)input, (Function1)(Function1 & Serializable & scala.Serializable)inputDStream -> model.registerStream(inputDStream), this.setupStreams$default$3(), (ClassTag)ClassTag$.MODULE$.apply(BinarySample.class), (ClassTag)ClassTag$.MODULE$.apply(StreamingTestResult.class));
            Seq outputBatches = this.runStreams(ssc, numBatches, numBatches, this.runStreams$default$4(), ClassTag$.MODULE$.apply(StreamingTestResult.class));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((IterableLike)outputBatches.flatten((Function1)Predef$.MODULE$.$conforms())).forall((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)StreamingTestSuite.$anonfun$new$25(result))), "outputBatches.flatten[org.apache.spark.mllib.stat.test.StreamingTestResult](scala.Predef.$conforms[Seq[org.apache.spark.mllib.stat.test.StreamingTestResult]]).forall(((result: org.apache.spark.mllib.stat.test.StreamingTestResult) => scala.Predef.doubleWrapper(result.pValue.-(1.0)).abs.<(0.001)))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
        }, new Position("StreamingTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
    }
}

