/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.stat;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.spark.SharedSparkSession;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.ml.stat.KolmogorovSmirnovTest;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.junit.Assert;
import org.junit.Test;

public class JavaKolmogorovSmirnovTestSuite
extends SharedSparkSession {
    private transient Dataset<Row> dataset;

    @Override
    public void setUp() throws IOException {
        super.setUp();
        List<Double> points = Arrays.asList(0.1, 1.1, 10.1, -1.1);
        this.dataset = this.spark.createDataset(points, Encoders.DOUBLE()).toDF(new String[]{"sample"});
    }

    @Test
    public void testKSTestCDF() {
        NormalDistribution stdNormalDist = new NormalDistribution(0.0, 1.0);
        Long seed = 10L;
        stdNormalDist.reseedRandomGenerator(seed.longValue());
        Function & Serializable stdNormalCDF = (Function & Serializable)x -> stdNormalDist.cumulativeProbability(x.doubleValue());
        double pThreshold = 0.05;
        Row results = (Row)KolmogorovSmirnovTest.test(this.dataset, (String)"sample", (Function)stdNormalCDF).head();
        double pValue1 = results.getDouble(0);
        Assert.assertTrue((pValue1 > pThreshold ? 1 : 0) != 0);
    }

    @Test
    public void testKSTestNamedDistribution() {
        double pThreshold = 0.05;
        Row results = (Row)KolmogorovSmirnovTest.test(this.dataset, (String)"sample", (String)"norm", (double[])new double[]{0.0, 1.0}).head();
        double pValue1 = results.getDouble(0);
        Assert.assertTrue((pValue1 > pThreshold ? 1 : 0) != 0);
    }
}

