/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.source.image;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Paths;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.image.ImageSchema$;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001-3AAB\u0004\u0001)!)\u0011\u0005\u0001C\u0001E!AQ\u0005\u0001EC\u0002\u0013%a\u0005\u0003\u00050\u0001!\u0015\r\u0011\"\u0003'\u0011\u001d\u0001\u0004A1A\u0005\nEBaA\u0013\u0001!\u0002\u0013\u0011$\u0001F%nC\u001e,g)\u001b7f\r>\u0014X.\u0019;Tk&$XM\u0003\u0002\t\u0013\u0005)\u0011.\\1hK*\u0011!bC\u0001\u0007g>,(oY3\u000b\u00051i\u0011AA7m\u0015\tqq\"A\u0003ta\u0006\u00148N\u0003\u0002\u0011#\u00051\u0011\r]1dQ\u0016T\u0011AE\u0001\u0004_J<7\u0001A\n\u0004\u0001UI\u0002C\u0001\f\u0018\u001b\u0005i\u0011B\u0001\r\u000e\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011!dH\u0007\u00027)\u0011A$H\u0001\u0005kRLGN\u0003\u0002\u001f\u001b\u0005)Q\u000e\u001c7jE&\u0011\u0001e\u0007\u0002\u0016\u001b2c\u0017N\u0019+fgR\u001c\u0006/\u0019:l\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0005\u0002%\u00015\tq!A\u0005j[\u0006<W\rU1uQV\tq\u0005\u0005\u0002)[5\t\u0011F\u0003\u0002+W\u0005!A.\u00198h\u0015\u0005a\u0013\u0001\u00026bm\u0006L!AL\u0015\u0003\rM#(/\u001b8h\u0003I\u0011XmY;sg&4X-S7bO\u0016\u0004\u0016\r\u001e5\u0002/\u0015D\b/Z2uK\u00124\u0015N]:u\u0005f$Xm\u001d\u001a1'\u0016$X#\u0001\u001a\u0011\u0007MRD(D\u00015\u0015\t)d'A\u0005j[6,H/\u00192mK*\u0011q\u0007O\u0001\u000bG>dG.Z2uS>t'\"A\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005m\"$aA*fiB!QHP\u0014A\u001b\u0005A\u0014BA 9\u0005\u0019!V\u000f\u001d7feA!QHP!E!\ti$)\u0003\u0002Dq\t\u0019\u0011J\u001c;\u0011\u0007M*u)\u0003\u0002Gi\t!A*[:u!\ti\u0004*\u0003\u0002Jq\t!!)\u001f;f\u0003a)\u0007\u0010]3di\u0016$g)\u001b:ti\nKH/Z:3aM+G\u000f\t")
public class ImageFileFormatSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private String imagePath;
    private String recursiveImagePath;
    private final Set<Tuple2<String, Tuple2<Object, List<Object>>>> expectedFirstBytes20Set;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;
    private volatile byte bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private String imagePath$lzycompute() {
        ImageFileFormatSuite imageFileFormatSuite = this;
        synchronized (imageFileFormatSuite) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.imagePath = "../data/mllib/images/partitioned";
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.imagePath;
    }

    private String imagePath() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.imagePath$lzycompute() : this.imagePath;
    }

    private String recursiveImagePath$lzycompute() {
        ImageFileFormatSuite imageFileFormatSuite = this;
        synchronized (imageFileFormatSuite) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.recursiveImagePath = "../data/mllib/images";
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.recursiveImagePath;
    }

    private String recursiveImagePath() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.recursiveImagePath$lzycompute() : this.recursiveImagePath;
    }

    private Set<Tuple2<String, Tuple2<Object, List<Object>>>> expectedFirstBytes20Set() {
        return this.expectedFirstBytes20Set;
    }

    private final void testImplicits$lzycompute$1() {
        ImageFileFormatSuite imageFileFormatSuite = this;
        synchronized (imageFileFormatSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public ImageFileFormatSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("Smoke test: create basic ImageSchema dataframe", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String origin = "path";
            int width = 1;
            int height = 1;
            int nChannels = 3;
            byte[] data = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 0, 0}), ClassTag$.MODULE$.Byte());
            int mode = BoxesRunTime.unboxToInt((Object)ImageSchema$.MODULE$.ocvTypes().apply((Object)"CV_8UC3"));
            Seq rows = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{origin, BoxesRunTime.boxToInteger((int)height), BoxesRunTime.boxToInteger((int)width), BoxesRunTime.boxToInteger((int)nChannels), BoxesRunTime.boxToInteger((int)mode), data}))})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)height), BoxesRunTime.boxToInteger((int)width), BoxesRunTime.boxToInteger((int)nChannels), BoxesRunTime.boxToInteger((int)mode), data}))})), (List)Nil$.MODULE$));
            SparkContext qual$1 = this.sc();
            Seq x$1 = rows;
            int x$2 = qual$1.makeRDD$default$2();
            RDD rdd = qual$1.makeRDD(x$1, x$2, ClassTag$.MODULE$.apply(Row.class));
            Dataset df = this.spark().createDataFrame(rdd, ImageSchema$.MODULE$.imageSchema());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df.count()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"incorrect image count", Prettifier$.MODULE$.default(), new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
            DataType $org_scalatest_assert_macro_left2 = df.schema().apply("image").dataType();
            StructType $org_scalatest_assert_macro_right2 = ImageSchema$.MODULE$.columnSchema();
            DataType dataType = $org_scalatest_assert_macro_left2;
            StructType structType = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType != null ? !dataType.equals(structType) : structType != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"data do not fit ImageSchema", Prettifier$.MODULE$.default(), new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        }, new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
        this.test("image datasource count test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset df1 = this.spark().read().format("image").load(this.imagePath());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df1.count()));
            int $org_scalatest_assert_macro_right = 9;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            Dataset df2 = this.spark().read().format("image").option("dropInvalid", true).load(this.imagePath());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df2.count()));
            int $org_scalatest_assert_macro_right2 = 8;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        }, new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("image datasource test: read jpg image", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset df = this.spark().read().format("image").load(new StringBuilder(38).append(this.imagePath()).append("/cls=kittens/date=2018-02/DP153539.jpg").toString());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df.count()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        }, new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        this.test("image datasource test: read png image", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset df = this.spark().read().format("image").load(new StringBuilder(39).append(this.imagePath()).append("/cls=multichannel/date=2018-01/BGRA.png").toString());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df.count()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        }, new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        this.test("image datasource test: read non image", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String filePath = new StringBuilder(39).append(this.imagePath()).append("/cls=kittens/date=2018-01/not-image.txt").toString();
            Dataset df = this.spark().read().format("image").option("dropInvalid", true).load(filePath);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df.count()));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            Dataset df2 = this.spark().read().format("image").option("dropInvalid", false).load(filePath);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df2.count()));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
            Row result = (Row)df2.head();
            String resultOrigin = result.getStruct(0).getString(0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new URI(resultOrigin));
            URI $org_scalatest_assert_macro_right3 = Paths.get(filePath, new String[0]).toAbsolutePath().normalize().toUri();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(result);
            Row $org_scalatest_assert_macro_right4 = ImageSchema$.MODULE$.invalidImageRow(resultOrigin);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        }, new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("image datasource partition test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Row[] result = (Row[])this.spark().read().format("image").option("dropInvalid", true).load(this.imagePath()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.substring_index(functions$.MODULE$.col("image.origin"), "/", -1).as("origin"), functions$.MODULE$.col("cls"), functions$.MODULE$.col("date")})).collect();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])result)));
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"29.5.a_b_EGDP022204.jpg", "kittens", "2018-01"})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"54893.jpg", "kittens", "2018-02"})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"DP153539.jpg", "kittens", "2018-02"})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"DP802813.jpg", "kittens", "2018-02"})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"BGRA.png", "multichannel", "2018-01"})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"BGRA_alpha_60.png", "multichannel", "2018-01"})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"chr30.4.184.jpg", "multichannel", "2018-02"})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"grayscale.jpg", "multichannel", "2018-02"}))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        }, new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        this.test("readImages pixel values test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Row[] images = (Row[])this.spark().read().format("image").option("dropInvalid", true).load(new StringBuilder(18).append(this.imagePath()).append("/cls=multichannel/").toString()).collect();
            Set firstBytes20Set = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])images)).map((Function1 & Serializable & scala.Serializable)rrow -> {
                Row row = (Row)rrow.getAs("image");
                String filename = ((Object)Paths.get(ImageSchema$.MODULE$.getOrigin(row), new String[0]).getFileName()).toString();
                int mode = ImageSchema$.MODULE$.getMode(row);
                List bytes20 = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(ImageSchema$.MODULE$.getData(row))).slice(0, 20))).toList();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)filename), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)mode), (Object)bytes20));
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toSet();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(firstBytes20Set);
            Set<Tuple2<String, Tuple2<Object, List<Object>>>> $org_scalatest_assert_macro_right = this.expectedFirstBytes20Set();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        }, new Position("ImageFileFormatSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        this.expectedFirstBytes20Set = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"grayscale.jpg"), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{-2, -33, -61, -60, -59, -59, -64, -59, -66, -67, -73, -73, -62, -57, -60, -63, -53, -49, -55, -69})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"chr30.4.184.jpg"), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)16), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{-9, -3, -1, -43, -32, -28, -75, -60, -57, -78, -59, -56, -74, -59, -57, -71, -58, -56, -73, -64})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"BGRA.png"), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)24), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{-128, -128, -8, -1, -128, -128, -8, -1, -128, -128, -8, -1, 127, 127, -9, -1, 127, 127, -9, -1})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"BGRA_alpha_60.png"), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)24), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{-128, -128, -8, 60, -128, -128, -8, 60, -128, -128, -8, 60, 127, 127, -9, 60, 127, 127, -9, 60}))))}));
    }
}

