/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.param;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.JavaParams;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamValidators;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.Identifiable$;

public class JavaTestParams
extends JavaParams {
    private String uid_;
    private IntParam myIntParam_;
    private DoubleParam myDoubleParam_;
    private Param<String> myStringParam_;
    private DoubleArrayParam myDoubleArrayParam_;

    public JavaTestParams() {
        this.uid_ = Identifiable$.MODULE$.randomUID("javaTestParams");
        this.init();
    }

    public JavaTestParams(String uid) {
        this.uid_ = uid;
        this.init();
    }

    public String uid() {
        return this.uid_;
    }

    public IntParam myIntParam() {
        return this.myIntParam_;
    }

    public int getMyIntParam() {
        return (Integer)this.getOrDefault((Param)this.myIntParam_);
    }

    public JavaTestParams setMyIntParam(int value) {
        this.set((Param)this.myIntParam_, value);
        return this;
    }

    public DoubleParam myDoubleParam() {
        return this.myDoubleParam_;
    }

    public double getMyDoubleParam() {
        return (Double)this.getOrDefault((Param)this.myDoubleParam_);
    }

    public JavaTestParams setMyDoubleParam(double value) {
        this.set((Param)this.myDoubleParam_, value);
        return this;
    }

    public Param<String> myStringParam() {
        return this.myStringParam_;
    }

    public String getMyStringParam() {
        return (String)this.getOrDefault(this.myStringParam_);
    }

    public JavaTestParams setMyStringParam(String value) {
        this.set(this.myStringParam_, value);
        return this;
    }

    public DoubleArrayParam myDoubleArrayParam() {
        return this.myDoubleArrayParam_;
    }

    public double[] getMyDoubleArrayParam() {
        return (double[])this.getOrDefault((Param)this.myDoubleArrayParam_);
    }

    public JavaTestParams setMyDoubleArrayParam(double[] value) {
        this.set((Param)this.myDoubleArrayParam_, value);
        return this;
    }

    private void init() {
        this.myIntParam_ = new IntParam((Identifiable)this, "myIntParam", "this is an int param", ParamValidators.gt((double)0.0));
        this.myDoubleParam_ = new DoubleParam((Identifiable)this, "myDoubleParam", "this is a double param", ParamValidators.inRange((double)0.0, (double)1.0));
        List<String> validStrings = Arrays.asList("a", "b");
        this.myStringParam_ = new Param((Identifiable)this, "myStringParam", "this is a string param", ParamValidators.inArray(validStrings));
        this.myDoubleArrayParam_ = new DoubleArrayParam((Params)this, "myDoubleArrayParam", "this is a double param");
        this.setDefault((Param)this.myIntParam(), 1);
        this.setDefault((Param)this.myDoubleParam(), 0.5);
        this.setDefault((Param)this.myDoubleArrayParam(), new double[]{1.0, 2.0});
    }

    public JavaTestParams copy(ParamMap extra) {
        return (JavaTestParams)this.defaultCopy(extra);
    }
}

