/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim.aggregator;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.InstanceBlock;
import org.apache.spark.ml.feature.InstanceBlock$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.aggregator.HuberBlockAggregator;
import org.apache.spark.ml.stat.Summarizer$;
import org.apache.spark.ml.stat.SummarizerBuffer;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001e4AAE\n\u0001A!)Q\u0006\u0001C\u0001]!9\u0011\u0007\u0001b\u0001\n\u0013\u0011\u0004BB\u001d\u0001A\u0003%1\u0007C\u0005;\u0001\u0001\u0007\t\u0019!C\u0001w!IQ\t\u0001a\u0001\u0002\u0004%\tA\u0012\u0005\n\u0019\u0002\u0001\r\u0011!Q!\nqB\u0011\"\u0015\u0001A\u0002\u0003\u0007I\u0011A\u001e\t\u0013I\u0003\u0001\u0019!a\u0001\n\u0003\u0019\u0006\"C+\u0001\u0001\u0004\u0005\t\u0015)\u0003=\u0011%9\u0006\u00011AA\u0002\u0013\u00051\bC\u0005Y\u0001\u0001\u0007\t\u0019!C\u00013\"I1\f\u0001a\u0001\u0002\u0003\u0006K\u0001\u0010\u0005\n;\u0002\u0001\r\u00111A\u0005\u0002mB\u0011B\u0018\u0001A\u0002\u0003\u0007I\u0011A0\t\u0013\u0005\u0004\u0001\u0019!A!B\u0013a\u0004\"B2\u0001\t\u0003\"\u0007\"B3\u0001\t\u00131'!\u0007%vE\u0016\u0014(\t\\8dW\u0006;wM]3hCR|'oU;ji\u0016T!\u0001F\u000b\u0002\u0015\u0005<wM]3hCR|'O\u0003\u0002\u0017/\u0005)q\u000e\u001d;j[*\u0011\u0001$G\u0001\u0003[2T!AG\u000e\u0002\u000bM\u0004\u0018M]6\u000b\u0005qi\u0012AB1qC\u000eDWMC\u0001\u001f\u0003\ry'oZ\u0002\u0001'\r\u0001\u0011%\n\t\u0003E\rj\u0011!G\u0005\u0003Ie\u0011Qb\u00159be.4UO\\*vSR,\u0007C\u0001\u0014,\u001b\u00059#B\u0001\u0015*\u0003\u0011)H/\u001b7\u000b\u0005)J\u0012!B7mY&\u0014\u0017B\u0001\u0017(\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqR\fa\u0001P5oSRtD#A\u0018\u0011\u0005A\u0002Q\"A\n\u0002\u000f\u0015\u00048/\u001b7p]V\t1\u0007\u0005\u00025o5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tATG\u0001\u0004E_V\u0014G.Z\u0001\tKB\u001c\u0018\u000e\\8oA\u0005I\u0011N\\:uC:\u001cWm]\u000b\u0002yA\u0019A'P \n\u0005y*$!B!se\u0006L\bC\u0001!D\u001b\u0005\t%B\u0001\"\u0018\u0003\u001d1W-\u0019;ve\u0016L!\u0001R!\u0003\u0011%s7\u000f^1oG\u0016\fQ\"\u001b8ti\u0006t7-Z:`I\u0015\fHCA$K!\t!\u0004*\u0003\u0002Jk\t!QK\\5u\u0011\u001dYU!!AA\u0002q\n1\u0001\u001f\u00132\u0003)Ign\u001d;b]\u000e,7\u000f\t\u0015\u0003\r9\u0003\"\u0001N(\n\u0005A+$!\u0003;sC:\u001c\u0018.\u001a8u\u0003aIgn\u001d;b]\u000e,7oQ8ogR\fg\u000e\u001e$fCR,(/Z\u0001\u001dS:\u001cH/\u00198dKN\u001cuN\\:uC:$h)Z1ukJ,w\fJ3r)\t9E\u000bC\u0004L\u0011\u0005\u0005\t\u0019\u0001\u001f\u00023%t7\u000f^1oG\u0016\u001c8i\u001c8ti\u0006tGOR3biV\u0014X\r\t\u0015\u0003\u00139\u000b\u0001%\u001b8ti\u0006t7-Z:D_:\u001cH/\u00198u\r\u0016\fG/\u001e:f\r&dG/\u001a:fI\u0006!\u0013N\\:uC:\u001cWm]\"p]N$\u0018M\u001c;GK\u0006$XO]3GS2$XM]3e?\u0012*\u0017\u000f\u0006\u0002H5\"91jCA\u0001\u0002\u0004a\u0014!I5ogR\fgnY3t\u0007>t7\u000f^1oi\u001a+\u0017\r^;sK\u001aKG\u000e^3sK\u0012\u0004\u0003F\u0001\u0007O\u0003=\u00198-\u00197fI&s7\u000f^1oG\u0016\u001c\u0018aE:dC2,G-\u00138ti\u0006t7-Z:`I\u0015\fHCA$a\u0011\u001dYe\"!AA\u0002q\n\u0001c]2bY\u0016$\u0017J\\:uC:\u001cWm\u001d\u0011)\u0005=q\u0015!\u00032fM>\u0014X-\u00117m)\u00059\u0015\u0001E4fi:+w/Q4he\u0016<\u0017\r^8s)\u00159'n[:y!\t\u0001\u0004.\u0003\u0002j'\t!\u0002*\u001e2fe\ncwnY6BO\u001e\u0014XmZ1u_JDQAO\tA\u0002qBQ\u0001\\\tA\u00025\fAbY8fM\u001aL7-[3oiN\u0004\"A\\9\u000e\u0003=T!\u0001]\f\u0002\r1Lg.\u00197h\u0013\t\u0011xN\u0001\u0004WK\u000e$xN\u001d\u0005\u0006iF\u0001\r!^\u0001\rM&$\u0018J\u001c;fe\u000e,\u0007\u000f\u001e\t\u0003iYL!a^\u001b\u0003\u000f\t{w\u000e\\3b]\")\u0011'\u0005a\u0001g\u0001")
public class HuberBlockAggregatorSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private final double epsilon;
    private transient Instance[] instances;
    private transient Instance[] instancesConstantFeature;
    private transient Instance[] instancesConstantFeatureFiltered;
    private transient Instance[] scaledInstances;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private double epsilon() {
        return this.epsilon;
    }

    public Instance[] instances() {
        return this.instances;
    }

    public void instances_$eq(Instance[] x$1) {
        this.instances = x$1;
    }

    public Instance[] instancesConstantFeature() {
        return this.instancesConstantFeature;
    }

    public void instancesConstantFeature_$eq(Instance[] x$1) {
        this.instancesConstantFeature = x$1;
    }

    public Instance[] instancesConstantFeatureFiltered() {
        return this.instancesConstantFeatureFiltered;
    }

    public void instancesConstantFeatureFiltered_$eq(Instance[] x$1) {
        this.instancesConstantFeatureFiltered = x$1;
    }

    public Instance[] scaledInstances() {
        return this.scaledInstances;
    }

    public void scaledInstances_$eq(Instance[] x$1) {
        this.scaledInstances = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
        this.instances_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(0.0, 0.3, Vectors$.MODULE$.dense(4.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5})))}));
        this.instancesConstantFeature_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(1.0, 0.3, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5})))}));
        this.instancesConstantFeatureFiltered_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new Instance(1.0, 0.3, Vectors$.MODULE$.dense(0.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))}));
        this.scaledInstances_$eq(this.standardize(this.instances()));
    }

    private HuberBlockAggregator getNewAggregator(Instance[] instances, Vector coefficients, boolean fitIntercept, double epsilon) {
        SummarizerBuffer featuresSummarizer;
        int x$2;
        WrappedArray x$1;
        SparkContext qual$1 = this.sc();
        Tuple2 tuple2 = Summarizer$.MODULE$.getClassificationSummarizers(qual$1.parallelize((Seq)(x$1 = Predef$.MODULE$.wrapRefArray((Object[])instances)), x$2 = qual$1.parallelize$default$2(), ClassTag$.MODULE$.apply(Instance.class)), Summarizer$.MODULE$.getClassificationSummarizers$default$2(), Summarizer$.MODULE$.getClassificationSummarizers$default$3());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SummarizerBuffer summarizerBuffer = featuresSummarizer = (SummarizerBuffer)tuple2._1();
        SummarizerBuffer featuresSummarizer2 = summarizerBuffer;
        double[] featuresStd = featuresSummarizer2.std().toArray();
        double[] featuresMean = featuresSummarizer2.mean().toArray();
        double[] inverseStd = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(featuresStd)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)std -> std != 0.0 ? 1.0 / std : 0.0, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double[] scaledMean = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(inverseStd)).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(featuresMean), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToDouble((double)HuberBlockAggregatorSuite.$anonfun$getNewAggregator$2(t)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        Broadcast bcInverseStd = this.sc().broadcast((Object)inverseStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast bcScaledMean = this.sc().broadcast((Object)scaledMean, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast bcCoefficients = this.sc().broadcast((Object)coefficients, ClassTag$.MODULE$.apply(Vector.class));
        return new HuberBlockAggregator(bcInverseStd, bcScaledMean, fitIntercept, epsilon, bcCoefficients);
    }

    private final void testImplicits$lzycompute$1() {
        HuberBlockAggregatorSuite huberBlockAggregatorSuite = this;
        synchronized (huberBlockAggregatorSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ double $anonfun$getNewAggregator$2(Tuple2 t) {
        return t._1$mcD$sp() * t._2$mcD$sp();
    }

    public static final /* synthetic */ void $anonfun$new$16(HuberBlockAggregatorSuite $this, Vector stdCoefVec$1, double sigmaValue$1, DoubleRef lossSum$1, double[] gradientCoef$1, Vector featuresStd$1, DoubleRef gradientSigma$1, Instance x0$1) {
        BoxedUnit boxedUnit;
        Instance instance = x0$1;
        if (instance != null) {
            double l = instance.label();
            double w = instance.weight();
            Vector f = instance.features();
            double margin = BLAS$.MODULE$.dot(stdCoefVec$1, f);
            double linearLoss = l - margin;
            if (package$.MODULE$.abs(linearLoss) <= sigmaValue$1 * $this.epsilon()) {
                lossSum$1.elem += 0.5 * w * (sigmaValue$1 + package$.MODULE$.pow(linearLoss, 2.0) / sigmaValue$1);
                new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef$1)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    gradientCoef$1[i] = gradientCoef$1[i] + -1.0 * w * (linearLoss / sigmaValue$1) * (f.apply(i) / featuresStd$1.apply(i));
                });
                gradientSigma$1.elem += 0.5 * w * (1.0 - package$.MODULE$.pow(linearLoss / sigmaValue$1, 2.0));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                lossSum$1.elem += 0.5 * w * (sigmaValue$1 + 2.0 * $this.epsilon() * package$.MODULE$.abs(linearLoss) - sigmaValue$1 * $this.epsilon() * $this.epsilon());
                double sign = linearLoss >= 0.0 ? -1.0 : 1.0;
                new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef$1)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    gradientCoef$1[i] = gradientCoef$1[i] + w * sign * $this.epsilon() * (f.apply(i) / featuresStd$1.apply(i));
                });
                gradientSigma$1.elem += 0.5 * w * (1.0 - $this.epsilon() * $this.epsilon());
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)instance);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$new$28(HuberBlockAggregatorSuite $this, Vector featuresMean$1, Vector stdCoefVec$2, double interceptValue$1, double sigmaValue$2, DoubleRef lossSum$2, double[] gradientCoef$2, Vector featuresStd$2, DoubleRef gradientIntercept$1, DoubleRef gradientSigma$2, Instance x0$2) {
        BoxedUnit boxedUnit;
        Instance instance = x0$2;
        if (instance != null) {
            double l = instance.label();
            double w = instance.weight();
            Vector f = instance.features();
            DenseVector centered = f.toDense().copy();
            BLAS$.MODULE$.axpy(-1.0, featuresMean$1, (Vector)centered);
            double margin = BLAS$.MODULE$.dot(stdCoefVec$2, (Vector)centered) + interceptValue$1;
            double linearLoss = l - margin;
            if (package$.MODULE$.abs(linearLoss) <= sigmaValue$2 * $this.epsilon()) {
                lossSum$2.elem += 0.5 * w * (sigmaValue$2 + package$.MODULE$.pow(linearLoss, 2.0) / sigmaValue$2);
                new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef$2)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    gradientCoef$2[i] = gradientCoef$2[i] + -1.0 * w * (linearLoss / sigmaValue$2) * ((f.apply(i) - featuresMean$1.apply(i)) / featuresStd$2.apply(i));
                });
                gradientIntercept$1.elem += -1.0 * w * (linearLoss / sigmaValue$2);
                gradientSigma$2.elem += 0.5 * w * (1.0 - package$.MODULE$.pow(linearLoss / sigmaValue$2, 2.0));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                lossSum$2.elem += 0.5 * w * (sigmaValue$2 + 2.0 * $this.epsilon() * package$.MODULE$.abs(linearLoss) - sigmaValue$2 * $this.epsilon() * $this.epsilon());
                double sign = linearLoss >= 0.0 ? -1.0 : 1.0;
                new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef$2)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    gradientCoef$2[i] = gradientCoef$2[i] + w * sign * $this.epsilon() * ((f.apply(i) - featuresMean$1.apply(i)) / featuresStd$2.apply(i));
                });
                gradientIntercept$1.elem += w * sign * $this.epsilon();
                gradientSigma$2.elem += 0.5 * w * (1.0 - $this.epsilon() * $this.epsilon());
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)instance);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ Assertion $anonfun$new$38(HuberBlockAggregatorSuite $this, double[] coefArray$1, double interceptValue$2, double sigmaValue$3, double[] coefArrayFiltered$1, boolean fitIntercept) {
        Vector coefVec = fitIntercept ? Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray$1)).$colon$plus((Object)BoxesRunTime.boxToDouble((double)interceptValue$2), ClassTag$.MODULE$.Double()))).$colon$plus((Object)BoxesRunTime.boxToDouble((double)sigmaValue$3), ClassTag$.MODULE$.Double())) : Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray$1)).$colon$plus((Object)BoxesRunTime.boxToDouble((double)sigmaValue$3), ClassTag$.MODULE$.Double()));
        HuberBlockAggregator aggConstantFeature = $this.getNewAggregator($this.instancesConstantFeature(), coefVec, fitIntercept, $this.epsilon());
        aggConstantFeature.add(InstanceBlock$.MODULE$.fromInstances((Seq)Predef$.MODULE$.wrapRefArray((Object[])$this.standardize($this.instancesConstantFeature()))));
        Vector grad = aggConstantFeature.gradient();
        Vector coefVecFiltered = fitIntercept ? Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArrayFiltered$1)).$colon$plus((Object)BoxesRunTime.boxToDouble((double)interceptValue$2), ClassTag$.MODULE$.Double()))).$colon$plus((Object)BoxesRunTime.boxToDouble((double)sigmaValue$3), ClassTag$.MODULE$.Double())) : Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArrayFiltered$1)).$colon$plus((Object)BoxesRunTime.boxToDouble((double)sigmaValue$3), ClassTag$.MODULE$.Double()));
        HuberBlockAggregator aggConstantFeatureFiltered = $this.getNewAggregator($this.instancesConstantFeatureFiltered(), coefVecFiltered, fitIntercept, $this.epsilon());
        aggConstantFeatureFiltered.add(InstanceBlock$.MODULE$.fromInstances((Seq)Predef$.MODULE$.wrapRefArray((Object[])$this.standardize($this.instancesConstantFeatureFiltered()))));
        Vector gradFiltered = aggConstantFeatureFiltered.gradient();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(aggConstantFeature.loss()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(aggConstantFeatureFiltered.loss()).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(aggConstantFeature.loss).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(aggConstantFeatureFiltered.loss).relTol(1.0E-9))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HuberBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToDouble((double)grad.apply(0)));
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HuberBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
        double d = 0.0;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(grad).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradFiltered.toArray())).$plus$colon((Object)BoxesRunTime.boxToDouble((double)d), ClassTag$.MODULE$.Double()))).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(grad).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.ml.linalg.Vectors.dense({\n  <synthetic> <artifact> val x$5: Double = 0.0;\n  scala.Predef.doubleArrayOps(gradFiltered.toArray).+:[Double](x$5)((ClassTag.Double: scala.reflect.ClassTag[Double]))\n})).relTol(1.0E-9))", Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HuberBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
    }

    public HuberBlockAggregatorSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.epsilon = 1.35;
        this.test("sparse coefficients", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Broadcast bcInverseStd = this.sc().broadcast((Object)new double[]{1.0}, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
            Broadcast bcScaledMean = this.sc().broadcast((Object)new double[]{2.0}, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
            Broadcast bcCoefficients = this.sc().broadcast((Object)Vectors$.MODULE$.sparse(2, new int[]{0}, new double[]{1.0}), ClassTag$.MODULE$.apply(Vector.class));
            HuberBlockAggregator binaryAgg = new HuberBlockAggregator(bcInverseStd, bcScaledMean, false, this.epsilon(), bcCoefficients);
            InstanceBlock block = InstanceBlock$.MODULE$.fromInstances((Seq)new .colon.colon((Object)new Instance(1.0, 1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), (List)Nil$.MODULE$));
            IllegalArgumentException thrownBinary = (IllegalArgumentException)this.withClue("aggregator cannot handle sparse coefficients", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> binaryAgg.add(block), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HuberBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81)));
            String $org_scalatest_assert_macro_left = thrownBinary.getMessage();
            String $org_scalatest_assert_macro_right = "coefficients only supports dense";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HuberBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        }, new Position("HuberBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.test("aggregator add method input size", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double[] coefArray = new double[]{1.0, 2.0};
            double interceptValue = 4.0;
            HuberBlockAggregator agg = this.getNewAggregator(this.instances(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).$colon$plus((Object)BoxesRunTime.boxToDouble((double)interceptValue), ClassTag$.MODULE$.Double())), true, this.epsilon());
            InstanceBlock block = InstanceBlock$.MODULE$.fromInstances((Seq)new .colon.colon((Object)new Instance(1.0, 1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), (List)Nil$.MODULE$));
            return (IllegalArgumentException)this.withClue("BinaryLogisticBlockAggregator features dimension must match coefficients dimension", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> agg.add(block), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HuberBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95)));
        }, new Position("HuberBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        this.test("negative weight", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double[] coefArray = new double[]{1.0, 2.0};
            double interceptValue = 4.0;
            HuberBlockAggregator agg = this.getNewAggregator(this.instances(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).$colon$plus((Object)BoxesRunTime.boxToDouble((double)interceptValue), ClassTag$.MODULE$.Double())), true, this.epsilon());
            InstanceBlock block = InstanceBlock$.MODULE$.fromInstances((Seq)new .colon.colon((Object)new Instance(1.0, -1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), (List)Nil$.MODULE$));
            return (IllegalArgumentException)this.withClue("BinaryLogisticBlockAggregator does not support negative instance weights", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> agg.add(block), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HuberBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108)));
        }, new Position("HuberBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        this.test("check sizes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Random rng = new Random();
            int numFeatures = ((Instance)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).head()).features().size();
            Vector coefWithIntercept = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(numFeatures + 1, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rng.nextDouble(), ClassTag$.MODULE$.Double()));
            Vector coefWithoutIntercept = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(numFeatures, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rng.nextDouble(), ClassTag$.MODULE$.Double()));
            InstanceBlock block = InstanceBlock$.MODULE$.fromInstances((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.instances()));
            HuberBlockAggregator aggIntercept = this.getNewAggregator(this.instances(), coefWithIntercept, true, this.epsilon());
            aggIntercept.add(block);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)aggIntercept.gradient().size()));
            int $org_scalatest_assert_macro_right = numFeatures + 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HuberBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            HuberBlockAggregator aggNoIntercept = this.getNewAggregator(this.instances(), coefWithoutIntercept, false, this.epsilon());
            aggNoIntercept.add(block);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)aggNoIntercept.gradient().size()));
            int $org_scalatest_assert_macro_right2 = numFeatures;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HuberBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        }, new Position("HuberBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        this.test("check correctness: fitIntercept = false", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SummarizerBuffer featuresSummarizer;
            int x$22;
            WrappedArray x$12;
            Vector coefVec = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}));
            double sigmaValue = 4.0;
            int numFeatures = ((Instance)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).head()).features().size();
            SparkContext qual$1 = this.sc();
            Tuple2 tuple2 = Summarizer$.MODULE$.getRegressionSummarizers(qual$1.parallelize((Seq)(x$12 = Predef$.MODULE$.wrapRefArray((Object[])this.instances())), x$22 = qual$1.parallelize$default$2(), ClassTag$.MODULE$.apply(Instance.class)), Summarizer$.MODULE$.getRegressionSummarizers$default$2(), Summarizer$.MODULE$.getRegressionSummarizers$default$3());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SummarizerBuffer summarizerBuffer = featuresSummarizer = (SummarizerBuffer)tuple2._1();
            SummarizerBuffer featuresSummarizer2 = summarizerBuffer;
            Vector featuresStd = featuresSummarizer2.std();
            Vector stdCoefVec = Vectors$.MODULE$.dense((double[])Array$.MODULE$.tabulate(numFeatures, (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> coefVec.apply(i) / featuresStd.apply(i), ClassTag$.MODULE$.Double()));
            double weightSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1.weight()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            DoubleRef lossSum = DoubleRef.create((double)0.0);
            double[] gradientCoef = (double[])Array$.MODULE$.ofDim(numFeatures, ClassTag$.MODULE$.Double());
            DoubleRef gradientSigma = DoubleRef.create((double)0.0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                HuberBlockAggregatorSuite.$anonfun$new$16(this, stdCoefVec, sigmaValue, lossSum, gradientCoef, featuresStd, gradientSigma, x0$1);
                return BoxedUnit.UNIT;
            });
            double loss = lossSum.elem / weightSum;
            Vector gradient = Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef)).$colon$plus((Object)BoxesRunTime.boxToDouble((double)gradientSigma.elem), ClassTag$.MODULE$.Double()))).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$2 -> x$2 / weightSum, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 4}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)blockSize -> {
                InstanceBlock[] blocks1 = (InstanceBlock[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.scaledInstances())).grouped(blockSize).map((Function1 & Serializable & scala.Serializable)seq -> InstanceBlock$.MODULE$.fromInstances((Seq)Predef$.MODULE$.wrapRefArray((Object[])seq))).toArray(ClassTag$.MODULE$.apply(InstanceBlock.class));
                InstanceBlock[] blocks2 = (InstanceBlock[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks1)).map((Function1 & Serializable & scala.Serializable)block -> new InstanceBlock(block.labels(), block.weights(), (Matrix)block.matrix().toSparseRowMajor()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InstanceBlock.class)));
                ((IterableLike)new .colon.colon((Object)blocks1, (List)new .colon.colon((Object)blocks2, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)blocks -> {
                    HuberBlockAggregator agg = this.getNewAggregator(this.instances(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefVec.toArray())).$colon$plus((Object)BoxesRunTime.boxToDouble((double)sigmaValue), ClassTag$.MODULE$.Double())), false, this.epsilon());
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).foreach((Function1 & Serializable & scala.Serializable)block -> agg.add(block));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(agg.loss()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(loss).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(agg.loss).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(loss).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HuberBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(agg.gradient()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(gradient).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(agg.gradient).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(gradient).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HuberBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
                });
            });
        }, new Position("HuberBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        this.test("check correctness: fitIntercept = true", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SummarizerBuffer featuresSummarizer;
            int x$42;
            WrappedArray x$32;
            Vector coefVec = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}));
            double interceptValue = 3.0;
            double sigmaValue = 4.0;
            int numFeatures = ((Instance)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).head()).features().size();
            SparkContext qual$2 = this.sc();
            Tuple2 tuple2 = Summarizer$.MODULE$.getRegressionSummarizers(qual$2.parallelize((Seq)(x$32 = Predef$.MODULE$.wrapRefArray((Object[])this.instances())), x$42 = qual$2.parallelize$default$2(), ClassTag$.MODULE$.apply(Instance.class)), Summarizer$.MODULE$.getRegressionSummarizers$default$2(), Summarizer$.MODULE$.getRegressionSummarizers$default$3());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SummarizerBuffer summarizerBuffer = featuresSummarizer = (SummarizerBuffer)tuple2._1();
            SummarizerBuffer featuresSummarizer2 = summarizerBuffer;
            Vector featuresStd = featuresSummarizer2.std();
            Vector featuresMean = featuresSummarizer2.mean();
            Vector stdCoefVec = Vectors$.MODULE$.dense((double[])Array$.MODULE$.tabulate(numFeatures, (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> coefVec.apply(i) / featuresStd.apply(i), ClassTag$.MODULE$.Double()));
            double weightSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)x$3.weight()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            DoubleRef lossSum = DoubleRef.create((double)0.0);
            double[] gradientCoef = (double[])Array$.MODULE$.ofDim(numFeatures, ClassTag$.MODULE$.Double());
            DoubleRef gradientIntercept = DoubleRef.create((double)0.0);
            DoubleRef gradientSigma = DoubleRef.create((double)0.0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                HuberBlockAggregatorSuite.$anonfun$new$28(this, featuresMean, stdCoefVec, interceptValue, sigmaValue, lossSum, gradientCoef, featuresStd, gradientIntercept, gradientSigma, x0$2);
                return BoxedUnit.UNIT;
            });
            double loss = lossSum.elem / weightSum;
            Vector gradient = Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef)).$colon$plus((Object)BoxesRunTime.boxToDouble((double)gradientIntercept.elem), ClassTag$.MODULE$.Double()))).$colon$plus((Object)BoxesRunTime.boxToDouble((double)gradientSigma.elem), ClassTag$.MODULE$.Double()))).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$4 -> x$4 / weightSum, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 4}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)blockSize -> {
                InstanceBlock[] blocks1 = (InstanceBlock[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.scaledInstances())).grouped(blockSize).map((Function1 & Serializable & scala.Serializable)seq -> InstanceBlock$.MODULE$.fromInstances((Seq)Predef$.MODULE$.wrapRefArray((Object[])seq))).toArray(ClassTag$.MODULE$.apply(InstanceBlock.class));
                InstanceBlock[] blocks2 = (InstanceBlock[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks1)).map((Function1 & Serializable & scala.Serializable)block -> new InstanceBlock(block.labels(), block.weights(), (Matrix)block.matrix().toSparseRowMajor()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InstanceBlock.class)));
                ((IterableLike)new .colon.colon((Object)blocks1, (List)new .colon.colon((Object)blocks2, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)blocks -> {
                    HuberBlockAggregator agg = this.getNewAggregator(this.instances(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefVec.toArray())).$colon$plus((Object)BoxesRunTime.boxToDouble((double)interceptValue), ClassTag$.MODULE$.Double()))).$colon$plus((Object)BoxesRunTime.boxToDouble((double)sigmaValue), ClassTag$.MODULE$.Double())), true, this.epsilon());
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).foreach((Function1 & Serializable & scala.Serializable)block -> agg.add(block));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(agg.loss()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(loss).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(agg.loss).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(loss).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HuberBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(agg.gradient()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(gradient).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(agg.gradient).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(gradient).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HuberBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
                });
            });
        }, new Position("HuberBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
        this.test("check with zero standard deviation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            double[] coefArray = new double[]{1.0, 2.0};
            double[] coefArrayFiltered = new double[]{2.0};
            double interceptValue = 1.0;
            double sigmaValue = 1.0;
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)fitIntercept -> HuberBlockAggregatorSuite.$anonfun$new$38(this, coefArray, interceptValue, sigmaValue, coefArrayFiltered, BoxesRunTime.unboxToBoolean((Object)fitIntercept)));
        }, new Position("HuberBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
    }
}

