/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.stat.distribution;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.diag$;
import breeze.linalg.eigSym;
import breeze.linalg.eigSym$;
import breeze.linalg.max$;
import breeze.storage.Zero;
import java.io.Serializable;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.impl.Utils$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001\u0002\b\u0010\u0001qA\u0001B\n\u0001\u0003\u0006\u0004%\ta\n\u0005\to\u0001\u0011\t\u0011)A\u0005Q!A\u0011\b\u0001BC\u0002\u0013\u0005!\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003<\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u0019\t\u0005\u0001\"\u0001\u0014\u0015\"A!\f\u0001EC\u0002\u0013%1\f\u0003\u0005f\u0001!\u0015\r\u0011\"\u0003;\u0011!9\u0007\u0001#b\u0001\n\u0013A\u0007\u0002\u00036\u0001\u0011\u000b\u0007I\u0011B6\t\u000b5\u0004A\u0011\u00018\t\u000bI\u0004A\u0011A:\t\u000bY\u0004A\u0011B<\u0003)5+H\u000e^5wCJL\u0017\r^3HCV\u001c8/[1o\u0015\t\u0001\u0012#\u0001\u0007eSN$(/\u001b2vi&|gN\u0003\u0002\u0013'\u0005!1\u000f^1u\u0015\t!R#\u0001\u0002nY*\u0011acF\u0001\u0006gB\f'o\u001b\u0006\u00031e\ta!\u00199bG\",'\"\u0001\u000e\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001i2\u0005\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0004B]f\u0014VM\u001a\t\u0003=\u0011J!!J\u0010\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\t5,\u0017M\\\u000b\u0002QA\u0011\u0011\u0006L\u0007\u0002U)\u00111fE\u0001\u0007Y&t\u0017\r\\4\n\u00055R#A\u0002,fGR|'\u000fK\u0002\u0002_U\u0002\"\u0001M\u001a\u000e\u0003ER!AM\u000b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u00025c\t)1+\u001b8dK\u0006\na'A\u00033]Ar\u0003'A\u0003nK\u0006t\u0007\u0005K\u0002\u0003_U\n1aY8w+\u0005Y\u0004CA\u0015=\u0013\ti$F\u0001\u0004NCR\u0014\u0018\u000e\u001f\u0015\u0004\u0007=*\u0014\u0001B2pm\u0002B3\u0001B\u00186\u0003\u0019a\u0014N\\5u}Q\u00191)R$\u0011\u0005\u0011\u0003Q\"A\b\t\u000b\u0019*\u0001\u0019\u0001\u0015)\u0007\u0015{S\u0007C\u0003:\u000b\u0001\u00071\bK\u0002H_UB3!B\u00186)\r\u00195J\u0016\u0005\u0006M\u0019\u0001\r\u0001\u0014\t\u0004\u001bF\u001bV\"\u0001(\u000b\u0005-z%\"\u0001)\u0002\r\t\u0014X-\u001a>f\u0013\t\u0011fJA\u0006EK:\u001cXMV3di>\u0014\bC\u0001\u0010U\u0013\t)vD\u0001\u0004E_V\u0014G.\u001a\u0005\u0006s\u0019\u0001\ra\u0016\t\u0004\u001bb\u001b\u0016BA-O\u0005-!UM\\:f\u001b\u0006$(/\u001b=\u0002\u000bQ,\b\u000f\\3\u0016\u0003q\u0003RAH/<'~K!AX\u0010\u0003\rQ+\b\u000f\\34!\tI\u0003-\u0003\u0002SU!\u0012qA\u0019\t\u0003=\rL!\u0001Z\u0010\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018a\u0004:p_R\u001c\u0016nZ7b\u0013:4X*\u0019;)\u0005!\u0011\u0017!A;\u0016\u0003MC#!\u00032\u0002#I|w\u000e^*jO6\f\u0017J\u001c<Nk2lU/F\u0001`Q\tQ!-A\u0002qI\u001a$\"aU8\t\u000bA\\\u0001\u0019\u0001\u0015\u0002\u0003aD3aC\u00186\u0003\u0019awn\u001a9eMR\u00111\u000b\u001e\u0005\u0006a2\u0001\r\u0001\u000b\u0015\u0004\u0019=*\u0014\u0001H2bY\u000e,H.\u0019;f\u0007>4\u0018M]5b]\u000e,7i\u001c8ti\u0006tGo]\u000b\u0002qB!a$_,T\u0013\tQxD\u0001\u0004UkBdWM\r\u0015\u0003\u0001q\u0004\"\u0001M?\n\u0005y\f$\u0001\u0004#fm\u0016dw\u000e]3s\u0003BL\u0007f\u0001\u00010k\u0001")
public class MultivariateGaussian
implements scala.Serializable {
    private transient Tuple3<Matrix, Object, org.apache.spark.ml.linalg.DenseVector> tuple;
    private transient Matrix rootSigmaInvMat;
    private transient double u;
    private transient org.apache.spark.ml.linalg.DenseVector rootSigmaInvMulMu;
    private final Vector mean;
    private final Matrix cov;
    private volatile transient byte bitmap$trans$0;

    public Vector mean() {
        return this.mean;
    }

    public Matrix cov() {
        return this.cov;
    }

    private Tuple3<Matrix, Object, org.apache.spark.ml.linalg.DenseVector> tuple$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                Tuple2<DenseMatrix<Object>, Object> tuple2 = this.calculateCovarianceConstants();
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                DenseMatrix rootSigmaInv = (DenseMatrix)tuple2._1();
                double u = tuple2._2$mcD$sp();
                Tuple2 tuple22 = new Tuple2((Object)rootSigmaInv, (Object)BoxesRunTime.boxToDouble((double)u));
                DenseMatrix rootSigmaInv2 = (DenseMatrix)tuple22._1();
                double u2 = tuple22._2$mcD$sp();
                Matrix rootSigmaInvMat = Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)rootSigmaInv2);
                org.apache.spark.ml.linalg.DenseVector rootSigmaInvMulMu = rootSigmaInvMat.multiply(this.mean());
                this.tuple = new Tuple3((Object)rootSigmaInvMat, (Object)BoxesRunTime.boxToDouble((double)u2), (Object)rootSigmaInvMulMu);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.tuple;
    }

    private Tuple3<Matrix, Object, org.apache.spark.ml.linalg.DenseVector> tuple() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.tuple$lzycompute();
        }
        return this.tuple;
    }

    private Matrix rootSigmaInvMat$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.rootSigmaInvMat = (Matrix)this.tuple()._1();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.rootSigmaInvMat;
    }

    private Matrix rootSigmaInvMat() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.rootSigmaInvMat$lzycompute();
        }
        return this.rootSigmaInvMat;
    }

    private double u$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.u = BoxesRunTime.unboxToDouble((Object)this.tuple()._2());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.u;
    }

    private double u() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.u$lzycompute();
        }
        return this.u;
    }

    private org.apache.spark.ml.linalg.DenseVector rootSigmaInvMulMu$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.rootSigmaInvMulMu = (org.apache.spark.ml.linalg.DenseVector)this.tuple()._3();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.rootSigmaInvMulMu;
    }

    private org.apache.spark.ml.linalg.DenseVector rootSigmaInvMulMu() {
        if ((byte)(this.bitmap$trans$0 & 8) == 0) {
            return this.rootSigmaInvMulMu$lzycompute();
        }
        return this.rootSigmaInvMulMu;
    }

    public double pdf(Vector x) {
        return package$.MODULE$.exp(this.logpdf(x));
    }

    public double logpdf(Vector x) {
        org.apache.spark.ml.linalg.DenseVector v = this.rootSigmaInvMulMu().copy();
        BLAS$.MODULE$.gemv(-1.0, this.rootSigmaInvMat(), x, 1.0, v);
        return this.u() - 0.5 * BLAS$.MODULE$.dot((Vector)v, (Vector)v);
    }

    private Tuple2<DenseMatrix<Object>, Object> calculateCovarianceConstants() {
        Tuple2 tuple2;
        eigSym.EigSym eigSym2 = (eigSym.EigSym)eigSym$.MODULE$.apply((Object)this.cov().asBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$), (UFunc.UImpl)eigSym.EigSym_DM_Impl$.MODULE$);
        if (eigSym2 == null) {
            throw new MatchError((Object)eigSym2);
        }
        DenseVector d = (DenseVector)eigSym2.eigenvalues();
        DenseMatrix u = (DenseMatrix)eigSym2.eigenvectors();
        Tuple2 tuple22 = new Tuple2((Object)d, (Object)u);
        DenseVector d2 = (DenseVector)tuple22._1();
        DenseMatrix u2 = (DenseMatrix)tuple22._2();
        double tol = Utils$.MODULE$.EPSILON() * BoxesRunTime.unboxToDouble((Object)max$.MODULE$.apply((Object)d2, max$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))) * (double)d2.length();
        try {
            double logPseudoDetSigma = BoxesRunTime.unboxToDouble((Object)d2.activeValuesIterator().filter((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$3 -> x$3 > tol).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.log(x)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            DenseMatrix pinvS = (DenseMatrix)diag$.MODULE$.apply((Object)new DenseVector.mcD.sp(((DenseVector)d2.map$mcD$sp((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)v -> {
                if (v > tol) {
                    return package$.MODULE$.sqrt(1.0 / v);
                }
                return 0.0;
            }, DenseVector$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double()))).toArray$mcD$sp(ClassTag$.MODULE$.Double())), diag$.MODULE$.diagDVDMImpl(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$));
            tuple2 = new Tuple2(pinvS.$times(u2.t(DenseMatrix$.MODULE$.canTranspose()), (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD()), (Object)BoxesRunTime.boxToDouble((double)(-0.5 * ((double)this.mean().size() * package$.MODULE$.log(Math.PI * 2) + logPseudoDetSigma))));
        }
        catch (UnsupportedOperationException uex) {
            throw new IllegalArgumentException("Covariance matrix has no non-zero singular values");
        }
        return tuple2;
    }

    public MultivariateGaussian(Vector mean, Matrix cov) {
        this.mean = mean;
        this.cov = cov;
        Predef$.MODULE$.require(cov.numCols() == cov.numRows(), (Function0 & Serializable & scala.Serializable)() -> "Covariance matrix must be square");
        Predef$.MODULE$.require(mean.size() == cov.numCols(), (Function0 & Serializable & scala.Serializable)() -> "Mean vector length must match covariance matrix size");
    }

    public MultivariateGaussian(DenseVector<Object> mean, DenseMatrix<Object> cov) {
        this(Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)mean), Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)cov));
    }
}

