/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.launcher.BaseSuite;
import org.apache.spark.launcher.InProcessLauncher;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.launcher.SparkSubmitOptionParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InProcessLauncherSuite
extends BaseSuite {
    private static final String TEST_SUCCESS = "success";
    private static final String TEST_FAILURE = "failure";
    private static final String TEST_KILL = "kill";
    private static final String TEST_FAILURE_MESSAGE = "d'oh";
    private static Throwable lastError;

    @Before
    public void testSetup() {
        lastError = null;
    }

    @Test
    public void testLauncher() throws Exception {
        SparkAppHandle app = this.startTest(TEST_SUCCESS);
        this.waitFor(app);
        Assert.assertNull((Object)lastError);
        Assert.assertEquals((Object)SparkAppHandle.State.LOST, (Object)app.getState());
    }

    @Test
    public void testKill() throws Exception {
        SparkAppHandle app = this.startTest(TEST_KILL);
        app.kill();
        this.waitFor(app);
        Assert.assertNull((Object)lastError);
        Assert.assertEquals((Object)SparkAppHandle.State.KILLED, (Object)app.getState());
    }

    @Test
    public void testErrorPropagation() throws Exception {
        SparkAppHandle app = this.startTest(TEST_FAILURE);
        this.waitFor(app);
        Assert.assertEquals((Object)SparkAppHandle.State.FAILED, (Object)app.getState());
        Assert.assertNotNull((Object)lastError);
        Assert.assertEquals((Object)TEST_FAILURE_MESSAGE, (Object)lastError.getMessage());
    }

    private SparkAppHandle startTest(String test) throws Exception {
        return ((InProcessLauncher)((InProcessLauncher)new TestInProcessLauncher().addAppArgs(new String[]{test})).setAppResource("spark-internal")).startApplication(new SparkAppHandle.Listener[0]);
    }

    public static void runTest(String[] args) {
        try {
            String test;
            Assert.assertTrue((args.length != 0 ? 1 : 0) != 0);
            final AtomicReference port = new AtomicReference();
            final AtomicReference secret = new AtomicReference();
            SparkSubmitOptionParser parser = new SparkSubmitOptionParser(){

                protected boolean handle(String opt, String value) {
                    if (opt == "--conf") {
                        String[] conf = value.split("=");
                        switch (conf[0]) {
                            case "spark.launcher.port": {
                                port.set(conf[1]);
                                break;
                            }
                            case "spark.launcher.secret": {
                                secret.set(conf[1]);
                                break;
                            }
                        }
                    }
                    return true;
                }

                protected boolean handleUnknown(String opt) {
                    return true;
                }

                protected void handleExtraArgs(List<String> extra) {
                }
            };
            parser.parse(Arrays.asList(args));
            Assert.assertNotNull((String)"Launcher port not found.", port.get());
            Assert.assertNotNull((String)"Launcher secret not found.", secret.get());
            switch (test = args[args.length - 1]) {
                case "success": {
                    break;
                }
                case "failure": {
                    throw new IllegalStateException(TEST_FAILURE_MESSAGE);
                }
                case "kill": {
                    try {
                        Thread.sleep(10000L);
                        Assert.fail((String)"Did not get expected interrupt after 10s.");
                    }
                    catch (InterruptedException interruptedException) {}
                    break;
                }
                default: {
                    Assert.fail((String)("Unknown test " + test));
                    break;
                }
            }
        }
        catch (Throwable t) {
            lastError = t;
            throw new RuntimeException(t);
        }
    }

    private static class TestInProcessLauncher
    extends InProcessLauncher {
        private TestInProcessLauncher() {
        }

        Method findSparkSubmit() throws IOException {
            try {
                return InProcessLauncherSuite.class.getMethod("runTest", String[].class);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }
}

