/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.EnvFromSourceFluent;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.io.Serializable;
import java.util.Collection;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eb!B\t\u0013\u0001aq\u0002\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\t\u000b=\u0002A\u0011\u0001\u0019\t\u000fM\u0002!\u0019!C\u0001i!1\u0011\b\u0001Q\u0001\nUBQA\u000f\u0001\u0005BmBQ!\u0011\u0001\u0005\n\tCQ\u0001\u0017\u0001\u0005\neCQ\u0001\u0018\u0001\u0005\nuCQ\u0001\u0019\u0001\u0005\n\u0005DQ\u0001\u001a\u0001\u0005\n\u0015DQa\u001b\u0001\u0005\n1DQa\u001c\u0001\u0005\nADQa\u001d\u0001\u0005\nQDQa\u001e\u0001\u0005\naDQA \u0001\u0005B}Dq!!\b\u0001\t\u0003\nyBA\u000bNCB\u00148i\u001c8gS\u001e4U-\u0019;ve\u0016\u001cF/\u001a9\u000b\u0005M!\u0012\u0001\u00034fCR,(/Z:\u000b\u0005U1\u0012aA69g*\u0011q\u0003G\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005eQ\u0012!B:qCJ\\'BA\u000e\u001d\u0003\u0019\t\u0007/Y2iK*\tQ$A\u0002pe\u001e\u001c2\u0001A\u0010&!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0019\te.\u001f*fMB\u0011aeJ\u0007\u0002%%\u0011\u0001F\u0005\u0002\u001c\u0017V\u0014WM\u001d8fi\u0016\u001ch)Z1ukJ,7i\u001c8gS\u001e\u001cF/\u001a9\u0002\t\r|gNZ\u0002\u0001!\taS&D\u0001\u0015\u0013\tqCC\u0001\bLk\n,'O\\3uKN\u001cuN\u001c4\u0002\rqJg.\u001b;?)\t\t$\u0007\u0005\u0002'\u0001!)\u0011F\u0001a\u0001W\u0005I1\u000f]1sW\u000e{gNZ\u000b\u0002kA\u0011agN\u0007\u00021%\u0011\u0001\b\u0007\u0002\n'B\f'o[\"p]\u001a\f!b\u001d9be.\u001cuN\u001c4!\u00031\u0019wN\u001c4jOV\u0014X\rU8e)\tat\b\u0005\u0002-{%\u0011a\b\u0006\u0002\t'B\f'o\u001b)pI\")\u0001)\u0002a\u0001y\u0005\u0019\u0001o\u001c3\u0002\u0017\u0005\u0004\b\u000f\\=MI\u0006\u00048)\u0014\u000b\u0004\u0007F3\u0006C\u0001#P\u001b\u0005)%B\u0001$H\u0003\u0015iw\u000eZ3m\u0015\tA\u0015*A\u0002ba&T!AS&\u0002\u0015-,(-\u001a:oKR,7O\u0003\u0002M\u001b\u00069a-\u00192sS\u000eD$\"\u0001(\u0002\u0005%|\u0017B\u0001)F\u0005A\u0019uN\u001c;bS:,'OQ;jY\u0012,'\u000fC\u0003S\r\u0001\u00071+\u0001\u0006q_\u0012\u0014U/\u001b7eKJ\u0004\"\u0001\u0012+\n\u0005U+%A\u0003)pI\n+\u0018\u000e\u001c3fe\")qK\u0002a\u0001\u0007\u0006\u00012m\u001c8uC&tWM\u001d\"vS2$WM]\u0001\u0010CB\u0004H._*T'\u0012\u001bVm\u0019:fiR\u00191IW.\t\u000bI;\u0001\u0019A*\t\u000b];\u0001\u0019A\"\u0002\u001d\u0005\u0004\b\u000f\\=T'\"\u001bVm\u0019:fiR\u00191IX0\t\u000bIC\u0001\u0019A*\t\u000b]C\u0001\u0019A\"\u0002#\u0005\u0004\b\u000f\\=DY&,g\u000e^*fGJ,G\u000fF\u0002DE\u000eDQAU\u0005A\u0002MCQaV\u0005A\u0002\r\u000ba#\u00199qYf\u001c\u0006/\u0019:l\u000bb$(/Y\"p]\u001aLwm\u001d\u000b\u0004M&T\u0007C\u0001\u0011h\u0013\tA\u0017E\u0001\u0003V]&$\b\"\u0002*\u000b\u0001\u0004\u0019\u0006\"B,\u000b\u0001\u0004\u0019\u0015aD1qa2LXk]3s'\u0016\u001c'/\u001a;\u0015\u0007\u0019lg\u000eC\u0003S\u0017\u0001\u00071\u000bC\u0003X\u0017\u0001\u00071)\u0001\nbaBd\u00170T3ue&\u001c7\u000fV5dW\u0016$HcA\"re\")!\u000b\u0004a\u0001'\")q\u000b\u0004a\u0001\u0007\u0006)\u0012\r\u001d9ms\u000ecWo\u001d;fe\u000e{gNZ5h\u001b\u0006\u0004HcA\"vm\")!+\u0004a\u0001'\")q+\u0004a\u0001\u0007\u0006q\u0011\r\u001a3DYV\u001cH/\u001a:F]Z\u001cHcA=}{B\u0011AI_\u0005\u0003w\u0016\u0013\u0011bQ8oi\u0006Lg.\u001a:\t\u000bIs\u0001\u0019A*\t\u000b]s\u0001\u0019A\"\u0002A\u001d,G/\u00113eSRLwN\\1m!>$7+_:uK6\u0004&o\u001c9feRLWm\u001d\u000b\u0003\u0003\u0003\u0001\u0002\"a\u0001\u0002\u0012\u0005]\u0011q\u0003\b\u0005\u0003\u000b\ti\u0001E\u0002\u0002\b\u0005j!!!\u0003\u000b\u0007\u0005-!&\u0001\u0004=e>|GOP\u0005\u0004\u0003\u001f\t\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0014\u0005U!aA'ba*\u0019\u0011qB\u0011\u0011\t\u0005\r\u0011\u0011D\u0005\u0005\u00037\t)B\u0001\u0004TiJLgnZ\u0001!O\u0016$\u0018\t\u001a3ji&|g.\u00197Lk\n,'O\\3uKN\u0014Vm]8ve\u000e,7\u000f\u0006\u0002\u0002\"A1\u00111EA\u0017\u0003gqA!!\n\u0002*9!\u0011qAA\u0014\u0013\u0005\u0011\u0013bAA\u0016C\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0018\u0003c\u00111aU3r\u0015\r\tY#\t\t\u0004\t\u0006U\u0012bAA\u001c\u000b\nY\u0001*Y:NKR\fG-\u0019;b\u0001")
public class MaprConfigFeatureStep
implements KubernetesFeatureConfigStep {
    private final SparkConf sparkConf;

    @Override
    public Seq<HasMetadata> getAdditionalPreKubernetesResources() {
        return KubernetesFeatureConfigStep.getAdditionalPreKubernetesResources$(this);
    }

    public SparkConf sparkConf() {
        return this.sparkConf;
    }

    @Override
    public SparkPod configurePod(SparkPod pod) {
        PodBuilder podBuilder = new PodBuilder(pod.pod());
        ContainerBuilder containerBuilder = new ContainerBuilder(pod.container());
        this.applyUserSecret(podBuilder, containerBuilder);
        this.applyMetricsTicket(podBuilder, containerBuilder);
        this.applyClusterConfigMap(podBuilder, containerBuilder);
        this.addClusterEnvs(podBuilder, containerBuilder);
        this.applyLdapCM(podBuilder, containerBuilder);
        this.applySSSDSecret(podBuilder, containerBuilder);
        this.applySSHSecret(podBuilder, containerBuilder);
        this.applyClientSecret(podBuilder, containerBuilder);
        this.applySparkExtraConfigs(podBuilder, containerBuilder);
        return new SparkPod(podBuilder.build(), containerBuilder.build());
    }

    private ContainerBuilder applyLdapCM(PodBuilder podBuilder, ContainerBuilder containerBuilder) {
        String cmName = "ldapclient-cm";
        String cmVolumeName = "ldap-cm";
        ((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((VolumeFluent.ConfigMapNested)podBuilder.editOrNewSpec().addNewVolume().withName(cmVolumeName).withNewConfigMap().withName(cmName).withOptional(Predef$.MODULE$.boolean2Boolean(true)).withDefaultMode(Predef$.MODULE$.int2Integer(420))).endConfigMap()).endVolume()).endSpec();
        return (ContainerBuilder)((ContainerFluent.VolumeMountsNested)containerBuilder.addNewVolumeMount().withName(cmVolumeName).withMountPath("/opt/mapr/kubernetes/ldap-cm")).endVolumeMount();
    }

    private ContainerBuilder applySSSDSecret(PodBuilder podBuilder, ContainerBuilder containerBuilder) {
        String secretName = "sssd";
        String volumeName = "sssd-secrets";
        ((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((VolumeFluent.SecretNested)podBuilder.editOrNewSpec().addNewVolume().withName(volumeName).withNewSecret().withSecretName(secretName).withDefaultMode(Predef$.MODULE$.int2Integer(420)).withOptional(Predef$.MODULE$.boolean2Boolean(true))).endSecret()).endVolume()).endSpec();
        return (ContainerBuilder)((ContainerFluent.VolumeMountsNested)containerBuilder.addNewVolumeMount().withName(volumeName).withMountPath("/opt/mapr/kubernetes/sssd-secrets")).endVolumeMount();
    }

    private ContainerBuilder applySSHSecret(PodBuilder podBuilder, ContainerBuilder containerBuilder) {
        String secretName = "ssh";
        String volumeName = "ssh-secrets";
        ((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((VolumeFluent.SecretNested)podBuilder.editOrNewSpec().addNewVolume().withName(volumeName).withNewSecret().withSecretName(secretName).withDefaultMode(Predef$.MODULE$.int2Integer(420)).withOptional(Predef$.MODULE$.boolean2Boolean(true))).endSecret()).endVolume()).endSpec();
        return (ContainerBuilder)((ContainerFluent.VolumeMountsNested)containerBuilder.addNewVolumeMount().withName(volumeName).withMountPath("/opt/mapr/kubernetes/ssh-secrets")).endVolumeMount();
    }

    private ContainerBuilder applyClientSecret(PodBuilder podBuilder, ContainerBuilder containerBuilder) {
        String secretName = "client";
        String volumeName = "client-secrets";
        ((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((VolumeFluent.SecretNested)podBuilder.editOrNewSpec().addNewVolume().withName(volumeName).withNewSecret().withSecretName(secretName).withDefaultMode(Predef$.MODULE$.int2Integer(420)).withOptional(Predef$.MODULE$.boolean2Boolean(true))).endSecret()).endVolume()).endSpec();
        return (ContainerBuilder)((ContainerFluent.VolumeMountsNested)containerBuilder.addNewVolumeMount().withName(volumeName).withMountPath("/opt/mapr/kubernetes/client-secrets")).endVolumeMount();
    }

    private void applySparkExtraConfigs(PodBuilder podBuilder, ContainerBuilder containerBuilder) {
        Option confSecretName = (Option)this.sparkConf().get(Config$.MODULE$.MAPR_SPARK_EXTRACONF_SECRET_NAME());
        if (confSecretName.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isEmpty()))) {
            return;
        }
        String confSecretVolumeName = "spark-extraconf-secret";
        ((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((VolumeFluent.SecretNested)podBuilder.editOrNewSpec().addNewVolume().withName(confSecretVolumeName).withNewSecret().withSecretName((String)confSecretName.get())).endSecret()).endVolume()).endSpec();
        ((ContainerFluent.VolumeMountsNested)containerBuilder.addNewVolumeMount().withName(confSecretVolumeName).withMountPath(Constants$.MODULE$.MAPR_SPARK_EXTRA_CONFIG_MOUNT_PATH())).endVolumeMount();
    }

    private void applyUserSecret(PodBuilder podBuilder, ContainerBuilder containerBuilder) {
        Option userSecretNameConfig = (Option)this.sparkConf().get(Config$.MODULE$.MAPR_USER_SECRET());
        if (userSecretNameConfig.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty()))) {
            return;
        }
        String userSecretName = (String)userSecretNameConfig.get();
        String userSecretVolumeName = new StringBuilder(7).append(userSecretName).append("-volume").toString();
        ((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((VolumeFluent.SecretNested)podBuilder.editOrNewSpec().addNewVolume().withName(userSecretVolumeName).withNewSecret().withSecretName(userSecretName)).endSecret()).endVolume()).endSpec();
        ((ContainerFluent.VolumeMountsNested)((ContainerFluentImpl)((ContainerFluent.EnvNested)((ContainerFluentImpl)((ContainerFluent.EnvNested)containerBuilder.addNewEnv().withName(Constants$.MODULE$.ENV_MAPR_TICKETFILE_LOCATION()).withValue(Constants$.MODULE$.MAPR_USER_TICKET_MOUNT_PATH())).endEnv()).addNewEnv().withName(Constants$.MODULE$.ENV_MAPR_USERSECRET_MOUNT_PATH()).withValue(Constants$.MODULE$.MAPR_USER_SECRET_MOUNT_PATH())).endEnv()).addNewVolumeMount().withName(userSecretVolumeName).withMountPath(Constants$.MODULE$.MAPR_USER_SECRET_MOUNT_PATH())).endVolumeMount();
    }

    private ContainerBuilder applyMetricsTicket(PodBuilder podBuilder, ContainerBuilder containerBuilder) {
        String serverSecretName = Constants$.MODULE$.MAPR_SERVER_SECRET();
        String serverSecretVolume = new StringBuilder(7).append(serverSecretName).append("-volume").toString();
        ((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((VolumeFluent.SecretNested)podBuilder.editOrNewSpec().addNewVolume().withName(serverSecretVolume).withNewSecret().withSecretName(serverSecretName).withOptional(Predef$.MODULE$.boolean2Boolean(true))).endSecret()).endVolume()).endSpec();
        return (ContainerBuilder)((ContainerFluent.VolumeMountsNested)((ContainerFluentImpl)((ContainerFluent.EnvNested)containerBuilder.addNewEnv().withName(Constants$.MODULE$.ENV_MAPR_METRICSFILE_LOCATION()).withValue(Constants$.MODULE$.MAPR_METRICS_TICKET_MOUNT_PATH())).endEnv()).addNewVolumeMount().withName(serverSecretVolume).withMountPath(Constants$.MODULE$.MAPR_METRICS_TICKET_MOUNT_PATH()).withSubPath(Constants$.MODULE$.MAPR_METRICS_TICKET_SUBPATH())).endVolumeMount();
    }

    private ContainerBuilder applyClusterConfigMap(PodBuilder podBuilder, ContainerBuilder containerBuilder) {
        String clusterConfMap = ((String)this.sparkConf().get(Config$.MODULE$.MAPR_CLUSTER_CONFIGMAP())).toString();
        return (ContainerBuilder)((ContainerFluent.EnvFromNested)((EnvFromSourceFluent.ConfigMapRefNested)containerBuilder.addNewEnvFrom().withNewConfigMapRef().withName(clusterConfMap).withOptional(Predef$.MODULE$.boolean2Boolean(true))).endConfigMapRef()).endEnvFrom();
    }

    private Container addClusterEnvs(PodBuilder podBuilder, ContainerBuilder containerBuilder) {
        Seq clusterEnvs = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sparkConf().getAllWithPrefix(Config$.MODULE$.KUBERNETES_CLUSTER_ENV_KEY()))).toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                String value = (String)tuple2._2();
                return ((EnvVarBuilder)((EnvVarFluentImpl)new EnvVarBuilder().withName(name)).withValue(value)).build();
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        return ((ContainerBuilder)containerBuilder.addAllToEnv((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(clusterEnvs).asJava())).build();
    }

    @Override
    public Map<String, String> getAdditionalPodSystemProperties() {
        return Predef$.MODULE$.Map().empty();
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return (Seq)Nil$.MODULE$;
    }

    public MaprConfigFeatureStep(KubernetesConf conf) {
        KubernetesFeatureConfigStep.$init$(this);
        this.sparkConf = conf.sparkConf();
    }
}

