/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesDriverSpec;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.SparkPod$;
import org.apache.spark.deploy.k8s.features.BasicDriverFeatureStep;
import org.apache.spark.deploy.k8s.features.DriverCommandFeatureStep;
import org.apache.spark.deploy.k8s.features.DriverKubernetesCredentialsFeatureStep;
import org.apache.spark.deploy.k8s.features.DriverServiceFeatureStep;
import org.apache.spark.deploy.k8s.features.DriverServiceFeatureStep$;
import org.apache.spark.deploy.k8s.features.EnvSecretsFeatureStep;
import org.apache.spark.deploy.k8s.features.HadoopConfDriverFeatureStep;
import org.apache.spark.deploy.k8s.features.KerberosConfDriverFeatureStep;
import org.apache.spark.deploy.k8s.features.KubernetesDriverCustomFeatureConfigStep;
import org.apache.spark.deploy.k8s.features.KubernetesExecutorCustomFeatureConfigStep;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.deploy.k8s.features.LocalDirsFeatureStep;
import org.apache.spark.deploy.k8s.features.LocalDirsFeatureStep$;
import org.apache.spark.deploy.k8s.features.MaprConfigFeatureStep;
import org.apache.spark.deploy.k8s.features.MountSecretsFeatureStep;
import org.apache.spark.deploy.k8s.features.MountVolumesFeatureStep;
import org.apache.spark.deploy.k8s.features.PodTemplateConfigMapStep;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Q2Qa\u0001\u0003\u0001\u0015AAQa\u0006\u0001\u0005\u0002eAQ\u0001\b\u0001\u0005\u0002u\u0011qcS;cKJtW\r^3t\tJLg/\u001a:Ck&dG-\u001a:\u000b\u0005\u00151\u0011AB:vE6LGO\u0003\u0002\b\u0011\u0005\u00191\u000eO:\u000b\u0005%Q\u0011A\u00023fa2|\u0017P\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h'\t\u0001\u0011\u0003\u0005\u0002\u0013+5\t1CC\u0001\u0015\u0003\u0015\u00198-\u00197b\u0013\t12C\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t!\u0004\u0005\u0002\u001c\u00015\tA!A\tck&dGM\u0012:p[\u001a+\u0017\r^;sKN$2A\b\u0012(!\ty\u0002%D\u0001\u0007\u0013\t\tcA\u0001\u000bLk\n,'O\\3uKN$%/\u001b<feN\u0003Xm\u0019\u0005\u0006G\t\u0001\r\u0001J\u0001\u0005G>tg\r\u0005\u0002 K%\u0011aE\u0002\u0002\u0015\u0017V\u0014WM\u001d8fi\u0016\u001cHI]5wKJ\u001cuN\u001c4\t\u000b!\u0012\u0001\u0019A\u0015\u0002\r\rd\u0017.\u001a8u!\tQ#'D\u0001,\u0015\tACF\u0003\u0002.]\u0005Q1.\u001e2fe:,G/Z:\u000b\u0005=\u0002\u0014a\u00024bEJL7\r\u000f\u0006\u0002c\u0005\u0011\u0011n\\\u0005\u0003g-\u0012\u0001cS;cKJtW\r^3t\u00072LWM\u001c;")
public class KubernetesDriverBuilder {
    public KubernetesDriverSpec buildFromFeatures(KubernetesDriverConf conf, KubernetesClient client) {
        SparkPod initialPod = (SparkPod)((Option)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_PODTEMPLATE_FILE())).map((Function1 & Serializable & scala.Serializable)file -> KubernetesUtils$.MODULE$.loadPodFromTemplate(client, (String)file, (Option<String>)((Option)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_PODTEMPLATE_CONTAINER_NAME())), conf.sparkConf())).getOrElse((Function0 & Serializable & scala.Serializable)() -> SparkPod$.MODULE$.initialPod());
        Seq userFeatures = (Seq)((TraversableLike)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_POD_FEATURE_STEPS())).map((Function1 & Serializable & scala.Serializable)className -> {
            None$ none$;
            Object feature = Utils$.MODULE$.classForName(className, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()).getConstructor(new Class[0]).newInstance(new Object[0]);
            Object t = feature;
            if (t instanceof KubernetesDriverCustomFeatureConfigStep) {
                KubernetesDriverCustomFeatureConfigStep kubernetesDriverCustomFeatureConfigStep = (KubernetesDriverCustomFeatureConfigStep)t;
                kubernetesDriverCustomFeatureConfigStep.init(conf);
                none$ = new Some((Object)kubernetesDriverCustomFeatureConfigStep);
            } else if (t instanceof KubernetesExecutorCustomFeatureConfigStep) {
                none$ = None$.MODULE$;
            } else if (t instanceof KubernetesFeatureConfigStep) {
                KubernetesFeatureConfigStep kubernetesFeatureConfigStep = (KubernetesFeatureConfigStep)t;
                none$ = new Some((Object)kubernetesFeatureConfigStep);
            } else {
                none$ = None$.MODULE$;
            }
            None$ initializedFeature = none$;
            return (KubernetesFeatureConfigStep)initializedFeature.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new SparkException(new StringBuilder(113).append("Failed to initialize feature step: ").append((String)className).append(", ").append("please make sure your driver side feature steps are implemented by ").append("`").append(KubernetesDriverCustomFeatureConfigStep.class.getName()).append("` or ").append("`").append(KubernetesFeatureConfigStep.class.getName()).append("`.").toString());
            });
        }, Seq$.MODULE$.canBuildFrom());
        Seq features = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KubernetesFeatureConfigStep[]{new BasicDriverFeatureStep(conf), new DriverKubernetesCredentialsFeatureStep(conf), new DriverServiceFeatureStep(conf, DriverServiceFeatureStep$.MODULE$.$lessinit$greater$default$2()), new MountSecretsFeatureStep(conf), new EnvSecretsFeatureStep(conf), new MountVolumesFeatureStep(conf), new DriverCommandFeatureStep(conf), new HadoopConfDriverFeatureStep(conf), new KerberosConfDriverFeatureStep(conf), new PodTemplateConfigMapStep(conf), new LocalDirsFeatureStep(conf, LocalDirsFeatureStep$.MODULE$.$lessinit$greater$default$2()), new MaprConfigFeatureStep(conf)}))).$plus$plus((GenTraversableOnce)userFeatures, Seq$.MODULE$.canBuildFrom());
        KubernetesDriverSpec spec = new KubernetesDriverSpec(initialPod, (Seq<HasMetadata>)((Seq)Nil$.MODULE$), (Seq<HasMetadata>)((Seq)Nil$.MODULE$), (Map<String, String>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])conf.sparkConf().getAll())).toMap(Predef$.MODULE$.$conforms()));
        return (KubernetesDriverSpec)features.foldLeft((Object)spec, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                KubernetesDriverSpec spec = (KubernetesDriverSpec)tuple2._1();
                KubernetesFeatureConfigStep feature = (KubernetesFeatureConfigStep)tuple2._2();
                SparkPod configuredPod = feature.configurePod(spec.pod());
                Map<String, String> addedSystemProperties = feature.getAdditionalPodSystemProperties();
                Seq<HasMetadata> addedPreResources = feature.getAdditionalPreKubernetesResources();
                Seq<HasMetadata> addedResources = feature.getAdditionalKubernetesResources();
                return new KubernetesDriverSpec(configuredPod, (Seq<HasMetadata>)((Seq)spec.driverPreKubernetesResources().$plus$plus(addedPreResources, Seq$.MODULE$.canBuildFrom())), (Seq<HasMetadata>)((Seq)spec.driverKubernetesResources().$plus$plus(addedResources, Seq$.MODULE$.canBuildFrom())), (Map<String, String>)spec.systemProperties().$plus$plus(addedSystemProperties));
            }
            throw new MatchError((Object)tuple2);
        });
    }
}

