/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import java.io.Serializable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.api.plugin.DriverPlugin;
import org.apache.spark.api.plugin.PluginContext;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Config$ExecutorRollPolicy$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.scheduler.ExecutorDecommissionInfo;
import org.apache.spark.scheduler.ExecutorDecommissionInfo$;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.status.api.v1.ExecutorSummary;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001B\b\u0011\u0001uAQ\u0001\u000e\u0001\u0005\u0002UB\u0011\u0002\u000f\u0001A\u0002\u0003\u0007I\u0011B\u001d\t\u0013y\u0002\u0001\u0019!a\u0001\n\u0013y\u0004\"\u0003%\u0001\u0001\u0004\u0005\t\u0015)\u0003;\u0011\u001dI\u0005A1A\u0005\n)Caa\u0015\u0001!\u0002\u0013Y\u0005\u0002\u0003+\u0001\u0001\u0004%\t\u0001E+\t\u0011e\u0003\u0001\u0019!C\u0001!iCa\u0001\u0018\u0001!B\u00131\u0006\"B/\u0001\t\u0003r\u0006\"B;\u0001\t\u00032\b\"B<\u0001\t\u0013A\bbBA,\u0001\u0011%\u0011\u0011\f\u0005\b\u0003S\u0002A\u0011BA6\u0005a)\u00050Z2vi>\u0014(k\u001c7m\tJLg/\u001a:QYV<\u0017N\u001c\u0006\u0003#I\t1a\u001b\u001dt\u0015\t\u0019B#A\u0004dYV\u001cH/\u001a:\u000b\u0005U1\u0012!C:dQ\u0016$W\u000f\\3s\u0015\t9\u0002$A\u0003ta\u0006\u00148N\u0003\u0002\u001a5\u00051\u0011\r]1dQ\u0016T\u0011aG\u0001\u0004_J<7\u0001A\n\u0005\u0001y1c\u0006\u0005\u0002 I5\t\u0001E\u0003\u0002\"E\u0005!A.\u00198h\u0015\u0005\u0019\u0013\u0001\u00026bm\u0006L!!\n\u0011\u0003\r=\u0013'.Z2u!\t9C&D\u0001)\u0015\tI#&\u0001\u0004qYV<\u0017N\u001c\u0006\u0003WY\t1!\u00199j\u0013\ti\u0003F\u0001\u0007Ee&4XM\u001d)mk\u001eLg\u000e\u0005\u00020e5\t\u0001G\u0003\u00022-\u0005A\u0011N\u001c;fe:\fG.\u0003\u00024a\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u00017!\t9\u0004!D\u0001\u0011\u00031\u0019\b/\u0019:l\u0007>tG/\u001a=u+\u0005Q\u0004CA\u001e=\u001b\u00051\u0012BA\u001f\u0017\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0003A\u0019\b/\u0019:l\u0007>tG/\u001a=u?\u0012*\u0017\u000f\u0006\u0002A\rB\u0011\u0011\tR\u0007\u0002\u0005*\t1)A\u0003tG\u0006d\u0017-\u0003\u0002F\u0005\n!QK\\5u\u0011\u001d95!!AA\u0002i\n1\u0001\u001f\u00132\u00035\u0019\b/\u0019:l\u0007>tG/\u001a=uA\u0005y\u0001/\u001a:j_\u0012L7mU3sm&\u001cW-F\u0001L!\ta\u0015+D\u0001N\u0015\tqu*\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001\u0015\u0012\u0002\tU$\u0018\u000e\\\u0005\u0003%6\u0013\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0003A\u0001XM]5pI&\u001c7+\u001a:wS\u000e,\u0007%\u0001\u0005nS:$\u0016m]6t+\u00051\u0006CA!X\u0013\tA&IA\u0002J]R\fA\"\\5o)\u0006\u001c8n]0%KF$\"\u0001Q.\t\u000f\u001dC\u0011\u0011!a\u0001-\u0006IQ.\u001b8UCN\\7\u000fI\u0001\u0005S:LG\u000fF\u0002`]B\u0004B\u0001Y1dG6\tq*\u0003\u0002c\u001f\n\u0019Q*\u00199\u0011\u0005\u0011\\gBA3j!\t1')D\u0001h\u0015\tAG$\u0001\u0004=e>|GOP\u0005\u0003U\n\u000ba\u0001\u0015:fI\u00164\u0017B\u00017n\u0005\u0019\u0019FO]5oO*\u0011!N\u0011\u0005\u0006_*\u0001\rAO\u0001\u0003g\u000eDQ!\u001d\u0006A\u0002I\f1a\u0019;y!\t93/\u0003\u0002uQ\ti\u0001\u000b\\;hS:\u001cuN\u001c;fqR\f\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0002\u0001\u000611\r[8pg\u0016$B!\u001f?\u0002\"A\u0019\u0011I_2\n\u0005m\u0014%AB(qi&|g\u000eC\u0003~\u0019\u0001\u0007a0\u0001\u0003mSN$\b#B@\u0002\n\u0005=a\u0002BA\u0001\u0003\u000bq1AZA\u0002\u0013\u0005\u0019\u0015bAA\u0004\u0005\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u0006\u0003\u001b\u00111aU3r\u0015\r\t9A\u0011\t\u0005\u0003#\ti\"\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003\t1\u0018GC\u0002,\u00033Q1!a\u0007\u0017\u0003\u0019\u0019H/\u0019;vg&!\u0011qDA\n\u0005=)\u00050Z2vi>\u00148+^7nCJL\bbBA\u0012\u0019\u0001\u0007\u0011QE\u0001\u0007a>d\u0017nY=\u0011\t\u0005\u001d\u0012q\n\b\u0005\u0003S\tIE\u0004\u0003\u0002,\u0005\rc\u0002BA\u0017\u0003\u007fqA!a\f\u0002<9!\u0011\u0011GA\u001d\u001d\u0011\t\u0019$a\u000e\u000f\u0007\u0019\f)$C\u0001\u001c\u0013\tI\"$\u0003\u0002\u00181%\u0019\u0011Q\b\f\u0002\r\u0011,\u0007\u000f\\8z\u0013\r\t\u0012\u0011\t\u0006\u0004\u0003{1\u0012\u0002BA#\u0003\u000f\naaQ8oM&<'bA\t\u0002B%!\u00111JA'\u0003I)\u00050Z2vi>\u0014(k\u001c7m!>d\u0017nY=\u000b\t\u0005\u0015\u0013qI\u0005\u0005\u0003#\n\u0019FA\u0003WC2,X-C\u0002\u0002V\t\u00131\"\u00128v[\u0016\u0014\u0018\r^5p]\u0006qr.\u001e;mS\u0016\u00148O\u0012:p[6+H\u000e^5qY\u0016$\u0015.\\3og&|gn\u001d\u000b\u0005\u00037\n)\u0007\u0005\u0004\u0002^\u0005\r\u0014qB\u0007\u0003\u0003?R1!!\u0019C\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0017\ty\u0006\u0003\u0004\u0002h5\u0001\rA`\u0001\u0012Y&\u001cHoV5uQ>,H\u000f\u0012:jm\u0016\u0014\u0018\u0001C8vi2LWM]:\u0015\u000by\fi'a\u001c\t\u000but\u0001\u0019\u0001@\t\u000f\u0005Ed\u00021\u0001\u0002t\u0005\u0019q-\u001a;\u0011\u000f\u0005\u000b)(a\u0004\u0002z%\u0019\u0011q\u000f\"\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA!\u0002|%\u0019\u0011Q\u0010\"\u0003\u000b\u0019cw.\u0019;")
public class ExecutorRollDriverPlugin
implements DriverPlugin,
Logging {
    private SparkContext sparkContext;
    private final ScheduledExecutorService periodicService;
    private int minTasks;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public void registerMetrics(String x$1, PluginContext x$2) {
        super.registerMetrics(x$1, x$2);
    }

    public Object receive(Object x$1) throws Exception {
        return super.receive(x$1);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkContext sparkContext() {
        return this.sparkContext;
    }

    private void sparkContext_$eq(SparkContext x$1) {
        this.sparkContext = x$1;
    }

    private ScheduledExecutorService periodicService() {
        return this.periodicService;
    }

    public int minTasks() {
        return this.minTasks;
    }

    public void minTasks_$eq(int x$1) {
        this.minTasks = x$1;
    }

    public java.util.Map<String, String> init(SparkContext sc, PluginContext ctx) {
        Object object;
        long interval = BoxesRunTime.unboxToLong((Object)sc.conf().get(Config$.MODULE$.EXECUTOR_ROLL_INTERVAL()));
        if (interval <= 0L) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Disabled due to invalid interval value, '").append(interval).append("'").toString());
            object = BoxedUnit.UNIT;
        } else if (!BoxesRunTime.unboxToBoolean((Object)sc.conf().get(package$.MODULE$.DECOMMISSION_ENABLED()))) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Disabled because ").append(package$.MODULE$.DECOMMISSION_ENABLED().key()).append(" is false.").toString());
            object = BoxedUnit.UNIT;
        } else {
            this.minTasks_$eq(BoxesRunTime.unboxToInt((Object)sc.conf().get(Config$.MODULE$.MINIMUM_TASKS_PER_EXECUTOR_BEFORE_ROLLING())));
            this.sparkContext_$eq(sc);
            Enumeration.Value policy = Config$ExecutorRollPolicy$.MODULE$.withName((String)sc.conf().get(Config$.MODULE$.EXECUTOR_ROLL_POLICY()));
            object = this.periodicService().scheduleAtFixedRate(() -> {
                block5: {
                    try {
                        SchedulerBackend schedulerBackend = this.sparkContext().schedulerBackend();
                        if (schedulerBackend instanceof KubernetesClusterSchedulerBackend) {
                            KubernetesClusterSchedulerBackend kubernetesClusterSchedulerBackend = (KubernetesClusterSchedulerBackend)schedulerBackend;
                            Seq executorSummaryList = this.sparkContext().statusStore().executorList(true);
                            Option<String> option = this.choose((Seq<ExecutorSummary>)executorSummaryList, policy);
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                String id = (String)some.value();
                                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Ask to decommission executor ").append(id).toString());
                                long now = System.currentTimeMillis();
                                kubernetesClusterSchedulerBackend.decommissionExecutor(id, new ExecutorDecommissionInfo(new StringBuilder(16).append("Rolling via ").append(policy).append(" at ").append(now).toString(), ExecutorDecommissionInfo$.MODULE$.apply$default$2()), false, kubernetesClusterSchedulerBackend.decommissionExecutor$default$4());
                            } else {
                                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "There is nothing to roll.");
                            }
                            break block5;
                        }
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("This plugin expects ").append(KubernetesClusterSchedulerBackend.class.getSimpleName()).append(".").toString());
                    }
                    catch (Throwable e) {
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error in rolling thread", e);
                    }
                }
            }, interval, interval, TimeUnit.SECONDS);
        }
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava();
    }

    public void shutdown() {
        this.periodicService().shutdown();
    }

    private Option<String> choose(Seq<ExecutorSummary> list, Enumeration.Value policy) {
        Seq seq;
        Seq listWithoutDriver = (Seq)((TraversableLike)list.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ExecutorRollDriverPlugin.$anonfun$choose$1(x$1)))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ExecutorRollDriverPlugin.$anonfun$choose$2(this, x$2)));
        Enumeration.Value value = policy;
        Enumeration.Value value2 = Config$ExecutorRollPolicy$.MODULE$.ID();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            seq = (Seq)listWithoutDriver.sortBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)ExecutorRollDriverPlugin.$anonfun$choose$3(x$3)), (Ordering)Ordering.Int$.MODULE$);
        } else {
            Enumeration.Value value4 = Config$ExecutorRollPolicy$.MODULE$.ADD_TIME();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                seq = (Seq)listWithoutDriver.sortBy((Function1 & Serializable & scala.Serializable)x$4 -> x$4.addTime(), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
            } else {
                Enumeration.Value value6 = Config$ExecutorRollPolicy$.MODULE$.TOTAL_GC_TIME();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    seq = (Seq)((SeqLike)listWithoutDriver.sortBy((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.totalGCTime()), (Ordering)Ordering.Long$.MODULE$)).reverse();
                } else {
                    Enumeration.Value value8 = Config$ExecutorRollPolicy$.MODULE$.TOTAL_DURATION();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        seq = (Seq)((SeqLike)listWithoutDriver.sortBy((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.totalDuration()), (Ordering)Ordering.Long$.MODULE$)).reverse();
                    } else {
                        Enumeration.Value value10 = Config$ExecutorRollPolicy$.MODULE$.AVERAGE_DURATION();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            seq = (Seq)((SeqLike)listWithoutDriver.sortBy((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToFloat((float)ExecutorRollDriverPlugin.$anonfun$choose$7(e)), (Ordering)Ordering.Float$.MODULE$)).reverse();
                        } else {
                            Enumeration.Value value12 = Config$ExecutorRollPolicy$.MODULE$.FAILED_TASKS();
                            Enumeration.Value value13 = value;
                            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                seq = (Seq)((SeqLike)listWithoutDriver.sortBy((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.failedTasks()), (Ordering)Ordering.Int$.MODULE$)).reverse();
                            } else {
                                Enumeration.Value value14 = Config$ExecutorRollPolicy$.MODULE$.OUTLIER();
                                Enumeration.Value value15 = value;
                                if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                                    seq = (Seq)this.outliersFromMultipleDimensions((Seq<ExecutorSummary>)listWithoutDriver).$plus$plus((GenTraversableOnce)((SeqLike)listWithoutDriver.sortBy((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.totalDuration()), (Ordering)Ordering.Long$.MODULE$)).reverse(), Seq$.MODULE$.canBuildFrom());
                                } else {
                                    Enumeration.Value value16 = Config$ExecutorRollPolicy$.MODULE$.OUTLIER_NO_FALLBACK();
                                    Enumeration.Value value17 = value;
                                    if (!(value16 != null ? !value16.equals(value17) : value17 != null)) {
                                        seq = this.outliersFromMultipleDimensions((Seq<ExecutorSummary>)listWithoutDriver);
                                    } else {
                                        throw new MatchError((Object)value);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        Seq sortedList = seq;
        return sortedList.headOption().map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.id());
    }

    private Seq<ExecutorSummary> outliersFromMultipleDimensions(Seq<ExecutorSummary> listWithoutDriver) {
        return (Seq)((TraversableLike)((TraversableLike)this.outliers((Seq<ExecutorSummary>)((Seq)listWithoutDriver.filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ExecutorRollDriverPlugin.$anonfun$outliersFromMultipleDimensions$1(x$10)))), (Function1<ExecutorSummary, Object>)(Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToFloat((float)ExecutorRollDriverPlugin.$anonfun$outliersFromMultipleDimensions$2(e))).$plus$plus(this.outliers(listWithoutDriver, (Function1<ExecutorSummary, Object>)(Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToFloat((float)e.totalDuration())), Seq$.MODULE$.canBuildFrom())).$plus$plus(this.outliers(listWithoutDriver, (Function1<ExecutorSummary, Object>)(Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToFloat((float)e.totalGCTime())), Seq$.MODULE$.canBuildFrom())).$plus$plus(this.outliers(listWithoutDriver, (Function1<ExecutorSummary, Object>)(Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToFloat((float)e.failedTasks())), Seq$.MODULE$.canBuildFrom());
    }

    private Seq<ExecutorSummary> outliers(Seq<ExecutorSummary> list, Function1<ExecutorSummary, Object> get) {
        if (list.isEmpty()) {
            return list;
        }
        int size = list.size();
        Seq values = (Seq)list.map(get, Seq$.MODULE$.canBuildFrom());
        float mean = BoxesRunTime.unboxToFloat((Object)values.sum((Numeric)Numeric.FloatIsFractional$.MODULE$)) / (float)size;
        double sd = Math.sqrt(BoxesRunTime.unboxToFloat((Object)((TraversableOnce)values.map((Function1)(JFunction1.mcFF.sp & Serializable & scala.Serializable)v -> (v - mean) * (v - mean), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.FloatIsFractional$.MODULE$)) / (float)size);
        return (Seq)((SeqLike)((SeqLike)list.filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ExecutorRollDriverPlugin.$anonfun$outliers$2(get, mean, sd, e)))).sortBy((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToFloat((float)ExecutorRollDriverPlugin.$anonfun$outliers$3(get, e)), (Ordering)Ordering.Float$.MODULE$)).reverse();
    }

    public static final /* synthetic */ boolean $anonfun$choose$1(ExecutorSummary x$1) {
        return x$1.id().equals(SparkContext$.MODULE$.DRIVER_IDENTIFIER());
    }

    public static final /* synthetic */ boolean $anonfun$choose$2(ExecutorRollDriverPlugin $this, ExecutorSummary x$2) {
        return x$2.totalTasks() >= $this.minTasks();
    }

    public static final /* synthetic */ int $anonfun$choose$3(ExecutorSummary x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3.id())).toInt();
    }

    public static final /* synthetic */ float $anonfun$choose$7(ExecutorSummary e) {
        return (float)e.totalDuration() / (float)Math.max(1, e.totalTasks());
    }

    public static final /* synthetic */ boolean $anonfun$outliersFromMultipleDimensions$1(ExecutorSummary x$10) {
        return x$10.totalTasks() > 0;
    }

    public static final /* synthetic */ float $anonfun$outliersFromMultipleDimensions$2(ExecutorSummary e) {
        return e.totalDuration() / (long)e.totalTasks();
    }

    public static final /* synthetic */ boolean $anonfun$outliers$2(Function1 get$1, float mean$1, double sd$1, ExecutorSummary e) {
        return (double)(BoxesRunTime.unboxToFloat((Object)get$1.apply((Object)e)) - mean$1) > (double)2 * sd$1;
    }

    public static final /* synthetic */ float $anonfun$outliers$3(Function1 get$1, ExecutorSummary e) {
        return BoxesRunTime.unboxToFloat((Object)get$1.apply((Object)e));
    }

    public ExecutorRollDriverPlugin() {
        Logging.$init$((Logging)this);
        this.periodicService = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("executor-roller");
        this.minTasks = 0;
    }
}

