/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Watchable;
import java.io.Closeable;
import java.io.Serializable;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.annotation.Stable;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@Stable
@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001\u0002\b\u0010\u0001qA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005_!)1\b\u0001C\u0001y!I\u0001\t\u0001a\u0001\u0002\u0004%I!\u0011\u0005\n\u0013\u0002\u0001\r\u00111A\u0005\n)C\u0011\u0002\u0015\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\"\t\u000bE\u0003A\u0011\u0001*\t\u000b%\u0004A\u0011\u00016\u0007\t1\u0004A!\u001c\u0005\u0006w%!\ta \u0005\b\u0003\u000bIA\u0011IA\u0004\u0011\u001d\ty#\u0003C!\u0003cAa!a\f\n\t\u0003R'aH#yK\u000e,Ho\u001c:Q_\u0012\u001cx+\u0019;dQNs\u0017\r]:i_R\u001cv.\u001e:dK*\u0011\u0001#E\u0001\u0004Wb\u001a(B\u0001\n\u0014\u0003\u001d\u0019G.^:uKJT!\u0001F\u000b\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(B\u0001\f\u0018\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0012$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00025\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!H\u0012\u0011\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\r\u0005s\u0017PU3g!\t!s%D\u0001&\u0015\t1S#\u0001\u0005j]R,'O\\1m\u0013\tASEA\u0004M_\u001e<\u0017N\\4\u0002\u001dMt\u0017\r]:i_R\u001c8\u000b^8sKB\u00111\u0006L\u0007\u0002\u001f%\u0011Qf\u0004\u0002\u001b\u000bb,7-\u001e;peB{Gm]*oCB\u001c\bn\u001c;t'R|'/Z\u0001\u0011WV\u0014WM\u001d8fi\u0016\u001c8\t\\5f]R\u0004\"\u0001M\u001d\u000e\u0003ER!AM\u001a\u0002\r\rd\u0017.\u001a8u\u0015\t!T'\u0001\u0006lk\n,'O\\3uKNT!AN\u001c\u0002\u000f\u0019\f'M]5dq)\t\u0001(\u0001\u0002j_&\u0011!(\r\u0002\u0011\u0017V\u0014WM\u001d8fi\u0016\u001c8\t\\5f]R\fa\u0001P5oSRtDcA\u001f?\u007fA\u00111\u0006\u0001\u0005\u0006S\r\u0001\rA\u000b\u0005\u0006]\r\u0001\raL\u0001\u0010o\u0006$8\r[\"p]:,7\r^5p]V\t!\t\u0005\u0002D\u000f6\tAI\u0003\u00029\u000b*\ta)\u0001\u0003kCZ\f\u0017B\u0001%E\u0005%\u0019En\\:fC\ndW-A\nxCR\u001c\u0007nQ8o]\u0016\u001cG/[8o?\u0012*\u0017\u000f\u0006\u0002L\u001dB\u0011a\u0004T\u0005\u0003\u001b~\u0011A!\u00168ji\"9q*BA\u0001\u0002\u0004\u0011\u0015a\u0001=%c\u0005\u0001r/\u0019;dQ\u000e{gN\\3di&|g\u000eI\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0017NCQ\u0001V\u0004A\u0002U\u000bQ\"\u00199qY&\u001c\u0017\r^5p]&#\u0007C\u0001,^\u001d\t96\f\u0005\u0002Y?5\t\u0011L\u0003\u0002[7\u00051AH]8pizJ!\u0001X\u0010\u0002\rA\u0013X\rZ3g\u0013\tqvL\u0001\u0004TiJLgn\u001a\u0006\u00039~A3aB1h!\t\u0011W-D\u0001d\u0015\t!W#\u0001\u0006b]:|G/\u0019;j_:L!AZ2\u0003\u000bMKgnY3\"\u0003!\fQa\r\u00182]M\nAa\u001d;paR\t1\nK\u0002\tC\u001e\u00141#\u0012=fGV$xN\u001d)pIN<\u0016\r^2iKJ\u001c2!\u00038u!\ty'/D\u0001q\u0015\t\tX)\u0001\u0003mC:<\u0017BA:q\u0005\u0019y%M[3diB\u0019\u0001'^<\n\u0005Y\f$aB,bi\u000eDWM\u001d\t\u0003qvl\u0011!\u001f\u0006\u0003un\fQ!\\8eK2T!\u0001`\u001a\u0002\u0007\u0005\u0004\u0018.\u0003\u0002\u007fs\n\u0019\u0001k\u001c3\u0015\u0005\u0005\u0005\u0001cAA\u0002\u00135\t\u0001!A\u0007fm\u0016tGOU3dK&4X\r\u001a\u000b\u0006\u0017\u0006%\u00111\u0006\u0005\b\u0003\u0017Y\u0001\u0019AA\u0007\u0003\u0019\t7\r^5p]B!\u0011qBA\u0013\u001d\u0011\t\t\"!\t\u000f\t\u0005M\u0011q\u0004\b\u0005\u0003+\tiB\u0004\u0003\u0002\u0018\u0005mab\u0001-\u0002\u001a%\t\u0001(\u0003\u00027o%\u0011A'N\u0005\u0003eMJ1!a\t2\u0003\u001d9\u0016\r^2iKJLA!a\n\u0002*\t1\u0011i\u0019;j_:T1!a\t2\u0011\u0019\tic\u0003a\u0001o\u0006\u0019\u0001o\u001c3\u0002\u000f=t7\t\\8tKR\u00191*a\r\t\u000f\u0005UB\u00021\u0001\u00028\u0005\tQ\rE\u00021\u0003sI1!a\u000f2\u0005A9\u0016\r^2iKJ,\u0005pY3qi&|g\u000eK\u0002\u0001\u0003\u007f\u00012AYA!\u0013\r\t\u0019e\u0019\u0002\r\t\u00164X\r\\8qKJ\f\u0005/\u001b\u0015\u0004\u0001\u0005\u001d\u0003c\u00012\u0002J%\u0019\u00111J2\u0003\rM#\u0018M\u00197f\u0001")
public class ExecutorPodsWatchSnapshotSource
implements Logging {
    public final ExecutorPodsSnapshotsStore org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$$snapshotsStore;
    private final KubernetesClient kubernetesClient;
    private Closeable watchConnection;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Closeable watchConnection() {
        return this.watchConnection;
    }

    private void watchConnection_$eq(Closeable x$1) {
        this.watchConnection = x$1;
    }

    public void start(String applicationId) {
        Predef$.MODULE$.require(this.watchConnection() == null, (Function0 & Serializable & scala.Serializable)() -> "Cannot start the watcher twice.");
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Starting watch for pods with labels ").append(Constants$.MODULE$.SPARK_APP_ID_LABEL()).append("=").append(applicationId).append(",").append(" ").append(Constants$.MODULE$.SPARK_ROLE_LABEL()).append("=").append(Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE()).append(".").toString());
        this.watchConnection_$eq((Closeable)((Watchable)((Filterable)this.kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).watch((Object)new ExecutorPodsWatcher()));
    }

    public void stop() {
        if (this.watchConnection() != null) {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.watchConnection().close());
            this.watchConnection_$eq(null);
            return;
        }
    }

    public ExecutorPodsWatchSnapshotSource(ExecutorPodsSnapshotsStore snapshotsStore, KubernetesClient kubernetesClient) {
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$$snapshotsStore = snapshotsStore;
        this.kubernetesClient = kubernetesClient;
        Logging.$init$((Logging)this);
    }

    private class ExecutorPodsWatcher
    implements Watcher<Pod> {
        public boolean reconnecting() {
            return super.reconnecting();
        }

        public void eventReceived(Watcher.Action action, Pod pod) {
            String podName = pod.getMetadata().getName();
            this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$ExecutorPodsWatcher$$$outer().logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Received executor pod update for pod named ").append(podName).append(", action ").append(action).toString());
            this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$ExecutorPodsWatcher$$$outer().org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$$snapshotsStore.updatePod(pod);
        }

        public void onClose(WatcherException e) {
            this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$ExecutorPodsWatcher$$$outer().logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Kubernetes client has been closed (this is expected if the application is shutting down.)", (Throwable)e);
        }

        public void onClose() {
            this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$ExecutorPodsWatcher$$$outer().logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Kubernetes client has been closed.");
        }

        public /* synthetic */ ExecutorPodsWatchSnapshotSource org$apache$spark$scheduler$cluster$k8s$ExecutorPodsWatchSnapshotSource$ExecutorPodsWatcher$$$outer() {
            return ExecutorPodsWatchSnapshotSource.this;
        }

        public ExecutorPodsWatcher() {
            if (ExecutorPodsWatchSnapshotSource.this == null) {
                throw null;
            }
        }
    }
}

