/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import com.google.common.io.Files;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapFluentImpl;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.util.DependencyUtils$;
import org.apache.spark.util.Utils$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00154QAC\u0006\u0001#]A\u0001B\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\u0006Q\u0001!\t!\u000b\u0005\bY\u0001\u0011\r\u0011\"\u0003.\u0011\u0019\t\u0004\u0001)A\u0005]!9!\u0007\u0001b\u0001\n\u0013\u0019\u0004BB \u0001A\u0003%A\u0007C\u0003A\u0001\u0011\u0005\u0011\tC\u0003H\u0001\u0011\u0005\u0003\nC\u0003M\u0001\u0011\u0005SJ\u0001\rQ_\u0012$V-\u001c9mCR,7i\u001c8gS\u001el\u0015\r]*uKBT!\u0001D\u0007\u0002\u0011\u0019,\u0017\r^;sKNT!AD\b\u0002\u0007-D4O\u0003\u0002\u0011#\u00051A-\u001a9m_fT!AE\n\u0002\u000bM\u0004\u0018M]6\u000b\u0005Q)\u0012AB1qC\u000eDWMC\u0001\u0017\u0003\ry'oZ\n\u0004\u0001aq\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"AB!osJ+g\r\u0005\u0002 A5\t1\"\u0003\u0002\"\u0017\tY2*\u001e2fe:,G/Z:GK\u0006$XO]3D_:4\u0017nZ*uKB\fAaY8oM\u000e\u0001\u0001CA\u0013'\u001b\u0005i\u0011BA\u0014\u000e\u00059YUOY3s]\u0016$Xm]\"p]\u001a\fa\u0001P5oSRtDC\u0001\u0016,!\ty\u0002\u0001C\u0003#\u0005\u0001\u0007A%A\u0006iCN$V-\u001c9mCR,W#\u0001\u0018\u0011\u0005ey\u0013B\u0001\u0019\u001b\u0005\u001d\u0011un\u001c7fC:\fA\u0002[1t)\u0016l\u0007\u000f\\1uK\u0002\nQbY8oM&<W.\u00199OC6,W#\u0001\u001b\u0011\u0005UbdB\u0001\u001c;!\t9$$D\u00019\u0015\tI4%\u0001\u0004=e>|GOP\u0005\u0003wi\ta\u0001\u0015:fI\u00164\u0017BA\u001f?\u0005\u0019\u0019FO]5oO*\u00111HG\u0001\u000fG>tg-[4nCBt\u0015-\\3!\u00031\u0019wN\u001c4jOV\u0014X\rU8e)\t\u0011U\t\u0005\u0002&\u0007&\u0011A)\u0004\u0002\t'B\f'o\u001b)pI\")ai\u0002a\u0001\u0005\u0006\u0019\u0001o\u001c3\u0002A\u001d,G/\u00113eSRLwN\\1m!>$7+_:uK6\u0004&o\u001c9feRLWm\u001d\u000b\u0002\u0013B!QG\u0013\u001b5\u0013\tYeHA\u0002NCB\f\u0001eZ3u\u0003\u0012$\u0017\u000e^5p]\u0006d7*\u001e2fe:,G/Z:SKN|WO]2fgR\ta\nE\u0002P)^s!\u0001\u0015*\u000f\u0005]\n\u0016\"A\u000e\n\u0005MS\u0012a\u00029bG.\fw-Z\u0005\u0003+Z\u00131aU3r\u0015\t\u0019&\u0004\u0005\u0002YG6\t\u0011L\u0003\u0002[7\u0006)Qn\u001c3fY*\u0011A,X\u0001\u0004CBL'B\u00010`\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0003A\u0006\fqAZ1ce&\u001c\u0007HC\u0001c\u0003\tIw.\u0003\u0002e3\nY\u0001*Y:NKR\fG-\u0019;b\u0001")
public class PodTemplateConfigMapStep
implements KubernetesFeatureConfigStep {
    private final KubernetesConf conf;
    private final boolean hasTemplate;
    private final String configmapName;

    @Override
    public Seq<HasMetadata> getAdditionalPreKubernetesResources() {
        return KubernetesFeatureConfigStep.getAdditionalPreKubernetesResources$(this);
    }

    private boolean hasTemplate() {
        return this.hasTemplate;
    }

    private String configmapName() {
        return this.configmapName;
    }

    @Override
    public SparkPod configurePod(SparkPod pod) {
        if (this.hasTemplate()) {
            Pod podWithVolume = ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((VolumeFluent.ConfigMapNested)((ConfigMapVolumeSourceFluent.ItemsNested)new PodBuilder(pod.pod()).editSpec().addNewVolume().withName(Constants$.MODULE$.POD_TEMPLATE_VOLUME()).withNewConfigMap().withName(this.configmapName()).addNewItem().withKey(Constants$.MODULE$.POD_TEMPLATE_KEY()).withPath(Constants$.MODULE$.EXECUTOR_POD_SPEC_TEMPLATE_FILE_NAME())).endItem()).endConfigMap()).endVolume()).endSpec()).build();
            Container containerWithVolume = ((ContainerBuilder)((ContainerFluent.VolumeMountsNested)new ContainerBuilder(pod.container()).addNewVolumeMount().withName(Constants$.MODULE$.POD_TEMPLATE_VOLUME()).withMountPath(Constants$.MODULE$.EXECUTOR_POD_SPEC_TEMPLATE_MOUNTPATH())).endVolumeMount()).build();
            return new SparkPod(podWithVolume, containerWithVolume);
        }
        return pod;
    }

    @Override
    public Map<String, String> getAdditionalPodSystemProperties() {
        if (this.hasTemplate()) {
            return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.KUBERNETES_EXECUTOR_PODTEMPLATE_FILE().key()), (Object)new StringBuilder(1).append(Constants$.MODULE$.EXECUTOR_POD_SPEC_TEMPLATE_MOUNTPATH()).append("/").append(Constants$.MODULE$.EXECUTOR_POD_SPEC_TEMPLATE_FILE_NAME()).toString())}));
        }
        return Predef$.MODULE$.Map().empty();
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        if (this.hasTemplate()) {
            String podTemplateFile = (String)((Option)this.conf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_PODTEMPLATE_FILE())).get();
            Configuration hadoopConf = SparkHadoopUtil$.MODULE$.get().newConfiguration(this.conf.sparkConf());
            String uri = DependencyUtils$.MODULE$.downloadFile(podTemplateFile, Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()), this.conf.sparkConf(), hadoopConf);
            String file = new URI(uri).getPath();
            String podTemplateString = Files.toString((File)new File(file), (Charset)StandardCharsets.UTF_8);
            return (Seq)new .colon.colon((Object)((ConfigMapBuilder)((ConfigMapFluentImpl)((ConfigMapFluentImpl)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(this.configmapName())).endMetadata()).withImmutable(Predef$.MODULE$.boolean2Boolean(true))).addToData(Constants$.MODULE$.POD_TEMPLATE_KEY(), podTemplateString)).build(), (List)Nil$.MODULE$);
        }
        return Nil$.MODULE$;
    }

    public PodTemplateConfigMapStep(KubernetesConf conf) {
        this.conf = conf;
        KubernetesFeatureConfigStep.$init$(this);
        this.hasTemplate = conf.contains((ConfigEntry<?>)Config$.MODULE$.KUBERNETES_EXECUTOR_PODTEMPLATE_FILE());
        this.configmapName = new StringBuilder(1).append(conf.resourceNamePrefix()).append("-").append(Constants$.MODULE$.POD_TEMPLATE_CONFIGMAP()).toString();
    }
}

