/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Editable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.InOutCreateable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.resource.ResourceProfileManager;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.scheduler.ExecutorKilled$;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$;
import org.apache.spark.scheduler.cluster.k8s.AbstractPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorLifecycleTestUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsPollingSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsWatchSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.GenerateExecID;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.jmock.lib.concurrent.DeterministicScheduler;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tUg\u0001\u0002\"D\u0001ACQa\u0017\u0001\u0005\u0002qCqa\u0018\u0001C\u0002\u0013%\u0001\r\u0003\u0004l\u0001\u0001\u0006I!\u0019\u0005\bY\u0002\u0011\r\u0011\"\u0003n\u0011\u0019\t\b\u0001)A\u0005]\"I!\u000f\u0001a\u0001\u0002\u0004%Ia\u001d\u0005\no\u0002\u0001\r\u00111A\u0005\naD!\"a\u0001\u0001\u0001\u0004\u0005\t\u0015)\u0003u\u0011-\t\u0019\u0002\u0001a\u0001\u0002\u0004%I!!\u0006\t\u0017\u0005u\u0001\u00011AA\u0002\u0013%\u0011q\u0004\u0005\f\u0003G\u0001\u0001\u0019!A!B\u0013\t9\u0002C\u0006\u0002(\u0001\u0001\r\u00111A\u0005\n\u0005%\u0002bCA\u001c\u0001\u0001\u0007\t\u0019!C\u0005\u0003sA1\"!\u0010\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002,!Y\u0011\u0011\t\u0001A\u0002\u0003\u0007I\u0011BA\"\u0011-\tY\u0005\u0001a\u0001\u0002\u0004%I!!\u0014\t\u0017\u0005E\u0003\u00011A\u0001B\u0003&\u0011Q\t\u0005\f\u0003+\u0002\u0001\u0019!a\u0001\n\u0013\t9\u0006C\u0006\u0002r\u0001\u0001\r\u00111A\u0005\n\u0005M\u0004bCA<\u0001\u0001\u0007\t\u0011)Q\u0005\u00033B1\"a\u001f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002~!Y\u0011Q\u0016\u0001A\u0002\u0003\u0007I\u0011BAX\u0011-\t\u0019\f\u0001a\u0001\u0002\u0003\u0006K!a \t\u0017\u0005]\u0006\u00011AA\u0002\u0013%\u0011\u0011\u0018\u0005\f\u0003\u0003\u0004\u0001\u0019!a\u0001\n\u0013\t\u0019\rC\u0006\u0002H\u0002\u0001\r\u0011!Q!\n\u0005m\u0006bCAf\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001bD1\"!6\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002X\"Y\u00111\u001c\u0001A\u0002\u0003\u0005\u000b\u0015BAh\u0011-\ty\u000e\u0001a\u0001\u0002\u0004%I!!9\t\u0017\u0005%\b\u00011AA\u0002\u0013%\u00111\u001e\u0005\f\u0003_\u0004\u0001\u0019!A!B\u0013\t\u0019\u000fC\u0006\u0002t\u0002\u0001\r\u00111A\u0005\n\u0005U\bbCA\u0000\u0001\u0001\u0007\t\u0019!C\u0005\u0005\u0003A1B!\u0002\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002x\"Y!\u0011\u0002\u0001A\u0002\u0003\u0007I\u0011\u0002B\u0006\u0011-\u0011\u0019\u0002\u0001a\u0001\u0002\u0004%IA!\u0006\t\u0017\te\u0001\u00011A\u0001B\u0003&!Q\u0002\u0005\f\u0005;\u0001\u0001\u0019!a\u0001\n\u0013\u0011y\u0002C\u0006\u0003(\u0001\u0001\r\u00111A\u0005\n\t%\u0002b\u0003B\u0017\u0001\u0001\u0007\t\u0011)Q\u0005\u0005CA1B!\r\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00034!Y!1\b\u0001A\u0002\u0003\u0007I\u0011\u0002B\u001f\u0011-\u0011\t\u0005\u0001a\u0001\u0002\u0003\u0006KA!\u000e\t\u0017\t\u0015\u0003\u00011AA\u0002\u0013%!q\t\u0005\f\u0005\u001f\u0002\u0001\u0019!a\u0001\n\u0013\u0011\t\u0006C\u0006\u0003V\u0001\u0001\r\u0011!Q!\n\t%\u0003b\u0003B-\u0001\u0001\u0007\t\u0019!C\u0005\u00057B1Ba\u0019\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003f!Y!\u0011\u000e\u0001A\u0002\u0003\u0005\u000b\u0015\u0002B/\u0011-\u0011i\u0007\u0001a\u0001\u0002\u0004%IAa\u001c\t\u0017\t]\u0004\u00011AA\u0002\u0013%!\u0011\u0010\u0005\f\u0005{\u0002\u0001\u0019!A!B\u0013\u0011\t\bC\u0006\u0003\u0002\u0002\u0001\r\u00111A\u0005\n\t\r\u0005b\u0003BI\u0001\u0001\u0007\t\u0019!C\u0005\u0005'C1Ba&\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003\u0006\"Y!\u0011\u0014\u0001A\u0002\u0003\u0007I\u0011\u0002BN\u0011-\u0011\u0019\u000b\u0001a\u0001\u0002\u0004%IA!*\t\u0017\t%\u0006\u00011A\u0001B\u0003&!Q\u0014\u0005\n\u0005W\u0003!\u0019!C\u0005\u0005[C\u0001B!.\u0001A\u0003%!q\u0016\u0005\n\u0005o\u0003!\u0019!C\u0005\u0005sC\u0001Ba2\u0001A\u0003%!1\u0018\u0005\n\u0005\u0013\u0004!\u0019!C\u0005\u0005\u0017D\u0001Ba5\u0001A\u0003%!Q\u001a\u0002'\u0017V\u0014WM\u001d8fi\u0016\u001c8\t\\;ti\u0016\u00148k\u00195fIVdWM\u001d\"bG.,g\u000eZ*vSR,'B\u0001#F\u0003\rY\u0007h\u001d\u0006\u0003\r\u001e\u000bqa\u00197vgR,'O\u0003\u0002I\u0013\u0006I1o\u00195fIVdWM\u001d\u0006\u0003\u0015.\u000bQa\u001d9be.T!\u0001T'\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0015aA8sO\u000e\u00011c\u0001\u0001R+B\u0011!kU\u0007\u0002\u0013&\u0011A+\u0013\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005YKV\"A,\u000b\u0005ak\u0015!C:dC2\fG/Z:u\u0013\tQvK\u0001\bCK\u001a|'/Z!oI\u00063G/\u001a:\u0002\rqJg.\u001b;?)\u0005i\u0006C\u00010\u0001\u001b\u0005\u0019\u0015\u0001G:dQ\u0016$W\u000f\\3s\u000bb,7-\u001e;peN+'O^5dKV\t\u0011\r\u0005\u0002cS6\t1M\u0003\u0002eK\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\u0019<\u0017a\u00017jE*\u0011\u0001.T\u0001\u0006U6|7m[\u0005\u0003U\u000e\u0014a\u0003R3uKJl\u0017N\\5ti&\u001c7k\u00195fIVdWM]\u0001\u001ag\u000eDW\rZ;mKJ,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0007%A\u0005ta\u0006\u00148nQ8oMV\ta\u000e\u0005\u0002S_&\u0011\u0001/\u0013\u0002\n'B\f'o[\"p]\u001a\f!b\u001d9be.\u001cuN\u001c4!\u0003\t\u00198-F\u0001u!\t\u0011V/\u0003\u0002w\u0013\na1\u000b]1sW\u000e{g\u000e^3yi\u000611oY0%KF$\"!_@\u0011\u0005ilX\"A>\u000b\u0003q\fQa]2bY\u0006L!A`>\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u00039\u0011\u0011!a\u0001i\u0006\u0019\u0001\u0010J\u0019\u0002\u0007M\u001c\u0007\u0005K\u0002\t\u0003\u000f\u0001B!!\u0003\u0002\u00105\u0011\u00111\u0002\u0006\u0004\u0003\u001bi\u0015aB7pG.LGo\\\u0005\u0005\u0003#\tYA\u0001\u0003N_\u000e\\\u0017aA3omV\u0011\u0011q\u0003\t\u0004%\u0006e\u0011bAA\u000e\u0013\nA1\u000b]1sW\u0016sg/A\u0004f]Z|F%Z9\u0015\u0007e\f\t\u0003C\u0005\u0002\u0002)\t\t\u00111\u0001\u0002\u0018\u0005!QM\u001c<!Q\rY\u0011qA\u0001\u0007eB\u001cWI\u001c<\u0016\u0005\u0005-\u0002\u0003BA\u0017\u0003gi!!a\f\u000b\u0007\u0005E\u0012*A\u0002sa\u000eLA!!\u000e\u00020\t1!\u000b]2F]Z\f!B\u001d9d\u000b:4x\fJ3r)\rI\u00181\b\u0005\n\u0003\u0003i\u0011\u0011!a\u0001\u0003W\tqA\u001d9d\u000b:4\b\u0005K\u0002\u000f\u0003\u000f\t\u0011\u0003\u001a:jm\u0016\u0014XI\u001c3q_&tGOU3g+\t\t)\u0005\u0005\u0003\u0002.\u0005\u001d\u0013\u0002BA%\u0003_\u0011aB\u00159d\u000b:$\u0007o\\5oiJ+g-A\u000bee&4XM]#oIB|\u0017N\u001c;SK\u001a|F%Z9\u0015\u0007e\fy\u0005C\u0005\u0002\u0002A\t\t\u00111\u0001\u0002F\u0005\u0011BM]5wKJ,e\u000e\u001a9pS:$(+\u001a4!Q\r\t\u0012qA\u0001\u0011WV\u0014WM\u001d8fi\u0016\u001c8\t\\5f]R,\"!!\u0017\u0011\t\u0005m\u0013QN\u0007\u0003\u0003;RA!a\u0018\u0002b\u000511\r\\5f]RTA!a\u0019\u0002f\u0005Q1.\u001e2fe:,G/Z:\u000b\t\u0005\u001d\u0014\u0011N\u0001\bM\u0006\u0014'/[29\u0015\t\tY'\u0001\u0002j_&!\u0011qNA/\u0005AYUOY3s]\u0016$Xm]\"mS\u0016tG/\u0001\u000blk\n,'O\\3uKN\u001cE.[3oi~#S-\u001d\u000b\u0004s\u0006U\u0004\"CA\u0001'\u0005\u0005\t\u0019AA-\u0003EYWOY3s]\u0016$Xm]\"mS\u0016tG\u000f\t\u0015\u0004)\u0005\u001d\u0011!\u00049pI>\u0003XM]1uS>t7/\u0006\u0002\u0002\u0000A!\u0011\u0011QAT\u001d\u0011\t\u0019)!)\u000f\t\u0005\u0015\u0015Q\u0014\b\u0005\u0003\u000f\u000bIJ\u0004\u0003\u0002\n\u0006]e\u0002BAF\u0003+sA!!$\u0002\u00146\u0011\u0011q\u0012\u0006\u0004\u0003#{\u0015A\u0002\u001fs_>$h(C\u0001O\u0013\taU*\u0003\u0002K\u0017&\u0019\u00111T%\u0002\r\u0011,\u0007\u000f\\8z\u0013\r!\u0015q\u0014\u0006\u0004\u00037K\u0015\u0002BAR\u0003K\u000baBR1ce&\u001c\u0007(\u00117jCN,7OC\u0002E\u0003?KA!!+\u0002,\n!\u0001k\u0014#T\u0015\u0011\t\u0019+!*\u0002#A|Gm\u00149fe\u0006$\u0018n\u001c8t?\u0012*\u0017\u000fF\u0002z\u0003cC\u0011\"!\u0001\u0017\u0003\u0003\u0005\r!a \u0002\u001dA|Gm\u00149fe\u0006$\u0018n\u001c8tA!\u001aq#a\u0002\u0002\u00171\f'-\u001a7fIB{Gm]\u000b\u0003\u0003w\u0003B!!!\u0002>&!\u0011qXAV\u00051a\u0015IQ#M\u000b\u0012{\u0006k\u0014#T\u0003=a\u0017MY3mK\u0012\u0004v\u000eZ:`I\u0015\fHcA=\u0002F\"I\u0011\u0011A\r\u0002\u0002\u0003\u0007\u00111X\u0001\rY\u0006\u0014W\r\\3e!>$7\u000f\t\u0015\u00045\u0005\u001d\u0011\u0001F2p]\u001aLw-T1qg>\u0003XM]1uS>t7/\u0006\u0002\u0002PB!\u0011\u0011QAi\u0013\u0011\t\u0019.a+\u0003\u0017\r{eJR%H?6\u000b\u0005kU\u0001\u0019G>tg-[4NCB\u001cx\n]3sCRLwN\\:`I\u0015\fHcA=\u0002Z\"I\u0011\u0011\u0001\u000f\u0002\u0002\u0003\u0007\u0011qZ\u0001\u0016G>tg-[4NCB\u001cx\n]3sCRLwN\\:!Q\ri\u0012qA\u0001\u0012Y\u0006\u0014W\r\\3e\u0007>tg-[4NCB\u001cXCAAr!\u0011\t\t)!:\n\t\u0005\u001d\u00181\u0016\u0002\u0014\u0019\u0006\u0013U\tT#E?\u000e{eJR%H?6\u000b\u0005kU\u0001\u0016Y\u0006\u0014W\r\\3e\u0007>tg-[4NCB\u001cx\fJ3r)\rI\u0018Q\u001e\u0005\n\u0003\u0003y\u0012\u0011!a\u0001\u0003G\f!\u0003\\1cK2,GmQ8oM&<W*\u00199tA!\u001a\u0001%a\u0002\u0002\u001bQ\f7o[*dQ\u0016$W\u000f\\3s+\t\t9\u0010\u0005\u0003\u0002z\u0006mX\"A$\n\u0007\u0005uxIA\tUCN\\7k\u00195fIVdWM]%na2\f\u0011\u0003^1tWN\u001b\u0007.\u001a3vY\u0016\u0014x\fJ3r)\rI(1\u0001\u0005\n\u0003\u0003\u0011\u0013\u0011!a\u0001\u0003o\fa\u0002^1tWN\u001b\u0007.\u001a3vY\u0016\u0014\b\u0005K\u0002$\u0003\u000f\t!\"\u001a<f]R\fV/Z;f+\t\u0011i\u0001E\u0002_\u0005\u001fI1A!\u0005D\u0005i)\u00050Z2vi>\u0014\bk\u001c3t':\f\u0007o\u001d5piN\u001cFo\u001c:f\u00039)g/\u001a8u#V,W/Z0%KF$2!\u001fB\f\u0011%\t\t!JA\u0001\u0002\u0004\u0011i!A\u0006fm\u0016tG/U;fk\u0016\u0004\u0003f\u0001\u0014\u0002\b\u0005a\u0001o\u001c3BY2|7-\u0019;peV\u0011!\u0011\u0005\t\u0004=\n\r\u0012b\u0001B\u0013\u0007\n)R\t_3dkR|'\u000fU8eg\u0006cGn\\2bi>\u0014\u0018\u0001\u00059pI\u0006cGn\\2bi>\u0014x\fJ3r)\rI(1\u0006\u0005\n\u0003\u0003A\u0013\u0011!a\u0001\u0005C\tQ\u0002]8e\u00032dwnY1u_J\u0004\u0003fA\u0015\u0002\b\u0005)B.\u001b4fGf\u001cG.Z#wK:$\b*\u00198eY\u0016\u0014XC\u0001B\u001b!\rq&qG\u0005\u0004\u0005s\u0019%\u0001H#yK\u000e,Ho\u001c:Q_\u0012\u001cH*\u001b4fGf\u001cG.Z'b]\u0006<WM]\u0001\u001aY&4WmY=dY\u0016,e/\u001a8u\u0011\u0006tG\r\\3s?\u0012*\u0017\u000fF\u0002z\u0005\u007fA\u0011\"!\u0001,\u0003\u0003\u0005\rA!\u000e\u0002-1Lg-Z2zG2,WI^3oi\"\u000bg\u000e\u001a7fe\u0002B3\u0001LA\u0004\u0003-9\u0018\r^2i\u000bZ,g\u000e^:\u0016\u0005\t%\u0003c\u00010\u0003L%\u0019!QJ\"\u0003?\u0015CXmY;u_J\u0004v\u000eZ:XCR\u001c\u0007n\u00158baNDw\u000e^*pkJ\u001cW-A\bxCR\u001c\u0007.\u0012<f]R\u001cx\fJ3r)\rI(1\u000b\u0005\n\u0003\u0003q\u0013\u0011!a\u0001\u0005\u0013\nAb^1uG\",e/\u001a8ug\u0002B3aLA\u0004\u0003)\u0001x\u000e\u001c7Fm\u0016tGo]\u000b\u0003\u0005;\u00022A\u0018B0\u0013\r\u0011\tg\u0011\u0002\"\u000bb,7-\u001e;peB{Gm\u001d)pY2LgnZ*oCB\u001c\bn\u001c;T_V\u00148-Z\u0001\u000fa>dG.\u0012<f]R\u001cx\fJ3r)\rI(q\r\u0005\n\u0003\u0003\t\u0014\u0011!a\u0001\u0005;\n1\u0002]8mY\u00163XM\u001c;tA!\u001a!'a\u0002\u0002\u000f\r|g\u000e^3yiV\u0011!\u0011\u000f\t\u0005\u0003[\u0011\u0019(\u0003\u0003\u0003v\u0005=\"A\u0004*qG\u000e\u000bG\u000e\\\"p]R,\u0007\u0010^\u0001\fG>tG/\u001a=u?\u0012*\u0017\u000fF\u0002z\u0005wB\u0011\"!\u00015\u0003\u0003\u0005\rA!\u001d\u0002\u0011\r|g\u000e^3yi\u0002B3!NA\u0004\u00039!'/\u001b<fe\u0016sG\r]8j]R,\"A!\"\u0011\r\u0005%!q\u0011BF\u0013\u0011\u0011I)a\u0003\u0003\u001d\u0005\u0013x-^7f]R\u001c\u0015\r\u001d;peB!\u0011Q\u0006BG\u0013\u0011\u0011y)a\f\u0003\u0017I\u00038-\u00128ea>Lg\u000e^\u0001\u0013IJLg/\u001a:F]\u0012\u0004x.\u001b8u?\u0012*\u0017\u000fF\u0002z\u0005+C\u0011\"!\u00018\u0003\u0003\u0005\rA!\"\u0002\u001f\u0011\u0014\u0018N^3s\u000b:$\u0007o\\5oi\u0002\n\u0011d]2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3V]\u0012,'\u000fV3tiV\u0011!Q\u0014\t\u0004=\n}\u0015b\u0001BQ\u0007\n\t3*\u001e2fe:,G/Z:DYV\u001cH/\u001a:TG\",G-\u001e7fe\n\u000b7m[3oI\u0006i2o\u00195fIVdWM\u001d\"bG.,g\u000eZ+oI\u0016\u0014H+Z:u?\u0012*\u0017\u000fF\u0002z\u0005OC\u0011\"!\u0001;\u0003\u0003\u0005\rA!(\u00025M\u001c\u0007.\u001a3vY\u0016\u0014()Y2lK:$WK\u001c3feR+7\u000f\u001e\u0011\u0002\u00171L7\u000f^3oKJ\u0014Uo]\u000b\u0003\u0005_\u0003B!!?\u00032&\u0019!1W$\u0003\u001f1Kg/\u001a'jgR,g.\u001a:CkN\fA\u0002\\5ti\u0016tWM\u001d\"vg\u0002\naC]3t_V\u00148-\u001a)s_\u001aLG.Z'b]\u0006<WM]\u000b\u0003\u0005w\u0003BA!0\u0003D6\u0011!q\u0018\u0006\u0004\u0005\u0003L\u0015\u0001\u0003:fg>,(oY3\n\t\t\u0015'q\u0018\u0002\u0017%\u0016\u001cx.\u001e:dKB\u0013xNZ5mK6\u000bg.Y4fe\u00069\"/Z:pkJ\u001cW\r\u0015:pM&dW-T1oC\u001e,'\u000fI\u0001\u000fI\u00164\u0017-\u001e7u!J|g-\u001b7f+\t\u0011i\r\u0005\u0003\u0003>\n=\u0017\u0002\u0002Bi\u0005\u007f\u0013qBU3t_V\u00148-\u001a)s_\u001aLG.Z\u0001\u0010I\u00164\u0017-\u001e7u!J|g-\u001b7fA\u0001")
public class KubernetesClusterSchedulerBackendSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final DeterministicScheduler schedulerExecutorService;
    private final SparkConf sparkConf;
    @Mock
    private SparkContext sc;
    @Mock
    private SparkEnv env;
    @Mock
    private RpcEnv rpcEnv;
    @Mock
    private RpcEndpointRef driverEndpointRef;
    @Mock
    private KubernetesClient kubernetesClient;
    @Mock
    private MixedOperation<Pod, PodList, PodResource<Pod>> podOperations;
    @Mock
    private FilterWatchListDeletable<Pod, PodList> labeledPods;
    @Mock
    private MixedOperation<ConfigMap, ConfigMapList, Resource<ConfigMap>> configMapsOperations;
    @Mock
    private FilterWatchListDeletable<ConfigMap, ConfigMapList> labeledConfigMaps;
    @Mock
    private TaskSchedulerImpl taskScheduler;
    @Mock
    private ExecutorPodsSnapshotsStore eventQueue;
    @Mock
    private ExecutorPodsAllocator podAllocator;
    @Mock
    private ExecutorPodsLifecycleManager lifecycleEventHandler;
    @Mock
    private ExecutorPodsWatchSnapshotSource watchEvents;
    @Mock
    private ExecutorPodsPollingSnapshotSource pollEvents;
    @Mock
    private RpcCallContext context;
    private ArgumentCaptor<RpcEndpoint> driverEndpoint;
    private KubernetesClusterSchedulerBackend schedulerBackendUnderTest;
    private final LiveListenerBus listenerBus;
    private final ResourceProfileManager resourceProfileManager;
    private final ResourceProfile defaultProfile;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private DeterministicScheduler schedulerExecutorService() {
        return this.schedulerExecutorService;
    }

    private SparkConf sparkConf() {
        return this.sparkConf;
    }

    private SparkContext sc() {
        return this.sc;
    }

    private void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    private SparkEnv env() {
        return this.env;
    }

    private void env_$eq(SparkEnv x$1) {
        this.env = x$1;
    }

    private RpcEnv rpcEnv() {
        return this.rpcEnv;
    }

    private void rpcEnv_$eq(RpcEnv x$1) {
        this.rpcEnv = x$1;
    }

    private RpcEndpointRef driverEndpointRef() {
        return this.driverEndpointRef;
    }

    private void driverEndpointRef_$eq(RpcEndpointRef x$1) {
        this.driverEndpointRef = x$1;
    }

    private KubernetesClient kubernetesClient() {
        return this.kubernetesClient;
    }

    private void kubernetesClient_$eq(KubernetesClient x$1) {
        this.kubernetesClient = x$1;
    }

    private MixedOperation<Pod, PodList, PodResource<Pod>> podOperations() {
        return this.podOperations;
    }

    private void podOperations_$eq(MixedOperation<Pod, PodList, PodResource<Pod>> x$1) {
        this.podOperations = x$1;
    }

    private FilterWatchListDeletable<Pod, PodList> labeledPods() {
        return this.labeledPods;
    }

    private void labeledPods_$eq(FilterWatchListDeletable<Pod, PodList> x$1) {
        this.labeledPods = x$1;
    }

    private MixedOperation<ConfigMap, ConfigMapList, Resource<ConfigMap>> configMapsOperations() {
        return this.configMapsOperations;
    }

    private void configMapsOperations_$eq(MixedOperation<ConfigMap, ConfigMapList, Resource<ConfigMap>> x$1) {
        this.configMapsOperations = x$1;
    }

    private FilterWatchListDeletable<ConfigMap, ConfigMapList> labeledConfigMaps() {
        return this.labeledConfigMaps;
    }

    private void labeledConfigMaps_$eq(FilterWatchListDeletable<ConfigMap, ConfigMapList> x$1) {
        this.labeledConfigMaps = x$1;
    }

    private TaskSchedulerImpl taskScheduler() {
        return this.taskScheduler;
    }

    private void taskScheduler_$eq(TaskSchedulerImpl x$1) {
        this.taskScheduler = x$1;
    }

    private ExecutorPodsSnapshotsStore eventQueue() {
        return this.eventQueue;
    }

    private void eventQueue_$eq(ExecutorPodsSnapshotsStore x$1) {
        this.eventQueue = x$1;
    }

    private ExecutorPodsAllocator podAllocator() {
        return this.podAllocator;
    }

    private void podAllocator_$eq(ExecutorPodsAllocator x$1) {
        this.podAllocator = x$1;
    }

    private ExecutorPodsLifecycleManager lifecycleEventHandler() {
        return this.lifecycleEventHandler;
    }

    private void lifecycleEventHandler_$eq(ExecutorPodsLifecycleManager x$1) {
        this.lifecycleEventHandler = x$1;
    }

    private ExecutorPodsWatchSnapshotSource watchEvents() {
        return this.watchEvents;
    }

    private void watchEvents_$eq(ExecutorPodsWatchSnapshotSource x$1) {
        this.watchEvents = x$1;
    }

    private ExecutorPodsPollingSnapshotSource pollEvents() {
        return this.pollEvents;
    }

    private void pollEvents_$eq(ExecutorPodsPollingSnapshotSource x$1) {
        this.pollEvents = x$1;
    }

    private RpcCallContext context() {
        return this.context;
    }

    private void context_$eq(RpcCallContext x$1) {
        this.context = x$1;
    }

    private ArgumentCaptor<RpcEndpoint> driverEndpoint() {
        return this.driverEndpoint;
    }

    private void driverEndpoint_$eq(ArgumentCaptor<RpcEndpoint> x$1) {
        this.driverEndpoint = x$1;
    }

    private KubernetesClusterSchedulerBackend schedulerBackendUnderTest() {
        return this.schedulerBackendUnderTest;
    }

    private void schedulerBackendUnderTest_$eq(KubernetesClusterSchedulerBackend x$1) {
        this.schedulerBackendUnderTest = x$1;
    }

    private LiveListenerBus listenerBus() {
        return this.listenerBus;
    }

    private ResourceProfileManager resourceProfileManager() {
        return this.resourceProfileManager;
    }

    private ResourceProfile defaultProfile() {
        return this.defaultProfile;
    }

    public KubernetesClusterSchedulerBackendSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.schedulerExecutorService = new DeterministicScheduler();
        this.sparkConf = new SparkConf(false).set("spark.executor.instances", "3").set("spark.app.id", ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID()).set(Config$.MODULE$.KUBERNETES_EXECUTOR_DECOMMISSION_LABEL().key(), "soLong").set(Config$.MODULE$.KUBERNETES_EXECUTOR_DECOMMISSION_LABEL_VALUE().key(), "cruelWorld");
        this.listenerBus = new LiveListenerBus(new SparkConf());
        this.resourceProfileManager = new ResourceProfileManager(this.sparkConf(), this.listenerBus());
        this.defaultProfile = ResourceProfile$.MODULE$.getOrCreateDefaultProfile(this.sparkConf());
        this.before((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MockitoAnnotations.openMocks((Object)((Object)this)).close();
            Mockito.when((Object)this.taskScheduler().sc()).thenReturn((Object)this.sc());
            Mockito.when((Object)this.sc().conf()).thenReturn((Object)this.sparkConf());
            Mockito.when((Object)this.sc().resourceProfileManager()).thenReturn((Object)this.resourceProfileManager());
            Mockito.when((Object)this.sc().env()).thenReturn((Object)this.env());
            Mockito.when((Object)this.env().rpcEnv()).thenReturn((Object)this.rpcEnv());
            this.driverEndpoint_$eq((ArgumentCaptor<RpcEndpoint>)ArgumentCaptor.forClass(RpcEndpoint.class));
            Mockito.when((Object)this.rpcEnv().setupEndpoint((String)ArgumentMatchers.eq((Object)CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME()), (RpcEndpoint)this.driverEndpoint().capture())).thenReturn((Object)this.driverEndpointRef());
            Mockito.when((Object)this.kubernetesClient().pods()).thenReturn(this.podOperations());
            Mockito.when((Object)this.kubernetesClient().configMaps()).thenReturn(this.configMapsOperations());
            Mockito.when((Object)this.podAllocator().driverPod()).thenReturn((Object)None$.MODULE$);
            this.schedulerBackendUnderTest_$eq(new KubernetesClusterSchedulerBackend(this.taskScheduler(), this.sc(), this.kubernetesClient(), (ScheduledExecutorService)this.schedulerExecutorService(), this.eventQueue(), (AbstractPodsAllocator)this.podAllocator(), this.lifecycleEventHandler(), this.watchEvents(), this.pollEvents()));
        }, new Position("KubernetesClusterSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.test("Start all components", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.schedulerBackendUnderTest().start();
            ((ExecutorPodsAllocator)Mockito.verify((Object)this.podAllocator())).setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)3))})));
            ((ExecutorPodsAllocator)Mockito.verify((Object)this.podAllocator())).start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID(), this.schedulerBackendUnderTest());
            ((ExecutorPodsLifecycleManager)Mockito.verify((Object)this.lifecycleEventHandler())).start(this.schedulerBackendUnderTest());
            ((ExecutorPodsWatchSnapshotSource)Mockito.verify((Object)this.watchEvents())).start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID());
            ((ExecutorPodsPollingSnapshotSource)Mockito.verify((Object)this.pollEvents())).start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID());
            return (ConfigMap)((InOutCreateable)Mockito.verify(this.configMapsOperations())).create(ArgumentMatchers.any());
        }, new Position("KubernetesClusterSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        this.test("Stop all components", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.configMapsOperations().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.labeledConfigMaps());
            Mockito.when((Object)this.labeledConfigMaps().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.labeledConfigMaps());
            this.schedulerBackendUnderTest().stop();
            ((ExecutorPodsSnapshotsStore)Mockito.verify((Object)this.eventQueue())).stop();
            ((ExecutorPodsWatchSnapshotSource)Mockito.verify((Object)this.watchEvents())).stop();
            ((ExecutorPodsPollingSnapshotSource)Mockito.verify((Object)this.pollEvents())).stop();
            ((ExecutorPodsAllocator)Mockito.verify((Object)this.podAllocator())).stop(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID());
            ((Deletable)Mockito.verify(this.labeledConfigMaps())).delete();
            ((Client)Mockito.verify((Object)this.kubernetesClient())).close();
        }, new Position("KubernetesClusterSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        this.test("Remove executor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            KubernetesClusterSchedulerBackend backend = (KubernetesClusterSchedulerBackend)Mockito.spy((Object)this.schedulerBackendUnderTest());
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)backend.isExecutorActive((String)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)backend.isExecutorActive((String)ArgumentMatchers.eq((Object)"2")))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
            backend.start();
            backend.doRemoveExecutor("1", (ExecutorLossReason)ExecutorKilled$.MODULE$);
            ((RpcEndpointRef)Mockito.verify((Object)this.driverEndpointRef())).send((Object)new CoarseGrainedClusterMessages.RemoveExecutor("1", (ExecutorLossReason)ExecutorKilled$.MODULE$));
            backend.doRemoveExecutor("2", (ExecutorLossReason)ExecutorKilled$.MODULE$);
            ((RpcEndpointRef)Mockito.verify((Object)this.driverEndpointRef())).send((Object)new CoarseGrainedClusterMessages.RemoveExecutor("2", (ExecutorLossReason)ExecutorKilled$.MODULE$));
        }, new Position("KubernetesClusterSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
        this.test("Kill executors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.schedulerBackendUnderTest().start();
            NonNamespaceOperation operation = (NonNamespaceOperation)Mockito.mock(NonNamespaceOperation.class);
            Mockito.when((Object)this.podOperations().inNamespace((String)ArgumentMatchers.any())).thenReturn((Object)operation);
            Mockito.when((Object)this.podOperations().withField((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.labeledPods());
            Mockito.when((Object)this.labeledPods().withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"1", "2"})).thenReturn(this.labeledPods());
            Pod pod1 = (Pod)Mockito.mock(Pod.class);
            ObjectMeta pod1Metadata = (ObjectMeta)Mockito.mock(ObjectMeta.class);
            Mockito.when((Object)pod1Metadata.getNamespace()).thenReturn((Object)"coffeeIsLife");
            Mockito.when((Object)pod1Metadata.getName()).thenReturn((Object)"pod1");
            Mockito.when((Object)pod1.getMetadata()).thenReturn((Object)pod1Metadata);
            Pod pod2 = (Pod)Mockito.mock(Pod.class);
            ObjectMeta pod2Metadata = (ObjectMeta)Mockito.mock(ObjectMeta.class);
            Mockito.when((Object)pod2Metadata.getNamespace()).thenReturn((Object)"coffeeIsLife");
            Mockito.when((Object)pod2Metadata.getName()).thenReturn((Object)"pod2");
            Mockito.when((Object)pod2.getMetadata()).thenReturn((Object)pod2Metadata);
            PodResource pod1op = (PodResource)Mockito.mock(PodResource.class);
            PodResource pod2op = (PodResource)Mockito.mock(PodResource.class);
            Mockito.when((Object)operation.withName("pod1")).thenReturn((Object)pod1op);
            Mockito.when((Object)operation.withName("pod2")).thenReturn((Object)pod2op);
            PodList podList = (PodList)Mockito.mock(PodList.class);
            Mockito.when((Object)this.labeledPods().list()).thenReturn((Object)podList);
            Mockito.when((Object)podList.getItems()).thenReturn(Arrays.asList((Object[])new Pod[0]));
            this.schedulerExecutorService().tick(BoxesRunTime.unboxToLong((Object)this.sparkConf().get(Config$.MODULE$.KUBERNETES_DYN_ALLOC_KILL_GRACE_PERIOD())) * 2L, TimeUnit.MILLISECONDS);
            ((Deletable)Mockito.verify(this.labeledPods(), (VerificationMode)Mockito.never())).delete();
            this.schedulerBackendUnderTest().doKillExecutors((Seq)new .colon.colon((Object)"1", (List)new .colon.colon((Object)"2", (List)Nil$.MODULE$)));
            ((RpcEndpointRef)Mockito.verify((Object)this.driverEndpointRef())).send((Object)new CoarseGrainedClusterMessages.RemoveExecutor("1", (ExecutorLossReason)ExecutorKilled$.MODULE$));
            ((RpcEndpointRef)Mockito.verify((Object)this.driverEndpointRef())).send((Object)new CoarseGrainedClusterMessages.RemoveExecutor("2", (ExecutorLossReason)ExecutorKilled$.MODULE$));
            ((Deletable)Mockito.verify(this.labeledPods(), (VerificationMode)Mockito.never())).delete();
            ((Editable)Mockito.verify((Object)pod1op, (VerificationMode)Mockito.never())).edit((UnaryOperator)ArgumentMatchers.any(UnaryOperator.class));
            ((Editable)Mockito.verify((Object)pod2op, (VerificationMode)Mockito.never())).edit((UnaryOperator)ArgumentMatchers.any(UnaryOperator.class));
            this.schedulerExecutorService().tick(BoxesRunTime.unboxToLong((Object)this.sparkConf().get(Config$.MODULE$.KUBERNETES_DYN_ALLOC_KILL_GRACE_PERIOD())) * 2L, TimeUnit.MILLISECONDS);
            ((Deletable)Mockito.verify(this.labeledPods(), (VerificationMode)Mockito.never())).delete();
            ((Editable)Mockito.verify((Object)pod1op, (VerificationMode)Mockito.never())).edit((UnaryOperator)ArgumentMatchers.any(UnaryOperator.class));
            ((Editable)Mockito.verify((Object)pod2op, (VerificationMode)Mockito.never())).edit((UnaryOperator)ArgumentMatchers.any(UnaryOperator.class));
            Mockito.when((Object)podList.getItems()).thenReturn(Arrays.asList((Object[])new Pod[]{pod1}));
            this.schedulerBackendUnderTest().doKillExecutors((Seq)new .colon.colon((Object)"1", (List)new .colon.colon((Object)"2", (List)Nil$.MODULE$)));
            ((Deletable)Mockito.verify(this.labeledPods(), (VerificationMode)Mockito.never())).delete();
            this.schedulerExecutorService().runUntilIdle();
            ((Editable)Mockito.verify((Object)pod1op)).edit((UnaryOperator)ArgumentMatchers.any(UnaryOperator.class));
            ((Editable)Mockito.verify((Object)pod2op, (VerificationMode)Mockito.never())).edit((UnaryOperator)ArgumentMatchers.any(UnaryOperator.class));
            ((Deletable)Mockito.verify(this.labeledPods(), (VerificationMode)Mockito.never())).delete();
            this.schedulerExecutorService().tick(BoxesRunTime.unboxToLong((Object)this.sparkConf().get(Config$.MODULE$.KUBERNETES_DYN_ALLOC_KILL_GRACE_PERIOD())) * 2L, TimeUnit.MILLISECONDS);
            return ((Deletable)Mockito.verify(this.labeledPods())).delete();
        }, new Position("KubernetesClusterSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
        this.test("SPARK-34407: CoarseGrainedSchedulerBackend.stop may throw SparkException", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.schedulerBackendUnderTest().start();
            Mockito.when((Object)this.driverEndpointRef().askSync((Object)CoarseGrainedClusterMessages.StopDriver$.MODULE$, ClassTag$.MODULE$.Boolean())).thenThrow(new Throwable[]{new RuntimeException()});
            this.schedulerBackendUnderTest().stop();
            ((Client)Mockito.verify((Object)this.kubernetesClient())).close();
        }, new Position("KubernetesClusterSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        this.test("SPARK-34469: Ignore RegisterExecutor when SparkContext is stopped", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.sc().isStopped())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
            CoarseGrainedSchedulerBackend.DriverEndpoint endpoint = this.schedulerBackendUnderTest().createDriverEndpoint();
            endpoint.receiveAndReply(null).apply((Object)new CoarseGrainedClusterMessages.RegisterExecutor("1", null, "host1", 1, Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), 0));
        }, new Position("KubernetesClusterSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
        this.test("Dynamically fetch an executor ID", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CoarseGrainedSchedulerBackend.DriverEndpoint endpoint = this.schedulerBackendUnderTest().createDriverEndpoint();
            endpoint.receiveAndReply(this.context()).apply((Object)new GenerateExecID("cheeseBurger"));
            ((RpcCallContext)Mockito.verify((Object)this.context())).reply((Object)"1");
        }, new Position("KubernetesClusterSchedulerBackendSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
    }
}

