/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.InOutCreateable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorSpec;
import org.apache.spark.resource.ExecutorResourceRequests;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.resource.ResourceProfileBuilder;
import org.apache.spark.resource.TaskResourceRequests;
import org.apache.spark.scheduler.cluster.k8s.DeterministicExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorLifecycleTestUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocator$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBuilder;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ManualClock;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.PrivateMethodTester;
import org.scalatest.PrivateMethodTester$;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t5e\u0001B\u001e=\u0001%CQ\u0001\u0016\u0001\u0005\u0002UCq\u0001\u0017\u0001C\u0002\u0013%\u0011\f\u0003\u0004c\u0001\u0001\u0006IA\u0017\u0005\bG\u0002\u0011\r\u0011\"\u0003e\u0011\u0019\u0019\b\u0001)A\u0005K\"9A\u000f\u0001b\u0001\n\u0013)\bBB=\u0001A\u0003%a\u000fC\u0004{\u0001\t\u0007I\u0011B>\t\u000f\u0005\u0015\u0001\u0001)A\u0005y\"I\u0011q\u0001\u0001C\u0002\u0013%\u0011\u0011\u0002\u0005\t\u0003/\u0001\u0001\u0015!\u0003\u0002\f!I\u0011\u0011\u0004\u0001C\u0002\u0013%\u00111\u0004\u0005\t\u0003G\u0001\u0001\u0015!\u0003\u0002\u001e!I\u0011Q\u0005\u0001C\u0002\u0013%\u00111\u0004\u0005\t\u0003O\u0001\u0001\u0015!\u0003\u0002\u001e!I\u0011\u0011\u0006\u0001C\u0002\u0013%\u00111\u0004\u0005\t\u0003W\u0001\u0001\u0015!\u0003\u0002\u001e!I\u0011Q\u0006\u0001C\u0002\u0013%\u0011q\u0006\u0005\t\u0003o\u0001\u0001\u0015!\u0003\u00022!Y\u0011\u0011\b\u0001A\u0002\u0003\u0007I\u0011BA\u001e\u0011-\tI\u0005\u0001a\u0001\u0002\u0004%I!a\u0013\t\u0017\u0005]\u0003\u00011A\u0001B\u0003&\u0011Q\b\u0005\f\u00033\u0002\u0001\u0019!a\u0001\n\u0013\tY\u0006C\u0006\u0002j\u0001\u0001\r\u00111A\u0005\n\u0005-\u0004bCA8\u0001\u0001\u0007\t\u0011)Q\u0005\u0003;B1\"a \u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0002\"Y\u0011\u0011\u0017\u0001A\u0002\u0003\u0007I\u0011BAZ\u0011-\t9\f\u0001a\u0001\u0002\u0003\u0006K!a!\t\u0017\u0005m\u0006\u00011AA\u0002\u0013%\u0011Q\u0018\u0005\f\u0003\u000b\u0004\u0001\u0019!a\u0001\n\u0013\t9\rC\u0006\u0002L\u0002\u0001\r\u0011!Q!\n\u0005}\u0006bCAh\u0001\u0001\u0007\t\u0019!C\u0005\u0003#D1\"!7\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\\\"Y\u0011q\u001c\u0001A\u0002\u0003\u0005\u000b\u0015BAj\u0011-\t\u0019\u000f\u0001a\u0001\u0002\u0004%I!!:\t\u0017\u00055\b\u00011AA\u0002\u0013%\u0011q\u001e\u0005\f\u0003g\u0004\u0001\u0019!A!B\u0013\t9\u000fC\u0006\u0002x\u0002\u0001\r\u00111A\u0005\n\u0005e\bb\u0003B\u0001\u0001\u0001\u0007\t\u0019!C\u0005\u0005\u0007A1Ba\u0002\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002|\"Y!1\u0002\u0001A\u0002\u0003\u0007I\u0011\u0002B\u0007\u0011-\u0011Y\u0002\u0001a\u0001\u0002\u0004%IA!\b\t\u0017\t\u0005\u0002\u00011A\u0001B\u0003&!q\u0002\u0005\f\u0005K\u0001\u0001\u0019!a\u0001\n\u0013\u00119\u0003C\u0006\u00030\u0001\u0001\r\u00111A\u0005\n\tE\u0002b\u0003B\u001b\u0001\u0001\u0007\t\u0011)Q\u0005\u0005SA1B!\u000f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003<!Y!1\t\u0001A\u0002\u0003\u0007I\u0011\u0002B#\u0011-\u0011I\u0005\u0001a\u0001\u0002\u0003\u0006KA!\u0010\t\u0017\t5\u0003\u00011AA\u0002\u0013%!q\n\u0005\f\u0005/\u0002\u0001\u0019!a\u0001\n\u0013\u0011I\u0006C\u0006\u0003^\u0001\u0001\r\u0011!Q!\n\tE\u0003b\u0003B0\u0001\u0001\u0007\t\u0019!C\u0005\u0005CB1B!\u001b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003l!Y!q\u000e\u0001A\u0002\u0003\u0005\u000b\u0015\u0002B2\u0011!\u0011\t\b\u0001b\u0001\n\u0003I\u0006b\u0002B:\u0001\u0001\u0006IA\u0017\u0005\b\u0005k\u0002A\u0011\u0002B<\u0005i)\u00050Z2vi>\u0014\bk\u001c3t\u00032dwnY1u_J\u001cV/\u001b;f\u0015\tid(A\u0002lqMT!a\u0010!\u0002\u000f\rdWo\u001d;fe*\u0011\u0011IQ\u0001\ng\u000eDW\rZ;mKJT!a\u0011#\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u00153\u0015AB1qC\u000eDWMC\u0001H\u0003\ry'oZ\u0002\u0001'\r\u0001!J\u0014\t\u0003\u00172k\u0011AQ\u0005\u0003\u001b\n\u0013Qb\u00159be.4UO\\*vSR,\u0007CA(S\u001b\u0005\u0001&BA)G\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002T!\nq!)\u001a4pe\u0016\fe\u000eZ!gi\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0001W!\t9\u0006!D\u0001=\u00035!'/\u001b<feB{GMT1nKV\t!\f\u0005\u0002\\A6\tAL\u0003\u0002^=\u0006!A.\u00198h\u0015\u0005y\u0016\u0001\u00026bm\u0006L!!\u0019/\u0003\rM#(/\u001b8h\u00039!'/\u001b<feB{GMT1nK\u0002\n\u0011\u0002\u001a:jm\u0016\u0014\bk\u001c3\u0016\u0003\u0015\u0004\"AZ9\u000e\u0003\u001dT!\u0001[5\u0002\u000b5|G-\u001a7\u000b\u0005)\\\u0017aA1qS*\u0011A.\\\u0001\u000bWV\u0014WM\u001d8fi\u0016\u001c(B\u00018p\u0003\u001d1\u0017M\u0019:jGbR\u0011\u0001]\u0001\u0003S>L!A]4\u0003\u0007A{G-\u0001\u0006ee&4XM\u001d)pI\u0002\nAaY8oMV\ta\u000f\u0005\u0002Lo&\u0011\u0001P\u0011\u0002\n'B\f'o[\"p]\u001a\fQaY8oM\u0002\na\u0002Z3gCVdG\u000f\u0015:pM&dW-F\u0001}!\ri\u0018\u0011A\u0007\u0002}*\u0011qPQ\u0001\te\u0016\u001cx.\u001e:dK&\u0019\u00111\u0001@\u0003\u001fI+7o\\;sG\u0016\u0004&o\u001c4jY\u0016\fq\u0002Z3gCVdG\u000f\u0015:pM&dW\rI\u0001\u0012a>$\u0017\t\u001c7pG\u0006$\u0018n\u001c8TSj,WCAA\u0006!\u0011\ti!a\u0005\u000e\u0005\u0005=!BAA\t\u0003\u0015\u00198-\u00197b\u0013\u0011\t)\"a\u0004\u0003\u0007%sG/\u0001\nq_\u0012\fE\u000e\\8dCRLwN\\*ju\u0016\u0004\u0013A\u00059pI\u0006cGn\\2bi&|g\u000eR3mCf,\"!!\b\u0011\t\u00055\u0011qD\u0005\u0005\u0003C\tyA\u0001\u0003M_:<\u0017a\u00059pI\u0006cGn\\2bi&|g\u000eR3mCf\u0004\u0013aE3yK\u000e,Ho\u001c:JI2,G+[7f_V$\u0018\u0001F3yK\u000e,Ho\u001c:JI2,G+[7f_V$\b%\u0001\nq_\u0012\u001c%/Z1uS>tG+[7f_V$\u0018a\u00059pI\u000e\u0013X-\u0019;j_:$\u0016.\\3pkR\u0004\u0013AB:fG6;'/\u0006\u0002\u00022A\u00191*a\r\n\u0007\u0005U\"IA\bTK\u000e,(/\u001b;z\u001b\u0006t\u0017mZ3s\u0003\u001d\u0019XmY'he\u0002\n\u0001d^1ji\u001a{'/\u0012=fGV$xN\u001d)pIN\u001cEn\\2l+\t\ti\u0004\u0005\u0003\u0002@\u0005\u0015SBAA!\u0015\r\t\u0019EQ\u0001\u0005kRLG.\u0003\u0003\u0002H\u0005\u0005#aC'b]V\fGn\u00117pG.\fAd^1ji\u001a{'/\u0012=fGV$xN\u001d)pIN\u001cEn\\2l?\u0012*\u0017\u000f\u0006\u0003\u0002N\u0005M\u0003\u0003BA\u0007\u0003\u001fJA!!\u0015\u0002\u0010\t!QK\\5u\u0011%\t)&FA\u0001\u0002\u0004\ti$A\u0002yIE\n\u0011d^1ji\u001a{'/\u0012=fGV$xN\u001d)pIN\u001cEn\\2lA\u0005\u00012.\u001e2fe:,G/Z:DY&,g\u000e^\u000b\u0003\u0003;\u0002B!a\u0018\u0002f5\u0011\u0011\u0011\r\u0006\u0004\u0003GZ\u0017AB2mS\u0016tG/\u0003\u0003\u0002h\u0005\u0005$\u0001E&vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u\u0003QYWOY3s]\u0016$Xm]\"mS\u0016tGo\u0018\u0013fcR!\u0011QJA7\u0011%\t)\u0006GA\u0001\u0002\u0004\ti&A\tlk\n,'O\\3uKN\u001cE.[3oi\u0002B3!GA:!\u0011\t)(a\u001f\u000e\u0005\u0005]$bAA=\r\u00069Qn\\2lSR|\u0017\u0002BA?\u0003o\u0012A!T8dW\u0006i\u0001o\u001c3Pa\u0016\u0014\u0018\r^5p]N,\"!a!\u0011\t\u0005\u0015\u00151\u0016\b\u0005\u0003\u000f\u000b)K\u0004\u0003\u0002\n\u0006\u0005f\u0002BAF\u0003;sA!!$\u0002\u001c:!\u0011qRAM\u001d\u0011\t\t*a&\u000e\u0005\u0005M%bAAK\u0011\u00061AH]8pizJ\u0011aR\u0005\u0003\u000b\u001aK!a\u0011#\n\u0007\u0005}%)\u0001\u0004eKBdw._\u0005\u0004{\u0005\r&bAAP\u0005&!\u0011qUAU\u000391\u0015M\u0019:jGb\nE.[1tKNT1!PAR\u0013\u0011\ti+a,\u0003\tA{Ei\u0015\u0006\u0005\u0003O\u000bI+A\tq_\u0012|\u0005/\u001a:bi&|gn]0%KF$B!!\u0014\u00026\"I\u0011QK\u000e\u0002\u0002\u0003\u0007\u00111Q\u0001\u000fa>$w\n]3sCRLwN\\:!Q\ra\u00121O\u0001\u0017a\u0016\u00148/[:uK:$hk\u001c7v[\u0016\u001cE.Y5ngV\u0011\u0011q\u0018\t\u0005\u0003\u000b\u000b\t-\u0003\u0003\u0002D\u0006=&\u0001\u0007)F%NK5\u000bV#O)~3v\nT+N\u000b~\u001bE*Q%N'\u0006Q\u0002/\u001a:tSN$XM\u001c;W_2,X.Z\"mC&l7o\u0018\u0013fcR!\u0011QJAe\u0011%\t)FHA\u0001\u0002\u0004\ty,A\fqKJ\u001c\u0018n\u001d;f]R4v\u000e\\;nK\u000ec\u0017-[7tA!\u001aq$a\u001d\u0002;1\f'-\u001a7fIB+'o]5ti\u0016tGOV8mk6,7\t\\1j[N,\"!a5\u0011\t\u0005\u0015\u0015Q[\u0005\u0005\u0003/\fyK\u0001\u0011M\u0003\n+E*\u0012#`!\u0016\u00136+S*U\u000b:#vLV(M+6+ul\u0011'B\u00136\u001b\u0016!\t7bE\u0016dW\r\u001a)feNL7\u000f^3oiZ{G.^7f\u00072\f\u0017.\\:`I\u0015\fH\u0003BA'\u0003;D\u0011\"!\u0016\"\u0003\u0003\u0005\r!a5\u0002=1\f'-\u001a7fIB+'o]5ti\u0016tGOV8mk6,7\t\\1j[N\u0004\u0003f\u0001\u0012\u0002t\u0005I\u0002/\u001a:tSN$XM\u001c;W_2,X.Z\"mC&lG*[:u+\t\t9\u000fE\u0002g\u0003SL1!a;h\u0005e\u0001VM]:jgR,g\u000e\u001e,pYVlWm\u00117bS6d\u0015n\u001d;\u0002;A,'o]5ti\u0016tGOV8mk6,7\t\\1j[2K7\u000f^0%KF$B!!\u0014\u0002r\"I\u0011Q\u000b\u0013\u0002\u0002\u0003\u0007\u0011q]\u0001\u001ba\u0016\u00148/[:uK:$hk\u001c7v[\u0016\u001cE.Y5n\u0019&\u001cH\u000f\t\u0015\u0004K\u0005M\u0014a\u00037bE\u0016dW\r\u001a)pIN,\"!a?\u0011\t\u0005\u0015\u0015Q`\u0005\u0005\u0003\u007f\fyK\u0001\u0007M\u0003\n+E*\u0012#`!>#5+A\bmC\n,G.\u001a3Q_\u0012\u001cx\fJ3r)\u0011\tiE!\u0002\t\u0013\u0005Us%!AA\u0002\u0005m\u0018\u0001\u00047bE\u0016dW\r\u001a)pIN\u0004\u0003f\u0001\u0015\u0002t\u0005\u0019BM]5wKJ\u0004v\u000eZ(qKJ\fG/[8ogV\u0011!q\u0002\t\u0006\u0005#\u00119\"Z\u0007\u0003\u0005'QAA!\u0006\u0002b\u0005\u0019Am\u001d7\n\t\te!1\u0003\u0002\f!>$'+Z:pkJ\u001cW-A\fee&4XM\u001d)pI>\u0003XM]1uS>t7o\u0018\u0013fcR!\u0011Q\nB\u0010\u0011%\t)FKA\u0001\u0002\u0004\u0011y!\u0001\u000bee&4XM\u001d)pI>\u0003XM]1uS>t7\u000f\t\u0015\u0004W\u0005M\u0014aD3yK\u000e,Ho\u001c:Ck&dG-\u001a:\u0016\u0005\t%\u0002cA,\u0003,%\u0019!Q\u0006\u001f\u00033-+(-\u001a:oKR,7/\u0012=fGV$xN\u001d\"vS2$WM]\u0001\u0014Kb,7-\u001e;pe\n+\u0018\u000e\u001c3fe~#S-\u001d\u000b\u0005\u0003\u001b\u0012\u0019\u0004C\u0005\u0002V5\n\t\u00111\u0001\u0003*\u0005\u0001R\r_3dkR|'OQ;jY\u0012,'\u000f\t\u0015\u0004]\u0005M\u0014\u0001E:dQ\u0016$W\u000f\\3s\u0005\u0006\u001c7.\u001a8e+\t\u0011i\u0004E\u0002X\u0005\u007fI1A!\u0011=\u0005\u0005ZUOY3s]\u0016$Xm]\"mkN$XM]*dQ\u0016$W\u000f\\3s\u0005\u0006\u001c7.\u001a8e\u0003Q\u00198\r[3ek2,'OQ1dW\u0016tGm\u0018\u0013fcR!\u0011Q\nB$\u0011%\t)\u0006MA\u0001\u0002\u0004\u0011i$A\ttG\",G-\u001e7fe\n\u000b7m[3oI\u0002B3!MA:\u00039\u0019h.\u00199tQ>$8o\u0015;pe\u0016,\"A!\u0015\u0011\u0007]\u0013\u0019&C\u0002\u0003Vq\u0012q\u0005R3uKJl\u0017N\\5ti&\u001cW\t_3dkR|'\u000fU8egNs\u0017\r]:i_R\u001c8\u000b^8sK\u0006\u00112O\\1qg\"|Go]*u_J,w\fJ3r)\u0011\tiEa\u0017\t\u0013\u0005U3'!AA\u0002\tE\u0013aD:oCB\u001c\bn\u001c;t'R|'/\u001a\u0011\u0002-A|Gm]!mY>\u001c\u0017\r^8s+:$WM\u001d+fgR,\"Aa\u0019\u0011\u0007]\u0013)'C\u0002\u0003hq\u0012Q#\u0012=fGV$xN\u001d)pIN\fE\u000e\\8dCR|'/\u0001\u000eq_\u0012\u001c\u0018\t\u001c7pG\u0006$xN]+oI\u0016\u0014H+Z:u?\u0012*\u0017\u000f\u0006\u0003\u0002N\t5\u0004\"CA+m\u0005\u0005\t\u0019\u0001B2\u0003]\u0001x\u000eZ:BY2|7-\u0019;peVsG-\u001a:UKN$\b%A\u0003baBLE-\u0001\u0004baBLE\rI\u0001\u0012Kb,7-\u001e;peB{G-\u00118to\u0016\u0014HC\u0001B=!\u0019\u0011YH!!\u0003\u00066\u0011!Q\u0010\u0006\u0005\u0005\u007f\n9(\u0001\u0005tiV\u0014'-\u001b8h\u0013\u0011\u0011\u0019I! \u0003\r\u0005s7o^3s!\u0011\u00119I!#\u000e\u0005\u0005%\u0016\u0002\u0002BF\u0003S\u0013acS;cKJtW\r^3t\u000bb,7-\u001e;peN\u0003Xm\u0019")
public class ExecutorPodsAllocatorSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final String driverPodName;
    private final Pod driverPod;
    private final SparkConf conf;
    private final ResourceProfile defaultProfile;
    private final int podAllocationSize;
    private final long podAllocationDelay;
    private final long executorIdleTimeout;
    private final long podCreationTimeout;
    private final SecurityManager secMgr;
    private ManualClock waitForExecutorPodsClock;
    @Mock
    private KubernetesClient kubernetesClient;
    @Mock
    private MixedOperation<Pod, PodList, PodResource<Pod>> podOperations;
    @Mock
    private MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, Resource<PersistentVolumeClaim>> persistentVolumeClaims;
    @Mock
    private FilterWatchListDeletable<PersistentVolumeClaim, PersistentVolumeClaimList> labeledPersistentVolumeClaims;
    @Mock
    private PersistentVolumeClaimList persistentVolumeClaimList;
    @Mock
    private FilterWatchListDeletable<Pod, PodList> labeledPods;
    @Mock
    private PodResource<Pod> driverPodOperations;
    @Mock
    private KubernetesExecutorBuilder executorBuilder;
    @Mock
    private KubernetesClusterSchedulerBackend schedulerBackend;
    private DeterministicExecutorPodsSnapshotsStore snapshotsStore;
    private ExecutorPodsAllocator podsAllocatorUnderTest;
    private final String appId;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private String driverPodName() {
        return this.driverPodName;
    }

    private Pod driverPod() {
        return this.driverPod;
    }

    private SparkConf conf() {
        return this.conf;
    }

    private ResourceProfile defaultProfile() {
        return this.defaultProfile;
    }

    private int podAllocationSize() {
        return this.podAllocationSize;
    }

    private long podAllocationDelay() {
        return this.podAllocationDelay;
    }

    private long executorIdleTimeout() {
        return this.executorIdleTimeout;
    }

    private long podCreationTimeout() {
        return this.podCreationTimeout;
    }

    private SecurityManager secMgr() {
        return this.secMgr;
    }

    private ManualClock waitForExecutorPodsClock() {
        return this.waitForExecutorPodsClock;
    }

    private void waitForExecutorPodsClock_$eq(ManualClock x$1) {
        this.waitForExecutorPodsClock = x$1;
    }

    private KubernetesClient kubernetesClient() {
        return this.kubernetesClient;
    }

    private void kubernetesClient_$eq(KubernetesClient x$1) {
        this.kubernetesClient = x$1;
    }

    private MixedOperation<Pod, PodList, PodResource<Pod>> podOperations() {
        return this.podOperations;
    }

    private void podOperations_$eq(MixedOperation<Pod, PodList, PodResource<Pod>> x$1) {
        this.podOperations = x$1;
    }

    private MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, Resource<PersistentVolumeClaim>> persistentVolumeClaims() {
        return this.persistentVolumeClaims;
    }

    private void persistentVolumeClaims_$eq(MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, Resource<PersistentVolumeClaim>> x$1) {
        this.persistentVolumeClaims = x$1;
    }

    private FilterWatchListDeletable<PersistentVolumeClaim, PersistentVolumeClaimList> labeledPersistentVolumeClaims() {
        return this.labeledPersistentVolumeClaims;
    }

    private void labeledPersistentVolumeClaims_$eq(FilterWatchListDeletable<PersistentVolumeClaim, PersistentVolumeClaimList> x$1) {
        this.labeledPersistentVolumeClaims = x$1;
    }

    private PersistentVolumeClaimList persistentVolumeClaimList() {
        return this.persistentVolumeClaimList;
    }

    private void persistentVolumeClaimList_$eq(PersistentVolumeClaimList x$1) {
        this.persistentVolumeClaimList = x$1;
    }

    private FilterWatchListDeletable<Pod, PodList> labeledPods() {
        return this.labeledPods;
    }

    private void labeledPods_$eq(FilterWatchListDeletable<Pod, PodList> x$1) {
        this.labeledPods = x$1;
    }

    private PodResource<Pod> driverPodOperations() {
        return this.driverPodOperations;
    }

    private void driverPodOperations_$eq(PodResource<Pod> x$1) {
        this.driverPodOperations = x$1;
    }

    private KubernetesExecutorBuilder executorBuilder() {
        return this.executorBuilder;
    }

    private void executorBuilder_$eq(KubernetesExecutorBuilder x$1) {
        this.executorBuilder = x$1;
    }

    private KubernetesClusterSchedulerBackend schedulerBackend() {
        return this.schedulerBackend;
    }

    private void schedulerBackend_$eq(KubernetesClusterSchedulerBackend x$1) {
        this.schedulerBackend = x$1;
    }

    private DeterministicExecutorPodsSnapshotsStore snapshotsStore() {
        return this.snapshotsStore;
    }

    private void snapshotsStore_$eq(DeterministicExecutorPodsSnapshotsStore x$1) {
        this.snapshotsStore = x$1;
    }

    private ExecutorPodsAllocator podsAllocatorUnderTest() {
        return this.podsAllocatorUnderTest;
    }

    private void podsAllocatorUnderTest_$eq(ExecutorPodsAllocator x$1) {
        this.podsAllocatorUnderTest = x$1;
    }

    public String appId() {
        return this.appId;
    }

    private Answer<KubernetesExecutorSpec> executorPodAnswer() {
        return invocation -> {
            KubernetesExecutorConf k8sConf = (KubernetesExecutorConf)invocation.getArgument(0);
            return new KubernetesExecutorSpec(ExecutorLifecycleTestUtils$.MODULE$.executorPodWithId(new StringOps(Predef$.MODULE$.augmentString(k8sConf.executorId())).toInt(), k8sConf.resourceProfileId()), (Seq)Nil$.MODULE$);
        };
    }

    public static final /* synthetic */ Pod $anonfun$new$5(ExecutorPodsAllocatorSuite $this, int nextId) {
        return (Pod)((InOutCreateable)Mockito.verify($this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(nextId, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
    }

    public ExecutorPodsAllocatorSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.driverPodName = "driver";
        this.driverPod = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(this.driverPodName()).addToLabels(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID()).addToLabels(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_DRIVER_ROLE()).withUid("driver-pod-uid")).endMetadata()).build();
        this.conf = new SparkConf().set(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME(), (Object)this.driverPodName()).set(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_EXECUTOR_IDLE_TIMEOUT().key(), "10s");
        this.defaultProfile = ResourceProfile$.MODULE$.getOrCreateDefaultProfile(this.conf());
        this.podAllocationSize = BoxesRunTime.unboxToInt((Object)this.conf().get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_SIZE()));
        this.podAllocationDelay = BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_DELAY()));
        this.executorIdleTimeout = BoxesRunTime.unboxToLong((Object)this.conf().get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_EXECUTOR_IDLE_TIMEOUT())) * 1000L;
        this.podCreationTimeout = package$.MODULE$.max(this.podAllocationDelay() * 5L, BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_ALLOCATION_EXECUTOR_TIMEOUT())));
        this.secMgr = new SecurityManager(this.conf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3());
        this.appId = "testapp";
        this.before((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MockitoAnnotations.openMocks((Object)((Object)this)).close();
            Mockito.when((Object)this.kubernetesClient().pods()).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withName(this.driverPodName())).thenReturn(this.driverPodOperations());
            Mockito.when((Object)this.driverPodOperations().get()).thenReturn((Object)this.driverPod());
            Mockito.when((Object)this.driverPodOperations().waitUntilReady(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (TimeUnit)((Object)((Object)ArgumentMatchers.any())))).thenReturn((Object)this.driverPod());
            Mockito.when((Object)this.executorBuilder().buildFromFeatures((KubernetesExecutorConf)ArgumentMatchers.any(KubernetesExecutorConf.class), (SecurityManager)ArgumentMatchers.eq((Object)this.secMgr()), (KubernetesClient)ArgumentMatchers.eq((Object)this.kubernetesClient()), (ResourceProfile)ArgumentMatchers.any(ResourceProfile.class))).thenAnswer(this.executorPodAnswer());
            this.snapshotsStore_$eq(new DeterministicExecutorPodsSnapshotsStore());
            this.waitForExecutorPodsClock_$eq(new ManualClock(0L));
            this.podsAllocatorUnderTest_$eq(new ExecutorPodsAllocator(this.conf(), this.secMgr(), this.executorBuilder(), this.kubernetesClient(), (ExecutorPodsSnapshotsStore)this.snapshotsStore(), (Clock)this.waitForExecutorPodsClock()));
            Mockito.when((Object)this.schedulerBackend().getExecutorIds()).thenReturn((Object)Nil$.MODULE$);
            this.podsAllocatorUnderTest().start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID(), this.schedulerBackend());
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        this.test("SPARK-36052: test splitSlots", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq seq1 = (Seq)new .colon.colon((Object)"a", (List)Nil$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(ExecutorPodsAllocator$.MODULE$.splitSlots(seq1, 0));
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(ExecutorPodsAllocator$.MODULE$.splitSlots(seq1, 1));
            Seq $org_scalatest_assert_macro_right2 = (Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(ExecutorPodsAllocator$.MODULE$.splitSlots(seq1, 2));
            Seq $org_scalatest_assert_macro_right3 = (Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2)), (List)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
            Seq seq2 = (Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(ExecutorPodsAllocator$.MODULE$.splitSlots(seq2, 0));
            Seq $org_scalatest_assert_macro_right4 = (Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$)));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(ExecutorPodsAllocator$.MODULE$.splitSlots(seq2, 1));
            Seq $org_scalatest_assert_macro_right5 = (Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)1)), (List)new .colon.colon((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$)));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(ExecutorPodsAllocator$.MODULE$.splitSlots(seq2, 2));
            Seq $org_scalatest_assert_macro_right6 = (Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)1)), (List)new .colon.colon((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1)), (List)new .colon.colon((Object)new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$)));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(ExecutorPodsAllocator$.MODULE$.splitSlots(seq2, 3));
            Seq $org_scalatest_assert_macro_right7 = (Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)1)), (List)new .colon.colon((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1)), (List)new .colon.colon((Object)new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$)));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(ExecutorPodsAllocator$.MODULE$.splitSlots(seq2, 4));
            Seq $org_scalatest_assert_macro_right8 = (Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2)), (List)new .colon.colon((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1)), (List)new .colon.colon((Object)new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$)));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        this.test("SPARK-36052: pending pod limit with multiple resource profiles", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.podOperations().withField("status.phase", "Pending")).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabelIn((String)ArgumentMatchers.eq((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), new String[]{(String)ArgumentMatchers.any()})).thenReturn(this.podOperations());
            long startTime = Instant.now().toEpochMilli();
            this.waitForExecutorPodsClock().setTime(startTime);
            ResourceProfileBuilder rpb = new ResourceProfileBuilder();
            ExecutorResourceRequests ereq = new ExecutorResourceRequests();
            TaskResourceRequests treq = new TaskResourceRequests();
            ereq.cores(4).memory("2g");
            treq.cpus(2);
            rpb.require(ereq).require(treq);
            ResourceProfile rp = rpb.build();
            SparkConf confWithLowMaxPendingPods = this.conf().clone().set(Config$.MODULE$.KUBERNETES_MAX_PENDING_PODS().key(), "3");
            this.podsAllocatorUnderTest_$eq(new ExecutorPodsAllocator(confWithLowMaxPendingPods, this.secMgr(), this.executorBuilder(), this.kubernetesClient(), (ExecutorPodsSnapshotsStore)this.snapshotsStore(), (Clock)this.waitForExecutorPodsClock()));
            this.podsAllocatorUnderTest().start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID(), this.schedulerBackend());
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rp), (Object)BoxesRunTime.boxToInteger((int)3))})));
            int $org_scalatest_assert_macro_left = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(1L, this.defaultProfile().id()));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(2L, this.defaultProfile().id()));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(3L, rp.id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(2L, this.defaultProfile().id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(3L, rp.id()));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left2 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
            ((InOutCreateable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)3))).create(ArgumentMatchers.any());
            ((Deletable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.never())).delete();
            this.waitForExecutorPodsClock().advance(this.executorIdleTimeout() * 2L);
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rp), (Object)BoxesRunTime.boxToInteger((int)3))})));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left3 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right3 = 3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(4L, rp.id()));
            ((Deletable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)1))).delete();
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(3L, rp.id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(4L, rp.id()));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left4 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right4 = 3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(5L, rp.id()));
            return ((Deletable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)1))).delete();
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        this.test("Initially request executors in batches. Do not request another batch if the first has not finished.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)(this.podAllocationSize() + 1)))})));
            int $org_scalatest_assert_macro_left = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.podAllocationSize()).foreach((Function1 & Serializable & scala.Serializable)nextId -> ExecutorPodsAllocatorSuite.$anonfun$new$5(this, BoxesRunTime.unboxToInt((Object)nextId)));
            return (Pod)((InOutCreateable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.never())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(this.podAllocationSize() + 1, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
        this.test("Request executors in batches. Allow another batch to be requested if all pending executors start running.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            PrivateMethodTester.Invocation counter = PrivateMethodTester$.MODULE$.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "EXECUTOR_ID_COUNTER")).apply((Seq)Nil$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((AtomicInteger)PrivateMethodTester$.MODULE$.anyRefToInvoker((Object)this.podsAllocatorUnderTest()).invokePrivate(counter)).get()));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)(this.podAllocationSize() + 1)))})));
            int $org_scalatest_assert_macro_left2 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right2 = 5;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), this.podAllocationSize()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)execId -> this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(execId, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2())));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((AtomicInteger)PrivateMethodTester$.MODULE$.anyRefToInvoker((Object)this.podsAllocatorUnderTest()).invokePrivate(counter)).get()));
            int $org_scalatest_assert_macro_right3 = 5;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left4 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
            ((InOutCreateable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.never())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(this.podAllocationSize() + 1, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(this.podAllocationSize(), ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left5 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(this.podAllocationSize() + 1, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(this.podAllocationSize(), ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left6 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
            return (Pod)((InOutCreateable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)(this.podAllocationSize() + 1)))).create(ArgumentMatchers.any(Pod.class));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
        this.test("When a current batch reaches error states immediately, re-request them on the next batch.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)this.podAllocationSize()))})));
            int $org_scalatest_assert_macro_left = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), this.podAllocationSize()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)execId -> this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(execId, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2())));
            Pod failedPod = ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion(this.podAllocationSize(), ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion$default$2());
            this.snapshotsStore().updatePod(failedPod);
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left2 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
            return (Pod)((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(this.podAllocationSize() + 1, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
        this.test("Verify stopping deletes the labeled pods", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.labeledPods());
            this.podsAllocatorUnderTest().stop(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID());
            return ((Deletable)Mockito.verify(this.labeledPods())).delete();
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
        this.test("When an executor is requested but the API does not report it in a reasonable time, retry requesting that executor.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"1"})).thenReturn(this.labeledPods());
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)1))})));
            int $org_scalatest_assert_macro_left = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(1L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            this.waitForExecutorPodsClock().setTime(this.podCreationTimeout() + 1L);
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left2 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
            ((Deletable)Mockito.verify(this.labeledPods())).delete();
            return (Pod)((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(2L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
        this.test("SPARK-28487: scale up and down on target executor count changes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.podOperations().withField("status.phase", "Pending")).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabelIn((String)ArgumentMatchers.eq((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), new String[]{(String)ArgumentMatchers.any()})).thenReturn(this.podOperations());
            long startTime = Instant.now().toEpochMilli();
            this.waitForExecutorPodsClock().setTime(startTime);
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)1))})));
            int $org_scalatest_assert_macro_left = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(1L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(1L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left2 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315));
            ((InOutCreateable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)1))).create(ArgumentMatchers.any());
            ((Deletable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.never())).delete();
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)4))})));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left3 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right3 = 3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(2L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(3L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(4L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(2L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(3L, ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor$default$2()));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left4 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right4 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332));
            ((InOutCreateable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)4))).create(ArgumentMatchers.any());
            ((Deletable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.never())).delete();
            this.waitForExecutorPodsClock().advance(this.executorIdleTimeout() * 2L);
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)1))})));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left5 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right5 = 0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
            ((InOutCreateable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)4))).create(ArgumentMatchers.any());
            ((Filterable)Mockito.verify(this.podOperations())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"3", "4"});
            ((Deletable)Mockito.verify(this.podOperations())).delete();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("3"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"3\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("4"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"4\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor(3L, ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor(4L, ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor$default$2()));
            this.snapshotsStore().removeDeletedExecutors();
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left6 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right6 = 0;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("3"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"3\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 355));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("4"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"4\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
        this.test("SPARK-34334: correctly identify timed out pending pod requests as excess", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.podOperations().withField("status.phase", "Pending")).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabelIn((String)ArgumentMatchers.eq((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), new String[]{(String)ArgumentMatchers.any()})).thenReturn(this.podOperations());
            long startTime = Instant.now().toEpochMilli();
            this.waitForExecutorPodsClock().setTime(startTime);
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)1))})));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(1L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create(ArgumentMatchers.any());
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(1L, ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor$default$2()));
            this.snapshotsStore().notifySubscribers();
            this.waitForExecutorPodsClock().advance(this.executorIdleTimeout());
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)2))})));
            this.snapshotsStore().notifySubscribers();
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(2L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)1))})));
            this.snapshotsStore().notifySubscribers();
            ((Filterable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.never())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"1"});
            ((Deletable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.never())).delete();
            this.waitForExecutorPodsClock().advance(this.executorIdleTimeout());
            this.snapshotsStore().notifySubscribers();
            ((Filterable)Mockito.verify(this.podOperations())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"1"});
            return ((Deletable)Mockito.verify(this.podOperations())).delete();
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
        this.test("SPARK-33099: Respect executor idle timeout configuration", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.podOperations().withField("status.phase", "Pending")).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabelIn((String)ArgumentMatchers.eq((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), new String[]{(String)ArgumentMatchers.any()})).thenReturn(this.podOperations());
            long startTime = Instant.now().toEpochMilli();
            this.waitForExecutorPodsClock().setTime(startTime);
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)5))})));
            int $org_scalatest_assert_macro_left = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 422));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(1L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(2L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(3L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(4L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(5L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((InOutCreateable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)5))).create(ArgumentMatchers.any());
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(1L, ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(2L, ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor$default$2()));
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)0))})));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left2 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right2 = 5;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 436));
            ((Filterable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.never())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"1", "2", "3", "4", "5"});
            ((Deletable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.never())).delete();
            this.waitForExecutorPodsClock().advance(this.executorIdleTimeout() * 2L);
            Mockito.when((Object)this.schedulerBackend().getExecutorIds()).thenReturn((Object)new .colon.colon((Object)"1", (List)new .colon.colon((Object)"3", (List)new .colon.colon((Object)"4", (List)Nil$.MODULE$))));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left3 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448));
            ((Filterable)Mockito.verify(this.podOperations())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"2", "5"});
            return ((Deletable)Mockito.verify(this.podOperations())).delete();
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
        this.test("SPARK-34361: scheduler backend known pods with multiple resource profiles at downscaling", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.podOperations().withField("status.phase", "Pending")).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabelIn((String)ArgumentMatchers.eq((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), new String[]{(String)ArgumentMatchers.any()})).thenReturn(this.podOperations());
            long startTime = Instant.now().toEpochMilli();
            this.waitForExecutorPodsClock().setTime(startTime);
            ResourceProfileBuilder rpb = new ResourceProfileBuilder();
            ExecutorResourceRequests ereq = new ExecutorResourceRequests();
            TaskResourceRequests treq = new TaskResourceRequests();
            ereq.cores(4).memory("2g");
            treq.cpus(2);
            rpb.require(ereq).require(treq);
            ResourceProfile rp = rpb.build();
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rp), (Object)BoxesRunTime.boxToInteger((int)4))})));
            int $org_scalatest_assert_macro_left = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right = 7;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 514));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(1L, this.defaultProfile().id()));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(2L, this.defaultProfile().id()));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(3L, this.defaultProfile().id()));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(4L, rp.id()));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(5L, rp.id()));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(6L, rp.id()));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(7L, rp.id()));
            Mockito.when((Object)this.schedulerBackend().getExecutorIds()).thenReturn((Object)new .colon.colon((Object)"1", (List)new .colon.colon((Object)"4", (List)Nil$.MODULE$)));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left2 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right2 = 5;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"scheduler backend known PODs are not outstanding", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 526));
            ((InOutCreateable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)7))).create(ArgumentMatchers.any());
            Mockito.when((Object)this.schedulerBackend().getExecutorIds()).thenReturn((Object)new .colon.colon((Object)"1", (List)new .colon.colon((Object)"2", (List)new .colon.colon((Object)"4", (List)new .colon.colon((Object)"5", (List)Nil$.MODULE$)))));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(2L, this.defaultProfile().id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(3L, this.defaultProfile().id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(5L, rp.id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(6L, rp.id()));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left3 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right3 = 3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 538));
            ((InOutCreateable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)7))).create(ArgumentMatchers.any());
            this.waitForExecutorPodsClock().advance(this.executorIdleTimeout() * 2L);
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rp), (Object)BoxesRunTime.boxToInteger((int)1))})));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left4 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right4 = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 545));
            ((InOutCreateable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)7))).create(ArgumentMatchers.any());
            ((Deletable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)2))).delete();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("3"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"3\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 548));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("6"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"6\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 549));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("7"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"7\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 550));
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rp), (Object)BoxesRunTime.boxToInteger((int)2))})));
            this.snapshotsStore().notifySubscribers();
            ((InOutCreateable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)7))).create(ArgumentMatchers.any());
            int $org_scalatest_assert_macro_left5 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right5 = 0;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 557));
            ((InOutCreateable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)7))).create(ArgumentMatchers.any());
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rp), (Object)BoxesRunTime.boxToInteger((int)3))})));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left6 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right6 = 2;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 563));
            ((InOutCreateable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)9))).create(ArgumentMatchers.any());
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(8L, this.defaultProfile().id()));
            return (Pod)((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(9L, rp.id()));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 487));
        this.test("SPARK-33288: multiple resource profiles", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.podOperations().withField("status.phase", "Pending")).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabelIn((String)ArgumentMatchers.eq((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), new String[]{(String)ArgumentMatchers.any()})).thenReturn(this.podOperations());
            long startTime = Instant.now().toEpochMilli();
            this.waitForExecutorPodsClock().setTime(startTime);
            ResourceProfileBuilder rpb = new ResourceProfileBuilder();
            ExecutorResourceRequests ereq = new ExecutorResourceRequests();
            TaskResourceRequests treq = new TaskResourceRequests();
            ereq.cores(4).memory("2g");
            treq.cpus(2);
            rpb.require(ereq).require(treq);
            ResourceProfile rp = rpb.build();
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rp), (Object)BoxesRunTime.boxToInteger((int)2))})));
            int $org_scalatest_assert_macro_left = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 597));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(1L, this.defaultProfile().id()));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(2L, rp.id()));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(3L, rp.id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(1L, this.defaultProfile().id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(2L, rp.id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(3L, rp.id()));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left2 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 607));
            ((InOutCreateable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)3))).create(ArgumentMatchers.any());
            ((Deletable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.never())).delete();
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rp), (Object)BoxesRunTime.boxToInteger((int)3))})));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left3 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right3 = 4;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 615));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(4L, this.defaultProfile().id()));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(5L, this.defaultProfile().id()));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(6L, this.defaultProfile().id()));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(7L, rp.id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(4L, this.defaultProfile().id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(5L, this.defaultProfile().id()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(7L, rp.id()));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left4 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right4 = 3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 626));
            ((InOutCreateable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)7))).create(ArgumentMatchers.any());
            ((Deletable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.never())).delete();
            this.waitForExecutorPodsClock().advance(this.executorIdleTimeout() * 2L);
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rp), (Object)BoxesRunTime.boxToInteger((int)1))})));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left5 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right5 = 0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 635));
            ((InOutCreateable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)7))).create(ArgumentMatchers.any());
            ((Filterable)Mockito.verify(this.podOperations())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"5", "6"});
            ((Filterable)Mockito.verify(this.podOperations())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"7"});
            ((Deletable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)2))).delete();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("5"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"5\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 640));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("6"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"6\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 641));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("7"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"7\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 642));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor(5L, ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor(6L, ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor(7L, ExecutorLifecycleTestUtils$.MODULE$.deletedExecutor$default$2()));
            this.snapshotsStore().removeDeletedExecutors();
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left6 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right6 = 0;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 651));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("5"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"5\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 652));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("6"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"6\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 653));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.podsAllocatorUnderTest().isDeleted("7"), "ExecutorPodsAllocatorSuite.this.podsAllocatorUnderTest.isDeleted(\"7\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 654));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 569));
        this.test("SPARK-33262: pod allocator does not stall with pending pods", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"1"})).thenReturn(this.labeledPods());
            Mockito.when((Object)this.podOperations().withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), new String[]{"2", "3", "4", "5", "6"})).thenReturn(this.podOperations());
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)6))})));
            int $org_scalatest_assert_macro_left = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 672));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(1L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(2L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(3L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(4L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(5L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor(1L, ExecutorLifecycleTestUtils$.MODULE$.pendingExecutor$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(2L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(3L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(4L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(5L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()));
            this.waitForExecutorPodsClock().setTime(this.podAllocationDelay() + 1L);
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left2 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 688));
            return (Pod)((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId(6L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForId$default$2()));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 657));
        this.test("SPARK-35416: Support PersistentVolumeClaim Reuse", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String prefix = "spark.kubernetes.executor.volumes.persistentVolumeClaim.spark-local-dir-1";
            SparkConf confWithPVC = this.conf().clone().set(Config$.MODULE$.KUBERNETES_DRIVER_OWN_PVC().key(), "true").set(Config$.MODULE$.KUBERNETES_DRIVER_REUSE_PVC().key(), "true").set(new StringBuilder(11).append(prefix).append(".mount.path").toString(), "/spark-local-dir").set(new StringBuilder(15).append(prefix).append(".mount.readOnly").toString(), "false").set(new StringBuilder(17).append(prefix).append(".option.claimName").toString(), "OnDemand").set(new StringBuilder(17).append(prefix).append(".option.sizeLimit").toString(), "200Gi").set(new StringBuilder(20).append(prefix).append(".option.storageClass").toString(), "gp2");
            Mockito.when((Object)this.kubernetesClient().persistentVolumeClaims()).thenReturn(this.persistentVolumeClaims());
            Mockito.when((Object)this.persistentVolumeClaims().withLabel((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(this.labeledPersistentVolumeClaims());
            Mockito.when((Object)this.labeledPersistentVolumeClaims().list()).thenReturn((Object)this.persistentVolumeClaimList());
            PersistentVolumeClaim pvc = ExecutorLifecycleTestUtils$.MODULE$.persistentVolumeClaim("pvc-0", "gp2", "200Gi");
            pvc.getMetadata().setCreationTimestamp(Instant.now().minus(this.podAllocationDelay() + 1L, ChronoUnit.MILLIS).toString());
            Mockito.when((Object)this.persistentVolumeClaimList().getItems()).thenReturn(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)pvc, (List)Nil$.MODULE$)).asJava());
            Mockito.when((Object)this.executorBuilder().buildFromFeatures((KubernetesExecutorConf)ArgumentMatchers.any(KubernetesExecutorConf.class), (SecurityManager)ArgumentMatchers.eq((Object)this.secMgr()), (KubernetesClient)ArgumentMatchers.eq((Object)this.kubernetesClient()), (ResourceProfile)ArgumentMatchers.any(ResourceProfile.class))).thenAnswer(invocation -> {
                KubernetesExecutorConf k8sConf = (KubernetesExecutorConf)invocation.getArgument(0);
                return new KubernetesExecutorSpec(ExecutorLifecycleTestUtils$.MODULE$.executorPodWithIdAndVolume(new StringOps(Predef$.MODULE$.augmentString(k8sConf.executorId())).toInt(), k8sConf.resourceProfileId()), (Seq)new .colon.colon((Object)ExecutorLifecycleTestUtils$.MODULE$.persistentVolumeClaim("pvc-0", "gp2", "200Gi"), (List)Nil$.MODULE$));
            });
            this.podsAllocatorUnderTest_$eq(new ExecutorPodsAllocator(confWithPVC, this.secMgr(), this.executorBuilder(), this.kubernetesClient(), (ExecutorPodsSnapshotsStore)this.snapshotsStore(), (Clock)this.waitForExecutorPodsClock()));
            this.podsAllocatorUnderTest().start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID(), this.schedulerBackend());
            Mockito.when((Object)this.podOperations().withField("status.phase", "Pending")).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabelIn((String)ArgumentMatchers.eq((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), new String[]{(String)ArgumentMatchers.any()})).thenReturn(this.podOperations());
            long startTime = Instant.now().toEpochMilli();
            this.waitForExecutorPodsClock().setTime(startTime);
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)1))})));
            int $org_scalatest_assert_macro_left = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 743));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForIdAndVolume(1L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForIdAndVolume$default$2()));
            this.snapshotsStore().updatePod(ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(1L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2()));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left2 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 749));
            ((InOutCreateable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)1))).create(ArgumentMatchers.any());
            ((Deletable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.never())).delete();
            this.podsAllocatorUnderTest().setTotalExpectedExecutors((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)2))})));
            this.snapshotsStore().notifySubscribers();
            int $org_scalatest_assert_macro_left3 = this.podsAllocatorUnderTest().numOutstandingPods().get();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 756));
            ((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForIdAndVolume(2L, ExecutorLifecycleTestUtils$.MODULE$.podWithAttachedContainerForIdAndVolume$default$2()));
            return (PersistentVolumeClaim)((InOutCreateable)Mockito.verify(this.persistentVolumeClaims(), (VerificationMode)Mockito.never())).create(ArgumentMatchers.any());
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 693));
        this.test("print the pod name instead of Some(name) if pod is absent", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String nonexistentPod = "i-do-not-exist";
            SparkConf conf = new SparkConf().set(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME(), (Object)nonexistentPod);
            Mockito.when((Object)this.kubernetesClient().pods()).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withName(nonexistentPod)).thenReturn(this.driverPodOperations());
            Mockito.when((Object)this.driverPodOperations().get()).thenReturn(null);
            SparkException e = (SparkException)this.intercept((Function0 & Serializable & scala.Serializable)() -> new ExecutorPodsAllocator(conf, this.secMgr(), this.executorBuilder(), this.kubernetesClient(), (ExecutorPodsSnapshotsStore)this.snapshotsStore(), (Clock)this.waitForExecutorPodsClock()), ClassTag$.MODULE$.apply(SparkException.class), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 767));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "No pod was found named i-do-not-exist in the cluster in the namespace default";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 769));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 761));
        this.test("SPARK-41388: getReusablePVCs should ignore recently created PVCs in the previous batch", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            PrivateMethodTester.PrivateMethod getReusablePVCs = PrivateMethodTester$.MODULE$.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "getReusablePVCs"));
            PersistentVolumeClaim pvc1 = ExecutorLifecycleTestUtils$.MODULE$.persistentVolumeClaim("pvc-0", "gp2", "200Gi");
            PersistentVolumeClaim pvc2 = ExecutorLifecycleTestUtils$.MODULE$.persistentVolumeClaim("pvc-1", "gp2", "200Gi");
            Instant now = Instant.now();
            pvc1.getMetadata().setCreationTimestamp(now.minus(2L * this.podAllocationDelay(), ChronoUnit.MILLIS).toString());
            pvc2.getMetadata().setCreationTimestamp(now.toString());
            Mockito.when((Object)this.persistentVolumeClaimList().getItems()).thenReturn(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)pvc1, (List)new .colon.colon((Object)pvc2, (List)Nil$.MODULE$))).asJava());
            return (Buffer)PrivateMethodTester$.MODULE$.anyRefToInvoker((Object)this.podsAllocatorUnderTest()).invokePrivate(getReusablePVCs.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"appId", new .colon.colon((Object)"pvc-1", (List)Nil$.MODULE$)})));
        }, new Position("ExecutorPodsAllocatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 773));
    }
}

