/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.client.GracePeriodConfigurable;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.MultiDeleteable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.submit.KillApplication;
import org.apache.spark.deploy.k8s.submit.ListStatus;
import org.apache.spark.scheduler.cluster.k8s.ExecutorLifecycleTestUtils$;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\u0010!\u00015BQ\u0001\u000f\u0001\u0005\u0002eBq\u0001\u0010\u0001C\u0002\u0013%Q\b\u0003\u0004G\u0001\u0001\u0006IA\u0010\u0005\b\u000f\u0002\u0011\r\u0011\"\u0003>\u0011\u0019A\u0005\u0001)A\u0005}!9\u0011\n\u0001b\u0001\n\u0013Q\u0005BB-\u0001A\u0003%1\nC\u0004[\u0001\t\u0007I\u0011\u0002&\t\rm\u0003\u0001\u0015!\u0003L\u0011\u001da\u0006A1A\u0005\nuCa\u0001\u001b\u0001!\u0002\u0013q\u0006bB5\u0001\u0005\u0004%I!\u0010\u0005\u0007U\u0002\u0001\u000b\u0011\u0002 \t\u0013-\u0004\u0001\u0019!a\u0001\n\u0013a\u0007bCA\u0002\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u000bA!\"a\u0005\u0001\u0001\u0004\u0005\t\u0015)\u0003n\u0011-\t\u0019\u0003\u0001a\u0001\u0002\u0004%I!!\n\t\u0017\u0005]\u0002\u00011AA\u0002\u0013%\u0011\u0011\b\u0005\f\u0003{\u0001\u0001\u0019!A!B\u0013\t9\u0003C\u0006\u0002B\u0001\u0001\r\u00111A\u0005\n\u0005\u0015\u0002bCA\"\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u000bB1\"!\u0013\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002(!Y\u0011Q\n\u0001A\u0002\u0003\u0007I\u0011BA(\u0011-\tI\u0006\u0001a\u0001\u0002\u0004%I!a\u0017\t\u0017\u0005}\u0003\u00011A\u0001B\u0003&\u0011\u0011\u000b\u0005\f\u0003G\u0002\u0001\u0019!a\u0001\n\u0013\t)\u0007C\u0006\u0002r\u0001\u0001\r\u00111A\u0005\n\u0005M\u0004bCA<\u0001\u0001\u0007\t\u0011)Q\u0005\u0003OBq!a\u001f\u0001\t\u0013\ti\bC\u0004\u0002\u0016\u0002!I!a&\u0003!-C4oU;c[&$x\n]*vSR,'BA\u0011#\u0003\u0019\u0019XOY7ji*\u00111\u0005J\u0001\u0004Wb\u001a(BA\u0013'\u0003\u0019!W\r\u001d7ps*\u0011q\u0005K\u0001\u0006gB\f'o\u001b\u0006\u0003S)\na!\u00199bG\",'\"A\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001q#\u0007\u0005\u00020a5\ta%\u0003\u00022M\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"a\r\u001c\u000e\u0003QR!!\u000e\u0016\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018BA\u001c5\u00059\u0011UMZ8sK\u0006sG-\u00114uKJ\fa\u0001P5oSRtD#\u0001\u001e\u0011\u0005m\u0002Q\"\u0001\u0011\u0002\u001d\u0011\u0014\u0018N^3s!>$g*Y7fcU\ta\b\u0005\u0002@\t6\t\u0001I\u0003\u0002B\u0005\u0006!A.\u00198h\u0015\u0005\u0019\u0015\u0001\u00026bm\u0006L!!\u0012!\u0003\rM#(/\u001b8h\u0003=!'/\u001b<feB{GMT1nKF\u0002\u0013A\u00043sSZ,'\u000fU8e\u001d\u0006lWMM\u0001\u0010IJLg/\u001a:Q_\u0012t\u0015-\\33A\u0005QAM]5wKJ\u0004v\u000eZ\u0019\u0016\u0003-\u0003\"\u0001T,\u000e\u00035S!AT(\u0002\u000b5|G-\u001a7\u000b\u0005A\u000b\u0016aA1qS*\u0011!kU\u0001\u000bWV\u0014WM\u001d8fi\u0016\u001c(B\u0001+V\u0003\u001d1\u0017M\u0019:jGbR\u0011AV\u0001\u0003S>L!\u0001W'\u0003\u0007A{G-A\u0006ee&4XM\u001d)pIF\u0002\u0013A\u00033sSZ,'\u000fU8ee\u0005YAM]5wKJ\u0004v\u000e\u001a\u001a!\u0003\u001d\u0001x\u000e\u001a'jgR,\u0012A\u0018\t\u0004?\u001a\\U\"\u00011\u000b\u0005\u0005\u0014\u0017!C5n[V$\u0018M\u00197f\u0015\t\u0019G-\u0001\u0006d_2dWm\u0019;j_:T\u0011!Z\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0002\u0014A\u0001T5ti\u0006A\u0001o\u001c3MSN$\b%A\u0005oC6,7\u000f]1dK\u0006Qa.Y7fgB\f7-\u001a\u0011\u0002\u001bA|Gm\u00149fe\u0006$\u0018n\u001c8t+\u0005i\u0007C\u00018\u007f\u001d\tyGP\u0004\u0002qw:\u0011\u0011O\u001f\b\u0003eft!a\u001d=\u000f\u0005Q<X\"A;\u000b\u0005Yd\u0013A\u0002\u001fs_>$h(C\u0001,\u0013\tI#&\u0003\u0002(Q%\u0011QEJ\u0005\u0003G\u0011J!! \u0012\u0002\u001d\u0019\u000b'M]5dq\u0005c\u0017.Y:fg&\u0019q0!\u0001\u0003\tA{Ei\u0015\u0006\u0003{\n\n\u0011\u0003]8e\u001fB,'/\u0019;j_:\u001cx\fJ3r)\u0011\t9!a\u0004\u0011\t\u0005%\u00111B\u0007\u0002I&\u0019\u0011Q\u00023\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003#y\u0011\u0011!a\u0001[\u0006\u0019\u0001\u0010J\u0019\u0002\u001dA|Gm\u00149fe\u0006$\u0018n\u001c8tA!\u001a\u0001#a\u0006\u0011\t\u0005e\u0011qD\u0007\u0003\u00037Q1!!\b+\u0003\u001diwnY6ji>LA!!\t\u0002\u001c\t!Qj\\2l\u0003Q!'/\u001b<feB{Gm\u00149fe\u0006$\u0018n\u001c8tcU\u0011\u0011q\u0005\t\u0006\u0003S\t\u0019dS\u0007\u0003\u0003WQA!!\f\u00020\u0005\u0019Am\u001d7\u000b\u0007\u0005E\u0012+\u0001\u0004dY&,g\u000e^\u0005\u0005\u0003k\tYCA\u0006Q_\u0012\u0014Vm]8ve\u000e,\u0017\u0001\u00073sSZ,'\u000fU8e\u001fB,'/\u0019;j_:\u001c\u0018g\u0018\u0013fcR!\u0011qAA\u001e\u0011%\t\tBEA\u0001\u0002\u0004\t9#A\u000bee&4XM\u001d)pI>\u0003XM]1uS>t7/\r\u0011)\u0007M\t9\"\u0001\u000bee&4XM\u001d)pI>\u0003XM]1uS>t7OM\u0001\u0019IJLg/\u001a:Q_\u0012|\u0005/\u001a:bi&|gn\u001d\u001a`I\u0015\fH\u0003BA\u0004\u0003\u000fB\u0011\"!\u0005\u0016\u0003\u0003\u0005\r!a\n\u0002+\u0011\u0014\u0018N^3s!>$w\n]3sCRLwN\\:3A!\u001aa#a\u0006\u0002!-,(-\u001a:oKR,7o\u00117jK:$XCAA)!\u0011\t\u0019&!\u0016\u000e\u0005\u0005=\u0012\u0002BA,\u0003_\u0011\u0001cS;cKJtW\r^3t\u00072LWM\u001c;\u0002)-,(-\u001a:oKR,7o\u00117jK:$x\fJ3r)\u0011\t9!!\u0018\t\u0013\u0005E\u0001$!AA\u0002\u0005E\u0013!E6vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8uA!\u001a\u0011$a\u0006\u0002\u0007\u0015\u0014(/\u0006\u0002\u0002hA!\u0011\u0011NA7\u001b\t\tYG\u0003\u0002W\u0005&!\u0011qNA6\u0005-\u0001&/\u001b8u'R\u0014X-Y7\u0002\u000f\u0015\u0014(o\u0018\u0013fcR!\u0011qAA;\u0011%\t\tbGA\u0001\u0002\u0004\t9'\u0001\u0003feJ\u0004\u0003f\u0001\u000f\u0002\u0018\u0005q!-^5mI\u0012\u0013\u0018N^3s!>$G#B&\u0002\u0000\u0005E\u0005bBAA;\u0001\u0007\u00111Q\u0001\ba>$g*Y7f!\u0011\t))!$\u000f\t\u0005\u001d\u0015\u0011\u0012\t\u0003i\u0012L1!a#e\u0003\u0019\u0001&/\u001a3fM&\u0019Q)a$\u000b\u0007\u0005-E\rC\u0004\u0002\u0014v\u0001\r!a!\u0002\u0005%$\u0017\u0001D4fiB{Gm\u0015;biV\u001cHCBAB\u00033\u000bY\nC\u0004\u0002\u0002z\u0001\r!a!\t\u000f\u0005Me\u00041\u0001\u0002\u0004\u0002")
public class K8sSubmitOpSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final String driverPodName1;
    private final String driverPodName2;
    private final Pod driverPod1;
    private final Pod driverPod2;
    private final List<Pod> podList;
    private final String namespace;
    @Mock
    private MixedOperation<Pod, PodList, PodResource<Pod>> podOperations;
    @Mock
    private PodResource<Pod> driverPodOperations1;
    @Mock
    private PodResource<Pod> driverPodOperations2;
    @Mock
    private KubernetesClient kubernetesClient;
    @Mock
    private PrintStream err;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private String driverPodName1() {
        return this.driverPodName1;
    }

    private String driverPodName2() {
        return this.driverPodName2;
    }

    private Pod driverPod1() {
        return this.driverPod1;
    }

    private Pod driverPod2() {
        return this.driverPod2;
    }

    private List<Pod> podList() {
        return this.podList;
    }

    private String namespace() {
        return this.namespace;
    }

    private MixedOperation<Pod, PodList, PodResource<Pod>> podOperations() {
        return this.podOperations;
    }

    private void podOperations_$eq(MixedOperation<Pod, PodList, PodResource<Pod>> x$1) {
        this.podOperations = x$1;
    }

    private PodResource<Pod> driverPodOperations1() {
        return this.driverPodOperations1;
    }

    private void driverPodOperations1_$eq(PodResource<Pod> x$1) {
        this.driverPodOperations1 = x$1;
    }

    private PodResource<Pod> driverPodOperations2() {
        return this.driverPodOperations2;
    }

    private void driverPodOperations2_$eq(PodResource<Pod> x$1) {
        this.driverPodOperations2 = x$1;
    }

    private KubernetesClient kubernetesClient() {
        return this.kubernetesClient;
    }

    private void kubernetesClient_$eq(KubernetesClient x$1) {
        this.kubernetesClient = x$1;
    }

    private PrintStream err() {
        return this.err;
    }

    private void err_$eq(PrintStream x$1) {
        this.err = x$1;
    }

    private Pod buildDriverPod(String podName, String id) {
        return ((PodBuilder)((PodFluent.StatusNested)((PodFluentImpl)((PodFluent.SpecNested)((PodFluentImpl)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(podName).withNamespace(this.namespace()).addToLabels(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID()).addToLabels(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_DRIVER_ROLE()).withUid(new StringBuilder(11).append("driver-pod-").append(id).toString())).endMetadata()).withNewSpec().withServiceAccountName(new StringBuilder(4).append("test").append(id).toString()).withVolumes(new Volume[0]).withNodeName(new StringBuilder(8).append("testNode").append(id).toString())).endSpec()).withNewStatus().withPhase("Running")).endStatus()).build();
    }

    private String getPodStatus(String podName, String id) {
        return new StringBuilder(29).append("Application status (driver): ").append(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(377).append("|").append("\n\t").append(" pod name: ").append(podName).append("\n          |").append("\t").append(" namespace: N/A\n          |").append("\t").append(" labels: spark-app-selector -> spark-app-id, spark-role -> driver\n          |").append("\t").append(" pod uid: driver-pod-").append(id).append("\n          |").append("\t").append(" creation time: N/A\n          |").append("\t").append(" service account name: test").append(id).append("\n          |").append("\t").append(" volumes: N/A\n          |").append("\t").append(" node name: testNode").append(id).append("\n          |").append("\t").append(" start time: N/A\n          |").append("\t").append(" phase: Running\n          |").append("\t").append(" container status: N/A").toString())).stripMargin()).toString();
    }

    public K8sSubmitOpSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.driverPodName1 = "driver1";
        this.driverPodName2 = "driver2";
        this.driverPod1 = this.buildDriverPod(this.driverPodName1(), "1");
        this.driverPod2 = this.buildDriverPod(this.driverPodName2(), "2");
        this.podList = new .colon.colon((Object)this.driverPod1(), (List)new .colon.colon((Object)this.driverPod2(), (List)Nil$.MODULE$));
        this.namespace = "test";
        this.before((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            MockitoAnnotations.openMocks((Object)((Object)this)).close();
            Mockito.when((Object)this.kubernetesClient().pods()).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().inNamespace(this.namespace())).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().delete((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.podList()).asJava())).thenReturn((Object)Predef$.MODULE$.boolean2Boolean(true));
            Mockito.when((Object)this.podOperations().withName(this.driverPodName1())).thenReturn(this.driverPodOperations1());
            Mockito.when((Object)this.podOperations().withName(this.driverPodName2())).thenReturn(this.driverPodOperations2());
            Mockito.when((Object)this.driverPodOperations1().get()).thenReturn((Object)this.driverPod1());
            Mockito.when((Object)this.driverPodOperations1().delete()).thenReturn((Object)Predef$.MODULE$.boolean2Boolean(true));
            Mockito.when((Object)this.driverPodOperations2().get()).thenReturn((Object)this.driverPod2());
            return Mockito.when((Object)this.driverPodOperations2().delete()).thenReturn((Object)Predef$.MODULE$.boolean2Boolean(true));
        }, new Position("K8sSubmitOpSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        this.test("List app status", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            KubernetesClient kubeClient = this.kubernetesClient();
            ListStatus listStatus = new ListStatus();
            listStatus.printStream_$eq(this.err());
            listStatus.executeOnPod(this.driverPodName1(), Option$.MODULE$.apply((Object)this.namespace()), new SparkConf(), kubeClient);
            ((PrintStream)Mockito.verify((Object)this.err())).println((String)ArgumentMatchers.eq((Object)this.getPodStatus(this.driverPodName1(), "1")));
        }, new Position("K8sSubmitOpSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        this.test("List status for multiple apps with glob", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            KubernetesClient kubeClient = this.kubernetesClient();
            ListStatus listStatus = new ListStatus();
            listStatus.printStream_$eq(this.err());
            listStatus.executeOnGlob(this.podList(), Option$.MODULE$.apply((Object)this.namespace()), new SparkConf(), kubeClient);
            ((PrintStream)Mockito.verify((Object)this.err())).println((String)ArgumentMatchers.eq((Object)this.getPodStatus(this.driverPodName1(), "1")));
            ((PrintStream)Mockito.verify((Object)this.err())).println((String)ArgumentMatchers.eq((Object)this.getPodStatus(this.driverPodName2(), "2")));
        }, new Position("K8sSubmitOpSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        this.test("Kill app", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesClient kubeClient = this.kubernetesClient();
            KillApplication killApp = new KillApplication();
            killApp.executeOnPod(this.driverPodName1(), Option$.MODULE$.apply((Object)this.namespace()), new SparkConf(), kubeClient);
            return ((Deletable)Mockito.verify(this.driverPodOperations1(), (VerificationMode)Mockito.times((int)1))).delete();
        }, new Position("K8sSubmitOpSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("Kill app with gracePeriod", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesClient kubeClient = this.kubernetesClient();
            KillApplication killApp = new KillApplication();
            SparkConf conf = new SparkConf().set(Config$.MODULE$.KUBERNETES_SUBMIT_GRACE_PERIOD(), (Object)BoxesRunTime.boxToLong((long)1L));
            Mockito.when((Object)this.driverPodOperations1().withGracePeriod(1L)).thenReturn(this.driverPodOperations1());
            killApp.executeOnPod(this.driverPodName1(), Option$.MODULE$.apply((Object)this.namespace()), conf, kubeClient);
            ((GracePeriodConfigurable)Mockito.verify(this.driverPodOperations1(), (VerificationMode)Mockito.times((int)1))).withGracePeriod(1L);
            return ((Deletable)Mockito.verify(this.driverPodOperations1(), (VerificationMode)Mockito.times((int)1))).delete();
        }, new Position("K8sSubmitOpSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("Kill multiple apps with glob without gracePeriod", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            KubernetesClient kubeClient = this.kubernetesClient();
            KillApplication killApp = new KillApplication();
            killApp.printStream_$eq(this.err());
            killApp.executeOnGlob(this.podList(), Option$.MODULE$.apply((Object)this.namespace()), new SparkConf(), kubeClient);
            ((MultiDeleteable)Mockito.verify(this.podOperations(), (VerificationMode)Mockito.times((int)1))).delete((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.podList()).asJava());
            ((PrintStream)Mockito.verify((Object)this.err())).println((String)ArgumentMatchers.eq((Object)new StringBuilder(22).append("Deleting driver pod: ").append(this.driverPodName1()).append(".").toString()));
            ((PrintStream)Mockito.verify((Object)this.err())).println((String)ArgumentMatchers.eq((Object)new StringBuilder(22).append("Deleting driver pod: ").append(this.driverPodName2()).append(".").toString()));
        }, new Position("K8sSubmitOpSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
    }
}

