/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesDriverSpec;
import org.apache.spark.deploy.k8s.KubernetesTestConf$;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.SparkPod$;
import org.apache.spark.deploy.k8s.features.DriverCommandFeatureStep;
import org.apache.spark.deploy.k8s.submit.JavaMainAppResource;
import org.apache.spark.deploy.k8s.submit.MainAppResource;
import org.apache.spark.deploy.k8s.submit.PythonMainAppResource;
import org.apache.spark.deploy.k8s.submit.RMainAppResource;
import org.apache.spark.internal.config.package$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r4Aa\u0002\u0005\u0001+!)!\u0004\u0001C\u00017!)a\u0004\u0001C\u0005?!9a\nAI\u0001\n\u0013y\u0005b\u0002.\u0001#\u0003%Ia\u0017\u0005\b;\u0002\t\n\u0011\"\u0003_\u0011\u001d\u0001\u0007!%A\u0005\n\u0005\u0014Q\u0004\u0012:jm\u0016\u00148i\\7nC:$g)Z1ukJ,7\u000b^3q'VLG/\u001a\u0006\u0003\u0013)\t\u0001BZ3biV\u0014Xm\u001d\u0006\u0003\u00171\t1a\u001b\u001dt\u0015\tia\"\u0001\u0004eKBdw.\u001f\u0006\u0003\u001fA\tQa\u001d9be.T!!\u0005\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0012aA8sO\u000e\u00011C\u0001\u0001\u0017!\t9\u0002$D\u0001\u000f\u0013\tIbBA\u0007Ta\u0006\u00148NR;o'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0001\"!\b\u0001\u000e\u0003!\t\u0001#\u00199qYf4U-\u0019;ve\u0016\u001cF/\u001a9\u0015\r\u0001\"C&\r#J!\t\t#%D\u0001\u000b\u0013\t\u0019#B\u0001\u000bLk\n,'O\\3uKN$%/\u001b<feN\u0003Xm\u0019\u0005\u0006K\t\u0001\rAJ\u0001\te\u0016\u001cx.\u001e:dKB\u0011qEK\u0007\u0002Q)\u0011\u0011FC\u0001\u0007gV\u0014W.\u001b;\n\u0005-B#aD'bS:\f\u0005\u000f\u001d*fg>,(oY3\t\u000f5\u0012\u0001\u0013!a\u0001]\u0005!1m\u001c8g!\t9r&\u0003\u00021\u001d\tI1\u000b]1sW\u000e{gN\u001a\u0005\be\t\u0001\n\u00111\u00014\u0003\u001d\t\u0007\u000f]!sON\u00042\u0001N\u001c:\u001b\u0005)$\"\u0001\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005a*$!B!se\u0006L\bC\u0001\u001eB\u001d\tYt\b\u0005\u0002=k5\tQH\u0003\u0002?)\u00051AH]8pizJ!\u0001Q\u001b\u0002\rA\u0013X\rZ3g\u0013\t\u00115I\u0001\u0004TiJLgn\u001a\u0006\u0003\u0001VBq!\u0012\u0002\u0011\u0002\u0003\u0007a)A\u0005qe>D\u00180V:feB\u0019AgR\u001d\n\u0005!+$AB(qi&|g\u000eC\u0004K\u0005A\u0005\t\u0019A&\u0002\u0007\u0015tg\u000f\u0005\u0003;\u0019fJ\u0014BA'D\u0005\ri\u0015\r]\u0001\u001bCB\u0004H.\u001f$fCR,(/Z*uKB$C-\u001a4bk2$HEM\u000b\u0002!*\u0012a&U\u0016\u0002%B\u00111\u000bW\u0007\u0002)*\u0011QKV\u0001\nk:\u001c\u0007.Z2lK\u0012T!aV\u001b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002Z)\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00025\u0005\u0004\b\u000f\\=GK\u0006$XO]3Ti\u0016\u0004H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0003qS#aM)\u00025\u0005\u0004\b\u000f\\=GK\u0006$XO]3Ti\u0016\u0004H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0003}S#AR)\u00025\u0005\u0004\b\u000f\\=GK\u0006$XO]3Ti\u0016\u0004H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0003\tT#aS)")
public class DriverCommandFeatureStepSuite
extends SparkFunSuite {
    private KubernetesDriverSpec applyFeatureStep(MainAppResource resource, SparkConf conf, String[] appArgs, Option<String> proxyUser, Map<String, String> env) {
        SparkConf x$1 = conf;
        MainAppResource x$2 = resource;
        String[] x$3 = appArgs;
        Option<String> x$4 = proxyUser;
        String x$5 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
        String x$6 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
        Option<String> x$7 = KubernetesTestConf$.MODULE$.createDriverConf$default$6();
        Map<String, String> x$8 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
        Map<String, String> x$9 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
        Map<String, String> x$10 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
        Map<String, String> x$11 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
        Map<String, String> x$12 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
        Map<String, String> x$13 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
        Seq<KubernetesVolumeSpec> x$14 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
        KubernetesDriverConf kubernetesConf = KubernetesTestConf$.MODULE$.createDriverConf(x$1, x$5, x$2, x$6, x$3, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$4);
        DriverCommandFeatureStep step = new DriverCommandFeatureStep(null, kubernetesConf, env){
            private final Map<String, String> environmentVariables;

            public Map<String, String> environmentVariables() {
                return this.environmentVariables;
            }
            {
                this.environmentVariables = env$1;
            }
        };
        SparkPod pod = step.configurePod(SparkPod$.MODULE$.initialPod());
        Map props = step.getAdditionalPodSystemProperties();
        return new KubernetesDriverSpec(pod, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, props);
    }

    private SparkConf applyFeatureStep$default$2() {
        return new SparkConf(false);
    }

    private String[] applyFeatureStep$default$3() {
        return (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
    }

    private Option<String> applyFeatureStep$default$4() {
        return None$.MODULE$;
    }

    private Map<String, String> applyFeatureStep$default$5() {
        return Predef$.MODULE$.Map().empty();
    }

    public DriverCommandFeatureStepSuite() {
        this.test("java resource", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String mainResource = "local:/main.jar";
            JavaMainAppResource x$1 = new JavaMainAppResource((Option)new Some((Object)mainResource));
            String[] x$2 = (String[])((Object[])new String[]{"5", "7"});
            SparkConf x$3 = this.applyFeatureStep$default$2();
            Option<String> x$4 = this.applyFeatureStep$default$4();
            Map<String, String> x$5 = this.applyFeatureStep$default$5();
            KubernetesDriverSpec spec = this.applyFeatureStep((MainAppResource)x$1, x$3, x$2, x$4, x$5);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(JavaConverters$.MODULE$.asScalaBufferConverter(spec.pod().container().getArgs()).asScala());
            List $org_scalatest_assert_macro_right = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"driver", "--properties-file", Constants$.MODULE$.SPARK_CONF_PATH(), "--class", KubernetesTestConf$.MODULE$.MAIN_CLASS(), mainResource, "5", "7"}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverCommandFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
        }, new Position("DriverCommandFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
        this.test("python resource", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String mainResource = "local:/main.py";
            SparkConf sparkConf = new SparkConf(false);
            KubernetesDriverSpec spec = this.applyFeatureStep((MainAppResource)new PythonMainAppResource(mainResource), sparkConf, (String[])((Object[])new String[]{"5", "7", "9"}), this.applyFeatureStep$default$4(), this.applyFeatureStep$default$5());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(JavaConverters$.MODULE$.asScalaBufferConverter(spec.pod().container().getArgs()).asScala());
            List $org_scalatest_assert_macro_right = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"driver", "--properties-file", Constants$.MODULE$.SPARK_CONF_PATH(), "--class", KubernetesTestConf$.MODULE$.MAIN_CLASS(), mainResource, "5", "7", "9"}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverCommandFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        }, new Position("DriverCommandFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        this.test("python executable precedence", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String mainResource = "local:/main.py";
            Seq pythonExecutables = (Seq)new .colon.colon((Object)new Tuple4((Object)new Some((Object)"conf_py"), (Object)new Some((Object)"conf_driver_py"), (Object)new Some((Object)"env_py"), (Object)new Some((Object)"env_driver_py")), (List)new .colon.colon((Object)new Tuple4((Object)new Some((Object)"conf_py"), (Object)None$.MODULE$, (Object)new Some((Object)"env_py"), (Object)new Some((Object)"env_driver_py")), (List)new .colon.colon((Object)new Tuple4((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)new Some((Object)"env_py"), (Object)new Some((Object)"env_driver_py")), (List)new .colon.colon((Object)new Tuple4((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)new Some((Object)"env_py"), (Object)None$.MODULE$), (List)Nil$.MODULE$))));
            Seq expectedResults = (Seq)new .colon.colon((Object)new Tuple2((Object)"conf_py", (Object)"conf_driver_py"), (List)new .colon.colon((Object)new Tuple2((Object)"conf_py", (Object)"conf_py"), (List)new .colon.colon((Object)new Tuple2((Object)"env_py", (Object)"env_driver_py"), (List)new .colon.colon((Object)new Tuple2((Object)"env_py", (Object)"env_py"), (List)Nil$.MODULE$))));
            ((IterableLike)pythonExecutables.zip((GenIterable)expectedResults, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Tuple4 pythonExecutable = (Tuple4)tuple2._1();
                    Tuple2 expected = (Tuple2)tuple2._2();
                    SparkConf sparkConf = new SparkConf(false);
                    Tuple4 tuple4 = pythonExecutable;
                    if (tuple4 == null) {
                        throw new MatchError((Object)tuple4);
                    }
                    Option confPy = (Option)tuple4._1();
                    Option confDriverPy = (Option)tuple4._2();
                    Some envPy = (Some)tuple4._3();
                    Option envDriverPy = (Option)tuple4._4();
                    Tuple4 tuple42 = new Tuple4((Object)confPy, (Object)confDriverPy, (Object)envPy, (Object)envDriverPy);
                    Option confPy2 = (Option)tuple42._1();
                    Option confDriverPy2 = (Option)tuple42._2();
                    Some envPy2 = (Some)tuple42._3();
                    Option envDriverPy2 = (Option)tuple42._4();
                    confPy2.foreach((Function1 & Serializable & scala.Serializable)x$2 -> sparkConf.set(package$.MODULE$.PYSPARK_PYTHON(), x$2));
                    confDriverPy2.foreach((Function1 & Serializable & scala.Serializable)x$3 -> sparkConf.set(package$.MODULE$.PYSPARK_DRIVER_PYTHON(), x$3));
                    Map pythonEnvs = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])((TraversableOnce)((GenericTraversableTemplate)Option$.MODULE$.option2Iterable(envPy2.map((Function1 & Serializable & scala.Serializable)v -> {
                        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_PYSPARK_PYTHON()), v);
                        return Nil$.MODULE$.$colon$colon((Object)tuple2);
                    })).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(envDriverPy2.map((Function1 & Serializable & scala.Serializable)v -> {
                        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_PYSPARK_DRIVER_PYTHON()), v);
                        return Nil$.MODULE$.$colon$colon((Object)tuple2);
                    })), Iterable$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms())).toArray(ClassTag$.MODULE$.apply(Tuple2.class))));
                    PythonMainAppResource x$6 = new PythonMainAppResource(mainResource);
                    SparkConf x$7 = sparkConf;
                    String[] x$8 = (String[])((Object[])new String[]{"foo"});
                    Map x$9 = pythonEnvs;
                    Option<String> x$10 = this.applyFeatureStep$default$4();
                    KubernetesDriverSpec spec = this.applyFeatureStep((MainAppResource)x$6, x$7, x$8, x$10, (Map<String, String>)x$9);
                    Map envs = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(spec.pod().container().getEnv()).asScala()).map((Function1 & Serializable & scala.Serializable)env -> new Tuple2((Object)env.getName(), (Object)env.getValue()), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    Tuple2 tuple22 = expected;
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    String expectedEnvPy = (String)tuple22._1();
                    String expectedDriverPy = (String)tuple22._2();
                    Tuple2 tuple23 = new Tuple2((Object)expectedEnvPy, (Object)expectedDriverPy);
                    String expectedEnvPy2 = (String)tuple23._1();
                    String expectedDriverPy2 = (String)tuple23._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(envs);
                    Map $org_scalatest_assert_macro_right = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_PYSPARK_PYTHON()), (Object)expectedEnvPy2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_PYSPARK_DRIVER_PYTHON()), (Object)expectedDriverPy2)}));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverCommandFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("DriverCommandFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        this.test("R resource", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String mainResource = "local:/main.R";
            RMainAppResource x$11 = new RMainAppResource(mainResource);
            String[] x$12 = (String[])((Object[])new String[]{"5", "7", "9"});
            SparkConf x$13 = this.applyFeatureStep$default$2();
            Option<String> x$14 = this.applyFeatureStep$default$4();
            Map<String, String> x$15 = this.applyFeatureStep$default$5();
            KubernetesDriverSpec spec = this.applyFeatureStep((MainAppResource)x$11, x$13, x$12, x$14, x$15);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(JavaConverters$.MODULE$.asScalaBufferConverter(spec.pod().container().getArgs()).asScala());
            List $org_scalatest_assert_macro_right = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"driver", "--properties-file", Constants$.MODULE$.SPARK_CONF_PATH(), "--class", KubernetesTestConf$.MODULE$.MAIN_CLASS(), mainResource, "5", "7", "9"}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverCommandFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        }, new Position("DriverCommandFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        this.test("SPARK-25355: java resource args with proxy-user", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String mainResource = "local:/main.jar";
            JavaMainAppResource x$16 = new JavaMainAppResource((Option)new Some((Object)mainResource));
            String[] x$17 = (String[])((Object[])new String[]{"5", "7"});
            Some x$18 = new Some((Object)"test.user");
            SparkConf x$19 = this.applyFeatureStep$default$2();
            Map<String, String> x$20 = this.applyFeatureStep$default$5();
            KubernetesDriverSpec spec = this.applyFeatureStep((MainAppResource)x$16, x$19, x$17, (Option<String>)x$18, x$20);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(JavaConverters$.MODULE$.asScalaBufferConverter(spec.pod().container().getArgs()).asScala());
            List $org_scalatest_assert_macro_right = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"driver", "--proxy-user", "test.user", "--properties-file", Constants$.MODULE$.SPARK_CONF_PATH(), "--class", KubernetesTestConf$.MODULE$.MAIN_CLASS(), mainResource, "5", "7"}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverCommandFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        }, new Position("DriverCommandFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        this.test("SPARK-25355: python resource args with proxy-user", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String mainResource = "local:/main.py";
            SparkConf sparkConf = new SparkConf(false);
            KubernetesDriverSpec spec = this.applyFeatureStep((MainAppResource)new PythonMainAppResource(mainResource), sparkConf, (String[])((Object[])new String[]{"5", "7", "9"}), (Option<String>)new Some((Object)"test.user"), this.applyFeatureStep$default$5());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(JavaConverters$.MODULE$.asScalaBufferConverter(spec.pod().container().getArgs()).asScala());
            List $org_scalatest_assert_macro_right = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"driver", "--proxy-user", "test.user", "--properties-file", Constants$.MODULE$.SPARK_CONF_PATH(), "--class", KubernetesTestConf$.MODULE$.MAIN_CLASS(), mainResource, "5", "7", "9"}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverCommandFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        }, new Position("DriverCommandFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        this.test("SPARK-25355: R resource args with proxy-user", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String mainResource = "local:/main.R";
            RMainAppResource x$21 = new RMainAppResource(mainResource);
            String[] x$22 = (String[])((Object[])new String[]{"5", "7", "9"});
            Some x$23 = new Some((Object)"test.user");
            SparkConf x$24 = this.applyFeatureStep$default$2();
            Map<String, String> x$25 = this.applyFeatureStep$default$5();
            KubernetesDriverSpec spec = this.applyFeatureStep((MainAppResource)x$21, x$24, x$22, (Option<String>)x$23, x$25);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(JavaConverters$.MODULE$.asScalaBufferConverter(spec.pod().container().getArgs()).asScala());
            List $org_scalatest_assert_macro_right = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"driver", "--proxy-user", "test.user", "--properties-file", Constants$.MODULE$.SPARK_CONF_PATH(), "--class", KubernetesTestConf$.MODULE$.MAIN_CLASS(), mainResource, "5", "7", "9"}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DriverCommandFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        }, new Position("DriverCommandFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
    }
}

