/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Patchable;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.ExecutorExited;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodState;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.FinalPodState;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.PodDeleted;
import org.apache.spark.scheduler.cluster.k8s.PodFailed;
import org.apache.spark.scheduler.cluster.k8s.PodSucceeded;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.generic.Subtractable;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ug!B\u000f\u001f\u0001\u0011R\u0003\u0002C\u001c\u0001\u0005\u000b\u0007I\u0011A\u001d\t\u0011y\u0002!\u0011!Q\u0001\niB\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\")\u0011\u000b\u0001C\u0001%\"Aq\u000b\u0001EC\u0002\u0013%\u0001\f\u0003\u0005]\u0001!\u0015\r\u0011\"\u0003^\u0011!\t\u0007\u0001#b\u0001\n\u0013\u0011\u0007b\u0002<\u0001\u0001\u0004%I!\u0018\u0005\bo\u0002\u0001\r\u0011\"\u0003y\u0011\u0019q\b\u0001)Q\u0005=\"Aq\u0010\u0001b\u0001\n\u0013\t\t\u0001\u0003\u0005\u0002\u0014\u0001\u0001\u000b\u0011BA\u0002\u0011\u001d\t)\u0002\u0001C\u0001\u0003/Aq!a\t\u0001\t\u0013\t)\u0003C\u0004\u0002L\u0001!I!!\u0014\t\u000f\u0005\r\u0004\u0001\"\u0003\u0002f!9\u0011Q\u0010\u0001\u0005\n\u0005}\u0004bBAD\u0001\u0011%\u0011\u0011\u0012\u0005\b\u0003/\u0003A\u0011BAM\u0011\u001d\tI\f\u0001C\u0005\u0003wCq!a0\u0001\t\u0013\t\tmB\u0004\u0002HzAI!!3\u0007\ruq\u0002\u0012BAf\u0011\u0019\t\u0006\u0004\"\u0001\u0002N\"I\u0011q\u001a\rC\u0002\u0013\u0005\u0011\u0011\u001b\u0005\t\u0003'D\u0002\u0015!\u0003\u00024\"9\u0011Q\u001b\r\u0005\u0002\u0005]'\u0001H#yK\u000e,Ho\u001c:Q_\u0012\u001cH*\u001b4fGf\u001cG.Z'b]\u0006<WM\u001d\u0006\u0003?\u0001\n1a\u001b\u001dt\u0015\t\t#%A\u0004dYV\u001cH/\u001a:\u000b\u0005\r\"\u0013!C:dQ\u0016$W\u000f\\3s\u0015\t)c%A\u0003ta\u0006\u00148N\u0003\u0002(Q\u00051\u0011\r]1dQ\u0016T\u0011!K\u0001\u0004_J<7c\u0001\u0001,cA\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t1\u0011I\\=SK\u001a\u0004\"AM\u001b\u000e\u0003MR!\u0001\u000e\u0013\u0002\u0011%tG/\u001a:oC2L!AN\u001a\u0003\u000f1{wmZ5oO\u0006!1m\u001c8g\u0007\u0001)\u0012A\u000f\t\u0003wqj\u0011\u0001J\u0005\u0003{\u0011\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002\u000b\r|gN\u001a\u0011\u0002!-,(-\u001a:oKR,7o\u00117jK:$\bCA!K\u001b\u0005\u0011%BA\"E\u0003\u0019\u0019G.[3oi*\u0011QIR\u0001\u000bWV\u0014WM\u001d8fi\u0016\u001c(BA$I\u0003\u001d1\u0017M\u0019:jGbR\u0011!S\u0001\u0003S>L!a\u0013\"\u0003!-+(-\u001a:oKR,7o\u00117jK:$\u0018AD:oCB\u001c\bn\u001c;t'R|'/\u001a\t\u0003\u001d>k\u0011AH\u0005\u0003!z\u0011!$\u0012=fGV$xN\u001d)pIN\u001cf.\u00199tQ>$8o\u0015;pe\u0016\fa\u0001P5oSRtD\u0003B*U+Z\u0003\"A\u0014\u0001\t\u000b]*\u0001\u0019\u0001\u001e\t\u000b}*\u0001\u0019\u0001!\t\u000b1+\u0001\u0019A'\u0002+MDw.\u001e7e\t\u0016dW\r^3Fq\u0016\u001cW\u000f^8sgV\t\u0011\f\u0005\u0002-5&\u00111,\f\u0002\b\u0005>|G.Z1o\u0003Ui\u0017n]:j]\u001e\u0004v\u000e\u001a#fi\u0016\u001cG\u000fR3mi\u0006,\u0012A\u0018\t\u0003Y}K!\u0001Y\u0017\u0003\t1{gnZ\u0001\u0016e\u0016lwN^3e\u000bb,7-\u001e;peN\u001c\u0015m\u00195f+\u0005\u0019\u0007\u0003\u00023n_>l\u0011!\u001a\u0006\u0003M\u001e\fQaY1dQ\u0016T!\u0001[5\u0002\r\r|W.\\8o\u0015\tQ7.\u0001\u0004h_><G.\u001a\u0006\u0002Y\u0006\u00191m\\7\n\u00059,'!B\"bG\",\u0007C\u00019v\u001b\u0005\t(B\u0001:t\u0003\u0011a\u0017M\\4\u000b\u0003Q\fAA[1wC&\u0011\u0001-]\u0001\u0013Y\u0006\u001cHOR;mYNs\u0017\r]:i_R$6/\u0001\fmCN$h)\u001e7m':\f\u0007o\u001d5piR\u001bx\fJ3r)\tIH\u0010\u0005\u0002-u&\u001110\f\u0002\u0005+:LG\u000fC\u0004~\u0015\u0005\u0005\t\u0019\u00010\u0002\u0007a$\u0013'A\nmCN$h)\u001e7m':\f\u0007o\u001d5piR\u001b\b%A\bj]\u0006\u001cG/\u001b<bi\u0016$\u0007k\u001c3t+\t\t\u0019\u0001E\u0003\u0002\u0006\u0005=a,\u0004\u0002\u0002\b)!\u0011\u0011BA\u0006\u0003\u001diW\u000f^1cY\u0016T1!!\u0004.\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003#\t9AA\u0004ICND7+\u001a;\u0002!%t\u0017m\u0019;jm\u0006$X\r\u001a)pIN\u0004\u0013!B:uCJ$HcA=\u0002\u001a!9\u00111\u0004\bA\u0002\u0005u\u0011\u0001E:dQ\u0016$W\u000f\\3s\u0005\u0006\u001c7.\u001a8e!\rq\u0015qD\u0005\u0004\u0003Cq\"!I&vE\u0016\u0014h.\u001a;fg\u000ecWo\u001d;feN\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$\u0017AD8o\u001d\u0016<8K\\1qg\"|Go\u001d\u000b\u0006s\u0006\u001d\u0012\u0011\u0006\u0005\b\u00037y\u0001\u0019AA\u000f\u0011\u001d\tYc\u0004a\u0001\u0003[\t\u0011b\u001d8baNDw\u000e^:\u0011\r\u0005=\u0012qHA#\u001d\u0011\t\t$a\u000f\u000f\t\u0005M\u0012\u0011H\u0007\u0003\u0003kQ1!a\u000e9\u0003\u0019a$o\\8u}%\ta&C\u0002\u0002>5\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002B\u0005\r#aA*fc*\u0019\u0011QH\u0017\u0011\u00079\u000b9%C\u0002\u0002Jy\u0011A#\u0012=fGV$xN\u001d)pIN\u001cf.\u00199tQ>$\u0018AF8o\r&t\u0017\r\u001c(p]\u0012+G.\u001a;fIN#\u0018\r^3\u0015\u0013e\u000by%!\u0017\u0002^\u0005}\u0003bBA)!\u0001\u0007\u00111K\u0001\ta>$7\u000b^1uKB\u0019a*!\u0016\n\u0007\u0005]cDA\u0007GS:\fG\u000eU8e'R\fG/\u001a\u0005\u0007\u00037\u0002\u0002\u0019\u00010\u0002\r\u0015DXmY%e\u0011\u001d\tY\u0002\u0005a\u0001\u0003;Aa!!\u0019\u0011\u0001\u0004I\u0016!\u00043fY\u0016$XM\u0012:p[.C4/A\u000bsK6|g/Z#yK\u000e,Ho\u001c:Ge>l7\nO:\u0015\u000be\f9'!\u001b\t\r\u0005m\u0013\u00031\u0001_\u0011\u001d\tY'\u0005a\u0001\u0003[\n!\"\u001e9eCR,G\rU8e!\u0011\ty'!\u001f\u000e\u0005\u0005E$\u0002BA:\u0003k\nQ!\\8eK2T1!a\u001eE\u0003\r\t\u0007/[\u0005\u0005\u0003w\n\tHA\u0002Q_\u0012\fqC]3n_Z,W\t_3dkR|'O\u0012:p[N\u0003\u0018M]6\u0015\u000fe\u000b\t)a!\u0002\u0006\"9\u00111\u0004\nA\u0002\u0005u\u0001bBA)%\u0001\u0007\u00111\u000b\u0005\u0007\u00037\u0012\u0002\u0019\u00010\u0002\u001d\u0019Lg\u000eZ#ySR\u0014V-Y:p]R1\u00111RAJ\u0003+\u0003B!!$\u0002\u00106\t!%C\u0002\u0002\u0012\n\u0012a\"\u0012=fGV$xN]#ySR,G\rC\u0004\u0002RM\u0001\r!a\u0015\t\r\u0005m3\u00031\u0001_\u0003E)\u00070\u001b;SK\u0006\u001cxN\\'fgN\fw-\u001a\u000b\t\u00037\u000bY+!,\u00020B!\u0011QTAS\u001d\u0011\ty*!)\u0011\u0007\u0005MR&C\u0002\u0002$6\na\u0001\u0015:fI\u00164\u0017\u0002BAT\u0003S\u0013aa\u0015;sS:<'bAAR[!9\u0011\u0011\u000b\u000bA\u0002\u0005M\u0003BBA.)\u0001\u0007a\fC\u0004\u00022R\u0001\r!a-\u0002\u0011\u0015D\u0018\u000e^\"pI\u0016\u00042\u0001LA[\u0013\r\t9,\f\u0002\u0004\u0013:$\u0018\u0001\u00044j]\u0012,\u00050\u001b;D_\u0012,G\u0003BAZ\u0003{Cq!!\u0015\u0016\u0001\u0004\t\u0019&A\u0007jgB{G-\u00138bGRLg/\u001a\u000b\u00043\u0006\r\u0007bBAc-\u0001\u0007\u0011QN\u0001\u0004a>$\u0017\u0001H#yK\u000e,Ho\u001c:Q_\u0012\u001cH*\u001b4fGf\u001cG.Z'b]\u0006<WM\u001d\t\u0003\u001db\u0019\"\u0001G\u0016\u0015\u0005\u0005%\u0017!E+O\u0017:{uKT0F1&#vlQ(E\u000bV\u0011\u00111W\u0001\u0013+:[ejT,O?\u0016C\u0016\nV0D\u001f\u0012+\u0005%\u0001\teKN\u001c'/\u001b2f\u000bbLGoQ8eKR!\u00111TAm\u0011\u001d\tY\u000e\ba\u0001\u0003g\u000bAaY8eK\u0002")
public class ExecutorPodsLifecycleManager
implements Logging {
    private boolean shouldDeleteExecutors;
    private long missingPodDetectDelta;
    private Cache<Long, Long> removedExecutorsCache;
    private final SparkConf conf;
    private final KubernetesClient kubernetesClient;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private long lastFullSnapshotTs;
    private final HashSet<Object> inactivatedPods;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static String describeExitCode(int n) {
        return ExecutorPodsLifecycleManager$.MODULE$.describeExitCode(n);
    }

    public static int UNKNOWN_EXIT_CODE() {
        return ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkConf conf() {
        return this.conf;
    }

    private boolean shouldDeleteExecutors$lzycompute() {
        ExecutorPodsLifecycleManager executorPodsLifecycleManager = this;
        synchronized (executorPodsLifecycleManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.shouldDeleteExecutors = BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.shouldDeleteExecutors;
    }

    private boolean shouldDeleteExecutors() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.shouldDeleteExecutors$lzycompute() : this.shouldDeleteExecutors;
    }

    private long missingPodDetectDelta$lzycompute() {
        ExecutorPodsLifecycleManager executorPodsLifecycleManager = this;
        synchronized (executorPodsLifecycleManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.missingPodDetectDelta = BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_MISSING_POD_DETECT_DELTA()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.missingPodDetectDelta;
    }

    private long missingPodDetectDelta() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.missingPodDetectDelta$lzycompute() : this.missingPodDetectDelta;
    }

    private Cache<Long, Long> removedExecutorsCache$lzycompute() {
        ExecutorPodsLifecycleManager executorPodsLifecycleManager = this;
        synchronized (executorPodsLifecycleManager) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.removedExecutorsCache = CacheBuilder.newBuilder().expireAfterWrite(3L, TimeUnit.MINUTES).build();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.removedExecutorsCache;
    }

    private Cache<Long, Long> removedExecutorsCache() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.removedExecutorsCache$lzycompute() : this.removedExecutorsCache;
    }

    private long lastFullSnapshotTs() {
        return this.lastFullSnapshotTs;
    }

    private void lastFullSnapshotTs_$eq(long x$1) {
        this.lastFullSnapshotTs = x$1;
    }

    private HashSet<Object> inactivatedPods() {
        return this.inactivatedPods;
    }

    public void start(KubernetesClusterSchedulerBackend schedulerBackend) {
        long eventProcessingInterval = BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_EVENT_PROCESSING_INTERVAL()));
        this.snapshotsStore.addSubscriber(eventProcessingInterval, (Function1<Seq<ExecutorPodsSnapshot>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
            this.onNewSnapshots(schedulerBackend, (Seq<ExecutorPodsSnapshot>)x$1);
            return BoxedUnit.UNIT;
        });
    }

    private void onNewSnapshots(KubernetesClusterSchedulerBackend schedulerBackend, Seq<ExecutorPodsSnapshot> snapshots) {
        block1: {
            HashSet execIdsRemovedInThisRound = HashSet$.MODULE$.empty();
            snapshots.foreach((Function1 & Serializable & scala.Serializable)snapshot -> {
                ExecutorPodsLifecycleManager.$anonfun$onNewSnapshots$1(this, schedulerBackend, execIdsRemovedInThisRound, snapshot);
                return BoxedUnit.UNIT;
            });
            if (this.inactivatedPods().nonEmpty() && snapshots.nonEmpty()) {
                this.inactivatedPods().retain((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$2 -> ((ExecutorPodsSnapshot)snapshots.last()).executorPods().contains((Object)BoxesRunTime.boxToLong((long)x$2)));
            }
            if (!snapshots.nonEmpty() || this.lastFullSnapshotTs() == ((ExecutorPodsSnapshot)snapshots.last()).fullSnapshotTs()) break block1;
            this.lastFullSnapshotTs_$eq(((ExecutorPodsSnapshot)snapshots.last()).fullSnapshotTs());
            scala.collection.immutable.Map lostExecutorsWithRegistrationTs = (scala.collection.immutable.Map)((Subtractable)schedulerBackend.getExecutorsWithRegistrationTs().map((Function1 & Serializable & scala.Serializable)t -> new Tuple2.mcJJ.sp(new StringOps(Predef$.MODULE$.augmentString((String)t._1())).toLong(), t._2$mcJ$sp()), Map$.MODULE$.canBuildFrom())).$minus$minus((GenTraversableOnce)((ExecutorPodsSnapshot)snapshots.last()).executorPods().keySet()).$minus$minus((GenTraversableOnce)execIdsRemovedInThisRound);
            lostExecutorsWithRegistrationTs.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                ExecutorPodsLifecycleManager.$anonfun$onNewSnapshots$9(this, schedulerBackend, x0$2);
                return BoxedUnit.UNIT;
            });
        }
    }

    private boolean onFinalNonDeletedState(FinalPodState podState, long execId, KubernetesClusterSchedulerBackend schedulerBackend, boolean deleteFromK8s) {
        boolean deleted;
        block0: {
            deleted = this.removeExecutorFromSpark(schedulerBackend, podState, execId);
            if (!deleteFromK8s) break block0;
            this.removeExecutorFromK8s(execId, podState.pod());
        }
        return deleted;
    }

    private void removeExecutorFromK8s(long execId, Pod updatedPod) {
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block1: {
                block0: {
                    if (!this.shouldDeleteExecutors()) break block0;
                    ((Deletable)$this.kubernetesClient.pods().withName(updatedPod.getMetadata().getName())).delete();
                    break block1;
                }
                if (this.inactivatedPods().contains((Object)BoxesRunTime.boxToLong((long)execId)) || this.isPodInactive(updatedPod)) break block1;
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Marking executor ").append(updatedPod.getMetadata().getName()).append(" as inactive since ").append("deletion is disabled.").toString());
                Pod inactivatedPod = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder(updatedPod).editMetadata().addToLabels((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_EXECUTOR_INACTIVE_LABEL()), (Object)"true")}))).asJava())).endMetadata()).build();
                ((Patchable)$this.kubernetesClient.pods().withName(updatedPod.getMetadata().getName())).patch((Object)inactivatedPod);
                this.inactivatedPods().$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
            }
        });
    }

    private boolean removeExecutorFromSpark(KubernetesClusterSchedulerBackend schedulerBackend, FinalPodState podState, long execId) {
        boolean bl;
        if (this.removedExecutorsCache().getIfPresent((Object)BoxesRunTime.boxToLong((long)execId)) == null) {
            this.removedExecutorsCache().put((Object)Predef$.MODULE$.long2Long(execId), (Object)Predef$.MODULE$.long2Long(execId));
            ExecutorExited exitReason = this.findExitReason(podState, execId);
            schedulerBackend.doRemoveExecutor(Long.toString(execId), (ExecutorLossReason)exitReason);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private ExecutorExited findExitReason(FinalPodState podState, long execId) {
        Tuple2 tuple2;
        int exitCode = this.findExitCode(podState);
        FinalPodState finalPodState = podState;
        if (finalPodState instanceof PodDeleted) {
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(61).append("The executor with id ").append(execId).append(" was deleted by a user or the framework.").toString());
        } else {
            String msg = this.exitReasonMessage(podState, execId, exitCode);
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)msg);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        boolean exitCausedByApp = tuple22._1$mcZ$sp();
        String exitMessage = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)exitCausedByApp), (Object)exitMessage);
        Tuple2 tuple24 = tuple23;
        boolean exitCausedByApp2 = tuple24._1$mcZ$sp();
        String exitMessage2 = (String)tuple24._2();
        return new ExecutorExited(exitCode, exitCausedByApp2, exitMessage2);
    }

    private String exitReasonMessage(FinalPodState podState, long execId, int exitCode) {
        Pod pod = podState.pod();
        Option reason = Option$.MODULE$.apply((Object)pod.getStatus().getReason());
        Option message = Option$.MODULE$.apply((Object)pod.getStatus().getMessage());
        String explained = ExecutorPodsLifecycleManager$.MODULE$.describeExitCode(exitCode);
        String exitMsg = new StringBuilder(45).append("The executor with id ").append(execId).append(" exited with exit code ").append(explained).append(".").toString();
        Option reasonStr = reason.map((Function1 & Serializable & scala.Serializable)r -> new StringBuilder(41).append("The API gave the following brief reason: ").append((String)r).toString());
        Option msgStr = message.map((Function1 & Serializable & scala.Serializable)m -> new StringBuilder(36).append("The API gave the following message: ").append((String)m).toString());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(116).append("\n       |").append(exitMsg).append("\n       |").append(reasonStr.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("\n       |").append(msgStr.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("\n       |\n       |The API gave the following container statuses:\n       |\n       |").append(KubernetesUtils$.MODULE$.containersDescription(pod, KubernetesUtils$.MODULE$.containersDescription$default$2())).append("\n      ").toString())).stripMargin();
    }

    private int findExitCode(FinalPodState podState) {
        return BoxesRunTime.unboxToInt((Object)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(podState.pod().getStatus().getContainerStatuses()).asScala()).find((Function1 & Serializable & scala.Serializable)containerStatus -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsLifecycleManager.$anonfun$findExitCode$1(containerStatus))).map((Function1 & Serializable & scala.Serializable)terminatedContainer -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(terminatedContainer.getState().getTerminated().getExitCode()))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE()));
    }

    private boolean isPodInactive(Pod pod) {
        Object v = pod.getMetadata().getLabels().get(Constants$.MODULE$.SPARK_EXECUTOR_INACTIVE_LABEL());
        String string = "true";
        return !(v != null ? !v.equals(string) : string != null);
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$1(ExecutorPodsLifecycleManager $this, KubernetesClusterSchedulerBackend schedulerBackend$2, HashSet execIdsRemovedInThisRound$1, ExecutorPodsSnapshot snapshot) {
        snapshot.executorPods().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HashSet hashSet;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long execId = tuple2._1$mcJ$sp();
                ExecutorPodState state = (ExecutorPodState)tuple2._2();
                ExecutorPodState executorPodState = state;
                if ($this.isPodInactive(executorPodState.pod())) {
                    hashSet = $this.inactivatedPods().$minus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                } else if (executorPodState instanceof PodDeleted) {
                    PodDeleted podDeleted = (PodDeleted)executorPodState;
                    if ($this.removeExecutorFromSpark(schedulerBackend$2, podDeleted, execId)) {
                        execIdsRemovedInThisRound$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Snapshot reported deleted executor with id ").append(execId).append(",").append(" pod name ").append(state.pod().getMetadata().getName()).toString());
                    }
                    hashSet = $this.inactivatedPods().$minus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                } else if (executorPodState instanceof PodFailed) {
                    BoxedUnit boxedUnit;
                    boolean deleteFromK8s;
                    PodFailed podFailed = (PodFailed)executorPodState;
                    boolean bl = deleteFromK8s = !execIdsRemovedInThisRound$1.contains((Object)BoxesRunTime.boxToLong((long)execId));
                    if ($this.onFinalNonDeletedState(podFailed, execId, schedulerBackend$2, deleteFromK8s)) {
                        execIdsRemovedInThisRound$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Snapshot reported failed executor with id ").append(execId).append(",").append(" pod name ").append(state.pod().getMetadata().getName()).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    hashSet = boxedUnit;
                } else if (executorPodState instanceof PodSucceeded) {
                    BoxedUnit boxedUnit;
                    boolean deleteFromK8s;
                    PodSucceeded podSucceeded = (PodSucceeded)executorPodState;
                    boolean bl = deleteFromK8s = !execIdsRemovedInThisRound$1.contains((Object)BoxesRunTime.boxToLong((long)execId));
                    if ($this.onFinalNonDeletedState(podSucceeded, execId, schedulerBackend$2, deleteFromK8s)) {
                        execIdsRemovedInThisRound$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                        if (schedulerBackend$2.isExecutorActive(Long.toString(execId))) {
                            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("Snapshot reported succeeded executor with id ").append(execId).append(", ").append("even though the application has not requested for it to be removed.").toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Snapshot reported succeeded executor with id ").append(execId).append(",").append(" pod name ").append(state.pod().getMetadata().getName()).append(".").toString());
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    hashSet = boxedUnit;
                } else {
                    hashSet = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            HashSet hashSet2 = hashSet;
            return hashSet2;
        });
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$9(ExecutorPodsLifecycleManager $this, KubernetesClusterSchedulerBackend schedulerBackend$2, Tuple2 x0$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            long lostExecId = tuple2._1$mcJ$sp();
            long lostExecRegistrationTs = tuple2._2$mcJ$sp();
            if ($this.removedExecutorsCache().getIfPresent((Object)BoxesRunTime.boxToLong((long)lostExecId)) == null && $this.lastFullSnapshotTs() - lostExecRegistrationTs > $this.missingPodDetectDelta()) {
                String exitReasonMessage = new StringBuilder(276).append("The executor with ID ").append(lostExecId).append(" (registered at ").append(lostExecRegistrationTs).append(" ms) was not found in the cluster at the polling time ").append("(").append($this.lastFullSnapshotTs()).append(" ms) which is after the accepted detect delta time ").append("(").append($this.missingPodDetectDelta()).append(" ms) configured by ").append("`").append(Config$.MODULE$.KUBERNETES_EXECUTOR_MISSING_POD_DETECT_DELTA().key()).append("`. ").append("The executor may have been deleted but the driver missed the deletion event. ").append("Marking this executor as failed.").toString();
                $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> exitReasonMessage);
                ExecutorExited exitReason = new ExecutorExited(ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE(), false, exitReasonMessage);
                schedulerBackend$2.doRemoveExecutor(Long.toString(lostExecId), (ExecutorLossReason)exitReason);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$findExitCode$1(ContainerStatus containerStatus) {
        return containerStatus.getState().getTerminated() != null;
    }

    public ExecutorPodsLifecycleManager(SparkConf conf, KubernetesClient kubernetesClient, ExecutorPodsSnapshotsStore snapshotsStore) {
        this.conf = conf;
        this.kubernetesClient = kubernetesClient;
        this.snapshotsStore = snapshotsStore;
        Logging.$init$((Logging)this);
        this.lastFullSnapshotTs = 0L;
        this.inactivatedPods = HashSet$.MODULE$.empty();
    }
}

